<?php
/**
 * @package     Nge.Plugin
 *
 * @copyright   Teatis
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

/**
 * Plug-in to enable some systems functions specific for NextGenEditor
 */
class PlgsystemNge_system extends JPlugin {

	private $modulesList;

	public function onBeforeCompileHead() {
		//NGE::time_elapsed('<br/>BEFORECOMPILEHEAD');
		$app = JFactory::getApplication();
		if ($app->isSite()) {
				
			$document = JFactory::getDocument();
			
			if (file_exists(JPATH_SITE . '/components/com_nge/helpers/nge.php')) 
			    require_once JPATH_SITE . '/components/com_nge/helpers/nge.php';	    
			else
			    return; //Component not installed
			                        
			if ($document->getType() == 'html') {

			    //Loading Bootstrap if required
			    if ($document->getType() == 'html') {
				$bootstrapJsSource = JComponentHelper::getParams('com_nge')->get('bootstrap_js_source', 'template');
				$bootstrapCssSource = JComponentHelper::getParams('com_nge')->get('bootstrap_css_source', 'template');
				if (($bootstrapJsSource != 'template') || ($bootstrapCssSource != 'template')){
				    if (file_exists(JPATH_SITE . '/plugins/content/nge_content/nge/libraries.php')) {
					require_once JPATH_SITE . '/plugins/content/nge_content/nge/libraries.php';
					$ngeAddons .= NgeLibraries::loadBootstrap();
				    }
				}
			    }         
			    			    
			    //Add custom NGE styles for page items
			    //If custom styles have been defined, the ngecustom.min.css contains all custom styles
			    //Adding at the end of the page, to be rendered last
			    //See onAfterRender for including scripts ngecustom.min.js
			    foreach (glob(NGEPATH_ASSETS. '/html/ngecustom*.min.css') as $filename) {
				$filename = str_replace(NGEPATH_ASSETS.'/', NGEURL_ASSETS, $filename);
				$document->addStyleSheet($filename);
			    }
			}
			
			//ngetemplate directive = remove current template styles and add admin template (default isis)
			$ngetemplate = JFactory::getApplication()->input->get('ngetemplate', '');
			if ($ngetemplate == 'admin') {
				// unset template css
				$css_keys = array_keys($document->_styleSheets);
				$keycount = count($css_keys);
				$template = JFactory::getApplication()->getTemplate();

				$templateurl = 'templates/' . $template;

				for ($i = $keycount - 1; $i >= 0; $i--) {
					if (strpos($css_keys[$i], $templateurl) !== false) {
						unset($document->_styleSheets[$css_keys[$i]]);
					}
				}

				// unset template js
				$js_keys = array_keys($document->_scripts);
				$keycount = count($js_keys);
				$template = JFactory::getApplication()->getTemplate();

				$templateurl = 'templates/' . $template;

				for ($i = $keycount - 1; $i >= 0; $i--) {
					if (strpos($js_keys[$i], $templateurl) !== false) {
						unset($document->_scripts[$css_keys[$i]]);
					}
				}
				JHtml::_('stylesheet', "administrator/templates/isis/css/template.css");
				JHtml::_('script', "administrator/templates/isis/js/template.js");
			}
		}
	}
	
	public function onAfterInitialise() {
		JLoader::register('NGE', JPATH_SITE . '/components/com_nge/helpers/nge');
	}

	public function onBeforeRender() {
		$jinput = JFactory::getApplication()->input;
		$currentComponent = $jinput->get('option');
		$app = JFactory::getApplication();
		$user = JFactory::getUser();

		// search for NextGenEditor update
		if($app->isAdmin()) {
			// look for nge package ID
			$db = JFactory::getDbo();
			$sql = 'SELECT extension_id FROM #__extensions WHERE element="pkg_nge"';
			$db->setQuery($sql);
			$packageId = $db->loadResult();
			
			// update the #__updates table for existing update or not
			$updater = JUpdater::getInstance();
			$updater->findUpdates($packageId);
			
			// look in #__updates table if there is a record for pkg_nge
			$sql = 'SELECT * FROM #__updates WHERE element="pkg_nge"';
			$db->setQuery($sql);
			$packageUpdateRecord = $db->loadObject();
			
			// if there is a message, show a notification message
			if(count($packageUpdateRecord)) {
			   	$app->enqueueMessage(JText::_( sprintf('There is an update for NextGenEditor to version %s<br />Go to <a href="index.php?option=com_installer&view=update">update page</a>', $packageUpdateRecord->version)), 'notice');
			}
		}
		else
		if ($app->isSite()) {
		    
			/* Frontediting managing modules */		    
			if ($currentComponent == 'com_nge') {
				$view = $jinput->get('view', '');
				if ($view == 'part')
					$this->_removeModules();
			}

			//Modules editing, only in content page
			if ($currentComponent == 'com_content') {
				$canManageModules = ($user->authorise('core.create', 'com_modules') || $user->authorise('core.edit', 'com_modules') || $user->authorise('core.delete', 'com_modules'));
				if ($canManageModules) {
				    if (file_exists(JPATH_SITE . '/components/com_nge/helpers/nge.php')) {
					require_once JPATH_SITE . '/components/com_nge/helpers/nge.php';
					$this->_loadEditableModules();
				    }
				    else
					return; //Component not installed				
				}
			}
						
		}
		
	}

	/**
	 * This event is triggered after the framework has rendered the application.
	 * @param none
	 * @return none
	 */
	public function onAfterRender() {
		//NGE::time_elapsed('<br/>AFTERRENDER ');
		/* Add NextGen Editor in current page */
	    

		if (file_exists(JPATH_SITE . '/components/com_nge/helpers/nge.php')) 
		    require_once JPATH_SITE . '/components/com_nge/helpers/nge.php';	    
		else
		    return; //Component not installed
	    
		$app = JFactory::getApplication();
		$document = JFactory::getDocument();
                	$ngeAddons = '';
			
		//Parsing parts		         
		    if (file_exists(JPATH_SITE . '/components/com_nge/helpers/nge.php')) {
		    
			//If user is enabled, in all front content, adding NGE editing capabilities
			//Mainbar in all front pages (isSite)
			//In all normal pages (themeFile = index.php). tmpl=component or tmpl=print will not display NGE mainbar
			//$userGroup for frontediting
			$fronteditingEnabled = NGE::features('frontediting.edit');
			
			//Notice in any url &nge=0 removes all nge editing stuff
			if (($app->isSite()) 
				&& ($fronteditingEnabled)
				&& ($document->getType() == 'html')
				&& ($app->get('themeFile') == 'index.php') 
				&& $app->input->get("option") !== "com_ngd" 
				&& $app->input->get("nge") !== "0"
				&& (NGE::user()->canManageContent || NGE::user()->canManageMenus || NGE::user()->canManageModules)) {
			    // loading main nge language file (for inline editing)
			    $lang = JFactory::getLanguage();				
			    $lang->load('com_nge');

			    ob_start();
			    /* Get mainbar style css */
			    echo '<style>';
			    require NGEPATH_HELPERS . '/editor/mainbar/editor.mainbar_css.php';
			    require NGEPATH_HELPERS . '/editor/mainbar/editor.mainbar_popup.css';
			    require NGEPATH_HELPERS . '/editor/mainbar/editor.mainbar_popover.css';
			    echo '</style>';

			    /* Get mainbar html */
			    require NGEPATH_HELPERS . '/editor/mainbar/themes/mainbar.floating.php';

			    /* Get mainbar init scripts */
			    echo '<script>';
			    //Nge main script constants
			    require NGEPATH_HELPERS . '/editor/editor.nge_js.php';
			    //Scripts for mainbar
			    require NGEPATH_HELPERS . '/editor/editor.nge.js';				
			    echo 'nge.initMainbar();'
			    . '</script>';

			    $ngeAddons .= ob_get_contents();
			    ob_clean();

			    //Required scripts for items if exists
			    if ($document->getType() == 'html') {
				foreach (glob(NGEPATH_ASSETS. '/html/ngecustom*.min.js') as $filename) {
				    ob_start();
				    require_once $filename;
				    $ngeAddons .= ob_get_contents();
				    ob_clean();				    
				}
				//Html for items if needed
				foreach (glob(NGEPATH_ASSETS. '/html/ngecustom*.min.html') as $filename) {
				    ob_start();
				    require_once $filename;
				    $ngeAddons .= ob_get_contents();
				    ob_clean();				    
				}
			    }				   
				   
			}
			//external libraries needed by all the displayed parts
			require_once NGEPATH_HELPERS . '/ngecontenthelper.php';
			$ngeAddons .= NgeContenthelper::renderStyleSheets();
			$ngeAddons .= NgeContenthelper::renderScripts();
			$ngeAddons .= NgeContenthelper::renderFonts();
							
		    //Adding ngeAddons
		    if ($ngeAddons != ''){
			//Adding NGE content at the end of the body
			$documentbody = $app->getBody();
			$documentbody = str_replace("</body>", $ngeAddons . "</body>", $documentbody);
			$app->setBody($documentbody);
			//$app->appendBody($ngeAddons);
		    }
		} //Nge component does not exists. Warning. Ngeplugin need to be uninstalled

	}

	/**
	 * Before rendering modules
	 * Check if There are Nge modules, and if they can be displayed or not with conditional display.
	 * If there are some modules that cannot be displayed, we remove the module in the list.
	 * If there is no module, the position will not be rendered empty, chaning the page layout in the pages where no modules must be displayed.
	 * For example some Nge modules are displayed only in the articles of one category
	 * @param none
	 * @return none
	 */
	public function onAfterModuleList(&$modules) {
	    for ($i=0;$i<count($modules); $i++){
		if ($modules[$i]->module == 'mod_nge'){
		    $paramsObject = json_decode($modules[$i]->params);
		    $partId = $paramsObject->id;
		    //Load part params
		    $db = JFactory::getDbo();
		    $query = $db->getQuery(true)
		    ->select('p.params ')
		    ->from('#__nge_parts AS p')
		    ->where('p.id = ' . (int) $partId);
		    $db->setQuery($query);
		    $partParams = $db->loadResult();
		    if ($partParams != false){
			$partParamsObject = json_decode($partParams);		    
			//TODO edit mode if (isset($paramsObject->display->rules) && ($paramsObject->display->rules != 'always') && in_array($params->rendering_mode, array("view", "edit"))){
			if (isset($partParamsObject->display->rules) && ($partParamsObject->display->rules != 'always')){
			    if (file_exists(JPATH_SITE . '/components/com_nge/helpers/nge.php'))
				require_once JPATH_SITE . '/components/com_nge/helpers/nge.php';
			    if (file_exists(NGEPATH_HELPERS . '/ngedisplayhelper.php')){
				require_once NGEPATH_HELPERS . '/ngedisplayhelper.php';
				$canViewPart = NgeDisplaytHelper::canViewPart($partParamsObject->display, 'view');
				if (!$canViewPart){
				    if (NGE::joomlaVersion() >="3.8"){
					$modules[$i]->published = false;
				    }
				    else{
					array_splice($modules, $i, 1);
					$i--;
				    }
				}
			    }
			}
		    }
		}
	    }	    
	}
	
	
	/*
	 * Removing existing modules, to replace them further by editable modules
	 */
	private function _removeModules() {
		$document = JFactory::getDocument();
		$app = JFactory::getApplication();
		$template = $app->getTemplate();
		$templatePath = JPath::clean(JPATH_THEMES . '/' . $template);
		
		//loading positions
		if (file_exists(JPATH_SITE . '/plugins/system/nge_system/modules/positions.php')){
		    require_once JPATH_SITE . '/plugins/system/nge_system/modules/positions.php';
		    $positions = NgePositions::getPositions();
		    //Reading modules content
		    $type = 'modules';
		    $bufferOptions = array();
		    $bufferOptions['type'] = 'modules';
		    $bufferOptions['title'] = '';
		    foreach ($positions as $position) {
			    //Only positions realy used in the index.php file
			    if (isset($position['attribs'])) {
				    $options['name'] = $position['name'];
				    //Filling position buffer
				    $bufferOptions['name'] = $position['name'];
				    $document->setBuffer('', $bufferOptions);
			    }
		    }
		}
	}

	private function _loadEditableModules() {
		//Before rendering JDocument
		//Load modules positions and styles.
		//Load modules content with same renderer than JDocumentHtml
		//Adds nge divs for editing.
		//Create position buffers in the current Document.
		//Warning : normal positions rendering in JdocumentHtml will not be called, because buffers are already filled.
		//Notice, cache is not used in this case (when current user can edit and theses aditing capabilities are launched)
		//todo if user can manage articles    

		$document = JFactory::getDocument();
		/*
		  $app = JFactory::getApplication();
		  $template = $app->getTemplate();
		  $templatePath = JPath::clean(JPATH_THEMES . '/' . $template);
		  //loading positions
		  $positions = $this->_getCurrentTemplatePositions($templatePath, $template);
		  $positions = $this->_parseCurrentTemplatePositions($positions, $templatePath);
		 */
		
		if (file_exists(JPATH_SITE . '/plugins/system/nge_system/modules/positions.php')){
		    require_once JPATH_SITE . '/plugins/system/nge_system/modules/positions.php';
		    $positions = NgePositions::getPositions();

		    //Reading modules content
		    $type = 'modules';
		    $bufferOptions = array();
		    $bufferOptions['type'] = 'modules';
		    $bufferOptions['title'] = '';

		    foreach ($positions as $position) {
			    //Only positions realy used in the index.php file and remove debug position because it's not a position used for the current user.
			    if (isset($position['attribs']) && (isset($position['attribs']["name"]) && $position['attribs']["name"] !== "debug" )) {
				    $bufferContent = $this->_renderPosition($document, $position['name'], $position['attribs']);

				    //In case of plugin content option has not been activated in custom html modules (and others...)
				    if (strpos($bufferContent, '<part ') !== false)
					    $bufferContent = NgeContentHelper::parse($bufferContent);
                                            
				    $options['name'] = $position['name'];
				    $newContent = array();
				    $newContent[] = '<div id="position-' . $position['name'] . '" class="ngelayout ngelayout-position" data-ngelayout="position" data-position="' . $position['name'] . '">';
				    $newContent[] = '<div id="ngeposition-' . $position['name'] . '" class="ngepositiontoolbar" style="display: none;">';
				    $newContent[] = '<div class="ngetoolbar-container">';
				    $newContent[] = '<span id="position-toolbar-title" class="ngetoolbar-title">' . $position['label'] . '</span>';
				    $newContent[] = '<span class="position-container-absolute">';
				    $newContent[] = '<span id="position-toolbar-plugins" class="position-toolbar-plugins">';
				    //Theming
				    $newContent[] = '<span class="position-toolbar-theme ngetoolbar-icon icomoon-paint-format" style="display:none;" data-toggle="tooltip" data-original-title="'.NGE::translate('COM_NGE_EDITOR_TOOLBAR_THEME_TITLE').'"></span>';
				    //Tools
				    if (Nge::features('nge.dev')){
				    $newContent[] = '<div class="btn-group">';
				    $newContent[] = '<button class=" dropdown-toggle" data-toggle="dropdown"><span class="icomoon-wrench"></span><span class="caret"></span></button>';
				    $newContent[] = '<ul class="dropdown-menu">';
				    $newContent[] = '<li><a href="javascript:ngePositionFormAddmodule();">Add new module</a></li>';
				    $newContent[] = '<li><a href="#">Show all modules</a></li>';
				    $newContent[] = '<li><a href="#">Show unpublished modules</a></li>';
				    $newContent[] = '</ul>';
				    $newContent[] = '</div>';
				    }
				    $newContent[] = '</span>';
				    $newContent[] = '<span id="position-toolbar-status" class="ngetoolbar-status" style="display:none;"></span>';
				    $newContent[] = '</span>';
				    $newContent[] = '</div>';
				    $newContent[] = '</div>';
                                    
//				$newContent[] = '<div class="ngelayout-toolbar" style="display: none;">';
//				    $newContent[] = '<span class="ngelayout-toolbar-title">' . $position['label'] . '</span>';
//				    $newContent[] = '</div>';
				    //$newContent[] = '<div class="content">';
				    //$newContent[] = '<div class="content ngeitemsaddable ngeitemsortable ngeitemsremovable" data-nge=\'{"itemsmode": "position", "itemstype": "module"}\'>';				
				    $newContent[] = '<div class="content">';
				    $newContent[] = $bufferContent;
				    if (Nge::features('nge.dev')){
					//$newContent[] = '<div class="sssngeaddableitem ngedroppableimage"> + </div>';
				    }
				    $newContent[] = '</div></div>';
				    //Filling position buffer
				    $bufferOptions['name'] = $position['name'];
				    $document->setBuffer(implode($newContent), $bufferOptions);
			    }
		    }
		}
	}

	/**
	 * Loading modules content.
	 * Same content as html renderer (libraries/joomla/html/renderer/modules)
	 */
	private function _renderPosition($document, $position, $params = array(), $content = null) {
	    //NGE::time_elapsed('<br/>RENDERPOSITION ');
		$renderer = $document->loadRenderer('module');
		$buffer = '';

		$app = JFactory::getApplication();
		//$frontediting = $app->get('frontediting', 1);
		$user = JFactory::getUser();
		//TODO see if this is needed. JFactory::getCache()->clean('com_modules', '');

		//$canEdit = $user->id && $frontediting && !($app->isAdmin() && $frontediting < 2) && $user->authorise('core.edit', 'com_modules');
		//$menusEditing = ($frontediting == 2) && $user->authorise('core.edit', 'com_menus');
		$canEdit = $user->id && !($app->isAdmin()) && $user->authorise('core.edit', 'com_modules');
		$menusEditing = $user->authorise('core.edit', 'com_menus');

		//foreach (JModuleHelper::getModules($position) as $mod) {
		foreach ($this->_getModules($position) as $mod) {
			if (isset($mod->published) && ($mod->published == 1)) {
				$moduleHtml = $renderer->render($mod, $params, $content);
				$buffer .= $moduleHtml;
			} else {
				$classPublished = ' ngeeditablestructuremodule ngeunpublished';
				$moduleHtml = $mod->title;

				if ($app->isSite() && $canEdit && trim($moduleHtml) != '' && $user->authorise('core.edit', 'com_modules.module.' . $mod->id)) {
					$displayData = array('moduleHtml' => &$moduleHtml, 'module' => $mod, 'position' => $position, 'menusediting' => $menusEditing);
					JLayoutHelper::render('joomla.edit.frontediting_modules', $displayData);

					if ($mod->module != 'mod_nge')
						$buffer .= '<div id="module-' . $mod->id . '" class="ngemodule ngemodule-joomla' . $classPublished . '" data-module-label="' . $mod->title . '" data-module-id="' . $mod->id . '" data-module-module="' . $mod->module . '">';
					else
						$buffer .= '<div id="module-' . $mod->id . '" class="ngemodule ngemodule-part' . $classPublished . '" data-module-label="' . $mod->title . '" data-module-id="' . $mod->id . '" data-module-module="' . $mod->module . '">';

					$buffer .= $moduleHtml;
					$buffer .= '</div>';
				}else {
					$buffer .= $moduleHtml;
				}
			}
		}

		return $buffer;
	}

	/*
	 * Get list of all modules
	 */
	private function _loadModules() {

		$jinput = JFactory::getApplication()->input;
	    
		if (isset($this->modulesList)) {
			return $this->modulesList;
		}

		$Itemid = $jinput->getInt('Itemid');
		
		$app = JFactory::getApplication();
		$user = JFactory::getUser();
		$groups = implode(',', $user->getAuthorisedViewLevels());
		$lang = JFactory::getLanguage()->getTag();
		$clientId = (int) $app->getClientId();

		$db = JFactory::getDbo();

		$query = new stdClass;
		$query->select = array();
		$query->from = array();
		$query->join = array();
		$query->where = array();
		$query->order = array();

		$query->select[] = 'm.published, m.id, m.title, m.module, m.position, m.content, m.showtitle, m.params, mm.menuid, m.published';
		$query->from[] = '#__modules AS m';
		$query->join[] = '#__modules_menu AS mm ON mm.moduleid = m.id';
		$query->where[] = 'm.published != -2';
		$query->join[] = '#__extensions AS e ON e.element = m.module AND e.client_id = m.client_id';
		$query->where[] = 'e.enabled = 1';

		$date = JFactory::getDate();
		$now = $date->toSql();
		$nullDate = $db->getNullDate();
		$query->where[] = '(m.publish_up = ' . $db->q($nullDate) . ' OR m.publish_up <= ' . $db->q($now) . ')';
		$query->where[] = '(m.publish_down = ' . $db->q($nullDate) . ' OR m.publish_down >= ' . $db->q($now) . ')';

		$query->where[] = 'm.client_id = ' . $clientId;
		$query->where[] = '(mm.menuid = ' . (int) $Itemid . ' OR mm.menuid <= 0)';

		// Filter by language
		if ($app->isSite() && $app->getLanguageFilter()) {
			$query->where[] = 'm.language IN (' . $db->q($lang) . ',' . $db->q('*') . ')';
		}

		$query->order[] = 'm.position, m.ordering';

		$q = $db->getQuery(true);
		// convert array object to query object
		foreach ($query as $type => $strings) {
			foreach ($strings as $string) {
				if ($type == 'join') {
					$q->{$type}('LEFT', $string);
				} else {
					$q->{$type}($string);
				}
			}
		}

		// Set the query
		$db->setQuery($q);
		$modules = $db->loadObjectList();
		$modulesList = array();

		/*if ($db->getErrorNum()) {
			JFactory::getApplication()->enqueueMessage(JText::sprintf('JLIB_APPLICATION_ERROR_MODULE_LOAD', $db->getErrorMsg()), 'warning');  
			return $modulesList;
		}*/

		// Apply negative selections and eliminate duplicates
		$negId = $Itemid ? -(int) $Itemid : false;
		$dupes = array();
		for ($i = 0, $n = count($modules); $i < $n; $i++) {
			$module = &$modules[$i];

			// The module is excluded if there is an explicit prohibition
			$negHit = ($negId === (int) $module->menuid);

			//Test NGE modules conditional display
			if ($modules[$i]->module == 'mod_nge'){
			    $paramsObject = json_decode($modules[$i]->params);
			    $partId = $paramsObject->id;
			    //Load part params
			    $db = JFactory::getDbo();
			    $query = $db->getQuery(true)
			    ->select('p.params ')
			    ->from('#__nge_parts AS p')
			    ->where('p.id = ' . (int) $partId);
			    $db->setQuery($query);
			    $partParams = $db->loadResult();
			    if ($partParams != false){
				$partParamsObject = json_decode($partParams);		    
				//TODO edit mode if (isset($paramsObject->display->rules) && ($paramsObject->display->rules != 'always') && in_array($params->rendering_mode, array("view", "edit"))){
				if (isset($partParamsObject->display->rules) && ($partParamsObject->display->rules != 'always')){
				    if (file_exists(NGEPATH_HELPERS . '/ngedisplayhelper.php')){
					require_once NGEPATH_HELPERS . '/ngedisplayhelper.php';
					$negHit = ! NgeDisplaytHelper::canViewPart($partParamsObject->display, 'view');
				    }
				}
			    }
			}			
			
			if (isset($dupes[$module->id])) {
				// If this item has been excluded, keep the duplicate flag set,
				// but remove any item from the cleaned array.
				if ($negHit) {
					unset($modulesList[$module->id]);
				}
				continue;
			}

			$dupes[$module->id] = true;

			// Only accept modules without explicit exclusions.
			if (!$negHit) {
				// Determine if this is a 1.0 style custom module (no mod_ prefix)
				// This should be eliminated when the class is refactored.
				// $module->user is deprecated.
				$file = $module->module;
				$custom = substr($file, 0, 4) == 'mod_' ? 0 : 1;
				$module->user = $custom;
				// 1.0 style custom module name is given by the title field, otherwise strip off "mod_"
				$module->name = $custom ? $module->module : substr($file, 4);
				$module->style = null;
				$module->position = strtolower($module->position);
				$modulesList[$module->id] = $module;
			}
		}

		unset($dupes);

		// Do 3rd party stuff to manipulate module array.
		// Any plugins using this architecture may make alterations to the referenced $modules array.
		// To remove items you can do unset($modules[n]) or $modules[n]->published = false.
		// "onPrepareModuleList" may alter or add $modules, and does not need to return anything.
		// This should be used for module addition/deletion that the user would expect to happen at an
		// early stage.
		$app->triggerEvent('onPrepareModuleList', array(&$clean));

		// "onAlterModuleList" may alter or add $modules, and does not need to return anything.
		$app->triggerEvent('onAlterModuleList', array(&$clean));

		// "onPostProcessModuleList" allows a plugin to perform actions like parameter changes
		// on the completed list of modules and is guaranteed to occur *after*
		// the earlier plugins.
		$app->triggerEvent('onPostProcessModuleList', array(&$clean));

		// Return to simple indexing that matches the query order.
		$modulesList = array_values($modulesList);

		/*
		  $cache->store($clean, $cacheid);
		  }
		 */

		return $modulesList;
	}

	/**
	 * Get all modules to be rendered in a position
	 * @param type $position
	 * @return type
	 */
	private function _getModules($position) {

		$position = strtolower($position);
		$result = array();

		$modules = $this->_loadModules();

		$total = count($modules);
		for ($i = 0; $i < $total; $i++) {
			if ($modules[$i]->position == $position) {
				$result[] = &$modules[$i];
			}
		}

		if (count($result) == 0) {
		    $jinput = JFactory::getApplication()->input;
		    $tp = $jinput->getBool('tp');
		    if ($tp && JComponentHelper::getParams('com_templates')->get('template_positions_display')) {
			$result[0] = JModuleHelper::getModule('mod_' . $position);
			$result[0]->title = $position;
			$result[0]->content = $position;
			$result[0]->position = $position;
		    }
		}

		return $result;
	}

	public function onCreateModuleQuery(&$query) {
		echo $query;
	}

	/*
	 * Declared for inserting template file (calls countModules function)
	 */

	private function countModules($condition) {
		$document = $document = JFactory::getDocument();
		return $document->countModules($condition);
	}

}
