<?php

/**
 * @package     Nge.Plugin
 *
 * @copyright   Teatis
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class NgePositions {

	
	public static function getPositions(){
		$app = JFactory::getApplication();
		$template = $app->getTemplate();
		$templatePath = JPath::clean(JPATH_THEMES . '/' . $template);
		$positions = self::_getCurrentTemplatePositions($templatePath, $template);
		$positions = self::_parseCurrentTemplatePositions($positions, $templatePath);
		return $positions;
}

    /**
     * get available positions in the current Template
     * from declared positions in the template manifest
     * used to get Labels
     * 
     * @return array
     */
    private static function _getCurrentTemplatePositions($templatePath, $currentTemplate) {

	$lang = JFactory::getLanguage();

	$positions = array();

	// Load the positions from the installed templates.
	$path = $templatePath . '/templateDetails.xml';

	if (file_exists($path)) {
	    $xml = simplexml_load_file($path);
	    if (isset($xml->positions[0])) {
		$lang->load('tpl_' . $currentTemplate . '.sys', JPATH_ROOT, null, false, true) || $lang->load('tpl_' . $currentTemplate . '.sys', JPATH_ROOT . '/templates/' . $currentTemplate, null, false, true);
		foreach ($xml->positions[0] as $position) {
		    $value = (string) $position['value'];
		    $label = (string) $position;
		    if (!$value) {
			$value = $label;
			$langLabel = preg_replace('/[^a-zA-Z0-9_\-]/', '_', 'TPL_' . $currentTemplate . '_POSITION_' . $value);
			$altlabel = preg_replace('/[^a-zA-Z0-9_\-]/', '_', 'COM_MODULES_POSITION_' . $value);
			if ($lang->hasKey($langLabel))
			    $label = jtext::_($langLabel);
			else
			if ($lang->hasKey($altlabel)) {
			    $label = jtext::_($altlabel);
			}
		    }
		    $positions[$value] = array('name' => $value, 'label' => $label);
		}
	    }
	}
	return $positions;
    }

    /**
     * get real positions in the current Document
     * used to get extra attributes (for example style)
     * 
     * @return array
     */
    private static function _parseCurrentTemplatePositions($positions, $templatePath) {
	/*
	  $directory = isset($params['directory']) ? $params['directory'] : 'templates';
	  $filter = JFilterInput::getInstance();
	  $template = $filter->clean($params['template'], 'cmd');
	  $file = $filter->clean($params['file'], 'cmd');
	 */
	//Load main template file
	$filename = "index.php";

	// Check to see if we have a valid template file
	if (file_exists($templatePath . '/' . $filename)) {
	    // Get the file content
	    $contents = file_get_contents($templatePath . '/' . $filename);
/*	    ob_start();
	    require $templatePath . '/' . $filename;
	    $contents = ob_get_contents();
	    ob_end_clean();*/
	}
	//Parse modules positions
	$matches = array();
	//Searching jdoc:include tags
	
	if (preg_match_all('#<jdoc:include\ type="([^"]+)"(.*)\/>#iU', $contents, $matches)) {
	    
	    // Step through the jdocs in reverse order.
	    for ($i = count($matches[0]) - 1; $i >= 0; $i--) {
		$type = $matches[1][$i];
		$attribs = empty($matches[2][$i]) ? array() : NGE::parseAttributes($matches[2][$i]);
		$name = isset($attribs['name']) ? $attribs['name'] : null;
        
		if ($type == 'module' || $type == 'modules') {
		  if(isset($positions[$name]))
		    $positions[$name] = array_merge($positions[$name], array('type' => $type, 'name' => $name, 'attribs' => $attribs));
		}
	    }
	}
	return $positions;
    }

}
