<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

class PlgExtensionNge_extension extends JPlugin {

    /**
     * PlgExtensionNge_extension::onExtensionBeforeSave()
     * 
     * @param mixed $context
     * @param mixed $table
     * @param mixed $isNew
     * @return void
     */
    public function onExtensionBeforeSave($context, $table, $isNew = null) {

	$task = JFactory::getApplication()->input->get('task');
	$component = JFactory::getApplication()->input->get('component');

	if ($context == 'com_modules.module' && strtoupper($task) == 'SAVE2COPY') {

	    //test if nge component installed
	    if (!file_exists(JPATH_SITE . '/components/com_nge/helpers/ngecontenthelper.php'))
		return;
	    
	    // module save2copy response, we duplicate parts in content field for all module
	    require_once JPATH_SITE . '/components/com_nge/helpers/ngecontenthelper.php';
	    $table->content = NgeContentHelper::duplicateParts($table->content);

	    // save2copy response for mod_nge modules => duplicate part and change module params
	    if ($table->module == 'mod_nge') {
		$moduleParams = new JRegistry;
		$moduleParams->loadString($table->params);
		require_once JPATH_SITE . '/components/com_nge/helpers/ngeparthelper.php';
		$duplicatePartKey = NgePartHelper::duplicate($moduleParams->get('id'));
		$moduleParams->set('id', $duplicatePartKey);

		$table->params = $moduleParams->toString();
	    }
	} // if $context == 'com_modules.module'        
	// com_nge config saving, update extra query with subscription id
	else 
	if ($context == 'com_config.component' && $component == 'com_nge') {
	    $formValues = JFactory::getApplication()->input->get('jform', '', 'array');

	    $subscriptionId = $formValues['subscription_id'];

	    $extra_query = '';
	    if ($subscriptionId != '')
		$extra_query = 'subscription_id=' . $subscriptionId;

	    // update table
	    $sql = sprintf('UPDATE #__update_sites SET extra_query="%s" 
		    WHERE update_site_id=(SELECT update_site_id FROM #__update_sites_extensions sie 
		    LEFT JOIN #__extensions ext ON sie.extension_id=ext.extension_id 
		    WHERE ext.element="pkg_nge")', $extra_query);
	    $db = JFactory::getDBO();
	    $db->setQuery($sql);
	    $db->execute();
	}
    }

    
    /**
     * After Joomla editor installs, we install NGE addons.
     * @param type $installer
     * @param type $eid
     * @return type
     */
    public function onExtensionAfterInstall($installer, $eid) {
	if (!$eid)
	    return;
	
	// search extention being installed
	$db = JFactory::getDbo();
	$sql = 'select * FROM #__extensions WHERE extension_id=' . $eid;
	$db->setQuery($sql);
	$extension = $db->loadObject();

	JFactory::getLanguage()->load('com_nge');

	//Getting installed addons
	JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_nge/models');
	$cpanelModel = JModelLegacy::getInstance('Cpanel','NgeModel');
	if ($cpanelModel == false)
	    return;
	
	$ngeplugins = $cpanelModel->getPluginsParams();		
		
	//We réinstall addons only if they are missing. NGE has not changed, so no need to reinstall addons.
	//If JCE has changed,  isNgeMissing is true
	switch ($extension->element) {
	    //Jce editor has been installed
	    case 'com_jce':
		$jce = $ngeplugins['jce'];
		if(($jce->isNgeMissing) && (file_exists(JPATH_ADMINISTRATOR.'/components/com_nge/helpers/installer.jce.php'))) {
		    require_once(JPATH_ADMINISTRATOR.'/components/com_nge/helpers/installer.jce.php');
		    if (ngeHelperJceInstaller::installAddon(true))
			JFactory::getApplication()->enqueueMessage(JText::_('COM_NGE_JCE_INSTALL_OK'));	
		}		
		break;
	    //Jck editor has been installed
	    case 'com_jckman':
		$jck = $ngeplugins['jckeditor'];
		if(($jck->isNgeMissing) && (file_exists(JPATH_ADMINISTRATOR.'/components/com_nge/helpers/installer.jck.php'))) {
		    require_once(JPATH_ADMINISTRATOR.'/components/com_nge/helpers/installer.jck.php');
		    if (ngeHelperJckInstaller::installAddon(true))
			JFactory::getApplication()->enqueueMessage(JText::_('COM_NGE_JCK_INSTALL_OK'));	
		}
		break;
	    case 'pkg_arkeditor':
		$ark = $ngeplugins['arkeditor'];
		if ($ark->isNgeMissing) {
		    JFactory::getApplication()->enqueueMessage(JText::_('COM_NGE_I_P_MISSING_CONTENT2_ARKEDITOR') . '<br /><a href="http://www.nextgeneditor.com/download/arkplugin_nge">http://www.nextgeneditor.com/download/arkplugin_nge</a><br />' . JText::_('COM_NGE_I_P_MISSING_CONTENT3_ARKEDITOR'), 'notice');
		}
		break;
	}
	
    }

}