<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  Content.nge
 *
 * @copyright   Teatis
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
//} catch(Exception $e){
//	echo 'NextGenEditor component not found. Please install NextGenEditor component or disable NextGenEditor plugin.';
//}
defined('_JEXEC') or die;
/**
 * Plug-in to enable loading parts into content (e.g. articles)
 * This uses the {loadnge} syntax
 *
 * @package     Joomla.Plugin
 * @subpackage  Content.nge
 * @since       2.5
 */
class PlgContentNge_content extends JPlugin {


	/* Nge render module to show module toolbar and edit content */

	public function onRenderModule(&$module, $attribs) {
		$app = JFactory::getApplication();
		if ($app->isSite() && file_exists(JPATH_SITE . '/plugins/content/nge_content/joomla/modules.php')) {
			require_once JPATH_SITE . '/plugins/content/nge_content/joomla/modules.php';
			$module->content = NgeModules::enableEditableModule($module, $attribs);
		}
	}	 
	
	public function onContentPrepare($context, &$article, &$params, $page = 0) {

		$app = JFactory::getApplication();
		if ($app->isSite()) {			

//try{
			// Don't run this plugin when the content is being indexed
			if ($context == 'com_finder.indexer')
				return true;

			//Don't run this plugin when nothing to do (recursive call)
			if (isset($params->task) && ($params->task == "nothing"))
				return true;
		    
			if (file_exists(JPATH_SITE . '/components/com_nge/helpers/nge.php')) {
				require_once JPATH_SITE . '/components/com_nge/helpers/nge.php';
				if (NGE::features('nge.cloud')){
				    require_once NGEPATH_HELPERS . '/ngecloudhelper.php';				    
				}
				else {
				    require_once NGEPATH_HELPERS . '/ngecontenthelper.php';
				    require_once NGEPATH_HELPERS . '/ngepartshelper.php';
				    require_once NGEPATH_HELPERS . '/ngeparthelper.php';
				}
			} else
				return true; //Component is missing. We do nothing

			//Parse all part short tags if some exist
			if (strpos($article->text, '<part') !== false){
			    //Parse article to transform <part /> tags
			    if (NGE::features('nge.cloud'))
				$article->text = NgeCloudHelper::parse($article->text, $params);
			    else {
				//Setting current article for some parts (labels)
				if ($context == 'com_content.article')
				    NgeContentHelper::setCurrentArticle($article);

				//Save trace of this contentPlugin calling in a static array
				NgeContenthelper::addContentPluginContext($context);
				$article->text = NgeContentHelper::parse($article->text, $params);
			    }

			    //Applying all content plugins on this new content
			    //All nge tags have been parsed, but we need to launch again all content plugins for other plugins.
			    //With the 'nothing task, this nge content plugin will not parse again parts
			    $paramsPlugin = new JObject();
			    $paramsPlugin->set('task', 'nothing');
			    $article->text = JHtml::_('content.prepare', $article->text, $paramsPlugin);
			}

			//Add NGE front editing
			if ((!$app->isAdmin()) && (NGE::user()->canManageContent)) {
			    $componentPath = explode('.', $context);
			    
			    //If an editing plugins exists for this component or module front-editing, we load it
			    //
			    switch (substr($componentPath[0], 0, 3)){
				//Loading components editing stuff
				case 'com' :
				    $componentName = substr($componentPath[0], 4);
				    $className = 'NgeComponentEditing' . ucfirst($componentName);
				    if (file_exists(NGEPATH_CONTENTS . '/editing/components/' . $componentPath[0] . '/editing.php')){
					require_once NGEPATH_CONTENTS . '/editing/components/' . $componentPath[0] . '/editing.php';
					$className::addInlineEditing($context, $article, $params, $page = 0);
				    }
				    break;
				//Loading modules editing stuff
				case 'mod' :
				    $className = 'NgeModuleEditing' . implode('', array_map('ucfirst', explode('_', substr($componentPath[0], 4))));
				    if (file_exists(NGEPATH_CONTENTS . '/editing/modules/' . $componentPath[0]  . '/editing.php')){
					require_once NGEPATH_CONTENTS . '/editing/modules/' . $componentPath[0]  . '/editing.php';
					$className::addInlineEditing($context, $article, $params, $page = 0);
				    }
				    break;
			    }
			}
		}
 
	}
	

	  /**
	   * PlgContentNge_content::onContentBeforeSave()
	   * 
	   * @param mixed $context
	   * @param mixed $article
	   * @param mixed $isNew
	   * @return
	   */
	  public function onContentBeforeSave($context, $article, $isNew) {
		  // See front article save as
		  // See back batchcopy
		  // See back module copy
		  // see content test for only change on article save (com_content.article context 
		  // In case of batch article duplicate, we need to duplicate also content parts.
          
		  // if task is save2copy, it's duplication of an article
		  $task = JFactory::getApplication()->input->get('task');
		  if ( $context == 'com_content.article' && strtoupper($task) == 'SAVE2COPY' && file_exists(JPATH_SITE . '/components/com_nge/helpers/ngecontenthelper.php') ) {
			if (file_exists(JPATH_SITE . '/components/com_nge/helpers/nge.php')) {
			    require_once JPATH_SITE . '/components/com_nge/helpers/nge.php';
			    require_once JPATH_SITE . '/components/com_nge/helpers/ngecontenthelper.php';
			    $article->introtext = NgeContentHelper::duplicateParts($article->introtext );
			}
		  } 
		  return true;
	  }

}