<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  Content.nge
 *
 * @copyright   Teatis
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;


class NgeLibraries {

    
    /**
     * loadBootstrap
     * load custom Bootstrap if needed
     * if before template : adding to the header scripts
     * if after template : returning in the function result. Will be added at the end of the body tag
     * 
     * 
     * 
     */
    public static function loadBootstrap() {
	
		
	$endDocumentContent = '';
	
	//Loading component params
	$bootstrapJsSource = JComponentHelper::getParams('com_nge')->get('bootstrap_js_source', 'template');
	$bootstrapCssSource = JComponentHelper::getParams('com_nge')->get('bootstrap_css_source', 'template');
	$bootstrapVersion = JComponentHelper::getParams('com_nge')->get('bootstrap_version', '2');
	$bootstrapLoading = JComponentHelper::getParams('com_nge')->get('bootstrap_loading', 'before_template');
	//Loading bootstrap js file
	switch ($bootstrapJsSource) {
	    case 'template' :
		//Nothing to do
		break;
	    case 'joomla' :
		//Adding included Joomla bootstrap
		JHtml::_('bootstrap.framework');
		break;
	    case 'bootstrap' :
		//Loading original bootstrap files, included in the NextGenEditor component (media/Com_nge directory) 
		if ($bootstrapLoading == 'after_template')
		    $endDocumentContent .= '<script src="' . Juri::root() . 'media/com_nge/bootstrap/bootstrap-' . $bootstrapVersion . '/js/bootstrap.min.js" type="text/javascript"></script>';
		else {		    
		    $document = JFactory::getDocument();
		    $document->addScript(Juri::root() . 'media/com_nge/bootstrap/bootstrap-' . $bootstrapVersion . '/js/bootstrap.min.js');
		}
		break;
	}

	//Loading bootstrap css file
	switch ($bootstrapCssSource) {
	    case 'template' :
		//Nothing to do
		break;
	    case 'joomla' :
		JHtml::_('bootstrap.loadCss', true);
		break;
	    case 'bootstrap' :
		//Loading original bootstrap files, included in the NextGenEditor component (media/Com_nge directory)				
		if ($bootstrapLoading == 'after_template') {
		    $endDocumentContent .= '<link rel="stylesheet" href="' . Juri::root() . 'media/com_nge/bootstrap/bootstrap-' . $bootstrapVersion . '/css/bootstrap.min.css" type="text/css" />';
		    if ($bootstrapVersion == '2')
			$endDocumentContent .= '<link rel="stylesheet" href="' . Juri::root() . 'media/com_nge/bootstrap/bootstrap-2/css/bootstrap-responsive.min.css" />';
		    else
			$endDocumentContent .= '<link rel="stylesheet" href="' . Juri::root() . 'media/com_nge/bootstrap/bootstrap-3/css/bootstrap-theme.min.css" />';

		}
		else {
		    $document = JFactory::getDocument();
		    $document->addStyleSheet(Juri::root() . 'media/com_nge/bootstrap/bootstrap-' . $bootstrapVersion . '/css/bootstrap.min.css');
		    if ($bootstrapVersion == '2')
			$document->addStyleSheet(Juri::root() . 'media/com_nge/bootstrap/bootstrap-2/css/bootstrap-responsive.min.css');
		    else
			$document->addStyleSheet(Juri::root() . 'media/com_nge/bootstrap/bootstrap-3/css/bootstrap-theme.min.css');
		}
		break;
	    case 'theme' :
		//Loading themed bootstrap files from Bootswatch, included in the NextGenEditor component (media/Com_nge directory)
		$bootstrapTheme = JComponentHelper::getParams('com_nge')->get('bootstrap_theme', true);
		if ($bootstrapLoading == 'after_template')
		    echo '<link rel="stylesheet" href="' . Juri::root() . 'media/com_nge/bootswatch/' . $bootstrapVersion . '/' . $bootstrapTheme . '/bootstrap.min.css" />';
		else {
		    $document = JFactory::getDocument();
		    $document->addStyleSheet(Juri::root() . 'media/com_nge/bootswatch/' . $bootstrapVersion . '/' . $bootstrapTheme . '/bootstrap.min.css');
		}
		break;
	    case 'url' :
		//Loading custom user bootstrap file 
		$bootstrapFile = JComponentHelper::getParams('com_nge')->get('bootstrap_file', true);
		if ($bootstrapLoading == 'after_template')
		    echo '<link rel="stylesheet" href="' . Juri::root() . 'media/com_nge/bootswatch/' . $bootstrapTheme . '/bootstrap.min.css" />';
		else {
		    $document = JFactory::getDocument();
		    $document->addStyleSheet(Juri::root() . 'media/com_nge/bootswatch/' . $bootstrapTheme . '/bootstrap.min.css');
		}
		break;
	}
	//If scripts or css tags to be added at the end of the document
	return $endDocumentContent;
    }

}
