<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  Content.nge
 *
 * @copyright   Teatis
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

//require_once JPATH_SITE . '/components/com_nge/helpers/nge.php';

class NgeEditor {


	/**   
	 *	Javascript content to be rendered for the editor
 	 *	@var String $scripts
	*/
	public $scripts;

	/**   
	 *	Css content to be rendered for the editor
 	 *	@var String $styles
	*/
	public $styles;
	
	/**   
	 *	Html content to be rendered for the editor
	 *	@var String $html  
	*/	
	public $html;
	
		
	public function __construct(){
		$this->scripts = '';
		$this->styles = '';
 		$this->html = '';												
	}

	
	public function display(){
		echo $this->render();
	}

	public function render(){

		    //To flush browser cache when NGE version changes
		    $ngeVersion = '?'. NGE::version();
	    
		    //Nge mainbar
		    require_once NGEPATH_HELPERS . '/ngecontenthelper.php';

		    //In case of plugin content option has not been activated in custom html modules (and others...)	
		    //if (strpos($documentbody, '<part ') !== false)
		    //$documentbody = NgeContentHelper::parse($documentbody);
		    //Create the mainbar html only once if the conditions are met			

		    
		    $includedEditionScripts = array();
		    $includedEditionStyles = array();
		    $includedEditionHtml = array();
		    
		    //External libraries
		    //NgeContenthelper::addScript(NGEURL_MEDIA.'jquery-ui/jquery-ui.min.js');
		    //NgeContenthelper::addScript(NGEURL_MEDIA.'jquery-ui/jquery.ui.touch-punch.min.js');
		    //NgeContenthelper::addScript(NGEURL_MEDIA.'bootbox/bootbox.min.js');
		    NgeContenthelper::addStyleSheet(NGEURL_MEDIA.'jquery-ui/jquery-ui.min.css' . $ngeVersion);
		    NgeContenthelper::addStyleSheet(NGEURL_MEDIA.'icomoon/icomoon-nge.css' . $ngeVersion);
		    NgeContenthelper::addStyleSheet(NGEURL_MEDIA.'material/icons/material-icons.css' . $ngeVersion);
		    
		    //Initialization 
		    //$includedEditionScripts[] = NGEPATH_HELPERS . '/editor/mainbar/editor.mainbar.init_js.php';
		    
		    NgeContenthelper::addScript(NGEURL_MEDIA . 'nge/ngetools.js' . $ngeVersion);
                    
		    //Modals		    
		    $includedEditionHtml[] = NGEPATH_HELPERS . '/editor/parttoolbar/modal.configpart.php';
		    $includedEditionHtml[] = NGEPATH_HELPERS . '/editor/mainbar/modal.create.php';
		    $includedEditionHtml[] = NGEPATH_HELPERS . '/editor/mainbar/modal.help.php';
		    $includedEditionHtml[] = NGEPATH_HELPERS . '/editor/mainbar/modal.general.php';
		    
		    //Toolbars management
		    NgeContenthelper::addStyleSheet(NGEURL_HELPERS . 'editor/toolbars/editor.toolbars.css' . $ngeVersion);
		    NgeContenthelper::addScript(NGEURL_HELPERS . 'editor/toolbars/editor.toolbars.js' . $ngeVersion);
		    
		    //Layouts
		    NgeContenthelper::addScript(NGEURL_HELPERS . 'editor/layout/editor.layout_sortable.js' . $ngeVersion);
		    
		    
		    		    
		    //Unlock button and main bar
		    if (NGE::features('editing.toolbar')) {
			//NgeContenthelper::addScript(NGEURL_MEDIA.'tabdrop/js/bootstrap-tabdrop.js');
			NgeContenthelper::addStyleSheet(NGEURL_MEDIA.'tabdrop/css/tabdrop.css' . $ngeVersion);

			NgeContenthelper::addScript(NGEURL_HELPERS . 'editor/mainbar/editor.mainbar.js' . $ngeVersion);
			/*$includedEditionStyles[] = NGEPATH_HELPERS . '/editor/mainbar/editor.mainbar_css.php';
			$includedEditionStyles[] = NGEPATH_HELPERS . '/editor/mainbar/editor.mainbar_popup.css';
			$includedEditionStyles[] = NGEPATH_HELPERS . '/editor/mainbar/editor.mainbar_popover.css';
			*/
			//include (NGEPATH_HELPERS . '/editor/mainbar/devices.php');
			NgeContenthelper::addScript(NGEURL_HELPERS . 'editor/mainbar/wireframe.js' . $ngeVersion);
			
			/*Include CSS for the plugins notification of ckeditor because he is in inline mode*/
			NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'ckeditor/plugins/notification/css/notification.css' . $ngeVersion);
		    }
		    
		    //Drop editing from the mainbar
		    if (NGE::features('parts.dropediting')) {		    
			NgeContenthelper::addScript(NGEURL_HELPERS . 'editor/mainbar/editor.mainbar_draggable.js' . $ngeVersion);
			if (Nge::features('nge.dev')){
			    NgeContenthelper::addScript(NGEURL_MEDIA.'dropzone/dropzone.min.js' . $ngeVersion);
			    NgeContenthelper::addStyleSheet(NGEURL_MEDIA.'dropzone/dropzone.min.css' . $ngeVersion);
			    NgeContenthelper::addScript(NGEURL_HELPERS . 'editor/dropimages/editor.dropimages.js' . $ngeVersion);
			}
		    }
		    
		    //Content inline editing
		    if (NGE::features('editing.inlineediting')) {		    
						
			if (NGE::features('inlineediting.elements')){
			    //$includedEditionScripts[] = NGEPATH_HELPERS . '/editor/inline/editor.inline_elements.js';
			    $includedEditionHtml[] = NGEPATH_HELPERS . '/editor/elements/editor.element_toolbar.php';
			    NgeContenthelper::addScript(NGEURL_HELPERS . 'editor/elements/editor.element.js' . $ngeVersion);
			    NgeContenthelper::addStyleSheet(NGEURL_HELPERS . 'editor/elements/editor.element.css' . $ngeVersion);
			    
			    //Include all available plugins
			    $rii = new RecursiveIteratorIterator(new RecursiveDirectoryIterator(NGEPATH_HELPERS . '/editor/elements/plugins'));
			    $files = array(); 
			    foreach ($rii as $file) {
				if ((!$file->isDir()) && ($file->getExtension() == 'js')) {
				    $includedEditionScripts[] = $file->getPathname();
				}
			    }			    
			}
			
			/* Direct inline-editing. Called after elementToolbar for events order */
			NgeContenthelper::addScript(NGEURL_MEDIA.'ckeditor/ckeditor.js' . $ngeVersion);
			NgeContenthelper::addStyleSheet(NGEURL_HELPERS . 'editor/inline/editor.inline.css' . $ngeVersion);
			NgeContenthelper::addScript(NGEURL_HELPERS . 'editor/inline/editor.inline_texts.js' . $ngeVersion);

			NgeContenthelper::addStyleSheet(NGEURL_HELPERS . 'editor/inline/config/editor.inline.config.css' . $ngeVersion);
			NgeContenthelper::addScript(NGEURL_HELPERS . 'editor/inline/config/editor.inline.config.js' . $ngeVersion);

			//Inline Config form
			$includedEditionHtml[] = NGEPATH_HELPERS . '/editor/inline/config/modal.inlineconfig.php';

			//Toobar for inline elements
			$includedEditionHtml[] = NGEPATH_HELPERS . '/editor/inline/editor.inline_toolbar.php';		
			NgeContenthelper::addScript(NGEURL_HELPERS . 'editor/inline/editor.inline_toolbar.js' . $ngeVersion);

			//$includedEditionScripts[] =  NGEPATH_INLINE . '/elements/toolbar_content_js.php';		
			//$includedEditionScripts[] =  NGEPATH_INLINE . '/elements/toolbar_params_js.php';					 
			 
		    }
		    
		    if (NGE::features('inlineediting.addable')) {
			NgeContenthelper::addStyleSheet(NGEURL_HELPERS . 'editor/addable/editor.addable.css' . $ngeVersion);
			NgeContenthelper::addScript(NGEURL_HELPERS . 'editor/addable/editor.addable.js' . $ngeVersion);
			//Add popovers
			$includedEditionStyles[] = NGEPATH_LAYOUTS . '/addable/add/add.css';
		    	$includedEditionHtml[] = NGEPATH_LAYOUTS . '/addable/add/content.php';
			$includedEditionHtml[] = NGEPATH_LAYOUTS . '/addable/add/link.php';
			$includedEditionHtml[] = NGEPATH_LAYOUTS . '/addable/add/menu.php';
			//NgeContenthelper::addScript(NGEURL_MEDIA.'sortable/Sortable.min.js');
		    }
		    else {
			$this->scripts .= '<script>enableNgeItemsAddable = function (selector) {};';
			$this->scripts .= 'enableNgeItemsSortable = function (selector) {};</script>';
		    }
		    
		    //Part toolbars 
		    if (NGE::features('parts.editing')) {
			$includedEditionHtml[] = NGEPATH_HELPERS . '/editor/parttoolbar/editor.parttoolbar.php';
			
			NgeContenthelper::addScript(NGEURL_HELPERS . 'editor/parttoolbar/editor.parttoolbar.js' . $ngeVersion);
			NgeContenthelper::addStyleSheet(NGEURL_HELPERS . 'editor/parttoolbar/editor.parttoolbar.css' . $ngeVersion);
			
			//Editing in part content
			NgeContenthelper::addScript(NGEURL_HELPERS . 'editor/layout/part/editor.part.js' . $ngeVersion);
			
			//For layout page in documents
			//$includedEditionScripts[] = NGEPATH_HELPERS . '/editor/layout/page/editor.page.js';
			//$includedEditionScripts[] = NGEPATH_HELPERS . '/editor/layout/page/editor.page_sortable.js';
			//$includedEditionStyles[] = NGEPATH_HELPERS . '/editor/layout/page/editor.page.css';

		    }
		    
		    //Modules management
		    if (NGE::features('editing.joomla.modules')) {
			//Drop in position and module sortable
			NgeContenthelper::addScript(NGEURL_HELPERS . 'editor/layout/position/editor.position.js' . $ngeVersion);
			NgeContenthelper::addStyleSheet(NGEURL_HELPERS . 'editor/layout/position/editor.position.css' . $ngeVersion);
			
			//$includedEditionHtml[] = NGEPATH_HELPERS . '/editor/moduletoolbar/editor.moduletoolbar.php';
			//$includedEditionScripts[] = NGEPATH_HELPERS . '/editor/moduletoolbar/editor.moduletoolbar.js';
			//$includedEditionStyles[] = NGEPATH_HELPERS . '/editor/moduletoolbar/editor.moduletoolbar.css';

			/*Neccesary to Edit (Duplicate, remove) modules content*/
			NgeContenthelper::addScript(NGEURL_HELPERS . 'editor/layout/module/editor.module.js' . $ngeVersion);
			NgeContenthelper::addStyleSheet(NGEURL_HELPERS . 'editor/layout/module/editor.module.css' . $ngeVersion);
						
			$includedEditionHtml[] = NGEPATH_CONTENTS . '/editing/page/modules/modal.configmodule.php';
			$includedEditionHtml[] = NGEPATH_CONTENTS . '/editing/page/modules/module_editable_js.php';
			$includedEditionHtml[] = NGEPATH_CONTENTS . '/editing/page/modules/module_toolbar_js.php';			
		    }
		    
		    //Articles editing
		    if (NGE::features('editing.joomla.articles')) {
			NgeContenthelper::addScript(NGEURL_HELPERS . 'editor/layout/article/editor.article.js' . $ngeVersion);
			NgeContenthelper::addStyleSheet(NGEURL_HELPERS . 'editor/layout/article/editor.article.css' . $ngeVersion);			
		    }   

		    /* Frontediting managing page. For some templates (for example protostar, we purpose inline config */
		    if (NGE::features('theming.page')) {
			NgeContenthelper::addScript(NGEURL_ROOT . 'components/com_nge/contents/editing/page/position/position_editable.js' . $ngeVersion);
			NgeContenthelper::addScript(NGEURL_ROOT . 'components/com_nge/contents/editing/page/page/page_editable.js' . $ngeVersion);
			NgeContenthelper::addStyleSheet(NGEURL_ROOT . 'components/com_nge/contents/editing/page/page/page_editable.css' . $ngeVersion);		
		    }
		    /*
		    if ($this->features['documents']) {
		    	    $includedEditionScripts[] = NGEPATH_HELPERS . '/editor/document/editable.js';
		    }
		    */
		    
		    //Included scripts, for rendering once all edition scripts and styles
		    ob_start();
		    foreach ($includedEditionStyles as $file){
			include_once($file);
		    }
		    $styles= ob_get_contents();
		    ob_end_clean();
		    
		    ob_start();
		    foreach ($includedEditionScripts as $file){
			include_once($file);
		    }
		    $scripts= ob_get_contents();
		    ob_end_clean();

		    ob_start();
		    foreach ($includedEditionHtml as $file){
			include_once($file);
		    }
		    $this->html = ob_get_contents();
		    ob_end_clean();
		    		    		    		    
		    $this->html .= NgeContenthelper::renderFonts();

		    // Todo cas pour feedalliance car NGE::User renvoie tjr false ne marche pas chez eux
		    /*$jinput = JFactory::getApplication()->input;

		    $data = new stdClass();
		    $data->view = $jinput->get('view', '', 'string');
		    $data->layout = $jinput->get('layout', '', 'string');
		    $this->html .= NgeEditor::createMainbar($data);			    
*/
			    //if ($data->view == "featured" || $data->view == "article" || $data->view == "document") {
			    //}
		    
		    $minifyOutput = NGE::params('output_minify', true);
		    if (!(isset($minifyOutput) && ($minifyOutput == FALSE))) {
			$styles = NGE::minify($styles);
			$scripts = NGE::minify($scripts);
		    }
		    		    
		    $this->styles .= NgeContenthelper::renderStyleSheets();
		    $this->styles .= '<style>'.$styles.'</style>';
		   
		    $this->scripts .= NgeContenthelper::renderScripts();
		    $this->scripts .= '<script>'.$scripts.'</script>';
		    
		    return $this->scripts . $this->styles . $this->html;

	}
    
    
	/**
	 * Create Mainbar Html
	 * @param Object $params
	 * @param Boolean $canManageContent
	 * @return string content mainbar html
	 */
	/*
	public static function createMainbar($data) {
		$mainbar_html = "";

		if(NGE::params('front-editing', true)){
			NgeContenthelper::addScript(NGEURL_MEDIA.'/jquery-ui/jquery-ui.min.js');
			NgeContenthelper::addScript(NGEURL_MEDIA.'/jquery-ui/jquery.ui.touch-punch.min.js');
			NgeContenthelper::addScript(NGEURL_MEDIA.'/bootbox/bootbox.min.js');
			NgeContenthelper::addStyleSheet(NGEURL_MEDIA.'/jquery-ui/jquery-ui.min.css');
			NgeContenthelper::addStyleSheet(NGEURL_MEDIA.'/icomoon/icomoon-nge.css');
			
			ob_start();
			
			include_once (JPATH_SITE . '/components/com_nge/helpers/editor/moduletoolbar/modal.configmodule.php');
			include_once (JPATH_SITE . '/components/com_nge/helpers/editor/parttoolbar/modal.configpart.php');
			include_once (JPATH_SITE . '/components/com_nge/helpers/editor/mainbar/modal.create.php');
			include_once (JPATH_SITE . '/components/com_nge/helpers/editor/mainbar/modal.help.php');

			if($data->view == "document" && $data->layout == "workshop"){
				/-*Do nothing because is including in the view document and layout defaut_workshop*-/
			}else /-*if($data->view == "featured" || $data->view == "article"
					|| ($data->view == "document" && $data->layout == "page"))*-/{
				include_once(NGEPATH_HELPERS . '/editor/editor.php');
				include_once(NGEPATH_HELPERS . '/editor/mainbar/themes/mainbar.floating.php');
			}
			
			$mainbar_html = ob_get_contents();
			ob_end_clean();
		}
		
		return $mainbar_html;
	}
	*/
/*
 * To test. Now in file libraries.php
    protected function loadBootstrap() {
	
		
	//TEST	
	//echo '<script src="' .NGEURL_MEDIA . '/jquery/jquery.min.js" type="text/javascript"></script>';
	//echo '<script src="' .NGEURL_MEDIA . '/bootstrap/bootstrap-3/js/ngebootstrap.min.js" type="text/javascript"></script>';
	
	//Loading component params
	$bootstrapJsSource = JComponentHelper::getParams('com_nge')->get('bootstrap_js_source', 'template');
	$bootstrapCssSource = JComponentHelper::getParams('com_nge')->get('bootstrap_css_source', 'template');
	$bootstrapVersion = JComponentHelper::getParams('com_nge')->get('bootstrap_version', '2');
	$bootstrapLoading = JComponentHelper::getParams('com_nge')->get('bootstrap_loading', 'before_template');

	//Loading bootstrap js file
	switch ($bootstrapJsSource) {
	    case 'template' :
		//Nothing to do
		break;
	    case 'joomla' :
		JHtml::_('bootstrap.framework');
		break;
	    case 'bootstrap' :
		//Loading original bootstrap files, included in the NextGenEditor component (media/Com_nge directory) 
		if ($bootstrapLoading == 'after_template')
		    echo '<script src="' . NGEURL_MEDIA . '/bootstrap/bootstrap-' . $bootstrapVersion . '/js/bootstrap.min.js" type="text/javascript"></script>';
		else {
		    $document = JFactory::getDocument();
		    $document->addScript(NGEURL_MEDIA . '/bootstrap/bootstrap-' . $bootstrapVersion . '/js/bootstrap.min.js');
		}
		break;
	}

	//Loading bootstrap css file
	switch ($bootstrapCssSource) {
	    case 'template' :
		//Nothing to do
		break;
	    case 'joomla' :
		JHtml::_('bootstrap.loadCss', true);
		break;
	    case 'bootstrap' :
		//Loading original bootstrap files, included in the NextGenEditor component (media/Com_nge directory)				
		if ($bootstrapLoading == 'after_template') {
		    echo '<link rel="stylesheet" href="' .NGEURL_MEDIA . '/bootstrap/bootstrap-' . $bootstrapVersion . '/css/bootstrap.min.css" type="text/css" />';
		    if ($bootstrapVersion == '2')
			echo '<link rel="stylesheet" href="' .NGEURL_MEDIA . '/bootstrap/bootstrap-2/css/bootstrap-responsive.min.css" />';
		    else
			echo '<link rel="stylesheet" href="' .NGEURL_MEDIA . '/bootstrap/bootstrap-3/css/bootstrap-theme.min.css" />';
		}
		else {
		    $document = JFactory::getDocument();
		    $document->addStyleSheet(NGEURL_MEDIA . '/bootstrap/bootstrap-' . $bootstrapVersion . '/css/bootstrap.min.css');
		    if ($bootstrapVersion == '2')
			$document->addStyleSheet(NGEURL_MEDIA . '/bootstrap/bootstrap-2/css/bootstrap-responsive.min.css');
		    else
			$document->addStyleSheet(NGEURL_MEDIA . '/bootstrap/bootstrap-3/css/bootstrap-theme.min.css');
		}
		break;
	    case 'theme' :
		//Loading themed bootstrap files from Bootswatch, included in the NextGenEditor component (media/Com_nge directory)
		$bootstrapTheme = JComponentHelper::getParams('com_nge')->get('bootstrap_theme', true);
		if ($bootstrapLoading == 'after_template')
		    echo '<link rel="stylesheet" href="' .NGEURL_MEDIA . '/bootswatch/' . $bootstrapVersion . '/' . $bootstrapTheme . '/bootstrap.min.css" />';
		else {
		    $document = JFactory::getDocument();
		    $document->addStyleSheet(NGEURL_MEDIA . '/bootswatch/' . $bootstrapVersion . '/' . $bootstrapTheme . '/bootstrap.min.css');
		}
		break;
	    case 'url' :
		//Loading custom user bootstrap file 
		$bootstrapFile = JComponentHelper::getParams('com_nge')->get('bootstrap_file', true);
		if ($bootstrapLoading == 'after_template')
		    echo '<link rel="stylesheet" href="' .NGEURL_MEDIA . '/bootswatch/' . $bootstrapTheme . '/bootstrap.min.css" />';
		else {
		    $document = JFactory::getDocument();
		    $document->addStyleSheet(NGEURL_MEDIA . '/bootswatch/' . $bootstrapTheme . '/bootstrap.min.css');
		}
		break;
	}
    }
*/
}
