<?php
/*------------------------------------------------------------------------
# Copyright (C) 2014-2015 WebxSolution Ltd. All Rights Reserved.
# @license - GPLv2.0
# Author: WebxSolution Ltd
# Websites:  http://www.webxsolution.com
# Terms of Use: An extension that is derived from the JoomlaCK editor will only be allowed under the following conditions: http://joomlackeditor.com/terms-of-use
# ------------------------------------------------------------------------*/ 

defined('_JEXEC') or die;

/**
 *Ark  Editor Plugin
 *
 * @package     Joomla.Plugin
 * @subpackage  ArkEditor.Treelink
 */
class PlgArkEditorAutoStylesheetParser extends JPlugin
{
	public function onBeforeInstanceLoaded(&$params) 
	{
		$useTemplateCSS = $params->get('stylelistsource',1);
		$customCssFile = $params->get('arkcustomtypographyfile','');
		
		if($customCssFile)
		{	
			$customCssFile = preg_replace('/^(.*?)(\/|\\\\)templates(.*?)$/','templates$3',$customCssFile);
			$customCssFile = preg_replace('/\\\\/','/',$customCssFile);
		}	
		
		return "
					editor.on( 'configLoaded', function() {
						editor.config.useTemplateCSS =  (1 ==". (int) $useTemplateCSS.");
						".( $useTemplateCSS == 3 ? "editor.config.customCssFile = '".$customCssFile."';" : "editor.config.customCssFile = '';") ."
						if(!editor.config.useTemplateCSS && CKEDITOR.stylesSet.registered.default)
							 CKEDITOR.stylesSet.registered.default = [];
					});
					
					CKEDITOR.once('defaultStylessetReady', function(evt)
					{
						if(!editor.config.useTemplateCSS && CKEDITOR.stylesSet.registered.default)
						{	
							CKEDITOR.stylesSet.registered.default = [];
						}
					});
				";
	}
		
	public function onInstanceLoaded(&$params) {}
}
