/**
 * @copyright   Copyright (C) 2020 - 2021 Webxsolution Ltd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

/**
 * Editor ArkEditor
 */
 
Joomla = window.Joomla || {};

// Only define editors if not defined
Joomla.editors = Joomla.editors || {};

// An object to hold each editor instance on page, only define if not defined.
Joomla.editors.instances = Joomla.editors.instances || {}; 
 
;(function(Joomla, window)
{
	
	window.jInsertEditorText = function( text,editor) 
    {
		Joomla.editors.instances[editor].replaceSelection( text );
	}	

   CKEDITOR.on('instanceCreated',function(evt)
   {
		var editor = evt.editor;				

		/** Register Editor with Joomla JS framwork */
		
		if(!Joomla.editors.instances[editor.name])
		{
			Joomla.editors.instances[editor.name] = 
			{
			   'id': editor.name,	
			   'instance': editor,		   	  
			   'element': editor.element.$, 
			   'getValue': function(){ return CKEDITOR.tools.getData( this.id );},
			   'setValue': function( text ) { CKEDITOR.tools.setData( this.id, text );},
			   'getSelection': function () { return this.instance.getSelection().$; },
			   'replaceSelection': function (text) { return window.ARKEditorUpdateSelectedImageOrLink && window.ARKEditorUpdateSelectedImageOrLink(this.id,text) || !!this.instance.insertHtml(text); },
			   'onSave': function() { return '';}
			}		
					
			editor.on('beforeDestroy', function (event)
			{
				if(Joomla.editors.instances[this.name])
					delete Joomla.editors.instances[this.name];
			});	
		}
	});

}(Joomla, window));
