/*  
 * Prototype NGETOOLS
 * @version: 1.1
 */

/****** Libraries use inside NGETOOLS ******/
/*! LAB.js (LABjs :: Loading And Blocking JavaScript)
 * https://github.com/getify/LABjs
 * v2.0.3 (c) Kyle Simpson MIT License
 * var $LAB
*/
(function(o){var K=o.$LAB,y="UseLocalXHR",z="AlwaysPreserveOrder",u="AllowDuplicates",A="CacheBust",B="BasePath",C=/^[^?#]*\//.exec(location.href)[0],D=/^\w+\:\/\/\/?[^\/]+/.exec(C)[0],i=document.head||document.getElementsByTagName("head"),L=(o.opera&&Object.prototype.toString.call(o.opera)=="[object Opera]")||("MozAppearance"in document.documentElement.style),q=document.createElement("script"),E=typeof q.preload=="boolean",r=E||(q.readyState&&q.readyState=="uninitialized"),F=!r&&q.async===true,M=!r&&!F&&!L;function G(a){return Object.prototype.toString.call(a)=="[object Function]"}function H(a){return Object.prototype.toString.call(a)=="[object Array]"}function N(a,c){var b=/^\w+\:\/\//;if(/^\/\/\/?/.test(a)){a=location.protocol+a}else if(!b.test(a)&&a.charAt(0)!="/"){a=(c||"")+a}return b.test(a)?a:((a.charAt(0)=="/"?D:C)+a)}function s(a,c){for(var b in a){if(a.hasOwnProperty(b)){c[b]=a[b]}}return c}function O(a){var c=false;for(var b=0;b<a.scripts.length;b++){if(a.scripts[b].ready&&a.scripts[b].exec_trigger){c=true;a.scripts[b].exec_trigger();a.scripts[b].exec_trigger=null}}return c}function t(a,c,b,d){a.onload=a.onreadystatechange=function(){if((a.readyState&&a.readyState!="complete"&&a.readyState!="loaded")||c[b])return;a.onload=a.onreadystatechange=null;d()}}function I(a){a.ready=a.finished=true;for(var c=0;c<a.finished_listeners.length;c++){a.finished_listeners[c]()}a.ready_listeners=[];a.finished_listeners=[]}function P(d,f,e,g,h){setTimeout(function(){var a,c=f.real_src,b;if("item"in i){if(!i[0]){setTimeout(arguments.callee,25);return}i=i[0]}a=document.createElement("script");if(f.type)a.type=f.type;if(f.charset)a.charset=f.charset;if(h){if(r){e.elem=a;if(E){a.preload=true;a.onpreload=g}else{a.onreadystatechange=function(){if(a.readyState=="loaded")g()}}a.src=c}else if(h&&c.indexOf(D)==0&&d[y]){b=new XMLHttpRequest();b.onreadystatechange=function(){if(b.readyState==4){b.onreadystatechange=function(){};e.text=b.responseText+"\n//@ sourceURL="+c;g()}};b.open("GET",c);b.send()}else{a.type="text/cache-script";t(a,e,"ready",function(){i.removeChild(a);g()});a.src=c;i.insertBefore(a,i.firstChild)}}else if(F){a.async=false;t(a,e,"finished",g);a.src=c;i.insertBefore(a,i.firstChild)}else{t(a,e,"finished",g);a.src=c;i.insertBefore(a,i.firstChild)}},0)}function J(){var l={},Q=r||M,n=[],p={},m;l[y]=true;l[z]=false;l[u]=false;l[A]=false;l[B]="";function R(a,c,b){var d;function f(){if(d!=null){d=null;I(b)}}if(p[c.src].finished)return;if(!a[u])p[c.src].finished=true;d=b.elem||document.createElement("script");if(c.type)d.type=c.type;if(c.charset)d.charset=c.charset;t(d,b,"finished",f);if(b.elem){b.elem=null}else if(b.text){d.onload=d.onreadystatechange=null;d.text=b.text}else{d.src=c.real_src}i.insertBefore(d,i.firstChild);if(b.text){f()}}function S(c,b,d,f){var e,g,h=function(){b.ready_cb(b,function(){R(c,b,e)})},j=function(){b.finished_cb(b,d)};b.src=N(b.src,c[B]);b.real_src=b.src+(c[A]?((/\?.*$/.test(b.src)?"&_":"?_")+~~(Math.random()*1E9)+"="):"");if(!p[b.src])p[b.src]={items:[],finished:false};g=p[b.src].items;if(c[u]||g.length==0){e=g[g.length]={ready:false,finished:false,ready_listeners:[h],finished_listeners:[j]};P(c,b,e,((f)?function(){e.ready=true;for(var a=0;a<e.ready_listeners.length;a++){e.ready_listeners[a]()}e.ready_listeners=[]}:function(){I(e)}),f)}else{e=g[0];if(e.finished){j()}else{e.finished_listeners.push(j)}}}function v(){var e,g=s(l,{}),h=[],j=0,w=false,k;function T(a,c){a.ready=true;a.exec_trigger=c;x()}function U(a,c){a.ready=a.finished=true;a.exec_trigger=null;for(var b=0;b<c.scripts.length;b++){if(!c.scripts[b].finished)return}c.finished=true;x()}function x(){while(j<h.length){if(G(h[j])){try{h[j++]()}catch(err){}continue}else if(!h[j].finished){if(O(h[j]))continue;break}j++}if(j==h.length){w=false;k=false}}function V(){if(!k||!k.scripts){h.push(k={scripts:[],finished:true})}}e={script:function(){for(var f=0;f<arguments.length;f++){(function(a,c){var b;if(!H(a)){c=[a]}for(var d=0;d<c.length;d++){V();a=c[d];if(G(a))a=a();if(!a)continue;if(H(a)){b=[].slice.call(a);b.unshift(d,1);[].splice.apply(c,b);d--;continue}if(typeof a=="string")a={src:a};a=s(a,{ready:false,ready_cb:T,finished:false,finished_cb:U});k.finished=false;k.scripts.push(a);S(g,a,k,(Q&&w));w=true;if(g[z])e.wait()}})(arguments[f],arguments[f])}return e},wait:function(){if(arguments.length>0){for(var a=0;a<arguments.length;a++){h.push(arguments[a])}k=h[h.length-1]}else k=false;x();return e}};return{script:e.script,wait:e.wait,setOptions:function(a){s(a,g);return e}}}m={setGlobalDefaults:function(a){s(a,l);return m},setOptions:function(){return v().setOptions.apply(null,arguments)},script:function(){return v().script.apply(null,arguments)},wait:function(){return v().wait.apply(null,arguments)},queueScript:function(){n[n.length]={type:"script",args:[].slice.call(arguments)};return m},queueWait:function(){n[n.length]={type:"wait",args:[].slice.call(arguments)};return m},runQueue:function(){var a=m,c=n.length,b=c,d;for(;--b>=0;){d=n.shift();a=a[d.type].apply(null,d.args)}return a},noConflict:function(){o.$LAB=K;return m},sandbox:function(){return J()}};return m}o.$LAB=J();(function(a,c,b){if(document.readyState==null&&document[a]){document.readyState="loading";document[a](c,b=function(){document.removeEventListener(c,b,false);document.readyState="complete"},false)}})("addEventListener","DOMContentLoaded")})(this);
/*!
 * Bowser - a browser detector
 * https://github.com/ded/bowser
 * MIT License | (c) Dustin Diaz 2015
 */
!function(e,t,n){typeof module!="undefined"&&module.exports?module.exports=n():typeof define=="function"&&define.amd?define(t,n):e[t]=n()}(this,"bowser",function(){function t(t){function n(e){var n=t.match(e);return n&&n.length>1&&n[1]||""}function r(e){var n=t.match(e);return n&&n.length>1&&n[2]||""}function N(e){switch(e){case"NT":return"NT";case"XP":return"XP";case"NT 5.0":return"2000";case"NT 5.1":return"XP";case"NT 5.2":return"2003";case"NT 6.0":return"Vista";case"NT 6.1":return"7";case"NT 6.2":return"8";case"NT 6.3":return"8.1";case"NT 10.0":return"10";default:return undefined}}var i=n(/(ipod|iphone|ipad)/i).toLowerCase(),s=/like android/i.test(t),o=!s&&/android/i.test(t),u=/nexus\s*[0-6]\s*/i.test(t),a=!u&&/nexus\s*[0-9]+/i.test(t),f=/CrOS/.test(t),l=/silk/i.test(t),c=/sailfish/i.test(t),h=/tizen/i.test(t),p=/(web|hpw)os/i.test(t),d=/windows phone/i.test(t),v=/SamsungBrowser/i.test(t),m=!d&&/windows/i.test(t),g=!i&&!l&&/macintosh/i.test(t),y=!o&&!c&&!h&&!p&&/linux/i.test(t),b=n(/edge\/(\d+(\.\d+)?)/i),w=n(/version\/(\d+(\.\d+)?)/i),E=/tablet/i.test(t)&&!/tablet pc/i.test(t),S=!E&&/[^-]mobi/i.test(t),x=/xbox/i.test(t),T;/opera/i.test(t)?T={name:"Opera",opera:e,version:w||n(/(?:opera|opr|opios)[\s\/](\d+(\.\d+)?)/i)}:/opr|opios/i.test(t)?T={name:"Opera",opera:e,version:n(/(?:opr|opios)[\s\/](\d+(\.\d+)?)/i)||w}:/SamsungBrowser/i.test(t)?T={name:"Samsung Internet for Android",samsungBrowser:e,version:w||n(/(?:SamsungBrowser)[\s\/](\d+(\.\d+)?)/i)}:/coast/i.test(t)?T={name:"Opera Coast",coast:e,version:w||n(/(?:coast)[\s\/](\d+(\.\d+)?)/i)}:/yabrowser/i.test(t)?T={name:"Yandex Browser",yandexbrowser:e,version:w||n(/(?:yabrowser)[\s\/](\d+(\.\d+)?)/i)}:/ucbrowser/i.test(t)?T={name:"UC Browser",ucbrowser:e,version:n(/(?:ucbrowser)[\s\/](\d+(?:\.\d+)+)/i)}:/mxios/i.test(t)?T={name:"Maxthon",maxthon:e,version:n(/(?:mxios)[\s\/](\d+(?:\.\d+)+)/i)}:/epiphany/i.test(t)?T={name:"Epiphany",epiphany:e,version:n(/(?:epiphany)[\s\/](\d+(?:\.\d+)+)/i)}:/puffin/i.test(t)?T={name:"Puffin",puffin:e,version:n(/(?:puffin)[\s\/](\d+(?:\.\d+)?)/i)}:/sleipnir/i.test(t)?T={name:"Sleipnir",sleipnir:e,version:n(/(?:sleipnir)[\s\/](\d+(?:\.\d+)+)/i)}:/k-meleon/i.test(t)?T={name:"K-Meleon",kMeleon:e,version:n(/(?:k-meleon)[\s\/](\d+(?:\.\d+)+)/i)}:d?(T={name:"Windows Phone",windowsphone:e},b?(T.msedge=e,T.version=b):(T.msie=e,T.version=n(/iemobile\/(\d+(\.\d+)?)/i))):/msie|trident/i.test(t)?T={name:"Internet Explorer",msie:e,version:n(/(?:msie |rv:)(\d+(\.\d+)?)/i)}:f?T={name:"Chrome",chromeos:e,chromeBook:e,chrome:e,version:n(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)}:/chrome.+? edge/i.test(t)?T={name:"Microsoft Edge",msedge:e,version:b}:/vivaldi/i.test(t)?T={name:"Vivaldi",vivaldi:e,version:n(/vivaldi\/(\d+(\.\d+)?)/i)||w}:c?T={name:"Sailfish",sailfish:e,version:n(/sailfish\s?browser\/(\d+(\.\d+)?)/i)}:/seamonkey\//i.test(t)?T={name:"SeaMonkey",seamonkey:e,version:n(/seamonkey\/(\d+(\.\d+)?)/i)}:/firefox|iceweasel|fxios/i.test(t)?(T={name:"Firefox",firefox:e,version:n(/(?:firefox|iceweasel|fxios)[ \/](\d+(\.\d+)?)/i)},/\((mobile|tablet);[^\)]*rv:[\d\.]+\)/i.test(t)&&(T.firefoxos=e)):l?T={name:"Amazon Silk",silk:e,version:n(/silk\/(\d+(\.\d+)?)/i)}:/phantom/i.test(t)?T={name:"PhantomJS",phantom:e,version:n(/phantomjs\/(\d+(\.\d+)?)/i)}:/slimerjs/i.test(t)?T={name:"SlimerJS",slimer:e,version:n(/slimerjs\/(\d+(\.\d+)?)/i)}:/blackberry|\bbb\d+/i.test(t)||/rim\stablet/i.test(t)?T={name:"BlackBerry",blackberry:e,version:w||n(/blackberry[\d]+\/(\d+(\.\d+)?)/i)}:p?(T={name:"WebOS",webos:e,version:w||n(/w(?:eb)?osbrowser\/(\d+(\.\d+)?)/i)},/touchpad\//i.test(t)&&(T.touchpad=e)):/bada/i.test(t)?T={name:"Bada",bada:e,version:n(/dolfin\/(\d+(\.\d+)?)/i)}:h?T={name:"Tizen",tizen:e,version:n(/(?:tizen\s?)?browser\/(\d+(\.\d+)?)/i)||w}:/qupzilla/i.test(t)?T={name:"QupZilla",qupzilla:e,version:n(/(?:qupzilla)[\s\/](\d+(?:\.\d+)+)/i)||w}:/chromium/i.test(t)?T={name:"Chromium",chromium:e,version:n(/(?:chromium)[\s\/](\d+(?:\.\d+)?)/i)||w}:/chrome|crios|crmo/i.test(t)?T={name:"Chrome",chrome:e,version:n(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)}:o?T={name:"Android",version:w}:/safari|applewebkit/i.test(t)?(T={name:"Safari",safari:e},w&&(T.version=w)):i?(T={name:i=="iphone"?"iPhone":i=="ipad"?"iPad":"iPod"},w&&(T.version=w)):/googlebot/i.test(t)?T={name:"Googlebot",googlebot:e,version:n(/googlebot\/(\d+(\.\d+))/i)||w}:T={name:n(/^(.*)\/(.*) /),version:r(/^(.*)\/(.*) /)},!T.msedge&&/(apple)?webkit/i.test(t)?(/(apple)?webkit\/537\.36/i.test(t)?(T.name=T.name||"Blink",T.blink=e):(T.name=T.name||"Webkit",T.webkit=e),!T.version&&w&&(T.version=w)):!T.opera&&/gecko\//i.test(t)&&(T.name=T.name||"Gecko",T.gecko=e,T.version=T.version||n(/gecko\/(\d+(\.\d+)?)/i)),!T.windowsphone&&!T.msedge&&(o||T.silk)?T.android=e:!T.windowsphone&&!T.msedge&&i?(T[i]=e,T.ios=e):g?T.mac=e:x?T.xbox=e:m?T.windows=e:y&&(T.linux=e);var C="";T.windows?C=N(n(/Windows ((NT|XP)( \d\d?.\d)?)/i)):T.windowsphone?C=n(/windows phone (?:os)?\s?(\d+(\.\d+)*)/i):T.mac?(C=n(/Mac OS X (\d+([_\.\s]\d+)*)/i),C=C.replace(/[_\s]/g,".")):i?(C=n(/os (\d+([_\s]\d+)*) like mac os x/i),C=C.replace(/[_\s]/g,".")):o?C=n(/android[ \/-](\d+(\.\d+)*)/i):T.webos?C=n(/(?:web|hpw)os\/(\d+(\.\d+)*)/i):T.blackberry?C=n(/rim\stablet\sos\s(\d+(\.\d+)*)/i):T.bada?C=n(/bada\/(\d+(\.\d+)*)/i):T.tizen&&(C=n(/tizen[\/\s](\d+(\.\d+)*)/i)),C&&(T.osversion=C);var k=!T.windows&&C.split(".")[0];if(E||a||i=="ipad"||o&&(k==3||k>=4&&!S)||T.silk)T.tablet=e;else if(S||i=="iphone"||i=="ipod"||o||u||T.blackberry||T.webos||T.bada)T.mobile=e;return T.msedge||T.msie&&T.version>=10||T.yandexbrowser&&T.version>=15||T.vivaldi&&T.version>=1||T.chrome&&T.version>=20||T.samsungBrowser&&T.version>=4||T.firefox&&T.version>=20||T.safari&&T.version>=6||T.opera&&T.version>=10||T.ios&&T.osversion&&T.osversion.split(".")[0]>=6||T.blackberry&&T.version>=10.1||T.chromium&&T.version>=20?T.a=e:T.msie&&T.version<10||T.chrome&&T.version<20||T.firefox&&T.version<20||T.safari&&T.version<6||T.opera&&T.version<10||T.ios&&T.osversion&&T.osversion.split(".")[0]<6||T.chromium&&T.version<20?T.c=e:T.x=e,T}function r(e){return e.split(".").length}function i(e,t){var n=[],r;if(Array.prototype.map)return Array.prototype.map.call(e,t);for(r=0;r<e.length;r++)n.push(t(e[r]));return n}function s(e){var t=Math.max(r(e[0]),r(e[1])),n=i(e,function(e){var n=t-r(e);return e+=(new Array(n+1)).join(".0"),i(e.split("."),function(e){return(new Array(20-e.length)).join("0")+e}).reverse()});while(--t>=0){if(n[0][t]>n[1][t])return 1;if(n[0][t]!==n[1][t])return-1;if(t===0)return 0}}function o(e,r,i){var o=n;typeof r=="string"&&(i=r,r=void 0),r===void 0&&(r=!1),i&&(o=t(i));var u=""+o.version;for(var a in e)if(e.hasOwnProperty(a)&&o[a]){if(typeof e[a]!="string")throw new Error("Browser version in the minVersion map should be a string: "+a+": "+String(e));return s([u,e[a]])<0}return r}function u(e,t,n){return!o(e,t,n)}var e=!0,n=t(typeof navigator!="undefined"?navigator.userAgent||"":"");return n.test=function(e){for(var t=0;t<e.length;++t){var r=e[t];if(typeof r=="string"&&r in n)return!0}return!1},n.isUnsupportedBrowser=o,n.compareVersions=s,n.check=u,n._detect=t,n})

/****** Prototype NGETOOLS ******/
var NGETOOLS = (function () {
    /**** PUBLIC attribut ****/
    NGETOOLS.prototype.bowser = bowser;
    
    /**** PUBLIC method ****/   
    /**
     * Show notification message when update something.
     * @param String message 
     * @param String type Message type (success, error, warning)
     * @param int duration
     * @param String container can be Id or Class. Default jQuery("body")
     */
    NGETOOLS.prototype.showNotification = function (message, type, duration, container) {
        var $container = typeof container !== "undefined" ? jQuery(container) : jQuery("body");
        var icon = "icomoon-checkmark";
        if (type === "warning") {
            icon = "icomoon-warning";
        } else if (type === "error") {
            icon = "icomoon-cross";
        }
        
        var messageBoxHtml = '<div class="nge-notification-box nge-notification-box-'+type+'">'
            +'<span class="icomoon '+icon+'"></span>'
            +'<span class="nge-message">'+message+'</span>'
        +'</div>';
        
        var $messageBox = jQuery(messageBoxHtml);
        
        $container.prepend($messageBox);
        
        var messageBoxTop = 10;
        messageBoxTop = $container.offset().top + 10 - jQuery(window).scrollTop();
        
        $messageBox.css({
            "top": messageBoxTop + "px"
        });
        
        $messageBox.show("slide", {direction: "left"}, 400, function () {
            setTimeout(function () {
                $messageBox.fadeOut(400, function () {
                    $messageBox.remove();
                });
            }, duration);
        });
    };
    
    /**
    * Load Modal
    * Load url content html in modal
    * params is  json object
    * known properties : 
    * title: displayed text in the modal header
    * buttons : 
    *  -> NEW way used object buttons to show and override events : 
    *              buttons : {
    *                   cancel: {
    *                       label: "FERMER"
    *                   },
    *                   stopEventsPropagation: false,
    *                   callback: function () {}
    *               }
    * backgroundColor: background color of the modal header
    * width: width in pixels of the modal window
    * height: height in pixels of the modal window
    */
    NGETOOLS.prototype.loadModal = function (params) {
        /*Same as above, but this time it loads the url in the iframe all the time. So it reloads the scripts every time*/
        var responsive = typeof params.responsive !== "undefined" ? params.responsive : false;
        var modalId = typeof params.modalId !== "undefined" ? params.modalId : null;
        var isIframe = typeof params.isIframe !== "undefined" ? params.isIframe : false;
        var $generalModal = jQuery("#nge-modal-general");
        
        if(modalId !== null){
            if(jQuery("#"+modalId).length > 0){
                $generalModal = jQuery("#"+modalId);
            }else{
                var $generalModalClone = $generalModal.clone();
                $generalModalClone.attr("id", modalId);
                $generalModal.parent().append($generalModalClone);
                $generalModal = $generalModalClone;

                $generalModal.draggable({
                    handle: ".modal-header",
                    scroll: false,
                    drag : function(e,ui){            
                        //Do not permit to go outside the window      
                        if(ui.position.top < 0){   
                            ui.position.top = 0;
                        }
                        if(ui.position.left > jQuery(window).width() - jQuery(this).width()){   
                            ui.position.left = jQuery(window).width() - jQuery(this).width();
                        }
                        if(ui.position.left < 0){   
                            ui.position.left = 0;
                        }
                        if(ui.position.top >(jQuery(window).height() - jQuery(this).height())){   
                            ui.position.top = jQuery(window).height() - jQuery(this).height();
                        }
                    }
                });
            }
        }
    
        if(!$generalModal.is('.ui-draggable')){
            $generalModal.draggable({
                handle: ".modal-header",
                scroll: false,
                drag : function(e,ui){            
                    //Do not permit to go outside the window      
                    if(ui.position.top < 0){   
                        ui.position.top = 0;
                    }
                    if(ui.position.left > jQuery(window).width() - jQuery(this).width()){   
                        ui.position.left = jQuery(window).width() - jQuery(this).width();
                    }
                    if(ui.position.left < 0){   
                        ui.position.left = 0;
                    }
                    if(ui.position.top >(jQuery(window).height() - jQuery(this).height())){   
                        ui.position.top = jQuery(window).height() - jQuery(this).height();
                    }
                }
            });
        }

        var $generalModalHeader = $generalModal.find(".modal-header");

        if(!responsive){ /*In px*/
            $generalModal.width(params.width).height(params.height);
            /*Center modal*/
            var windowHeight = jQuery(window).height();
            var windowWidth = jQuery(window).width();
            var boxHeight = $generalModal.height();
            var boxWidth = $generalModal.width();
            $generalModal.css({
                'left' : ((windowWidth - boxWidth)/2), 
                'top' : ((windowHeight - boxHeight)/2),
                "transform": "initial"
            });
            $generalModalHeader.css('cursor' , "move");
            $generalModal.draggable( "enable" );
        }else{ /*Responsive in %*/
            $generalModal.css({
                "width": params.width+"%",
                "height": params.height+"%",
                "top": ((100-params.height)/2)+"%",
                "left": ((100-params.width)/2)+"%"
            });
            $generalModalHeader.css('cursor' , "initial");
            if($generalModal.is('.ui-draggable')){
                $generalModal.draggable( "disable" );
            }
        }

        $generalModal.find(".nge-modal-title").html(params.title);		    
            //Submit buttons
            if (typeof params.buttons === "undefined"){
                //Default buttons
                $generalModal.find('.button-modalgeneral-submit').css( "display", "inline-block");
                $generalModal.find('.button-modalgeneral-cancel').css( "display", "inline-block");
                $generalModal.find('.button-modalgeneral-close').hide();
            }else{
                $generalModal.find('.nge-modal-button').children().hide();
                
                for (var button in params.buttons) {
                    var $button = $generalModal.find('.button-modalgeneral-'+button);
                    var stopEventsPropagation = typeof params.buttons[button].stopEventsPropagation !== "undefined" ? params.buttons[button].stopEventsPropagation : false;

                    $button.show();
                    
                    if(typeof params.buttons[button].callback !== "undefined"){
                        $button.data("buttonName", button);
                        $button.off("click").on( "click", function(evt) {
                            var currentButton = jQuery(this).data("buttonName");
                            if(stopEventsPropagation){
                                evt.preventDefault();
                                evt.stopPropagation();
                            }

                            params.buttons[currentButton].callback($button);
                        });
                    }
                }
            }
            $generalModal.find(".nge-loading-content").show();
            $generalModal.modal("show");

        /*Here not before else outerHeight is not well calculate*/
        var $generalModalHeader = $generalModal.find(".modal-header");
        $generalModalHeader.css('background-color', params.backgroundColor);	
        if (typeof params.hoverColor !== "undefined")
	$generalModal.find(".button-modalgeneral").hover(function(e) {
	    jQuery(this).css("background-color", e.type === "mouseenter"?params.hoverColor:"transparent")
	});
        $generalModal.find(".nge-modal-body").height($generalModal.outerHeight() - $generalModalHeader.outerHeight());

        var $generalModalContent = $generalModal.find(".nge-modal-content");
        if($generalModalContent.length > 0){
            $generalModalContent.css("visibility", "hidden");
            
            if(isIframe === false){
                jQuery.ajax({
                    url: params.url,
                    success: function (result) {
                        try {
                            $generalModalContent.html(result);
                            if(typeof params.callback !== "undefined"){
                                params.callback.call(this, $generalModalContent);
                            }
                        } catch (err) {
                            $generalModalContent.html("Error : to load html!<br>" + err.toString());
                            console.error("Error : to load html!<br>" + err.toString());
                        }
                    },
                    error: function () {
                        $generalModalContent.html("Error : to load html!");
                        console.error("Error : to load html!");
                    },
                    complete: function () {
                        $generalModal.find(".nge-loading-content").hide();
                        $generalModalContent.css("visibility", "visible");
                    },
                });
            }else{
                var $frame = jQuery('<iframe frameborder="0" width="100%" height="100%"></iframe>');
                $generalModalContent.html($frame);
                setTimeout( function() {
                    $frame.attr('src', params.url);
                    $frame.load(function() {
                        if(typeof params.callback !== "undefined"){
                            var doc = $frame[0].contentWindow.document;
                            var $body = jQuery('body',doc);
                            params.callback.call(this, $body, $frame);
                        }
                        
                        $generalModal.find(".nge-loading-content").hide();
                        $generalModalContent.css("visibility", "visible");
                        
                        /*Set focus inside for specific take effect like keypress...*/
                        $frame[0].contentWindow.focus();
                    });
                }, 1 );
            }
        }
    };
    
    /**
     * Loading all external font of a widget.
     * The function must be call before the dom is created if you want the font apply on the dom
     * @param Array arrayFontsToLoad : Array of fonts url we wants to load, in the order in which they are loaded
     * No dependencies like loadScripts function
     * External & internal url : No protocol needed (remove http:// or https://) just //
     * Example : [
            "My Font Name", "//www.fontname.fr./fontname.js"}
        ]
     */
    this._arrayFontsLoaded = [];
    
    NGETOOLS.prototype.loadFonts = function (arrayFontsToLoad) {
        var _this = this;
        
        for (var key in arrayFontsToLoad) {
            /*The path is not yet loaded, pull it into the deferred array*/
            if(jQuery.inArray(arrayFontsToLoad[key].url, _this._arrayFontsLoaded) === -1){

                var css = "";
                css += "@font-face {";
                css += "font-family: '"+arrayFontsToLoad[key].name+"';";
                css += "src: url('"+arrayFontsToLoad[key].url+"');";
                css += "}";
                
                var $head = jQuery("head");
                var $ngeToolsLoadFonts = $head.find("style.ngetools-loadfonts");
                if($ngeToolsLoadFonts.length === 0){
                    css = '<style class="ngetools-loadfonts">'+css+'</style>';
                    $head.append(css);
                }else{
                    $ngeToolsLoadFonts.append(css);
                }
                
                _this._arrayFontsLoaded.push(arrayFontsToLoad[key].url);
            }
        }
    };
    
    /**
     * Loading all css files, once, of a widget.
     * The function must be call before the dom is created if you want the css apply on the dom
     * @param Array arrayStylesheetsToLoad : Array of css libraries we wants to load, in the order in which they are loaded.
     * Urls must have the same syntax. In order not to have duplicates of the same url but different syntax. External and internal url authorized
     * No dependencies like loadScripts function
     * External & internal url : No protocol needed (remove http:// or https://) just //
     * Example : [
            "//www.externalUrl.fr./myfile.css"},
            "internalUrl/path_to_file/myfile2.css"},
        ]
     */
    this._arrayStylesheetsLoaded = [];
    
    NGETOOLS.prototype.loadStylesheets = function (arrayStylesheetsToLoad) {
        var _this = this;
        
        for (var key in arrayStylesheetsToLoad) {
            /*The path is not yet loaded, pull it into the deferred array*/
            if(jQuery.inArray(arrayStylesheetsToLoad[key], _this._arrayStylesheetsLoaded) === -1){
                if(arrayStylesheetsToLoad[key].indexOf(".css") !== -1){/*It's a css file*/
                    if(document.createStyleSheet) {
                        try {document.createStyleSheet(arrayStylesheetsToLoad[key]);} catch (e) { }
                    }else{
                        var css;
                        css         = document.createElement('link');
                        css.rel     = 'stylesheet';
                        css.type    = 'text/css';
                        css.media   = "all";
                        css.href    = arrayStylesheetsToLoad[key];
                        document.getElementsByTagName("head")[0].appendChild(css);
                        
                        _this._arrayStylesheetsLoaded.push(arrayStylesheetsToLoad[key]);
                    }
                }else{ /*It's another file*/
                    console.error("WARNING : The files must be css files");
                }
            }
        }
    };

    /**
     * Loading all js files, once, of a widget.
     * @dependencies LAB.JS - If lab.js doesn't exist create error. It is loaded at the beginning of this file.
     * @param Array arrayScriptsToLoad : Array of JS libraries we wants to load, in the order in which they are loaded.
     * Urls must have the same syntax. In order not to have duplicates of the same url but different syntax. External and internal url authorized
     * Urls , need to point to unique and same script. You can't call or re-declare two libraries with different versions in the same page, for example.
     * If script js have dependencie, follow the right syntax to call it and use requires parameters
     * External & internal url : No protocol needed (remove http:// or https://) just //
     * Example : [
            {path : "//www.externalUrl.fr./myfile.js"}, After js
            {
                path : "//www.externalUrl2.fr./myfile2.js",
                requires : [
                    {path : "internalUrl/path_to_file/myfile3.js"}, Is loaded only after the file "myfile2.js" is loaded
                    {path : "//www.externalUrl3.fr./xxx/myfile3.js"} Is loaded only after the file "myfile2.js" is loaded
                ]
            }
        ]
     * @param callback Launch callback function when all scripts are loaded. It is saved in memory if several functions have to be called up after the scripts are loaded.
     */
    
    this._arrayScriptsLoaded = [];
    this._arrayScriptsLoading = [];
    this._arrayScriptsCallback = [];
    this._arrayScriptsDeferred = [];
    this._stringScriptsExpr = ""; /*Because $LAB doesn't take array as argument but only chaining we have to do a hack to launch chaining paramaters form an array of path*/
    this._timerScriptsLoading;
    this._arrayStylesheetsLoaded = [];
    
    NGETOOLS.prototype.loadScripts = function (arrayScriptsToLoad, callbackFunctionName) {
        callbackFunctionName = (typeof callbackFunctionName !== "undefined") ? callbackFunctionName : null;
        var _this = this;

        function createStringExp$LAB (arrayPath, isRequiredArray){
            isRequiredArray = (typeof isRequiredArray !== "undefined") ? isRequiredArray : false;

            var constructStringJS = "";
            for (var key in arrayPath) {
                /*The path is not yet loaded, pull it into the deferred array*/
                if(jQuery.inArray(arrayPath[key].path, _this._arrayScriptsLoaded) === -1){
                    if(jQuery.inArray(arrayPath[key].path, _this._arrayScriptsLoading) === -1){
                        /*if(arrayPath[key].path.indexOf(".js") !== -1){/_*It's a js file*_/  For scripts with another extensions anf suffixes like ?key=xxxi*/
                            _this._arrayScriptsLoading.push(arrayPath[key].path);

                            if(typeof arrayPath[key].requires !== "undefined"){
                                if(!isRequiredArray){
                                    constructStringJS += '$LAB.script("'+arrayPath[key].path+'").wait()';
                                }else{
                                    constructStringJS += '.script("'+arrayPath[key].path+'").wait()';
                                }
                                constructStringJS += createStringExp$LAB(arrayPath[key].requires, true);
                            }else{
                                if(!isRequiredArray){
                                    _this._arrayScriptsDeferred.push(jQuery.Deferred());
                                    constructStringJS += '$LAB.script("'+arrayPath[key].path+'").wait(function(){_this._arrayScriptsDeferred['+(_this._arrayScriptsDeferred.length-1)+'].resolve();});';
                                }else{
                                    constructStringJS += '.script("'+arrayPath[key].path+'")';
                                }
                            }
                        /*}else{ /_*It's another file*_/
                            console.error("WARNING : The files must be js files");
                        }*/
                    }else{/*The path is loading, check is required script if they are loaded*/
                        if(typeof arrayPath[key].requires !== "undefined"){
                            if(!isRequiredArray){
                                constructStringJS += createStringExp$LAB(arrayPath[key].requires);
                            }else{
                                constructStringJS += createStringExp$LAB(arrayPath[key].requires, true);
                            }
                        }
                    }
                }else{/*The path is loaded, check is required script if they are loaded*/
                    if(typeof arrayPath[key].requires !== "undefined"){
                        if(!isRequiredArray){
                            constructStringJS += createStringExp$LAB(arrayPath[key].requires);
                        }else{
                            constructStringJS += createStringExp$LAB(arrayPath[key].requires, true);
                        }
                    }
                }
            }

            if(isRequiredArray){
                _this._arrayScriptsDeferred.push(jQuery.Deferred());
                constructStringJS += '.wait(function(){_this._arrayScriptsDeferred['+(_this._arrayScriptsDeferred.length-1)+'].resolve();});';
            }
            
            return constructStringJS;
        }
        
        function isArrayPathLoaded (arrayPath){
            var isLoaded = true;
            
            for (var key in arrayPath) {
                if(jQuery.inArray(arrayPath[key].path, _this._arrayScriptsLoaded) === -1){
                    isLoaded = false;
                }
                    
                if(typeof arrayPath[key].requires !== "undefined"){
                    isLoaded = isArrayPathLoaded(arrayPath[key].requires);
                }
            }
            
            return isLoaded;
        }
        
        /*If array of libraries exist*/
        if(typeof arrayScriptsToLoad === "object" && arrayScriptsToLoad.length > 0){
            var currentWidgetExp = createStringExp$LAB(arrayScriptsToLoad);

            if(currentWidgetExp !== ""){
                _this._stringScriptsExpr += currentWidgetExp;
                
                if(typeof callbackFunctionName === "function"){
                    _this._arrayScriptsCallback.push(callbackFunctionName);
                }
            }else{
                var isLoaded = isArrayPathLoaded(arrayScriptsToLoad);

                if(isLoaded){
                    callbackFunctionName();
                }else{
                    if(typeof callbackFunctionName === "function"){
                        _this._arrayScriptsCallback.push(callbackFunctionName);
                    }
                }
            }
        }else{
            console.error("WARNING : Array of scripts does not have the correct format. \n For example: [{path: path_to_your_file.js}, {path: path_to_your_file2.js}]")
        }  

        /*Always clear the previously timer*/
        clearTimeout(_this._timerScriptsLoading);
        
        /*Timer to only load at the last call of loadScripts function*/
        _this._timerScriptsLoading = setTimeout(function(){
            if(_this._stringScriptsExpr !== ""){
                _this._stringScriptsExpr = "$LAB.setGlobalDefaults({AlwaysPreserveOrder:true});"+_this._stringScriptsExpr;
            
                jQuery.when.apply(jQuery, _this._arrayScriptsDeferred).done(function (a1, a2, a3) {
                    try {
                        for (var key in _this._arrayScriptsCallback) {
                            /*Call all callback specific to the current widget (group) type of libraries*/
                            if(typeof _this._arrayScriptsCallback[key] === "function"){
                                _this._arrayScriptsCallback[key]();
                            }
                        }
                        
                        /*Reset Value*/
                        jQuery.merge( _this._arrayScriptsLoaded, _this._arrayScriptsLoading );
                        _this._arrayScriptsLoading = [];
                        _this._arrayScriptsCallback = [];
                        _this._arrayScriptsDeferred = [];
                    } catch (e) {
                        console.error(e);
                    }
                });

                /*Execute the $LAB loading scripts*/
                eval(_this._stringScriptsExpr);
                _this._stringScriptsExpr = "";
            }else{ /*Is EMPTY*/
                for (var key in _this._arrayScriptsCallback) {
                    /*Call all callback specific to the current widget (group) type of libraries*/
                    if(typeof _this._arrayScriptsCallback[key] === "function"){
                        _this._arrayScriptsCallback[key]();
                    }
                }
                
                /*Reset Value*/
                jQuery.merge( _this._arrayScriptsLoaded, _this._arrayScriptsLoading );
                _this._arrayScriptsLoading = [];
                _this._arrayScriptsCallback = [];
                _this._arrayScriptsDeferred = [];
                _this._stringScriptsExpr = "";
            }
        }, 20);
    };
    
     /**
     * Create custom scrollbar that replaces the browser's ugly scrollbar for a specific container element
     * https://nicescroll.areaaperta.com/demo/
     * @dependencies media/com_nge/nicescroll/jquery.nicescroll.min.js
     * @param jQuery Selector pointing to the container elements
     * @param Options theme to customized the current scrollbar
     */
    NGETOOLS.prototype.createCustomScrollbar = function (jQuerySelector, options) {
        options = (typeof options !== "undefined") ? options : {};
        
        var scrollbar = {
            init: function(){
                var currentScroll = jQuerySelector.niceScroll(options);
            },
            update: function(){
                jQuerySelector.getNiceScroll().resize();
            }
        }
        
        return scrollbar;
    };

    /**
     *  Class array : Allows to manipulate arrays for the moment only method multisort is available
     */
    NGETOOLS.prototype.array = {
        /**
        * Function to sort multidimensional array
        * It's a beggining because the sort inside an array is very complicated
        * For the moment we can only, sort by column, ASC or DESC by string, numeric or date(no case sensitive).
        * À perspective of evolution like excel with this librairies https://github.com/Teun/thenBy.js
        * @param {array} [arr] Source array
        * @param {array} [columns] List of columns to sort (object or index) ['name1', 'name2'] or ['0', '1'] 
        * @param {array} [order_by] List of directions (ASC, DESC)
        * @returns {array}
        */
        multisort: function(arr, columns, order_by) {
            if(typeof columns == 'undefined') {
                columns = []
                for(x=0;x<arr[0].length;x++) {
                    columns.push(x);
                }
            }

            if(typeof order_by == 'undefined') {
                order_by = []
                for(x=0;x<arr[0].length;x++) {
                    order_by.push('ASC');
                }
            }

            function IsDate(testValue) {
                var returnValue = false;
                var testDate;
                try {
                    testDate = new Date(testValue);
                    if (!isNaN(testDate)) {
                        returnValue = true;
                    } else {
                        returnValue = false;
                    }
                }catch (e) {
                    returnValue = false;
                }
                return returnValue;
            }

            function multisort_recursive(a,b,columns,order_by,index) {  
                var direction = order_by[index] == 'DESC' ? 1 : 0;
                var is_date =  (IsDate(a[columns[index]]) && IsDate(b[columns[index]]))
                var is_numeric = (!isNaN(+a[columns[index]] - +b[columns[index]]));

                if(is_numeric){ /*Numeric*/
                    var x = +a[columns[index]];
                    var y = +b[columns[index]];
                }else if (is_date){ /*Date*/
                    var x = new Date(a[columns[index]]);
                    var y = new Date(b[columns[index]]);
                }else{/*String no case sensitive and no accent*/
                    var x = a[columns[index]].toLowerCase().normalize('NFD').replace(/[\u0300-\u036f]/g, "");
                    var y = b[columns[index]].toLowerCase().normalize('NFD').replace(/[\u0300-\u036f]/g, "");
                }

                if(x < y) {
                    return direction == 0 ? -1 : 1;
                }

                if(x == y)  {               
                    return columns.length-1 > index ? multisort_recursive(a,b,columns,order_by,index+1) : 0;
                }

                return direction == 0 ? 1 : -1;
            }

            return arr.sort(function (a,b) {
                return multisort_recursive(a,b,columns,order_by,0);
            });
        }
    };
    
    /**
     * Get widget svg with url renderer if exist else return null. If CALLBACK specified, call it when svg is retrieved.
     */
    NGETOOLS.prototype.iframeCount = 0;
    NGETOOLS.prototype.getWidgetSvg = function(url, options, callback) {
        options = (typeof options !== "undefined") ? options : null;
        callback = (typeof callback !== "undefined") ? callback : null;
        var millisecond = new Date().getTime();
        var iframeClass = 'print_htmltosvg_'+NGETOOLS.prototype.iframeCount+"_"+millisecond;
        var hasJsError = false;

        jQuery("body").append('<div style="position:fixed;left:-5000px;top:-5000px;width:100%;overflow: hidden;"><iframe class="'+iframeClass+'" src="'+url+'" width="570px" height="500px" frameborder="0"></iframe></div>');
        var $currentiframe = jQuery('.'+iframeClass);
        NGETOOLS.prototype.iframeCount++;
        
        //If js error append inside iframe, means the url is not well formatted to render a svg.
        $currentiframe[0].contentWindow.onerror = function (errorMsg, url, lineNumber, column, errorObj) {
            hasJsError = true;
            if(callback !== null && typeof callback === "function"){
                callback.call(this, null);
            }
            
            return true;
        };
        
        /*Function to get svg until specific time default 60s after do nothing*/
        launchTimeOut = function($iframe, callback, intialTime, currentTime, endTime){
            currentTime = (typeof currentTime !== "undefined") ? currentTime : intialTime;
            endTime = (typeof endTime !== "undefined") ? endTime : 60000;
            
            if(currentTime < endTime){
                setTimeout(function(){
                    if(!hasJsError){
                        var realSvg = '<?xml version="1.0" encoding="UTF-8" standalone="no"?>';
                        var svgElement = $iframe.contents().find("svg");
                        var currentSvg = svgElement.parent().html();

                        if(svgElement.length > 0 ){
                            if(typeof currentSvg !== "undefined"){
                                if(typeof options.chartWidth !== "undefined"){
                                    svgElement.attr("width", options.chartWidth);
                                }
                                if(typeof options.chartHeight !== "undefined"){
                                    svgElement.attr("height", options.chartHeight);
                                }

                                realSvg += svgElement.parent().html();
                            }else{
                                realSvg += '<text>Error to find svg attribute !!!</text>';
                            }

                            if(callback !== null && typeof callback === "function"){
                                callback.call(this, realSvg);
                            }

//                            $iframe.parent().remove();
                        }else{
                            launchTimeOut($iframe, callback, intialTime, currentTime+intialTime);
                        }
                    }
                }, intialTime);
            }else{
                if(callback !== null && typeof callback === "function"){
                    callback.call(this, null);
                }
            }
        }
        
        var timeout = (typeof options.timeout !== "undefined") ? options.timeout : 2000;
        launchTimeOut($currentiframe, callback, timeout);
    };
    
    /**
     * Create Thumbnail (png) for the current widget Id.
     */
    NGETOOLS.prototype.createWidgetThumbnail = function(widgetId, urlBase) {
        urlBase = (typeof urlBase !== "undefined") ? urlBase : NGETOOLS.prototype.getBaseUrl();

        if((typeof widgetId !== "undefined") && Number.isInteger(parseInt(widgetId))){
            var url= urlBase+'index.php?option=com_ngd&view=widget&format=raw&template=htmltosvg&id='+widgetId;
            var options = {
                chartWidth : '500',
                chartHeight : '500'
            };

            ngetools.getWidgetSvg(url, options, function(svg){
                if(svg !== null || svg !== ""){/*Get svg to create thumbnail for chart*/
                    var data = {};
                    data.pk = widgetId;
                    data.svg = svg;

                    var url = urlBase+"index.php?option=com_nge&task=part.createThumbnail";
                    jQuery.ajax({
                        type : 'POST',
                        url:url,
                        data:data,
                        success : function(result){
                            var result_obj = jQuery.parseJSON(result);
                            if (result_obj.result === '0') {
                                console.error(result_obj.message);
                            }else { /* error > 0 == pas d'erreur*/
                            }
                        },
                        error : function(result){
                            console.error("Erreur : impossible de générer le svg");   
                        }
                    });
                }else{ /*Use thumbnail creating script*/
                    var url = urlBase+"index.php?option=com_nge&task=part.createThumbnail&pk="+widgetId;
                    jQuery.ajax({
                        type : 'POST',
                        url:url,
                        success : function(result){
                            var result_obj = jQuery.parseJSON(result);
                            if (result_obj.result === '0') {
                                console.error(result_obj.message);
                            }else { /* error > 0 == pas d'erreur*/
                            }
                        },
                        error : function(result){
                            console.error("Erreur : impossible de générer le svg");   
                        }
                    });
                }
            });
        }else{
            console.error("Error to create widget thumbnail : No widget ID specified!")
        }
    };
    function createThumbnail(widgetId, urlBase){
        
    };
    
    /**
     * Get the numbers of decimal of a string number. We need string number else round the number if too more decimal
     */
    NGETOOLS.prototype.decimalPlaces = function(n) {
        n = n.replace(',', '.');
        var nb_dec = n.split('.');
        
        return (typeof nb_dec[1] !== "undefined") ? nb_dec[1].length : 0;
    };
    
    /**
     * Detect if the browser is mobile or tablet
     */
    NGETOOLS.prototype.isMobile = function () {
        
        var isMobile = false; /*initiate as false*/
        var isMobileFictive = sessionStorage.getItem("isMobileFictive") == 'true'; /*To specified if we are in imaginary mobile mode.*/
        
        /* device detection */
        if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|ipad|iris|kindle|Android|Silk|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i.test(navigator.userAgent)
                || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(navigator.userAgent.substr(0, 4)))
            isMobile = true; 

        if(!isMobile && isMobileFictive){
            isMobile = true;
        }
        
        return isMobile;
    };
    
    NGETOOLS.prototype.getBaseUrl = function(){
        var file = (typeof url('file') !== "undefined") ? url('file') : "index.";
        var currentUrl = url().substring(0, url().indexOf(file));
        return (typeof baseUrl !== 'undefined') ? baseUrl : currentUrl;
    };
    
    /**** PRIVATE method ****/
    /**
     * Decode URL navigator and get specific element
     * js-url - v2.3.0 - 2016-03-10
     */
    url = function(){function a(){}function b(a){return decodeURIComponent(a.replace(/\+/g," "))}function c(a,b){var c=a.charAt(0),d=b.split(c);return c===a?d:(a=parseInt(a.substring(1),10),d[0>a?d.length+a:a-1])}function d(a,c){for(var d=a.charAt(0),e=c.split("&"),f=[],g={},h=[],i=a.substring(1),j=0,k=e.length;k>j;j++)if(f=e[j].match(/(.*?)=(.*)/),f||(f=[e[j],e[j],""]),""!==f[1].replace(/\s/g,"")){if(f[2]=b(f[2]||""),i===f[1])return f[2];h=f[1].match(/(.*)\[([0-9]+)\]/),h?(g[h[1]]=g[h[1]]||[],g[h[1]][h[2]]=f[2]):g[f[1]]=f[2]}return d===a?g:g[i]}return function(b,e){var f,g={};if("tld?"===b)return a();if(e=e||window.location.toString(),!b)return e;if(b=b.toString(),f=e.match(/^mailto:([^\/].+)/))g.protocol="mailto",g.email=f[1];else{if((f=e.match(/(.*?)\/#\!(.*)/))&&(e=f[1]+f[2]),(f=e.match(/(.*?)#(.*)/))&&(g.hash=f[2],e=f[1]),g.hash&&b.match(/^#/))return d(b,g.hash);if((f=e.match(/(.*?)\?(.*)/))&&(g.query=f[2],e=f[1]),g.query&&b.match(/^\?/))return d(b,g.query);if((f=e.match(/(.*?)\:?\/\/(.*)/))&&(g.protocol=f[1].toLowerCase(),e=f[2]),(f=e.match(/(.*?)(\/.*)/))&&(g.path=f[2],e=f[1]),g.path=(g.path||"").replace(/^([^\/])/,"/$1").replace(/\/$/,""),b.match(/^[\-0-9]+$/)&&(b=b.replace(/^([^\/])/,"/$1")),b.match(/^\//))return c(b,g.path.substring(1));if(f=c("/-1",g.path.substring(1)),f&&(f=f.match(/(.*?)\.(.*)/))&&(g.file=f[0],g.filename=f[1],g.fileext=f[2]),(f=e.match(/(.*)\:([0-9]+)$/))&&(g.port=f[2],e=f[1]),(f=e.match(/(.*?)@(.*)/))&&(g.auth=f[1],e=f[2]),g.auth&&(f=g.auth.match(/(.*)\:(.*)/),g.user=f?f[1]:g.auth,g.pass=f?f[2]:void 0),g.hostname=e.toLowerCase(),"."===b.charAt(0))return c(b,g.hostname);a()&&(f=g.hostname.match(a()),f&&(g.tld=f[3],g.domain=f[2]?f[2]+"."+f[3]:void 0,g.sub=f[1]||void 0)),g.port=g.port||("https"===g.protocol?"443":"80"),g.protocol=g.protocol||("443"===g.port?"https":"http")}return b in g?g[b]:"{}"===b?g:void 0}}(),"undefined"!=typeof jQuery&&jQuery.extend({url:function(a,b){return window.url(a,b)}});

/*!
 * jQuery initialize - v1.1.0 - 06/02/2017
 * https://github.com/adampietrasiak/jquery.initialize
 *
 * Copyright (c) 2015-2016 Adam Pietrasiak
 * Released under the MIT license
 * https://github.com/timpler/jquery.initialize/blob/master/LICENSE
 * 
 */
(function($){"use strict";var combinators=[" ",">","+","~"];var fraternisers=["+","~"];var complexTypes=["ATTR","PSEUDO","ID","CLASS"];function grok(msobserver){if(!$.find.tokenize){msobserver.isCombinatorial=true;msobserver.isFraternal=true;msobserver.isComplex=true;return}msobserver.isCombinatorial=false;msobserver.isFraternal=false;msobserver.isComplex=false;var token=$.find.tokenize(msobserver.selector);for(var i=0;i<token.length;i++){for(var j=0;j<token[i].length;j++){if(combinators.indexOf(token[i][j].type)!=-1)msobserver.isCombinatorial=true;if(fraternisers.indexOf(token[i][j].type)!=-1)msobserver.isFraternal=true;if(complexTypes.indexOf(token[i][j].type)!=-1)msobserver.isComplex=true}}}var MutationSelectorObserver=function(selector,callback,options){this.selector=selector.trim();this.callback=callback;this.options=options;grok(this)};var msobservers=[];msobservers.initialize=function(selector,callback,options){var seen=[];var callbackOnce=function(){if(seen.indexOf(this)==-1){seen.push(this);$(this).each(callback)}};$(options.target).find(selector).each(callbackOnce);var msobserver=new MutationSelectorObserver(selector,callbackOnce,options);this.push(msobserver);var observer=new MutationObserver(function(mutations){var matches=[];function push(match){matches.push(match)}for(var m=0;m<mutations.length;m++){if(mutations[m].type=="attributes"){if(mutations[m].target.matches(msobserver.selector))matches.push(mutations[m].target);if(msobserver.isFraternal)mutations[m].target.parentElement.querySelectorAll(msobserver.selector).forEach(push);else mutations[m].target.querySelectorAll(msobserver.selector).forEach(push)}if(mutations[m].type=="childList"){for(var n=0;n<mutations[m].addedNodes.length;n++){if(!(mutations[m].addedNodes[n]instanceof Element))continue;if(mutations[m].addedNodes[n].matches(msobserver.selector))matches.push(mutations[m].addedNodes[n]);if(msobserver.isFraternal)mutations[m].addedNodes[n].parentElement.querySelectorAll(msobserver.selector).forEach(push);else mutations[m].addedNodes[n].querySelectorAll(msobserver.selector).forEach(push)}}}matches.forEach(function(match){$(match).each(msobserver.callback)})});var defaultObeserverOpts={childList:true,subtree:true,attributes:msobserver.isComplex};observer.observe(options.target,options.observer||defaultObeserverOpts)};$.fn.initialize=function(callback,options){msobservers.initialize(this.selector,callback,$.extend({},$.initialize.defaults,options))};$.initialize=function(selector,callback,options){msobservers.initialize(selector,callback,$.extend({},$.initialize.defaults,options))};$.initialize.defaults={target:document.documentElement,observer:null}})(jQuery);   
    
});

var ngetools = new NGETOOLS();