/**
 * plugin.js
 *
 * Copyright, Teatis
 * Released under LGPL License.
 *
 * License: http://www.nextgeneditor.com/license
 */

tinymce.PluginManager.add('nge', function(editor, url) {

	function showDialog() {
		var win, data;

		data = getData(editor.selection.getNode());
		window.top.htmlpart = '';

		//Reading part id from data-part attribute : new part, or existing part    
		if(data['data-part']) 
			url_config = 'index.php?option=com_nge&view=config&caller=tinymce&mode=edit&tmpl=component&format=raw&pk='+data['data-part'];
		else	
			url_config = 'index.php?option=com_nge&view=librarygallery&tmpl=component&format=raw&caller=tinymce&selection='+encodeURI(editor.selection.getContent());

		if (window.innerHeight==window.parent.innerHeight) {
		    modalheight = window.innerHeight*0.85;
		    modalwidth = window.innerWidth*0.85;
		}
		else {
		    modalheight = window.innerHeight-100;
		    modalwidth = window.innerWidth-100;
		}

		// Open window with our config url
		win = editor.windowManager.open({
		    title: 'NextGenEditor',
		    url: url_config,
		    width: modalwidth,
		    height: modalheight,
		    resizeable:true,
				window : 'jep',
				close_previous : "no",
		    inline:"yes",
		    onSubmit : function() {

		    // called by the validation button
		    //We need to save config content inside the config iframe
		    //Trying all existing frames
		    var frames = window.frames; // or // var frames = window.parent.frames;
		    for (var i = 0; i < frames.length; i++) { 
		      try {
			  frames[i].savePart();
		      }
		      catch(e) {
			//console.log('error');
		      }
		    }
			//Saving node only if new part
			    if(!data['data-part'] && window.top.htmlpart !='' ) {
				var htmlContent = window.top.htmlpart;
				var beforeObjects, afterObjects, i, y;

				beforeObjects = editor.dom.select('img[data-mce-part]');
				editor.insertContent(htmlContent);
				afterObjects = editor.dom.select('img[data-mce-part]');

				// Find new image placeholder so we can select it
				for (i = 0; i < beforeObjects.length; i++) {
					for (y = afterObjects.length - 1; y >= 0; y--) {
						if (beforeObjects[i] == afterObjects[y]) {
							afterObjects.splice(y, 1);
						}
					}
				}

				editor.selection.select(afterObjects[0]);
				editor.nodeChanged();
			    }			
		    }
		},
		{
		    setResult: function (data) {
		    	//TOTO callback from modal dialog
		    	//file_browser_callback : myFunction
		    }
		});
        
    
	}

	function ngeHtmlToData(html) {
		var data = {};
		new tinymce.html.SaxParser({
			validate: false,
			allow_conditional_comments: true,
			start: function(name, attrs) {
				data = tinymce.extend(attrs.map, data);				
			}
		}).parse(html);
		
		return data;
	}

	function getData(element) {
		if (element.getAttribute("data-mce-part") == "part") {					
			return ngeHtmlToData(editor.serializer.serialize(element, {selection: true}));
		}
		return {};
	}

	editor.on('ResolveName', function(e) {
		var name;
		if (e.target.nodeType == 1 && (name = e.target.getAttribute("data-mce-part"))) {
			e.name = name;
		}
	});

	
	editor.on('preInit', function() {
		
		// Add CSS for customizing parts
		var rootClass = '.mce-content-body';
		editor.contentStyles.push(
			rootClass + ' img[data-mce-part] {' +
			'background: #fff;' +
			'border: 1px solid #ccc;' +
			'width: 64px;' +
			'height: 64px;' +
			'padding: 10px;' +
			'cursor: default;' +
			'}' 
		);
		
		// Allow part elements to be saved
		editor.schema.addValidElements('part[*]');
		
		// When loading, converts all part tags in the content into placeholder images
		editor.parser.addNodeFilter('part', function(nodes, name) {
			var i = nodes.length, ai, node, placeHolder, attrName, attrValue, attribs, innerHtml;

			while (i--) {
				node = nodes[i];
				if (!node.parent) {
					continue;
				}

				placeHolder = new tinymce.html.Node('img', 1);
				placeHolder.shortEnded = true;
				
				var dataclass = node.attr('data-class');
				if (dataclass != undefined)
				    var srcpath = 'components/com_nge/parts/'+ dataclass.replace('.', '/') +'/thumb.png';
				else    
				    var srcpath = 'components/com_nge/parts/nge/default/thumb.png';

				    placeHolder.attr({
					    "data-part": node.attr('data-part'),
					    "data-class": node.attr('data-class'),
					    src: srcpath,
					    //"data-mce-object": "part",
					    "data-mce-part": "part",
					    "class": "mce-object mce-object-part"
				    });

				    node.replace(placeHolder);
			}
		});

		// When saving, replaces placeholder images with real part tag
		editor.serializer.addAttributeFilter('data-mce-part', function(nodes, name) {
			var i = nodes.length, node, realElm, ai, attribs, innerHtml, innerNode, realElmName;

			while (i--) {
				node = nodes[i];
				if (!node.parent) {
					continue;
				}

				realElmName = node.attr(name);
				realElm = new tinymce.html.Node(realElmName, 1);

				// Add specific attributes
				if (realElmName == "part") {
					realElm.attr({
						'data-part': node.attr('data-part'),
						'data-class': node.attr('data-class')
					});
					
					// Add text content to avoid tag removing when saving
					innerNode = new tinymce.html.Node('#text', 3);
					innerNode.raw = true;
					innerNode.value = '&nbsp;';
					realElm.append(innerNode);

					//Replacing tag
					node.replace(realElm);					
				}
			}
		});
	});

    // Simple click on editor element
	editor.on('ObjectSelected', function(e) {
		if (e.target.getAttribute('data-mce-part') == "part") {
		    // if element is part, stop propagation
			//To avoid resizing	
			e.preventDefault();
		}
	});
	
    // dblClick on editor element 
	editor.on('dblClick', function(e) {
        // open nge dialog if element is part
		if (e.target.getAttribute('data-mce-part') == "part") {
			showDialog();
		}
	});
		
	// Add a button that opens a window
    editor.addButton('nge', {
        image: url+"/library.png",
        icon : true,
        text: '',
        tooltip: 'NextGenEditor',
        onclick: showDialog,
        stateSelector: ['img[data-mce-part]']
        }
    );
    
    // Adds a menu item to the tools menu
    editor.addMenuItem('nge', {
        image: url+"/library.png",
        icon : true,
        text: 'Widget',
        context: 'insert',
        onclick:showDialog,
        prependToContext: true
        }
    );
	
});
