/**
 * editor_plugin.js
 *
 * Copyright, Teatis
 * Released under LGPL License.
 *
 * License: http://www.nextgeneditor.com/license
 *
 * NextGenEditor plugin for JCK 6
 */

// TODO: commentaire en anglais

var url_jcck; 
var matches, partid;
var myeditor;

/**********************************************************************************************
  Iframe dialog OK button response                                                                                     
**********************************************************************************************/
var okListener = function(ev) {
   myeditor = ev.sender._.editor;
        // remove the listeners to avoid any JS exceptions
    CKEDITOR.dialog.getCurrent().removeListener("ok", okListener);
   //console.log(CKEDITOR.dialog.getCurrent());

    // pour chaque frames presentes dans l'ecran
    // on essai de lancer la fonction save part.
    // postulat de depart -> il n'existe qu'une fenetre de parametrage de part
    var frames = window.frames; // or // var frames = window.parent.frames;
    for (var i = 0; i < frames.length; i++) { 
      // do something with each subframe as frames[i]
      
      try {
        
          // on lance le save part de la frame. 
          frames[i].savePart();
      }
      catch(e) {
       // console.log('erreur');
      }
    }
    
    // insertion de la part dans l'editeur
	if(!partid && window.top.htmlpart !='' ) {
        // note : there is a bug with &nbsp in CKeditor, replace by space caractere
        myeditor.insertHtml(window.top.htmlpart);

	}

};

/**********************************************************************************************
     Launched by click on the NextGenEditor button on the JCK toolbar                                                                                   
**********************************************************************************************/
	var insertPartCmd =
	{
		modes : { wysiwyg:1, source:0 }, // button displayed only in wysiwyg mode

		exec : function( editor ) 
		{
		var selection = editor.getSelection(); // current selection in the editor
		// cursor position  
		var positions = selection.getRanges(); 
		var current_position = positions[0].startOffset;

		// current tag html content
		var current_element = selection.getStartElement();
		var current_text_element = current_element.getHtml();

		partid = selection.getStartElement().getAttribute("data-part");
		// top window var definition
    		window.top.pkid = 0;
    		
    		if(partid) {
    		    //console.log('matches');
    			url_jcck = 'index.php?option=com_nge&view=config&caller=jck&mode=edit&format=raw&pk='+partid;
    		}
		else
		{	
		    //console.log('no matches');
			    /*url_jcck = 'index.php?option=com_nge&view=librarygallery&format=raw&caller=jck&selection='+encodeURI(selection.getSelectedText());*/
			    url_jcck = 'index.php?option=com_nge&view=librarygallery&format=raw&caller=jck';
		}

            var strbaseuri = window.top.location.href;
            var prefixe='';
            if(strbaseuri.indexOf('administrator')>=0) 
               prefixe = 'administrator/';
  
  	url_jcck = editor.config.baseHref + prefixe + url_jcck;

            // ouverture de la fenetre modal
            if (window.innerHeight==window.parent.innerHeight) {
                height = window.innerHeight*0.85;
                width = window.innerWidth*0.85;
            }
            else {
                height = window.innerHeight-100;
                width = window.innerWidth-100;
            }

	  if (!CKEDITOR.dialog.exists('ngeDialog')){
		CKEDITOR.dialog.addIframe(
		    'ngeDialog',
		    'NextGen Editor',
		    '', 
		    width, 
		    height, 
		    function(){
			//oniframeload
			//console.log('ON ADDIFRAME LOADED');
			//console.log(this);
			}		    
		);
	  }
            dialog = editor.openDialog('ngeDialog');
	                
            CKEDITOR.event.implementOn(CKEDITOR.dialog.getCurrent());	    
            CKEDITOR.dialog.getCurrent().on("ok", okListener);
            
	CKEDITOR.dialog.getCurrent().on("show", function(e){
                var t = CKEDITOR.dialog.getCurrent()._.contents.iframe.undefined.domId;

                jQuery('#'+t).attr('src',url_jcck);
                // bt - 09/04/15 -  show button bar for jck
	jQuery(".cke_dialog_close_button", window.parent.document).hide();
	jQuery(".cke_dialog_title", window.parent.document).hide();
	jQuery(".cke_dialog_footer", window.parent.document).hide();
	jQuery(".cke_dialog_contents", window.parent.document).css("padding", "0");
	jQuery(".cke_dialog_body", window.parent.document).css("padding", "0");
	jQuery(".cke_dialog_ui_vbox_child", window.parent.document).css("padding", "0"); //TODO modal height wiith scrollbars	
                jQuery(".cke_dialog_ui_button_ok", window.parent.document).hide();
                jQuery(".cke_dialog_ui_button_cancel", window.parent.document).hide();
            });
	    
	CKEDITOR.dialog.getCurrent().on("hide", function(e){
	jQuery(".cke_dialog_close_button", window.parent.document).show();
	jQuery(".cke_dialog_title", window.parent.document).show();
	jQuery(".cke_dialog_footer", window.parent.document).show();
                jQuery(".cke_dialog_ui_button_ok", window.parent.document).show();
                jQuery(".cke_dialog_ui_button_cancel", window.parent.document).show();
            });            
            
		}
	};
	
/**********************************************************************************************
     plugin definition                                                                                
**********************************************************************************************/

	var commandName = 'insertPartCmd';


	// Register a plugin named "save".
	CKEDITOR.plugins.add( 'nge',
	{
	   requires: ['iframedialog'],
		init : function( editor )
		{

            // dblClick event
            editor.on( 'doubleclick', function( evt )
            {
                var element = evt.data.element;
                if ( element.$.className=="ck_part" )
                    editor.	execCommand(commandName);
    
            });
            
            // include css
            var css = [editor.plugins.nge.path+'css/nge.css'];
            editor.config.contentsCss.append(css);
            
            // add command for plugin
			var command = editor.addCommand( commandName, insertPartCmd );
            
            // add toolbar button
			editor.ui.addButton( 'NextGenEditor',
			{
				label : 'NextGenEditor',
				command : commandName,
				icon: this.path + "library.png"
			});
            
            // add context menu command
            if ( editor.contextMenu ) {
                editor.addMenuGroup( 'NextGenEditor' );
                editor.addMenuItem( 'nge', {
                    label: editor.lang.select.btnModify,
                    icon: this.path + 'library.png',
                    command: commandName,
                    group: 'NextGenEditor'
                });
                editor.contextMenu.addListener(function(element, selection) {
                    console.log(element);
                     if ( element.$.className=="ck_part" ) {
                        return {
                          nge : CKEDITOR.TRISTATE_OFF
                        };
                    } 
                  });
            }

		},
        afterInit : function( editor )
        {
            function createFakeElement( editor, realElement )
            {

                var dataclass = realElement.attributes["data-class"];
                var datapart_id = realElement.attributes["data-part"];
                
                var FakeElement = editor.createFakeParserElement( realElement, 'ck_part', 'part', "false" );
                var srcpath = 'components/com_nge/parts/'+ dataclass.replace('.', '/') +'/thumb.png';
                 
                // modify fake element for img src
                FakeElement.attributes.src = srcpath;
                // add partid attribute
                FakeElement.attributes['data-part'] = datapart_id;
                // disable resizable
                FakeElement.attributes[ '_cke_resizable' ] = "false";
                return FakeElement;
            }
    
            // process part replacement with fakeElement
            var dataProcessor = editor.dataProcessor,
                    dataFilter = dataProcessor && dataProcessor.dataFilter;
                    
                if ( dataFilter )
                {
                    dataFilter.addRules(
                        {
                            elements :
                            {
                                'part' : function( element )
                                {
                                    //alert("here");
                                    var attributes = element.attributes;
    
                                   
                                        return createFakeElement( editor, element );
    
                                }
                            }
                        });
                };

        }
 
	});


