<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

defined('WF_EDITOR') or die('RESTRICTED');

require_once( WF_EDITOR_LIBRARIES . '/classes/plugin.php' );

class WFNgePlugin extends WFEditorPlugin {
    
    /**
     * @access	protected
     */
    public function __construct() {
        
        parent::__construct(array('easyparts' => true));
    }
    
    public function display() {
        parent::display();

        $document = WFDocument::getInstance();

        $document->addScript(array('plugins/jce/editor-nge/js/nge.js'), 'joomla');
        $document->removeCss('plugin');
       
        $document->addStyleSheet(array('plugins/jce/editor-nge/css/nge.css'),'joomla');
    }
    
    public function getView() {
		$view = parent::getView();
		
		$view->addTemplatePath(JPATH_ROOT.'/plugins/jce/editor-nge/tmpl');
		
		return $view;
		
	}
}

?>
