/**
 * editor_plugin.js
 *
 * Copyright, Teatis
 * Released under LGPL License.
 *
 * License: http://www.nextgeneditor.com/license
 *
 * NextGenEditor plugin for CKeditor4.3
 */

// TODO: commentaire en anglais

var url_jcck; 
var matches, partid;
var myeditor;

var partconfig_iframe_id = null;

var ceditor ;
var ckCaller = 'ckeditor.inline';

function base_url(segment){
   // get the segments
   pathArray = window.location.pathname.split( '/' );
   // find where the segment is located
   indexOfSegment = pathArray.indexOf(segment);
   // make base_url be the origin plus the path to the segment
   return window.location.origin + pathArray.slice(0,indexOfSegment).join('/') + '/';
}

/**********************************************************************************************
  Iframe dialog OK button response                                                                                     
**********************************************************************************************/
var okListener = function(ev) {
   myeditor = ev.sender._.editor;
   
   var savepart_result = '';
   
   // remove the listeners to avoid any JS exceptions
   CKEDITOR.dialog.getCurrent().removeListener("ok", okListener);
   //console.log(CKEDITOR.dialog.getCurrent());

   // launche config frame savePart function
   jQuery('#'+partconfig_iframe_id)[0].contentWindow.savePart();

    // insert part in editor
    //if ckCaller is ckeditor we are in config screen for a part
    if(ckCaller == 'ckeditor') {
        // controle for insert only if it's a new part
    	if(!partid && window.top.htmlpart !='' ) {
            var html = window.top.htmlpart;
            myeditor.insertHtml(html);
            previewPart();
    	}
    }
    
    // if ckCaller is ckeditor.inline, we are in inline editing, use after layout part insert function
    if(ckCaller == 'ckeditor.inline' && window.top.result_obj != '') {
        // insert temporary div
        var tempDroppedPart = '<div id="part-temp-dropped" class="part" style="display:block; padding:10px"></div>';
        myeditor.insertHtml(tempDroppedPart);
        // launch inline editor function
    	window.parent.document.afterLayoutPartCreate(window.top.result_obj);
    }
    

};

/**********************************************************************************************
     Launched by click on the NExtGenEditor button on the JCK toolbar                                                                                   
**********************************************************************************************/
	var insertPartCmd =
	{
		modes : { wysiwyg:1, source:0 }, // button displayed only in wysiwyg mode

		exec : function( editor ) 
		{
            ceditor = editor;
            var selection = editor.getSelection(); // current selection in the editor
            // cursor position  
            var positions = selection.getRanges(); 
            var current_position = positions[0].startOffset;
        
            // current tag html content
            var current_element = selection.getStartElement();
            var current_text_element = current_element.getHtml();

            // ckCaller, default = inline editing
           ckCaller="ckeditor.inline";
            
            // if var config_screen exist, we are in part config frame (see config/default.php)
            if(typeof config_screen != 'undefined')
                ckCaller = "ckeditor";
		    
            //console.log(ckCaller);            
            partid = selection.getStartElement().getAttribute("data-part");
            // top window var definition
	    window.top.pkid = 0;
	    if(partid) {
		//console.log('matches');
		    url_jcck = 'index.php?option=com_nge&view=config&caller='+ckCaller+'&mode=edit&format=raw&pk='+partid;
	    }
	    else {
		    url_jcck = 'index.php?option=com_nge&view=librarygallery&format=raw&caller='+ckCaller + '&selection='+encodeURI(editor.getSelectedHtml(true));
	    }
            var strbaseuri = window.top.location.href;
            var prefixe='';
            /*if(strbaseuri.indexOf('administrator')>=0) 
               prefixe = 'administrator/';
*/ 
	url_jcck =  prefixe + url_jcck;
	/*url_jcck =  'http://localhost/nge/'+prefixe + url_jcck;*/

            // ouverture de la fenetre modal
            if (window.innerHeight==window.parent.innerHeight) {
                height = window.innerHeight*0.9;
                width = window.innerWidth*0.9;
            }else {
                height = window.innerHeight-200;
                width = window.innerWidth-100;
            }
          
	  if (!CKEDITOR.dialog.exists('ngeDialog')){
		CKEDITOR.dialog.addIframe(
		    'ngeDialog',
		    'NextGen Editor',
		    '', 
		    width, 
		    height, 
		    function(){
			//oniframeload

			//console.log(this);
			}
		);
	  }
            dialog = editor.openDialog('ngeDialog');
            
            CKEDITOR.event.implementOn(CKEDITOR.dialog.getCurrent());
            CKEDITOR.dialog.getCurrent().on("ok", okListener);            
            CKEDITOR.dialog.getCurrent().on("show", function(e){

	
	jQuery(".cke_dialog_ui_button_ok", window.parent.document).show();
                jQuery(".cke_dialog_ui_button_cancel", window.parent.document).show();
                partconfig_iframe_id = CKEDITOR.dialog.getCurrent()._.contents.iframe.undefined.domId;
                jQuery('#'+partconfig_iframe_id).attr('src',url_jcck);                
                
            });            

            CKEDITOR.dialog.getCurrent().on("hide", function(e){
	//CKEDITOR.dialog.getCurrent().enableButton('ok')
	//CKEDITOR.dialog.getCurrent().enableButton('cancel')
                jQuery(".cke_dialog_ui_button_ok", window.parent.document).show();
                jQuery(".cke_dialog_ui_button_cancel", window.parent.document).show();
            });            
                 
            
		}
	};
	
/**********************************************************************************************
     plugin definition                                                                                
**********************************************************************************************/

	var commandName = 'insertPartCmd';


	// Register a plugin named "save".
	CKEDITOR.plugins.add( 'nge',
	{
		requires: ['iframedialog'],
		init : function( editor )
		{
  		        
            // dblClick event
            editor.on( 'doubleclick', function( evt )
            {
                var element = evt.data.element;
                if ( element.$.className=="ck_part" )
                    editor.	execCommand(commandName);
    
            });
            
            // include css
            var css = [editor.plugins.nge.path+'css/nge.css'];
            editor.config.contentsCss = css;
            
            // add command for plugin
			var command = editor.addCommand( commandName, insertPartCmd );
            
            // add toolbar button
			editor.ui.addButton( 'NextGenEditor',
			{
				label : 'NextGenEditor',
				command : commandName,
				icon: this.path + 'icons/nge.png'
			});
            
            // add context menu command
            if ( editor.contextMenu ) {
                editor.addMenuGroup( 'NextGenEditor' );
                editor.addMenuItem( 'nge', {
                    label: 'NextgenEditor',
                    icon: this.path + 'icons/nge.png',
                    command: commandName,
                    group: 'NextGenEditor'
                });
                editor.contextMenu.addListener(function(element, selection) {
                    //console.log(element);
                     if ( element.$.className=="ck_part" ) {
                        return {
                          nge : CKEDITOR.TRISTATE_OFF
                        };
                    } 
                  });
            }

		},
        afterInit : function( editor )
        {
            function createFakeElement( editor, realElement )
            {

                var dataclass = realElement.attributes["data-class"];
                var datapart_id = realElement.attributes["data-part"];
                
                var FakeElement = editor.createFakeParserElement( realElement, 'ck_part', 'part', "false" );

                // write url of fake image, always site url before, for administrator and cef 
                if (typeof dataclass != 'undefined') 
            	    var srcpath = rootUrl + 'components/com_nge/parts/'+ dataclass.replace('.', '/') +'/thumb.png';
            	else
                    var srcpath = rootUrl + 'components/com_nge/parts/nge/thumb.png';
	     
                // modify fake element for img src
                FakeElement.attributes.src = srcpath;
                // add partid attribute
                FakeElement.attributes['data-part'] = datapart_id;
                // disable resizable
                FakeElement.attributes[ '_cke_resizable' ] = "false";
                return FakeElement;
            }
    
            // process part replacement with fakeElement
            var dataProcessor = editor.dataProcessor,
                    dataFilter = dataProcessor && dataProcessor.dataFilter;
                    
                if ( dataFilter )
                {
                    dataFilter.addRules(
                        {
                            elements :
                            {
                                'part' : function( element )
                                {
                                    //alert("here");
                                    var attributes = element.attributes;
    
                                   
                                        return createFakeElement( editor, element );
    
                                },
                                'img' : function (element)
                                {
                                    // img tag rule
                                    // adding rootUrl to src attribute because of cef and administrator 
                                    element.attributes.src = rootUrl+element.attributes.src.replace(rootUrl,'');
                                }
                            }
                        });
                };

        }
 
	});


