<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

$user = JFactory::getUser();
    $canCreateParts = $user->authorise('core.create', 'com_nge');
    //The edit button ca be used, to edit its own parts, or all parts
    //TODO$canEditParts = $user->authorise('core.edit', 'com_nge') ||$user->authorise('core.edit.own', 'com_nge');
    
    //If current component us article, user can edit com_content?
    //In any component, user can edit modules?
    $canEditParts = $user->authorise('core.edit', 'com_nge');
    $canDeleteParts = $user->authorise('core.delete', 'com_nge');

?>
<div id="part-toolbar" class="ngetoolbar" style="display:none;">
	<div class="ngetoolbar-container">
		<span id="part-toolbar-info" class="ngetoolbar-info">
			<span id="part-toolbar-status" class="ngetoolbar-status" style="display:none;"></span>
			<span id="part-toolbar-save" class="ngetoolbar-save" style="display:none;"></span>
		</span>
		<span id="part-toolbar-title" class="ngetoolbar-title" data-part-toolbar-title="<?php echo NGE::translate('COM_NGE_EDITOR_TOOLBAR_TITLE'); ?>"></span>
		<span id ="ngepart-toolbar-plugins"></span>
		<?php if ($canEditParts) { ?>
		<span id="ngeparttlb-edit" 
			class="ngetoolbar-icon ngeloading"<?php //ngeloading displays a spinner. When configform is loaded then configFormReady function removes this class and the button is enabled?>
			data-toggle="tooltip"			
			data-jsfunction="ngePartToolbarEdit"
			data-original-title="<?php echo NGE::translate('COM_NGE_EDITOR_TOOLBAR_EDIT_TITLE'); ?>">		    
		</span>
		<?php } ?>
		<?php if (NGE::features('nge.dev')){ ?>
		<span id="ngeparttlb-theme" 
			class="ngetoolbar-icon icomoon-paint-format"
			data-toggle="tooltip"			
			data-jsfunction="ngePartFormTheme"
			data-original-title="<?php echo NGE::translate('COM_NGE_EDITOR_TOOLBAR_THEME_TITLE'); ?>">		    
		</span>
		<span id="ngeparttlb-animate" 
			class="ngetoolbar-icon icomoon-power"
			data-toggle="tooltip"			
			data-jsfunction="ngePartFormAnimate"
			data-original-title="<?php echo NGE::translate('COM_NGE_EDITOR_TOOLBAR_ANIMATE_TITLE'); ?>">		    
		</span>
		<span id="ngeparttlb-display" 
			class="ngetoolbar-icon icomoon-display"
			data-toggle="tooltip"			
			data-jsfunction="ngePartFormDisplay"
			data-original-title="<?php echo NGE::translate('COM_NGE_EDITOR_TOOLBAR_DISPLAY_TITLE'); ?>">		    
		</span>
		<?php } ?>
		<?php if (!Nge::features('nge.dev')){ ?>
		<?php if (NGE::features('parts.duplicate') && $canCreateParts) {?>
		<span id="ngeparttlb-duplicate" 
			class="ngetoolbar-icon icomoon-files-empty"
			data-toggle="tooltip"
			data-jsfunction="ngePartDuplicate"
			data-original-title="<?php echo NGE::translate('COM_NGE_EDITOR_TOOLBAR_DUPLICATE_TITLE'); ?>">
		</span>
		<?php } ?>
		<!--<span id="ngeparttlb-add" 
			class="ngetoolbar-icon icomoon-plus"
			data-toggle="tooltip"
			data-jsfunction="ngePartToolbarAdd"
			data-original-title="<?php echo NGE::translate('COM_NGE_EDITOR_TOOLBAR_ADD_TITLE'); ?>">
		</span>-->
		<?php if ($canDeleteParts) { ?>
		<span id="ngeparttlb-remove" 
			class="ngetoolbar-icon icomoon-bin2"
			data-toggle="tooltip" 
			data-jsfunction="ngePartRemove"
			data-original-title="<?php echo NGE::translate('COM_NGE_EDITOR_TOOLBAR_REMOVE_TITLE'); ?>">
		</span>
		<?php } ?>
		<?php } ?>
		<?php    //Tools
		    if (Nge::features('nge.dev')){ ?>
		    <div class="btn-group">
		    <button class="ngetoolbar-icon dropdown-toggle" data-toggle="dropdown" style="border:none;padding-left:3px;padding-right:3px;"><span class="icomoon-wrench"></span><span class="caret"></span></button>
		    <ul class="dropdown-menu">
		    <li><a href="javascript:ngePartFormConditions();"><span class="icomoon-key"></span>&nbsp;<?php echo NGE::translate('COM_NGE_EDITOR_TOOLBAR_CONDITIONS_TITLE'); ?></a></li>
		    <li><a href="javascript:ngePartFormTransform();"><span class="icomoon-magic-wand"></span>&nbsp;<?php echo NGE::translate('COM_NGE_EDITOR_TOOLBAR_TRANSFORM_TITLE'); ?></a></li>
		    <?php if (NGE::features('parts.duplicate') && $canCreateParts) {?>
		    <li><a href="javascript:ngePartDuplicate();"><span class="icomoon-files-empty"></span>&nbsp;<?php echo NGE::translate('COM_NGE_EDITOR_TOOLBAR_DUPLICATE_TITLE'); ?></a></li>
		    <?php } ?>
		    <?php if ($canDeleteParts) { ?>		    
		    <li><a href="javascript:ngePartRemove();"><span class="icomoon-bin2"></span>&nbsp;<?php echo NGE::translate('COM_NGE_EDITOR_TOOLBAR_REMOVE_TITLE'); ?></a></li>
		    <?php } ?>
		    <li><a href="javascript:ngePartFormInformation();"><span class="icomoon-info"></span>&nbsp;<?php echo NGE::translate('COM_NGE_EDITOR_TOOLBAR_INFO_TITLE'); ?></a></li>
		    </ul>
		    </div>
		<?php
		    }
		    ?>
	</div>
	<div class="toolbarpopover-add-content" style="display: none;">
		<div style="margin-bottom: 10px;"><?php echo NGE::translate('COM_NGE_EDITOR_TOOLBAR_ADD_TITLE'); ?></div>
		<span class='btn'
			onclick='ngePartToolbarAddWidget("before", jQuery("#part-toolbar").attr("data-part"));'>
			Avant
		</span>
		<span class='btn' onclick='ngePartToolbarAddWidget("after", jQuery("#part-toolbar").attr("data-part"));'>Après</span>
                <span class='btn btn-danger' onclick='jQuery("#ngeparttlb-add").popover("hide");'><?php echo NGE::translate('COM_NGE_CANCEL'); ?></span>
	</div>
        <div class="toolbarpopover-remove-content" style="display: none;">
		<div style="margin-bottom: 20px;"><?php echo NGE::translate('COM_NGE_EDITOR_TOOLBAR_REMOVE_CONTENT'); ?></div>
		<span class="nge-part-remove " style="min-width:130px;padding:8px 12px;color:#fff;background-color:#19BC9C;cursor:pointer;margin-bottom:20px;margin-right:12px;"
			onclick='			    
				<?php if (NGE::features('nge.demo'))
				    echo 'alert("' . NGE::translate('COM_NGE_DEMO_MODE_MESSAGE') . '");';
				else
				    echo 'afterLayoutPartDelete(jQuery("#part-"+jQuery("#part-toolbar").attr("data-part")));'; ?>
			'>
			<?php echo NGE::translate('COM_NGE_DELETE_ITEM'); ?>
		</span>
		<span style="min-width:130px;padding:8px 12px;color:#fff;background-color:#F26D66;cursor:pointer;margin-bottom:20px;" onclick='jQuery("#ngeparttlb-remove").popover("hide");'><?php echo NGE::translate('COM_NGE_CANCEL'); ?></span>
	</div>
</div>