<?php

/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

$user  = JFactory::getUser();
$input = JFactory::getApplication()->input;

$data = $displayData;

ob_start();

?>
<style>
#containergallery{
    width:804px;
    font-family: Open Sans, Source Sans Pro, Helvetica, Arial, sans-serif;
/* 	zoom: 0.9; */
/* 	-ms-zoom: 0.9; */
/* 	-webkit-zoom: 0.9; */
/* 	-moz-transform:  scale(0.9,0.9); */
    -moz-transform-origin: left center;
    background-color:#F5F5F5;
    -moz-box-shadow: 0px 0px 60px 0px #ccc;
    -webkit-box-shadow: 0px 0px 60px 0px #ccc;
    -o-box-shadow: 0px 0px 60px 0px #ccc;
    box-shadow: 0px 0px 60px 0px #ccc;
}

#containergallery .nav-tabs{
    background-color:#646D9C;
}

.headtabbar li:hover a{
    background-color:#8B92B3;
}

#widgets-header{
    color:#fff;
    font-size:24px;
    padding:12px;
    background-color:#646D9C;
}

#containergallery ul.nav {
    margin-bottom: 0px;
    border-bottom: none;
    box-shadow: 0 4px 7px 0 rgba(0,0,0,.5);
}

#containergallery .nav-tabs a{
    color :#fff;
}

#containergallery .headtabbar{
	box-shadow: 0 4px 14px 0 rgba(0,0,0,.3);
}

#containerhelp {
    padding: 0px 20px 0px 20px;
    background-color: #fff;
    box-shadow: -1px 0px 7px 0 rgba(0,0,0,.2);
}

#libraryparttitle {
    color: #8B92B3;
    font-family: Open Sans, Source Sans Pro, Helvetica, Arial, sans-serif;
    font-weight: 300;
    line-height: 1.3;
    font-size: 30px;
    margin-bottom:20px;
}

#librarypartdescription {
    color: #777;
    font-family: Open Sans, Source Sans Pro, Helvetica, Arial, sans-serif;
    font-size: 17;
    margin-top:10px;
    line-height: 1.6;
    font-weight: 300;
    float: left;
}

	
#containergallery .thumbs{
    margin-top:2px;
    margin-bottom:2px;
    margin-left:2px;
}

#containergallery .tab-pane{	
    padding-top:2px;
    padding-bottom:4px;
}

#containergallery .tabs-left > .nav-tabs {
    margin:0px;
}
#containergallery .tabs-left .tab-content{
    padding-bottom:10px;
}

#containergallery .tabbable .dropdown-menu {
    background-color : #646D9C;
}


#containergallery li.thumb{
    display: inline-block;
    padding: 0px;
    line-height: 13px;
    -webkit-transition: all .2s ease-in-out;
    -moz-transition: all .2s ease-in-out;
    -o-transition: all .2s ease-in-out;
    transition: all .2s ease-in-out;
    width: 80px;
    height: 80px;
    -webkit-border-radius: 0px;
    -moz-border-radius: 0px;
    border:none;
    border-radius: 0px;
    font-size: 11px;
    position: relative;
    text-align:center;
    cursor:move;
    margin-right:8px;
    background-color:#ffffff;    
  box-shadow: 0 1px 3px rgba(0,0,0,0.12), 0 1px 2px rgba(0,0,0,0.24);
  transition: all 0.3s cubic-bezier(.25,.8,.25,1);
}

#containergallery li.thumb:hover{
    box-shadow: 0 4px 8px rgba(0,0,0,0.12), 0 4px 4px rgba(0,0,0,0.22);
}

#containergallery .category-title{
    color:#ffffff;
    height:30px;
    width:100px;
    text-align:center;
    padding-top:5px;
    font-weight:bold;
    transform: rotate(270deg) translateX(-70px);
    transform-origin: left top 0;
    text-transform:uppercase;
    font-size: 12px;
}

#containergallery .category_back{
    background-color:#7B8FA1;
    max-width:30px;
}
	
#containergallery div.legend{
    position: absolute;
    text-align: center;
    left: 0px;
    bottom: 0px;
    width: 100%;
    font-size:10px;
}
	
#containergallery img{
    height:48px;
    width:48px;
    vertical-align: middle;
    border: 0;
}

#containergallery .height-80{
    height:80px;
    margin-top:5px;
}

/*Style tabs*/
#containergallery ul.nav li{    
    padding: 0px;
    line-height: 20px;
    text-transform: uppercase;
    text-align:center;
    text-shadow: none;
    min-width:150px;
    -webkit-transition: border-bottom-color .2s ease-in-out, background-color.2s ease-in-out;
    -moz-transition: border-bottom-color .2s ease-in-out, background-color.2s ease-in-out;
    -o-transition: border-bottom-color .2s ease-in-out, background-color.2s ease-in-out;
    transition: border-bottom-color .2s ease-in-out, background-color.2s ease-in-out;
    border-bottom-width: 8px;
    border-bottom-style: solid;
    border-bottom-color: #7B8FA1;
}
	
#containergallery ul.nav li > a{
    color: #fff;
    font-size: 14px;
    border: none;
    cursor: pointer !important;
    padding: 10px 14px;
}

#containergallery ul.nav li:hover,
#containergallery ul.nav li.active{    
    background-color: #8B92B3;
    border-bottom-color: #C2CCD6;
}

#containergallery .nav-tabs > .active > a,#containergallery .nav-tabs > .active > a:hover,#containergallery .nav-tabs > .active > a:focus {
/*    color: #204389;*/
    background-color: initial;
    border: none;
    border-bottom-color: transparent;
    cursor: default;
}

#containergallery ul > li:hover, #ngemainbar-body ul > li{
    outline: none;
}

#containergallery .nav-header a:hover, #ngemainbar-body .nav-header a:active,
#containergallery .nav-header a:visited, #ngemainbar-body .nav-header a:focus{
    background-color:inherit ;
}

#ngecategory-content, #ngecategory-media, #ngecategory-navigation ,#ngecategory-office{
    border-bottom-width: 8px;
    border-bottom-style: solid;
}

#ngecategory-content{
    border-bottom-color: #FFF6C1 !important;
}

#ngecategory-content:hover a,
#ngecategory-content.active a{
    background-color: #FFBF5B !important;
}

#ngecategory-media{
    border-bottom-color: #FFD1CF !important;
}

#ngecategory-media:hover a,
#ngecategory-media.active a{
    background-color: #FF776D !important;
}


#ngecategory-navigation{
    border-bottom-color: #B6E1EC !important;
}

#ngecategory-navigation:hover a,
#ngecategory-navigation.active a{
    background-color: #49AFCD !important;
}

#ngecategory-office{
    border-bottom-color: #D6F2C8 !important;
}

#ngecategory-office:hover a,
#ngecategory-office.active a{
    background-color: #75CD49 !important;
}

#ngemainbar-body .ngecategorybody-content li:hover,
#ngemainbar-body .ngecategorybody-content li.active-category,
#ngemainbar-body li.ngecategorybody-content:hover{
    background-color:#FFF6C1 ;
}

#ngemainbar-body .ngecategorybody-navigation li:hover, 
#ngemainbar-body .ngecategorybody-navigation li.active-category,
#ngemainbar-body li.ngecategorybody-navigation:hover{
    background-color:#B6E1EC ;
}

#ngemainbar-body .ngecategorybody-media li:hover, 
#ngemainbar-body .ngecategorybody-media li.active-category,
#ngemainbar-body li.ngecategorybody-media:hover{
    background-color:#FFD1CF ;
}

#ngemainbar-body .ngecategorybody-office li:hover, 
#ngemainbar-body .ngecategorybody-office li.active-category,
#ngemainbar-body li.ngecategorybody-office:hover{
    background-color:#D6F2C8 ;
}

.ngecategorybody-content .ngecategory-content{
    background-color:#FFBF5B !important;
}
	
.ngecategorybody-navigation .ngecategory-navigation{
    background-color:#ADCCEA !important;
}

.ngecategorybody-media .ngecategory-media{
    background-color:#FF776D !important;
}

.ngecategorybody-office .ngecategory-office{
    background-color:#75CD49 !important;
}

#containergallery ul.nav li.tabdrop i{
    font-size: 16px;
}

#containergallery .nav-tabs .open .dropdown-toggle,
#containergallery .nav-pills .open .dropdown-toggle,
#containergallery .nav > li.dropdown.open.active > a:hover,
#containergallery .nav > li.dropdown.open.active > a:focus {
    background-color: transparent !important;
}

#ngemainbar-body .dropdown-menu > li, 
#ngemainbar-body .dropdown-menu > li.active{
    border: none !important;
}
#ngemainbar-body .dropdown-menu > li:hover, 
#ngemainbar-body .dropdown-menu > li.active{
    border: none !important;
}
#ngemainbar-body .dropdown-menu > li > a:hover, 
#ngemainbar-body .dropdown-menu > li.active > a {
    background-color: transparent !important;
}
#ngemainbar-body .dropdown-menu > li > a:hover, 
#ngemainbar-body .dropdown-menu > li.active > a {
    background-color: transparent !important;
}

#ngemainbar-body .dropdown-menu{
    -webkit-border-radius: 0px;
    -moz-border-radius: 0px;
    border-radius: 0px;
    height: 250px;
    overflow-y: auto;
}
</style>
<div id="containergallery">
<?php	
	$currentCategory = 0;
	$currentPlugin = '';
	$tabs = array();
	$body = array();
	$hasManyPlugins = false; //More than one plugin
	//$hasManyCategoriesinPlugin = false; //More than one category in the current plugin
	if ((count($data->parts) > 0) && ($data->parts[0]->plugin != $data->parts[count($data->parts)-1]->plugin))
	    $hasManyPlugins = true;
	foreach($data->parts as $part){
		//New Pack ?
		if ($part->category_plugin != $currentPlugin){
			$currentCategory = 0;
			//$hasManyCategoriesinPlugin = false;
			$activeLi = $currentPlugin == '' ? ' active' : '';
			$active = $currentPlugin == '' ? ' active' : '';
			$title = $part->plugin_title != '' ? JText::_($part->plugin_title) : JText::_($part->category_title);
			$tabs[] = '<li id="ngecategory-'.$part->category_plugin.'" class="'.$activeLi . '"><a href="#ngecategorybody-'.$part->category_plugin.'" data-toggle="tab">'.$title.'</a></li>';
			$body[] = $currentPlugin != '' ? '</ul></td></tr></table></div>' : '';
			$body[] = '<div class="tab-pane ngecategorybody-'.$part->category_plugin . $active.'" id="ngecategorybody-'.$part->category_plugin.'">';
			$currentPlugin = $part->category_plugin;
		}
		//Categories
		if ($part->category_id != $currentCategory){
			//if ($currentCategory != 0)
			//    $hasManyCategories = true;
			$body[] = $currentCategory != 0 ? '</ul></td></tr></table>' : '';
			$body[] = '<table><tr>';
			$body[] = '<td class="category_back ngecategory-'.$part->category_plugin.'"><div class="category-title">'.JText::_( $part->category_title).'</div></td>';
			$body[] = '<td><ul class="manager thumbs">';
			//$body[] = '<li class="category-title">'.JText::_( $part->category_title).'</li>';
			$currentCategory = $part->category_id;
		}
		//Parts
		$body[] =  '<li id="thumbs_'.$part->name.'" data-part="'.$part->name.'" class="thumbs_hover ngedraggable-mainbar imgOutline thumb" data-ngedraggable-type="part" data-ngedraggable-dest="article position module page part multiple workshop wall" data-ngedraggable-ref="'.$part->name.'" data-title="'.JText::_($part->title).'" data-description="'.JText::_($part->description).'">';
		$body[] =  '	<div class="height-80">';
		$body[] =  '<img src="' . NGEURL_ROOT . 'components/com_nge/parts/'.str_replace('.', '/', $part->name).'/thumb.png" onerror="this.src=\'' . NGEURL_ROOT . 'components/com_nge/assets/images/default_thumb.png\'" />';
		$body[] =  '	</div>';
		$body[] =  '	<div class="legend" title="'.JText::_( $part->title ).'">';
		$body[] =  JText::_( $part->title );
		$body[] =  '	</div>';
  		$body[] =  '</li>';
		
	}
	$body[] =  '</ul></td></tr></table></div>';
	?>
    <div id="widgets-header">
	<?= NGE::translate('NGE_LIBRARY_TITLE'); ?>
    </div>
<div class="tabbable">
  <ul class="nav nav-tabs" style="background-color:#646D9C">
      	  <?php  if ($hasManyPlugins)
		echo implode($tabs);  ?>
  </ul>
    <div class="row-fluid" style="display:flex;height:100%;">
	<div class="tab-content span9" style="display: flex;align-items: stretch;background-color:#f9f9f9;width:74%">
	  <?php  echo implode($body);  ?>
	</div>
	<div id="containerhelp" class="span3" style="align-items: stretch;flex-wrap: wrap;margin-left:0px;width:25%"><h3 id="libraryparttitle"><?= NGE::translate('NGE_LIBRARY_HELP_TITLE'); ?></h3>
		<div style="position:relative; overflow:hidden;">
		    <div id="librarypartthumb"><div style="width:100%;text-align:center;"><img src="<?php echo NGEURL_ROOT?>/components/com_nge/assets/images/widget_add.png"/></div>
			</div>
			<div id="librarypartdescription"><?= NGE::translate('NGE_LIBRARY_HELP_ADD'); ?>
			    <br/><br/>
			    <?php /*<a>More widgets</a>*/ ?>
			</div>
		</div> 
	</div>
    </div>  
</div>
</div>
<?php

$content = ob_get_contents();
ob_clean();

echo $content;
?>
<script>
function showPackInformation(packname, titleLabel, language){
	jQuery('#librarygallery-content').hide();
	jQuery("#gallery-body").html('<iframe id="pack_information" frameBorder="0" width="100%" height="500px" src="http://www.nextgeneditor.com/'+language+'/packs/'+packname+'?tmpl=component"></iframe>');
}    

/*Default category*/
/*jQuery(document).ready(function(){         */
	
	jQuery('li.thumb').mouseover(function(){
	   jQuery("#libraryparttitle").html(jQuery(this).data('title'));
	   jQuery("#librarypartdescription").html(jQuery(this).data('description'));

	   var image = jQuery(this).find('img').attr('src');
	   jQuery("#librarypartthumb").html('<img src="'+image+'"/>');
	});		
	
	jQuery('li.thumb').click(function(){
	    /* If there is a workshop in tha current page, click will create an element inside the workshop.
	     Otherwise, drag destination is needed */
	    $workshoplayout = jQuery('.ngelayout-workshop');
	    if ($workshoplayout.length == 0)
	       bootbox.alert("<?php echo NGE::translate('COM_NGE_JS_EDITING_DRAG_PART_IN_PAGE'); ?>");
	   else {
	   	var part = jQuery(this).data('part');
		jQuery("#partConfigForm").modal("show");
		document.getElementById("partconfig_iframe").contentWindow.loadContent("index.php?option=com_nge&view=config&layout=form&caller=layout.workshop&mode=create&format=raw&plname=" + part);		
	    }
	});		

</script>