<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;
 
/*
 * A changer en un pat transform
 * laisser longlet transformation
 * et ajouter des effet de transition
 * http://www.cheesetoast.co.uk/add-grayscale-images-hover-css-black-white/
 */
/***** INSTANTIATION VARIABLES *****/
$data = 			$displayData;
$html = 			array();

/***** CONTENT *****/
$content = '';
if ($data->content->source == 'html'){
	$content = $data->content->html;
}else if($data->content->source == 'article'){
	require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
	$article = NgeJoomlaArticleDriver::load($data->content->article);
	$content = $article->introtext;
}else if($data->content->source == 'module'){
	require_once (NGEPATH_HELPERS . '/data/joomla/moduledriver.php');
	$content = NgeJoomlaModuleDriver::load($data->content->module);
}else if($data->content->source == 'url'){
	require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');	
	$content = UrlDriver::getContents($data->content->url);
}else if($data->content->source == 'query'){
	require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');	
	$content = NgeDatabaseDriver::loadSingle($data->content->query);
}

//Attributes
$class = array();
$class[] = "part";

//Part display options
$data->selector = '#part-' . $data->id ;
$data->style[] = NGE::layout('nge.parts.parts.display_style', $data);
$class[] = NGE::layout('nge.parts.parts.display_class', $data);
$data->script[] = NGE::layout('nge.parts.parts.display_script', $data);

$attributes = array();
$attributes[] = ' id="part-'.$data->id.'"';
$attributes[] = ' data-part="'.$data->name.'"';
$attributes[] = ' data-part-label="'.NGE::translate($data->libraryTitle).'"';
$attributes[] = NGE::layout('nge.parts.parts.display_attribute', $data);
$attributes[] = ' class="'.implode(' ', $class).'"';
if($data->rendering->mode == 'edit'){
	if($data->content->source == 'html'){
		//NgeContenthelper::addScript("media/editors/tinymce/tinymce.min.js");
		$attributes_editable = 'data-nge = \'{"title": "Text", "type": "editor", "source":"content:content.html"}\' ';
		$class_editable = "ngeinlineeditable ngeinlineeditor";
	}
}

/**** CSS ***********************************************************************/

//Cache
if ($data->cache->css != ''){
    $data->style[] = $data->cache->css;
}
else {

	//Transform
	$dataTransform = $data->transform;
	$dataTransform->selector = '#part-'.$data->id;
	$data->style[] = NGE::layout('nge.parts.panels.css.animation_transform_css', $dataTransform);

	//Animate
	if ($data->effect->style != ""){
		$dataAnimate = $data->effect;
		$dataAnimate->selector = '#part-'.$data->id;
		$data->style[] = NGE::layout('nge.parts.panels.css.animation_css', $dataAnimate);
	}
  
}

/**** JS ************************************************************************/

//Cache
if ($data->cache->js != ''){
    $data->script[] = $data->cache->js;
}
else {

	//Animate
	if ($data->effect->style != ""){
		$dataAnimate = $data->effect;
		$dataAnimate->selector = '#part-'.$data->id;
		$script[] = NGE::layout('nge.parts.panels.js.animation_js', $dataAnimate);
	}
}

//Writing cache    
if (($data->cache->css == '' && count($data->style) >0) || ($data->cache->js == '' && count($data->script) >0)){
    require_once NGEPATH_HELPERS . '/data/nge/partdriver.php';
    NgeNgePartDriver::storeCache($data->id, implode($data->style), implode($data->script));    		
}



//Style and Script
$scripts = '';
if (count($data->style) != 0)
	$scripts .= '<style>'.implode($data->style).'</style>';
if (count($data->script) != 0)
	$scripts .= '<script>'.implode($data->script).'</script>';


if(isset($attributes_editable) && isset($class_editable)){
	$html[] = '<div '.implode($attributes).'>'.$scripts.'<div id="part-'.$data->id.'-body" class="'.$class_editable.'" '.$attributes_editable.'>'.$content.'</div></div>';
}else{
	$html[] = '<div '.implode($attributes).'>'.$scripts.$content.'</div>';
}

//Path libraries css
//NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'animate/css/animate.min.css');


//Html
echo implode($html);