<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;
 
/***** INSTANTIATION VARIABLES *****/
$data = 			$displayData;
$html = 			array();
$class = 			array();
$attributes = 		array();

/***** CONTENT *****/
$content = '';

//Part usage is unique or multiple (in data reports)
if (isset($data->rendering->multiple) && ($data->rendering->multiple == true))
    $data->selector = '.part-'.$data->id;
else
    $data->selector = '#part-'.$data->id;

//Label content
if ($data->label->source == 'html') {
	$content = $data->label->html;
}else if($data->label->source == 'url'){
	require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
	$content = UrlDriver::getContents($data->label->url);
}else if($data->label->source == 'query'){
	require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
	$content = NgeDatabaseDriver::loadSingle($data->label->query);
}else if ($data->label->source == 'data') {
    $content = $data->label->data != '' ? '{{item.' . $data->label->data . '}}' : '';
}		

//Sublabel Content
if ($data->sublabel->source == 'html') {
	$content_sublabel = $data->sublabel->html;
}else if($data->sublabel->source == 'url'){
	require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
	$content_sublabel = UrlDriver::getContents($data->sublabel->url);
}else if($data->sublabel->source == 'query'){
	require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
	$content_sublabel = NgeDatabaseDriver::loadSingle($data->sublabel->query);
}else if ($data->sublabel->source == 'data') {
	$content_sublabel = $data->sublabel->data != '' ? '{{item.' . $data->sublabel->data . '}}' : '';
}

if ($content_sublabel != ""){
	
	if (in_array($data->sublabel->tag, array('h1', 'h2', 'h3', 'h4', 'h5', 'h6')))
		$tag_sub = $data->sublabel->tag;
	else
		$tag_sub = 'span';

	if($data->rendering->mode == 'edit'){
		$content_sublabel = '<'.$tag_sub.' title="Sub title" class="title_subcontent ngeinlineeditable ngeinlinetext" data-nge = \'{"title": "Sub label", "type": "text", "source":"sublabel.html"}\'>'.$content_sublabel.'</span>';
	}else{
		$content_sublabel = '<'.$tag_sub.' class="title_subcontent">'.$content_sublabel.'</span>';
	}		
}else{
	$content_sublabel = '';
}

//Part Default Class css
$class[] = NGE::layout('nge.parts.parts.display_class', $data);
$class[] = "part";
$class[] = $data->shadow->style == 'none' ? '' : $data->shadow->style;

    //If part usage is multiple (in data reports), using class instead of unique selector
    if (isset($data->rendering->multiple) && ($data->rendering->multiple == true))
	$class[] = 'part-'.$data->id;

//Part Default Attribute
$attributes = array();
$attributes[] = ' id="part-'.$data->id.'"';
$attributes[] = ' data-part="'.$data->name.'"';
$attributes[] = ' data-part-label="'.NGE::translate($data->libraryTitle).'"';
$attributes[] = NGE::layout('nge.parts.parts.display_attribute', $data);
$attributes[] = ' class="'.implode(' ', $class).'"';

if(isset($data->rendering->mode) && $data->rendering->mode == 'edit'){
	//$glyphEditableClass = ' ngecontenteditable';
	//$glyphEditableAttributes = ' title="Glyph" data-type="glyph" data-property="glyph.name"';
	$glyphEditableClass = ' ngeelement ngeinlineeditable ngeinlineglyph';
	$glyph_name = (isset($data->glyph->name) && $data->glyph->name != '') ? $data->glyph->name : '';
	$glyphEditableAttributes = ' data-nge = \'{"title": "Glyph", "type": "glyph", "source":"content:glyph.name", "value":"'.$glyph_name.'"}\' ';
}else{
	$glyphEditableClass = '';
	$glyphEditableAttributes = '';
}

if ($data->glyph->name != ''){
	$iconleft = 	$data->glyph->position == 'left' ? '<span'.$glyphEditableAttributes.' class="icomoon '.$data->glyph->name.$glyphEditableClass.'" style="display:table-cell; vertical-align:middle; padding-right:8px"></span> ' : '';	
	$iconright = 	$data->glyph->position == 'right' ? ' <span'.$glyphEditableAttributes.' class="icomoon '.$data->glyph->name.$glyphEditableClass.'" style="display:table-cell; vertical-align:middle; padding-left:8px"></span>' : '';
}else{
	$iconleft = '';
	$iconright = '';
}

$html[] = '<div '.implode($attributes).'>';

/******** CSS *******************************************************************/

//Cache
if ($data->cache->css != ''){
    $data->style[] = $data->cache->css;
}
else {

    //Part Default Style css
    $data->style[] = NGE::layout('nge.parts.parts.display_style', $data);

    //Main css
    $data->style[] = NGE::layout('nge.parts.text.css.title_css', $data);

    //Font Label CSS
    if($data->label->font->style == 'custom'){
	    $dataFont = $data->label->font;
	    $dataFont->selector = $data->selector. ' .title_content' ; //Warning final tag for media print color rendering
	    $dataFont->selector_hover = $data->selector. ':hover .title_content' ; 
	    $data->style[] = NGE::layout('nge.parts.text.css.font_css', $dataFont);
    }

    //Font subLabel CSS
    if($data->sublabel->font->style == 'custom'){
	    $dataFont = $data->sublabel->font;
	    $dataFont->selector = $data->selector. ' .title_subcontent' ;
	    $dataFont->selector_hover = $data->selector. ':hover .title_subcontent' ;
	    $data->style[] = NGE::layout('nge.parts.text.css.font_css', $dataFont);
    }

    //Label Effects
    if(isset($data->label->effects) &&  (count($data->label->effects) >0)){
	$dataLabel = $data->label;
	$dataLabel->selector = $data->selector. ' .title_content' ; //Warning final tag for media print color rendering
	$dataLabel->selector_hover = $data->selector. ':hover .title_content' ; 
	$data->style[] = NGE::layout('nge.parts.parts.effects.css.effects_css', $dataLabel);
    }

    //Sublabel Effects
    if(isset($data->sublabel->effects) &&  (count($data->sublabel->effects) >0)){
	$dataSubLabel = $data->sublabel;
	$dataSubLabel->selector = $data->selector. ' .title_subcontent' ; //Warning final tag for media print color rendering
	$dataSubLabel->selector_hover = $data->selector. ':hover .title_subcontent' ; 
	$data->style[] = NGE::layout('nge.parts.parts.effects.css.effects_css', $dataSubLabel);
    }
    
    //Icomoon CSS
    if ($data->glyph->name != ""){
	    NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'icomoon/icomoon-nge.css');
	    $dataIcomoon = $data->glyph;
	    $dataIcomoon->selector = $data->selector.' .icomoon';
	    $dataIcomoon->selector_hover = $data->selector.':hover .icomoon';
	    $data->style[] = NGE::layout('nge.parts.panels.css.icomoon_css', $dataIcomoon);
    }

    //Border CSS
    if (($data->border->style != "none") || ($data->border->radius->width != "0")){
	    $dataBorder = $data->border;
	    $dataBorder->selector = $data->selector;
	    $data->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataBorder);
    }

    //Background CSS
    if ($data->background->style != "none") {
	    $dataBackground = $data->background;
	    $dataBackground->selector = $data->selector;
	    $data->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataBackground);
    }

    //Shadow
    if($data->shadow->style != 'none'){
	    $dataShadow = $data->shadow;
	    $dataShadow->selector = $data->selector;
	    $dataShadow->background = $data->background;
	    $data->style[] = NGE::layout('nge.parts.panels.css.shadow_css', $dataShadow);	
    }
    //Writing cache    
    require_once NGEPATH_HELPERS . '/data/nge/partdriver.php';
    NgeNgePartDriver::storeCache($data->id, implode($data->style), '');
}

/******** JS *******************************************************************/

//Cache
if ($data->cache->js != ''){
    $data->script[] = $data->cache->js;
}
else {

    //Part Default Scripts (effects)
    $data->script[] = NGE::layout('nge.parts.parts.display_script', $data);
    
    //Writing cache    
    require_once NGEPATH_HELPERS . '/data/nge/partdriver.php';
    NgeNgePartDriver::storeCache($data->id, implode($data->script), '');
}

//Style and Script
if (count($data->style) != 0) {
    //Part usage is unique or multiple (in data reports) If multiple, style are unique outside of the part
    if (isset($data->rendering->multiple) && ($data->rendering->multiple == true))
	NgeContenthelper::addStyle('#part-'.$data->id, implode($data->style));
    else //unique rendering, inside the part (it can be edited and replaced)
	$html[] = '<style>'.implode($data->style).'</style>';     
}
if (count($data->script) != 0) {
    //Part usage is unique or multiple (in data reports) If multiple, style are unique outside of the part
    if (isset($data->rendering->multiple) && ($data->rendering->multiple == true))
	NgeContenthelper::addStyle('#part-'.$data->id, implode($data->script));
    else //unique rendering, inside the part (it can be edited and replaced)
	$html[] = '<script>'.implode($data->script).'</script>';
}



/**** HTML **********************************************************************/

if (in_array($data->label->tag, array('h1', 'h2', 'h3', 'h4', 'h5', 'h6')))
	$tag = $data->label->tag;
else
    $tag = 'span';

if($data->rendering->mode == 'edit'){
	$content = '<'.$tag.' title="Title" class="title_content ngeinlineeditable ngeinlinetext" data-nge = \'{"title": "Label", "type": "text", "source":"content:label.html"}\'>'. $content .'</'.$tag.'>';
}else{
	$content =  '<'.$tag.' class="title_content">'. $content .'</'.$tag.'>';
}

$title_final = "";
if ($data->sublabel->position == "top" && $content_sublabel != ''){
	//Top
	$title_final = $content_sublabel."<br/>".$content;
}else if ($data->sublabel->position == "right"){
	//Right
	$title_final =$content." ".$content_sublabel;
}else if ($data->sublabel->position == "bottom"){
	//Bottom
	$title_final =$content."<br/>".$content_sublabel;
}else{
	//Left
	$title_final = $content_sublabel." ".$content;
}

$title_final = '<span style="display:table-cell">'.$title_final.'</span>';

$html[] = '<span style="display:inline-block">'.$iconleft . $title_final . $iconright.'</span>';
$html[] = '</div>';


//Html
echo implode($html); 
