<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;
 
/***** INSTANTIATION VARIABLES *****/
$data = 			$displayData;
$html = 			array();
$style = 			array();
$script = 			array();

//Part usage is unique or multiple (in data reports)
if (isset($data->rendering->multiple) && ($data->rendering->multiple == true))
    $data->selector = '.part-'.$data->id;
else
    $data->selector = '#part-'.$data->id;


/*
 * 
title
author
creation date
modification date
hits
Category
 */
/***** CONTENT *****/


//shortcut label
if ($data->label != '') {
	$data->content->source = 'html';
	$data->content->html = $data->label;
}

//Content
switch ($data->content->source){
	case 'system' :
		require_once (NGEPATH_HELPERS . '/data/system/systemdriver.php');	
		$content = NgeSystemDriver::get($data->content->system, $data->content->date_format_mode, $data->content->date_format_value);
		break;
	case 'url' :
		require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');	
		$content = UrlDriver::getContents($data->content->url);
		break;
	case 'query' :
		require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');	
		$content = NgeDatabaseDriver::loadSingle($data->content->query);
		break;
	case 'article' :
		$article = NgeContentHelper::currentArticle();
		$property = $data->content->article;
		if ((!isset($article)) && ($data->rendering->mode == 'preview'))
			$content = 'Will be displayed in current article.';
		else
		switch ($property){
			case 'created':
			case 'modified':
			case 'publish_up':
				$content = isset($article) ? JHtml::_('date', $article->$property) : '';		
				break;
			default :
				$content = isset($article) ? $article->$property : '';		
		}
		
		break;
	case 'data' :
		$content = $data->content->data != '' ? '{{item.' . $data->content->data . '}}' : '';
		break;    
	default : //html
		$content = $data->content->html;
		break;

}

//Class
$class = array();
$class[] = "part";

if ($data->style != 'html'){
	if($data->style == "label"){
		$class[] = NgeBootstrapTag::_( $data->style.'-default');
		if($data->theme == "danger"){
			$class[] = NgeBootstrapTag::_( $data->style.'-'.$data->theme);
		}else if ($data->theme == "custom") {
            $style[] = $data->selector.' {background : '.$data->custom_color.'}';
		} 
        else {
			$class[] = $data->style.'-'.$data->theme;
		}
	}else if($data->style == "badge"){
		$class[] = $data->style;
		if ($data->theme == "custom") {
            $style[] = $data->selector.' {background : '.$data->custom_color.'}';
		} 
        else {
			$class[] = $data->style.'-'.$data->theme;
		}
	}
}
	
    
//Part display options
$class[] = NGE::layout('nge.parts.parts.display_class', $data);

//If part usage is multiple (in data reports), using class instead of unique selector
if (isset($data->rendering->multiple) && ($data->rendering->multiple == true))
    $class[] = 'part-'.$data->id;


//Attribute
$attributes = array();
$attributes[] = 'id="part-'.$data->id.'"';
$attributes[] = ' data-part="'.$data->name.'"';
$attributes[] = ' style="display:inline-block; width:auto;"';
$attributes[] = ' data-part-label="'.NGE::translate($data->libraryTitle).'"';
$attributes[] = 'class="'.implode(' ', $class). '"';


	

//Popover
$popover_content = "";
if($data->popover->trigger != "none"){
	if ($data->popover->source == 'html')
		$popover_content = $data->popover->html;
	else if ($data->popover->source == 'url'){
		require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
		//$popover_content = UrlDriver::getContents($data->popover->url);

		$popover_content = '<iframe src="'.$data->popover->url.'" style="zoom:0.60" width="400" height="500" frameborder="0"></iframe>';

	}
	else if ($data->popover->source == 'query') {
		require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
		$popover_content = NgeDatabaseDriver::loadSingle($data->popover->query);
	}
	else if ($data->popover->source == 'article') {
		require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
		$article = NgeJoomlaArticleDriver::load($data->popover->article);
		$popover_content = $article->introtext;
	}else if ($data->popover->source == 'module') {
		require_once (NGEPATH_HELPERS . '/data/joomla/moduledriver.php');
		$popover_content = NgeJoomlaModuleDriver::load($data->popover->module);
	}else if($data->popover->source == 'image'){
		if($data->popover->image == ""){
			$data->popover->image = "components/com_nge/assets/images/default_bigthumb.png";
		}
		$popover_content = '<img src="'.$data->popover->image.'" />';
	}
}else{
	$popover_content = "";
}

if ($popover_content != ""){
	$dataPopover = $data->popover;
	$dataPopover->selector = $data->selector;
	$dataPopover->id = $data->id;
	$dataPopover->content = $popover_content;
	$dataPopover->rendering_mode = $data->rendering->mode;
	$htmlPopover = NGE::layout('nge.parts.text.html.popover_html', $dataPopover);
	$classPopover = ' trigger';
	
}else{
	$htmlPopover = '';
	$classPopover = '';
}

if(($data->rendering->mode == 'edit') && ($data->content->source == 'html')){
	$html[] = '<span '.implode(' ', $attributes).'> <span class="'.$classPopover.' ngeinlineeditable ngeinlinetext" data-nge = \'{"title": "Label", "type": "text", "source":"content:content.html"}\' >'.$content.'</span>';
}else{
	$html[] =  '<span '.implode(' ', $attributes).'> <span class="'.$classPopover.'">'.$content.'</span>';
}

$html[] = $htmlPopover;



/***** CSS **********************************************************************/
//Cache
if ($data->cache->css != ''){
    $style[] = $data->cache->css;
}
else {

	//Part display options
	$style[] = NGE::layout('nge.parts.parts.display_style', $data);
	$script[] = NGE::layout('nge.parts.parts.display_script', $data);
	
	//General CSS 
	$dataGeneral = $data;
	$dataGeneral->selector = $data->selector;
	$style[] = NGE::layout('nge.parts.text.css.label_css', $dataGeneral);

	//Font CSS
	if($data->font->style == "custom"){
		$dataFont = $data->font;
		$dataFont->selector = $data->selector;
		$style[] = NGE::layout('nge.parts.text.css.font_css', $dataFont);
	}

	if ($data->style == 'dotted')
		$style[] = $data->selector.'{border-bottom: 1px dotted;}';
	
	if ($popover_content != ""){
		$dataPopover = $data->popover;
		$dataPopover->selector = $data->selector;
		$dataPopover->id = $data->id;
		$dataPopover->rendering_mode = $data->rendering->mode;

		$style[] = NGE::layout('nge.parts.text.css.popover_css', $dataPopover);

		//Popover header
		//Header Font CSS
		if($data->popover->header->font->style == 'custom'){
			$dataHeaderFont = $data->popover->header->font;
			$dataHeaderFont->selector = '#popover-'.$data->id.' .popover > .popover-title';
			$style[] = NGE::layout('nge.parts.text.css.font_css', $dataHeaderFont);
		}

		//Header Background CSS
		if ($data->popover->header->background->style != "default") {
			$dataHeaderBackground = $data->popover->header->background;
			$dataHeaderBackground->selector = '#popover-'.$data->id.' .popover > .popover-title';
			$style[] = NGE::layout('nge.parts.panels.css.background_css', $dataHeaderBackground);
		}

		//Popover body
		//Border
		if ($data->popover->border->style != "default") {
			$dataGeneralBorder = $data->popover->border;
			$dataGeneralBorder->selector = '#popover-'.$data->id.' .popover';
			$style[] = NGE::layout('nge.parts.panels.css.border_css', $dataGeneralBorder);
		}

		//Background
		if ($data->popover->background->style != "default") {
			$dataPanelBackground = $data->popover->background;
			$dataPanelBackground->selector =  '#popover-'.$data->id.' .popover';
			$style[] = NGE::layout('nge.parts.panels.css.background_css', $dataPanelBackground);
		}
	}
}


/*** JS *************************************************************************/
//Cache
if ($data->cache->js != ''){
    $script[] = $data->cache->js;
}
else {    
	if ($popover_content != ""){
		$dataPopover = $data->popover;
		$dataPopover->selector = $data->selector
			;
		$dataPopover->id = $data->id;
		$dataPopover->rendering_mode = $data->rendering->mode;
		$script[] = NGE::layout('nge.parts.text.js.popover_js', $dataPopover);
	}	
}

//Writing cache    
if (($data->cache->css == '' && count($style) >0) || ($data->cache->js == '' && count($script) >0)){
    require_once NGEPATH_HELPERS . '/data/nge/partdriver.php';
    NgeNgePartDriver::storeCache($data->id, implode($style), implode($script));    		
}

//Style and Script
if (count($style) != 0) {
    //Part usage is unique or multiple (in data reports) If multiple, style are unique outside of the part
    if (isset($data->rendering->multiple) && ($data->rendering->multiple == true))
	NgeContenthelper::addStyle('#part-'.$data->id, implode($style));
    else //unique rendering, inside the part (it can be edited and replaced)
	$html[] = '<style>'.implode($style).'</style>';     
}
if (count($script) != 0)
    $html[] = '<script>'.implode($script).'</script>';

$html[] = '</span>';
//Html
echo implode($html);