<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

require_once(NGEPATH_LAYOUTS . '/parts/parts/html/panel.php');
/***** INSTANTIATION VARIABLES *****/
$data = 			$displayData;

$part = new LayoutPanel($data);


/***** CONTENT *****/
$content = '';
/***** CONTENT *****/
$content = '';
if ($data->content->source == 'html') {
	$content = $data->content->html;
}else if($data->content->source == 'article') {
	require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
	$article = NgeJoomlaArticleDriver::load($data->content->article);
	$content = $article->introtext;
}else if($data->content->source == 'module') {
	require_once (NGEPATH_HELPERS . '/data/joomla/moduledriver.php');
	$content = NgeJoomlaModuleDriver::load($data->content->module);
}else if($data->content->source == 'url'){
	$content = '<iframe src="'.$data->content->url.'" style="width:100%;height:500px;border:0px;"></iframe>';
}else if ($data->content->source == 'query') {
	require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
	$content = NgeDatabaseDriver::loadSingle($data->content->query);
}else if($data->content->source == 'template') {
	require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
	require_once (NGEPATH_HELPERS . '/renderer/smarty/smartyrenderer.php');
	$contentData = NgeDatabaseDriver::loadAssoc($data->content->query);
	
	if ($data->template->source == 'input')
		$content = SmartyRenderer::renderString($contentData, $data->template->input);
	else
	if ($data->template->source == 'file')		
		$content = SmartyRenderer::render($contentData, $data->template->file);
}

/***** SEPARATOR LABEL ******************/
if ($data->separator->label_mode == "custom")
	$separator_label = $data->separator->label;
else
if ($data->separator->label_mode == "chevron")
	$separator_label = '<span class="icon-chevron-down"></span>';
else			
if ($data->separator->label_mode == "plus")
	$separator_label = '<span class="icon-plus"></span>';	
else //more and default	
	$separator_label = 'More';


//Separator style
$class_sep = array();
if($data->separator->style == "button"){
	$class_sep[] = "btn";
	if($data->separator->theme != "default"){
		$class_sep[] = "btn-".$data->separator->theme;
	}
}


//**** CSS **********************************************************************/
//Cache
if ($data->cache->css == ''){

    //Separator button style
    /*
    if($data->separator->style == 'button'){
	    $dataSeparatorButtonPadding = $data->separator->padding;
	    $dataSeparatorButtonPadding->selector = '#part-'.$data->id.' div.content-more div span.btn-more.btn-custom';
	    $part->style[] = NGE::layout('nge.parts.panels.css.padding_css', $dataSeparatorButtonPadding);
    }
    */
    
    //Expandable CSS & JS
    $dataExpandable = $data;
    $dataExpandable->selector = '#part-'.$data->id;
    $part->style[] = NGE::layout('nge.parts.panels.css.expandable_css', $dataExpandable);
    
    //Separator Font CSS
    if($data->separator->font->style == 'custom'){
	    $dataSeparatorFont = $data->separator->font;
	    $dataSeparatorFont->selector = '#part-'.$data->id.' div.content-more div span.btn-more';
	    $part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataSeparatorFont);
    }
}

//**** JS **********************************************************************/
//Cache
if ($data->cache->js == ''){

	//Expandable CSS & JS
	$dataExpandable = $data;
	$dataExpandable->selector = '#part-'.$data->id;
	$part->script[] = NGE::layout('nge.parts.panels.js.expandable_js', $data);
}


$separator_class = ($data->separator->font->style == 'class') ? $data->separator->font->class : '';

/*Editable attribute*/
if ($data->rendering->mode == 'edit') {
	switch ($data->content->source) {
		case 'html' :
			//$editableTitle = 'Text';
			$editableClass = ' ngeinlineeditable ngeinlineeditor';
            $editableAttributes = 'data-nge = \'{"title": "Text", "type": "editor", "source":"content:content.html"}\'';
			//$editableType = 'ngeeditor';
			//$editableProperty = 'content.html';
			break;
		case 'article' :
			$editableTitle = 'Article';
			$editableClass = ' ngeinlineeditable';
			$editableType = 'article';
			$editableProperty = 'content.article';
            $editableAttributes = 'data-nge = \'{"title": "Article", "type": "joomla.article", "source":"content:content.article"}\'';
			break;
		case 'module' :
			$editableTitle = 'Module';
			$editableClass = ' ngeinlineeditable';
			$editableType = 'module';
			$editableProperty = 'content.module';
            $editableAttributes = 'data-nge = \'{"title": "Module", "type": "joomla.module", "source":"content:content.module"}\'';
			break;
		case 'url' :
			$editableTitle = 'Url';
			$editableClass = ' ngeinlineeditable';
			$editableType = 'url';
			$editableProperty = 'content.url';
			break;
		default :
			$editableTitle = '';
			$editableClass = ' ';
			$editableType = '';
			$editableProperty = '';
	}
} else {
	$editableTitle = '';
	$editableClass = '';
	$editableType = '';
	$editableProperty = '';
}

if($data->rendering->mode == 'edit'){
	if($data->content->source == 'html'){
		$part->content .= '<div class="collapsable collapsed outer"><div id="part-' . $data->id . '-body" " class="inner content' . $editableClass . '" ' . $editableAttributes . '>'.$content.'</div></div>';
	}else{
		$part->content .= '<div class="collapsable collapsed outer"><div class="inner">'.$content.'</div></div>';
	}
}else{
	$part->content .= '<div class="collapsable collapsed outer"><div class="inner">'.$content.'</div></div>';
}
$part->content .= '<div class="content-more"><div><span class="btn-more '.$separator_class.' '.implode(" ", $class_sep).'">'.$separator_label.'</span></div></div>';

//Generate HTML
echo $part->render();
