<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;
 
/***** INSTANTIATION VARIABLES *****/
$data = 			$displayData;
$html = 			array();
$style = 			array();

/***** CONTENT *****/
$content = '';

//Label content
$content = $data->label->html;

//Attributes
$class = array();
$class[] = "part";
$class[] = $data->shadow->style == 'none' ? '' : $data->shadow->style;

//Part display options
//$style[] = NGE::layout('nge.parts.parts.display_style', $data);
//$class[] = NGE::layout('nge.parts.parts.display_class', $data);

$attributes = array();
$attributes[] = ' id="part-'.$data->id.'"';
$attributes[] = ' data-part="'.$data->name.'"';
$attributes[] = ' data-part-label="'.NGE::translate($data->libraryTitle).'"';
$attributes[] = ' style="float: '.$data->position.'"';
$attributes[] = ' class="'.implode(' ', $class).'"';
//$attributes[] =  $data->size->type == 'css' ? ' style="width:'.$data->size->css.';"' : '';


if(isset($data->rendering->mode) && $data->rendering->mode == 'edit'){
	$glyphEditableClass = ' ngeinlineeditable ngeinlineglyph';
        $glyph_name = (isset($data->glyph->name) && $data->glyph->name != '') ? $data->glyph->name : '';
	$glyphEditableAttributes = ' data-nge = \'{"title": "Glyph", "type": "glyph", "source":"glyph.name", "name":"'.$glyph_name.'"}\' ';
}else{
	$glyphEditableClass = '';
	$glyphEditableAttributes = '';
}

if ($data->glyph->name != ''){
	$iconleft = 	$data->glyph->position == 'left' ? '<span'.$glyphEditableAttributes.' class="icomoon '.$data->glyph->name.$glyphEditableClass.'"></span> ' : '';	
	$iconright = 	$data->glyph->position == 'right' ? ' <span'.$glyphEditableAttributes.' class="icomoon '.$data->glyph->name.$glyphEditableClass.'"></span>' : '';
}else{
	$iconleft = '';
	$iconright = '';
}


/**** CSS ***********************************************************************/
//Cache
if ($data->cache->css != ''){
    $data->style[] = $data->cache->css;
}
else {

	//Padding
	if(isset($data->padding)){
		$style[] = '#part-'.$data->id . ' {';
		if(isset($data->padding->default) && ($data->padding->default != ""))
		    $style[] = 	'padding: '.$data->padding->default . 'px;';
		if(isset($data->padding->left) && ($data->padding->left != ""))
		    $style[] = 	'padding-left: '.$data->padding->left . 'px;';
		if(isset($data->padding->top) && ($data->padding->top != ""))
		    $style[] = 	'padding-top: '.$data->padding->top . 'px;';
		if(isset($data->padding->right) && ($data->padding->right != ""))
		    $style[] = 	'padding-right: '.$data->padding->right . 'px;';
		if(isset($data->padding->bottom) && ($data->padding->bottom != ""))
		    $style[] = 	'padding-bottom: '.$data->padding->bottom . 'px;';
		$style[] = '}';
	}

	//Margin
	if(isset($data->margin)){
		$style[] = '#part-'.$data->id . ' {';
		if(isset($data->margin->default) && ($data->margin->default != ""))
		    $style[] = 	'margin: '.$data->margin->default . 'px;';
		if (($data->position == 'left') && (isset($data->margin->right)) && ($data->margin->right != ""))
		    $style[] = 	'margin-right: '.$data->margin->right . 'px;';
		else
		if (($data->position == 'right') && (isset($data->margin->left)) && ($data->margin->left != ""))
		    $style[] = 	'margin-left: '.$data->margin->left . 'px;';


		if(isset($data->margin->bottom) && ($data->margin->bottom != ""))
		    $style[] = 	'margin-bottom: '.$data->margin->bottom . 'px;';
		$style[] = '}';
	}


	//Font Label CSS
	if($data->label->font->style == 'custom'){
		$dataFont = $data->label->font;
		$dataFont->selector = '#part-'.$data->id. ' .title_content' ; //Warning final tag for media print color rendering
		$style[] = NGE::layout('nge.parts.text.css.font_css', $dataFont);
	}

	//Label Effects
	if(isset($data->label->effects) &&  (count($data->label->effects) >0)){
	    $dataLabel = $data->label;
	    $dataLabel->selector = '#part-'.$data->id. ' h1' ; 
	    $dataLabel->selector_hover = '#part-'.$data->id. ':hover h1' ; 
	    $style[] = NGE::layout('nge.parts.parts.effects.css.effects_css', $dataLabel);
	}
	
	//Icomoon CSS
	if ($data->glyph->name != ""){
		NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'icomoon/icomoon-nge.css');
		$dataIcomoon = $data->glyph;
		$dataIcomoon->selector = '#part-'.$data->id.' .icomoon';
		$style[] = NGE::layout('nge.parts.panels.css.icomoon_css', $dataIcomoon);
	}

	//Border CSS
	if (($data->border->style != "none") || ($data->border->radius->width != "0")){
		$dataBorder = $data->border;
		$dataBorder->selector = '#part-'.$data->id;
		$style[] = NGE::layout('nge.parts.panels.css.border_css', $dataBorder);
	}

	//Background CSS
	if ($data->background->style != "none") {
		$dataBackground = $data->background;
		$dataBackground->selector = '#part-'.$data->id;
		$style[] = NGE::layout('nge.parts.panels.css.background_css', $dataBackground);
	}

	$data->selector = '#part-'.$data->id;
	$style[] = NGE::layout('nge.parts.text.css.title_css', $data);

	//Shadow
	if($data->shadow->style != 'none'){
		$dataShadow = $data->shadow;
		$dataShadow->selector = '#part-'.$data->id;
		$dataShadow->background = $data->background;
		$style[] = NGE::layout('nge.parts.panels.css.shadow_css', $dataShadow);	
	}
    //Writing cache    
    require_once NGEPATH_HELPERS . '/data/nge/partdriver.php';
    NgeNgePartDriver::storeCache($data->id, implode($data->style), '');    
}	
	
$html[] = '<div '.implode($attributes).'>';
//Style 
if (count($style) != 0) 
	$html[] = '<style>'.implode($style).'</style>'; 

if (in_array($data->label->font->style, array('h1', 'h2', 'h3', 'h4')))
	$tag = $data->label->font->style;
else
    $tag = 'h1';

if($data->rendering->mode == 'edit'){
	$content = '<'.$tag.' title="Title" class="title_content ngeinlineeditable ngeinlinetext" data-nge = \'{"title": "Title", "type": "text", "source":"content:label.html"}\' >'. $content .'</'.$tag.'>';
}else{
	$content =  '<'.$tag.' class="title_content">'. $content .'</'.$tag.'>';
}

$html[] = $iconleft . $content . $iconright;
$html[] = '</div>';


//Html
echo implode($html); 
if(isset($data->rendering->mode) && $data->rendering->mode == 'preview'){
    echo $data->previewtext;
}
//echo '<div class="part-parent">'.implode($html).'</div>';
/*
?>
<style>
    html, body {
  overflow-x: hidden;
}
.body .container {
    border:none;
    box-shadow : none;
    webkit-box-shadow : none;
    width: 1150px;
    max-width: 1260px;
}
#part-27397 { 
  margin: 0 -9999rem;
  padding: 0.25rem 9999rem;
width:initial;
padding-top : 80px;
padding-bottom : 80px;
margin-top : 30px;
margin-bottom : 30px;
  
}
</style>
*/