<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;
 
$data = $displayData;
/*Get Font Google if exist*/
$font_name = "";
if(isset($data->name) && ($data->name!='')){

    $browserFonts = array(
	"Georgia",
	"'Palatino Linotype', 'Book Antiqua', Palatino",
	"'Times New Roman', Times",
	"Arial, Helvetica",
	"'Arial Black', Gadget",
	"'Comic Sans MS', cursive",
	"Impact, Charcoal",
	"'Lucida Sans Unicode', 'Lucida Grande'",
	"Tahoma, Geneva",
	"'Trebuchet MS', Helvetica",
	"Verdana, Geneva",
	"'Courier New', Courier",
	"'Lucida Console', Monaco"
    );
    
    // 1 - Browser fonts ?
    if (in_array($data->name, $browserFonts))
	$font_name = $data->name;
    // 2 - Google fonts ?
    else {
	require_once (NGEPATH_CLASSES . '/ngegooglefont.php');
	$google_font_object = NgeGoogleFont::getFont($data->name, $data->weight, $data->italic);

	if($google_font_object !== false){
		$font_name = $google_font_object->family.$google_font_object->variant;
		echo "@font-face {
			font-family: '".$font_name."';
			src: url('".$google_font_object->files->{$google_font_object->variant}."');
		}";
	//3 - Other font (manual fonts, with name defined in a css styleshhet...
	}else{
		$font_name = $data->name;
	}
    }
}

echo $data->selector.'{';

echo 'text-shadow:none;';
if(isset($data->color)){echo "color: ".$data->color.";";}
if(isset($data->size)){ 
	 $line_height = round($data->size * 1.3 + 4); 
	 echo "font-size: ".$data->size."px;";	
	 echo "line-height: ".$line_height ."px;";
}

if(isset($data->letter_spacing)){echo "letter-spacing: ".$data->letter_spacing."px;";}
if($font_name != ""){echo "font-family: ".$font_name.";";}
if(isset($data->decoration)){
	if($data->decoration == "none"){echo "text-decoration: none;";}	
	else if($data->decoration == "underline"){
		echo "text-decoration: underline;";
	}
}
if (isset($data->weight)) {
    echo "font-weight:".$data->weight.";";
}
if (isset($data->italic) && $data->italic==1) {
    echo "font-style:italic;";
}
if (isset($data->case)) {
	switch ($data->case){
		case 'capitalize' :
			echo "text-transform:capitalize;";
			break;
		case 'uppercase' :
			echo "text-transform:uppercase;";
			break;
		case 'lowercase' :
			echo "text-transform:lowercase;";
			break;
	}
}

//No border! override css for some H1 border styles
//If there is border (part text.title for example) It will be applied on others tags
//NO! JMB 21-12-2015 echo "border: none;";

echo "}";

if(isset($data->color_link) && ($data->color_link != '')){echo $data->selector." a {color: ".$data->color_link.";}";}
if(isset($data->color_active) && ($data->color_active != '')){echo $data->selector.".active {color: ".$data->color_active.";}";}

/** font hover */ 

if(isset($data->color_hover) && ($data->color_hover != '') && ($data->color_hover != $data->color)){
	
    $selector_hover = '';
	if(isset($data->selector_hover) && $data->selector_hover!='')
		$selector_hover = $data->selector_hover;
	else 
	    $selector_hover = $data->selector.':hover';
	    
	echo $selector_hover." {color: ".$data->color_hover.";";
	echo '-moz-transition: all .2s ease-in-out;';
		echo '-o-transition: all .2s ease-in-out;';
		echo '-webkit-transition: all .2s ease-in-out;';
		echo 'transition: all .2s ease-in-out;';
		echo '}';
	
}		

//Link hover
if(isset($data->color_link_hover) && ($data->color_link_hover != '')){
    echo $data->selector." a:hover {color: ".$data->color_link_hover.";";
	echo '-moz-transition: all .2s ease-in-out;';
		echo '-o-transition: all .2s ease-in-out;';
		echo '-webkit-transition: all .2s ease-in-out;';
		echo 'transition: all .2s ease-in-out;';
	    echo "}";
    
}


if(isset($data->decoration)){
	if($data->decoration == "underline_hover"){
		echo $data->selector.":hover {text-decoration: underline;}";
	}	
}

if(isset($data->color)){
	echo "@media print {";
	echo $data->selector.'{';
	echo "color: ".$data->color." !important;";
	echo "}";
	echo "}";
}