<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;
 
require_once(NGEPATH_LAYOUTS . '/parts/parts/html/panel.php');
/***** INSTANTIATION VARIABLES *****/
$data = 			$displayData;

$part = new LayoutPanel($data);

/***** CONTENT *****/
$content = '';
if ($data->content->source == 'html'){
	$content = $data->content->html;
}else if($data->content->source == 'article'){
	require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
	$article = NgeJoomlaArticleDriver::load($data->content->article);
	$content = $article->introtext;
}else if($data->content->source == 'module'){
	require_once (NGEPATH_HELPERS . '/data/joomla/moduledriver.php');
	$content = NgeJoomlaModuleDriver::load($data->content->module);
}else if($data->content->source == 'url'){
	require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');	
	$content = UrlDriver::getContents($data->content->url);
}else if($data->content->source == 'query'){
	require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');	
	$content = NgeDatabaseDriver::loadSingle($data->content->query);
}

//Cache
if ($data->cache->css == ''){
    //Columns css
    $dataColumns = $data->columns;
    $dataColumns->selector = '#part-'.$data->id . ' .part-body';
    $part->style[] = NGE::layout('nge.parts.text.css.columns_css', $dataColumns);
}

//Padding
//Columns padding is the same as main body padding.
if (isset($data->columns->padding))
    $data->body->padding->default = $data->columns->padding;

// body
if($data->rendering->mode == 'edit'){
    switch ($data->content->source) {
	case 'html' :
	    //$editableTitle = 'Text';
	    $editableClass = ' ngeinlineeditable ngeinlineeditor';
        $editableAttributes = 'data-nge = \'{"title": "Text", "type": "editor", "source":"content:content.html"}\'';
	    //$editableType = 'ngeeditor'; 
	    //$editableProperty = 'content.html';
	    break;
	case 'article' :
	    $editableTitle = 'Article';
	    $editableClass = ' ngeinlineeditable';
	    $editableType = 'article'; 
	    $editableProperty = 'content.article';
	    $editableAttributes = 'data-nge = \'{"title": "Article", "type": "joomla.article", "source":"content:content.article"}\'';
        break;
	case 'module' :
	    $editableTitle = 'Module';
	    $editableClass = ' ngeinlineeditable';
	    $editableType = 'module'; 
	    $editableProperty = 'content.module';
        $editableAttributes = 'data-nge = \'{"title": "Module", "type": "joomla.module", "source":"content:content.module"}\'';
	    break;
	case 'url' :
	    $editableTitle = 'Url';
	    $editableClass = ' ngeinlineeditable';
	    $editableType = 'url'; 
	    $editableProperty = 'content.url';
	    break;
	default :
	    $editableTitle = '';
	    $editableClass = '';
	    $editableType = ''; 
	    $editableProperty = '';
    }
	//if($data->content->source == 'html'){
		$part->content = '<div id="part-'.$data->id.'-body" class="part-body'.$editableClass.'" ' . $editableAttributes . '>'.$content.'</div>';
	//}else{
	//	$html[] = '<div class="content ngeinlineeditable" data-type="article">'.$content.'</div>';
	//}
}else{
    $part->content = '<div  id="part-' . $data->id . '-body" class="part-body">'.$content.'</div>';
}

echo $part->render();