<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

 
/***** INSTANTIATION VARIABLES *****/
$data = 			$displayData;
$html = 			array();
$style = 			array();

/***** CONTENT *****/
$content = '';
if ($data->content->source == 'html'){
	$content = $data->content->html;
}else if($data->content->source == 'article'){
	require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
	$article = NgeJoomlaArticleDriver::load($data->content->article);
	$content = $article->introtext;
}else if($data->content->source == 'module'){
	require_once (NGEPATH_HELPERS . '/data/joomla/moduledriver.php');
	$content = NgeJoomlaModuleDriver::load($data->content->module);
}else if($data->content->source == 'url'){
	require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');	
	$content = UrlDriver::getContents($data->content->url);
}else if($data->content->source == 'query'){
	require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');	
	$content = NgeDatabaseDriver::loadSingle($data->content->query);
}

$label = "";
if($data->rendering->mode == 'edit'){
	$label = '<span class="ngecontenteditableinline" data-type="inline"  data-property="label">'. $data->label .'</span>';
	if($data->content->source == 'html'){
		//NgeContenthelper::addScript("media/editors/tinymce/tinymce.min.js");
		$content = '<div  id="part-'.$data->id.'-body" class="part-body ngecontenteditableinline" title="text" data-type="ngeeditor" data-property="content.html"  data-pk="'.$data->id.'-content-html">'. $content .'</div>';
		
	}
}else{
		$label = $data->label;
}

if($data->style == "callout"){
	$label = '<h4>'.$label.'</h4>';
}
else
	$label = '<b>'.$label.'</b>';

//Class
$class = array();
$class[] = "part";
if($data->style == "well"){
	$class[] = 'well';
}else if($data->style == "alert"){
	//Template Bootstrap 2
	if($data->theme == "danger"){
		$class[] = 'alert '.NgeBootstrapTag::_( 'alert-danger' );
	}else{
		$class[] = 'alert alert-'.$data->theme;
	}
}else if($data->style == "callout"){
	//Template Bootstrap 3
	$class[] = 'alert-message alert-message-'.$data->theme;
}

//Part display options
$style[] = NGE::layout('nge.parts.parts.display_style', $data);
$class[] = NGE::layout('nge.parts.parts.display_class', $data);


$attributes = array();
$attributes[] = ' id="part-'.$data->id.'"';
$attributes[] = ' data-part="'.$data->name.'"';
$attributes[] = ' data-part-label="'.NGE::translate($data->libraryTitle).'"';
$attributes[] = NGE::layout('nge.parts.parts.display_attribute', $data);
$attributes[] = ' class="'.implode(' ', $class).'"';
//$attributes[] =  $data->size->type == 'css' ? ' style="width:'.$data->size->css.';"' : '';


$data->selector = '#part-'.$data->id;
$style[] = NGE::layout('nge.parts.text.css.box_css', $data);
$html = array();

$html[] = '<div '. implode($attributes) .'>';
//Style and Script
if (count($style) != 0) 
	$html[] = '<style>'.implode($style).'</style>'; 

if ($data->dismiss == '1')
	$html[] = '<button type="button" class="close" data-dismiss="alert">&times;</button>';
$html[] = $label;
$html[] = $content;
$html[] = '</div>';

echo implode($html);
