<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// no direct access
defined('_JEXEC') or die;

require_once JPATH_SITE . '/components/com_nge/helpers/ngecontenthelper.php';
require_once(NGEPATH_LAYOUTS . '/parts/parts/html/panel.php');
require_once NGEPATH_HELPERS . '/data/nge/patterndriver.php'; 
$data = $displayData;
$part = new LayoutPanel($data);
$dataContent = array();
$dataHeader = array();
$hasBodyMergedCells = false;
$hasLastHeaderMergedCells = false;
//Used to show error displaying responsive with datatable and multi header row. Datatable responsive doesn't work with multi header row et merged cells
$hasMoreThanOneRowInHeader = false; 

//NgeContenthelper::addScript(NGEURL_MEDIA . 'nge/ngetools.js');

switch ($data->content->source) {
	case 'input' :
		//Main content in values property
		if (isset($data->content->input->values)){
		    $dataContent = $data->content->input->values;
		    //Header can be stored in separate headers property
		    //In this case, we force the number of header lines and merge all the header lines with the main content
		    if (isset($data->content->input->headers)){
			$dataContentHeader = $data->content->input->headers;
			if (count($dataContentHeader) != 0){
			    $data->table->header->length = count($dataContentHeader);
			    $dataContent = array_merge($dataContentHeader, $dataContent);
			    $data->content->input->options->cells = array_merge($data->content->input->options->headers->cells, $data->content->input->options->cells);
			    $data->content->input->options->rows = array_merge($data->content->input->options->headers->rows, $data->content->input->options->rows);
			    //Shift rows properties to the new full content
			    //for ($i=0;$i<$data->table->header->length;$i++)
			     //   array_unshift($data->content->input->options->rows, '');
			}
		    }
		}
		break;
	case 'file' :
	    if (file_exists($data->content->file)){
		$handle = fopen($data->content->file,"r"); 
		$dataContent = array();
		while (($row = fgetcsv($handle, 1000, ";")) !== FALSE) 
		{
		    $dataContent[] = $row;
		}
		echo count($dataContent);
	    }
	    else		
		$part->warnings[] = NGE::translate('COM_NGE_WARNING_FILE_NOT_FOUND') . $data->content->file;
		break;
	case 'database.query' :
		$query = $data->content->query;
		$db = JFactory::getDbo();
		$db->setQuery($query);
		$dataContent = $db->loadAssocList();
		break;
	case 'data' :
		$dataContent = $data->content->data;
		break;
}
//remove empty rows
/*
 * Bug in header row count
$hasRemovedRows = false;
for ($row= count($dataContent)-1;$row>=0;$row--){
    if (implode($dataContent[$row], '') == ''){
	unset($dataContent[$row]);
	$hasRemovedRows = true;
    }	
}
if ($hasRemovedRows)
    $dataContent = array_values($dataContent);
*/
if (((count($dataContent) == 0) && (count($dataHeader == 0))) && ($data->rendering->mode == 'preview')) {
    $part->warnings[] = 'COM_NGE_WARNING_NO_DATA_FOUND';
}

//If fastview mode, truncate data to display only first elements
if ($data->rendering->mode == 'fastview'){
    array_splice($dataContent, 10);
}

//Attributes
$class = array();
$class[] = "part";
$classTable = array();
$classTable[] = "responsive";
$classTable[] = "display";
$classTable[] = 'part-'.$data->id.'-table'; //class needed to apply all styles when datatables is in scroll mode (<table> id attribute is lost)
/******** JS ********************************************************************************/
$usingDatatables = false;
//Cache
if ($data->cache->js != ''){
    $part->script[] = $data->cache->js;
}else{
    if($data->rendering->mode != 'fastview'){
        $classTable[] = "nge-table-responsive";
        $part->script[] = NGE::layout('nge.parts.tables.js.tables_js', $data);
    }
}

$attributesTable = array();
$attributesTable[] = ' class="' . implode(' ', $classTable) . '"';
$attributesTable[] = ' style="width:100%;"';
/******** CSS *******************************************************************/

//Cache
if ($data->cache->css != ''){
    $part->style[] = $data->cache->css;
}
else {

    //Navigation mode
    //Auto mode : height is defined by content : no scrolling
    //else : scrolling is applied. Scrolling is made by datatables.
    //In thise case datatables remove and recreate all table tags. The <table> id attribute disapears.
    //So in non scrolling mode, all styles are applied to #part-nnn-table (fast)
    //In scrolling mode, all styles are applied to #part-nnn table.part-nnn-table (slower)
    if ($data->navigation->mode !== 'scrolling'){
	$tableSelector = '#part-' . $data->id . '-table';
    }
    else {
	$tableSelector = '#part-' . $data->id . ' table.part-' . $data->id . '-table';
    }

    //General table CSS    
    if ($data->table->font->style == 'custom') {
	    $dataFont = $data->table->font;
	    $dataFont->selector = $tableSelector . '>tbody>tr>td';
	    $part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataFont);
    }

    if ($data->table->border->style != 'default') {
	    $dataBorder = $data->table->border;
	    $dataBorder->selector = $tableSelector;
	    $part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataBorder);
    }

    //Fake row
    $part->style[] = $tableSelector . '>thead>tr.fake>th{';
    $part->style[] =     'padding:0px;';
    $part->style[] =     '}';
    
    //***** Table Header row *******************
    if ($data->table->header->display == '1') {

	    //Header CSS
	    $dataHeaderRows = $data->table->header->rows;
	    $dataHeaderRows->selector = $tableSelector . '>thead>tr';
	    $part->style[] = NGE::layout('nge.parts.tables.css.rows_css', $dataHeaderRows);

	    $dataHeader = $data->table->header;
	    $dataHeader->selector = $tableSelector . '>thead ';
	    $part->style[] = NGE::layout('nge.parts.panels.css.header_css', $dataHeader);

	    if (isset($data->table->header->cells->align)){
		$part->style[] = $tableSelector . '>thead>tr>th {';
		$part->style[] = 'text-align: ' . $data->table->header->cells->align . ';';
		$part->style[] = 'padding: ' . $data->table->header->cells->padding->top . 'px ' . $data->table->header->cells->padding->right . 'px ' . $data->table->header->cells->padding->bottom . 'px ' . $data->table->header->cells->padding->left . 'px;';
		$part->style[] = '}';
	    }

	    //Cells white-space is applied on the tbody tag.
	    //If custom cols have white-space they will override in the td cells
	    //thead can enable word wrap while tbody doesnt
	    if(isset($data->table->header->cells->whitespace) && ($data->table->header->cells->whitespace != 'normal')){
		$part->style[] = $tableSelector . '>thead {';
		$part->style[] =     'white-space: '.$data->table->header->cells->whitespace.';';
		$part->style[] = '}';
	    }
	    
	    //Header Font CSS
	    if ($data->table->header->font->style == 'custom') {
		    $dataHeaderFont = $data->table->header->font;
		    $dataHeaderFont->selector = $tableSelector . '>thead>tr>th';
		    $part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataHeaderFont);
	    }

	    //Header Cells Border CSS
	    $dataHeaderCellsBorder = $data->table->header->cells->border;
	    $dataHeaderCellsBorder->selector = $tableSelector . '>thead>tr>th';
	    $part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataHeaderCellsBorder);

	    //Header Border CSS
	    $dataHeaderBorder = $data->table->header->border;
	    $dataHeaderBorder->selector = $tableSelector . '>thead';
	    $part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataHeaderBorder);

	    //Header Background CSS
	    $dataHeaderBackground = $data->table->header->background;
	    $dataHeaderBackground->selector = $tableSelector . '>thead, #part-'.$data->id . ' div.dataTables_scrollHead'; //when datatables enabled with scrolling, background also on the right side of the table head
	    $part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataHeaderBackground);
    } else
	    $part->style[] = '#part-' . $data->id . ' table > thead {display:none;}';


    //Rows	
    //Rows display CSS
    $dataRows = $data->table->rows;
    $dataRows->selector = $tableSelector . '>tbody>tr';
    $part->style[] = NGE::layout('nge.parts.tables.css.rows_css', $dataRows);

    //Rows CSS
    if ($data->table->rows->border->style != "default" && $data->table->rows->border->style != "none") {
	    $dataRowsBorder = $data->table->rows->border;
	    $dataRowsBorder->selector = $tableSelector . '>tbody>tr';
	    $part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataRowsBorder);
    }

    if ($data->table->rows->background->style != "default" && $data->table->rows->background->style != "none") {
	    $dataRowsBackground = $data->table->rows->background;
	    $dataRowsBackground->selector = $tableSelector . '>tbody>tr';	
	    $part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataRowsBackground);
    }

    //Cols CSS
    if ($data->table->cols->border->style != "default") {
	    $dataColsBorder = $data->table->cols->border;
	    $dataColsBorder->selector = $tableSelector . '>tbody>tr';
	    $part->style[] = NGE::layout('nge.parts.tables.css.border_cols_css', $dataColsBorder);
    }

    if ($data->table->cols->background->style != "default") {
	    $dataColsBackground = $data->table->cols->background;
	    $dataColsBackground->selector = $tableSelector . '>tbody>tr>td';
	    $part->style[] = NGE::layout('nge.parts.tables.css.background_cols_css', $dataColsBackground);
    }

    //Cells
    //Cells CSS (padding, margin)
    //Warning table->cells>white-space is applied on table tag and not on each td tag.
    //A custom col can override the white-space of the td
    $dataCells = $data->table->cells;
    $dataCells->selector = $tableSelector . '>tbody>tr>td';
    $part->style[] = NGE::layout('nge.parts.tables.css.cells_css', $dataCells);
    
    //Cells white-space is applied on the tbody tag.
    //If custom cols have white-space they will override in the td cells
    //thead can enable word wrap while tbody doesnt
    if(isset($data->table->cells->whitespace) && ($data->table->cells->whitespace != 'normal')){
	$part->style[] = $tableSelector . '>tbody {';
	$part->style[] =     'white-space: '.$data->table->cells->whitespace.';';
	$part->style[] = '}';
    }

    /*Style for icon responsive when responsive active, else our style override datatable style*/
    $padding_left = 30;
    if(isset($dataCells->padding->left) && intval($dataCells->padding->left) > $padding_left){
        $padding_left = $dataCells->padding->left;
    }
    $part->style[] = '#part-' . $data->id . '-table.dataTable.dtr-inline.collapsed>tbody>tr>td:first-child {padding-left:'.$padding_left.'px;}';
    
    //Cells Border CSS
    $dataGeneralBorder = $data->table->cells->border;
    $dataGeneralBorder->selector = $tableSelector . '>tbody>tr>td';
    $part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataGeneralBorder);



    /************* CUSTOM formatting ************************************/
    //If options defined in the content object (right clic on input handsontable)
    //Custom columns

    if (isset($data->content->input->options->cols)){
	for ($i=0;$i<count($data->content->input->options->cols);$i++){
	    if (is_object($data->content->input->options->cols[$i]) && ($data->content->input->options->cols[$i]->style != 'default')){

		if ($data->content->input->options->cols[$i]->style == 'pattern'){	
		    if ($data->content->input->options->cols[$i]->pattern != ''){
			$dataCol = NgePatternDriver::loadParams($data->content->input->options->cols[$i]->pattern);
                    }
		}else{ //custom
		    $dataCol = $data->content->input->options->cols[$i];
                }

                    if(isset($dataCol) && ($dataCol != null)){ //null if pattern mode and no pattern defined			
                        //width applied on the first row wich is a fake row to be sure to have all widths even if case many cells are merged
                        
                        if(isset($dataCol->display) && $dataCol->display === "custom"){
                            if(!$usingDatatables){
                                if((isset($dataCol->width)) 
                                    && ((($dataCol->width->mode == "fixed") && ($dataCol->width->fixed_value != ''))
                                    || (($dataCol->width->mode == "flexible") && ($dataCol->width->fixed_value != '')))){

                                    if ($dataCol->width->mode == "fixed"){
                                        $dataCol->width->value = $dataCol->width->fixed_value.'px;';
                                    }else if ($dataCol->width->mode == "flexible"){
                                        $dataCol->width->value = $dataCol->width->flexible_value.'%;';
                                    }

                                    $part->style[] = $tableSelector . '>thead>tr.fake>th.ngecol_'.$i.'{';
                                    $part->style[] =     'padding:0px;'; //To be sure to override cell settings and that the row is 0 height (not visible)
                                    $part->style[] =     'min-width: '.$dataCol->width->value.';'; //Minimum width garanty.
                                    $part->style[] =     'width: '.$dataCol->width->value.';'; //Width
                                    $part->style[] = '}';
                                }
                            }

                            $part->style[] = $tableSelector . '>tbody>tr>td.ngecol_'.$i.'{';
                                $part->style[] = 'text-align: ' . $dataCol->align . ';';
                                $part->style[] = 'padding: ' . $dataCol->vpadding . 'px ' . $dataCol->hpadding . 'px ' . $dataCol->vpadding . 'px ' . $dataCol->hpadding . 'px;';
                            $part->style[] = '}';
                        }
                        
                        //white-space, always overrides the default value (cells settings can have global white-space defined on the tbody tag)
                        if(isset($dataCol->whitespace)){
                            $part->style[] = $tableSelector . '>tbody>tr>td.ngecol_'.$i.'{';
                                $part->style[] =     'white-space: '.$dataCol->whitespace.';';
                            $part->style[] = '}';
                        }
                        
//                        $part->style[] = '}';

                        if (isset($dataCol->font) && $dataCol->font->style != 'default'){
                            $dataColFont = $dataCol->font;
                            $dataColFont->selector = $tableSelector . '>tbody>tr>td.ngecol_'.$i;
                            $part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataColFont);
                        }
                        if (isset($dataCol->border) && $dataCol->border->style != 'default'){
                            $dataColBorder = $dataCol->border;
                            $dataColBorder->selector = $tableSelector . '>tbody>tr>td.ngecol_'.$i;
                            $part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataColBorder);
                        }
                        if (isset($dataCol->background) && $dataCol->background->style != 'default'){
                            $dataColBackground = $dataCol->background;
                            $dataColBackground->selector = $tableSelector . '>tbody>tr>td.ngecol_'.$i;
                            $part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataColBackground);
                        }
                    }
	    }
	}
    }

    //Custom rows
    if (isset($data->content->input->options->rows)){
	for ($i=0;$i<count($data->content->input->options->rows);$i++){
	    if (is_object($data->content->input->options->rows[$i]) && ($data->content->input->options->rows[$i]->style != 'default')){

		if ($data->content->input->options->rows[$i]->style == 'pattern'){	
		    $dataRow = NgePatternDriver::loadParams($data->content->input->options->rows[$i]->pattern);
		}
		else //custom
		    $dataRow = $data->content->input->options->rows[$i];
          
                if(isset($dataRow) && ($dataRow != null)){ //null if pattern mode and no pattern defined	
                    if(isset($dataRow->display) && $dataRow->display === "custom"){
                        $part->style[] = $tableSelector . '>thead>tr.ngerow_' . $i . '>td, ' . $tableSelector . '>tbody>tr.ngerow_'.$i.' >td{';
                        if(isset($dataRow->vpadding)){
                            $part->style[] = 'padding-top: ' . $dataRow->vpadding . 'px;';
                            $part->style[] = 'padding-bottom: ' . $dataRow->vpadding . 'px;';
                        }
                        if(isset($dataRow->height->mode) && $dataRow->height->mode === "fixed"){
                            $part->style[] = 'height: ' . $dataRow->height->fixed_value . 'px;';
                        }
                        $part->style[] = '}';
                    }     
                    if (isset($dataRow->font->style) && $dataRow->font->style != 'default'){
                        $dataRowFont = $dataRow->font;
                        $dataRowFont->selector = $tableSelector . '>thead>tr.ngerow_' . $i . '>td, ' . $tableSelector . '>tbody>tr.ngerow_'.$i.' >td';
                        $part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataRowFont);
                    }
                    if (isset($dataRow->border->style) && $dataRow->border->style != 'default'){
                        $dataRowBorder = $dataRow->border;
                        $dataRowBorder->selector = $tableSelector . '>thead>tr.ngerow_' . $i . ', ' . $tableSelector . '>tbody>tr.ngerow_'.$i;
                        $part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataRowBorder);
                    }
                    //Background is applied on each cell for the line background to hace priority on the col background if defined
                    if (isset($dataRow->background->style) && $dataRow->background->style != 'default'){
                        $dataRowBackground = $dataRow->background;
                        $dataRowBackground->selector = $tableSelector . '>thead>tr.ngerow_' . $i . '>th, ' . $tableSelector . '>tbody>tr.ngerow_'.$i.'>td';
                        $dataRowBackground->selector_hover = $tableSelector . '>thead>tr.ngerow_' . $i . ':hover>th, ' . $tableSelector . '>tbody>tr.ngerow_'.$i.':hover>td';
                        $part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataRowBackground); 
                    }
                }
	    }
	}
    }

    //Custom cells
    if (isset($data->content->input->options->cells)){

	for ($y=0;$y<count($data->content->input->options->cells);$y++){
	    for ($x=0;$x<count($data->content->input->options->cells[$y]);$x++){
                if (is_object($data->content->input->options->cells[$y][$x]) && (isset($data->content->input->options->cells[$y][$x]->style)) && ($data->content->input->options->cells[$y][$x]->style != 'default')){

                    if ($data->content->input->options->cells[$y][$x]->style == 'pattern'){	
                        $dataCell = NgePatternDriver::loadParams($data->content->input->options->cells[$y][$x]->pattern);
                    }else{ //custom
                        $dataCell = $data->content->input->options->cells[$y][$x];
                    }

                    if(isset($dataCell) && ($dataCell != null)){ //null if pattern mode and no pattern defined
                        //Warning
                        //Using id in each td can not be used to apply css : the #part-xxx-cell-3_0 selector has les priority then the general row css #part-xxx-table>tbody>tr.ngerow_3
                        //So we need to use the main id and subclasses even with a more complex selector
                        if($data->navigation->ordering->display == true){
                            $dataCell->hpadding = ($dataCell->hpadding < 12) ? 12 : $dataCell->hpadding;
                        }

                        if(isset($dataCell->display) && $dataCell->display === "custom"){
                            $part->style[] = $tableSelector . '>thead>tr.ngerow_' . $y . '>th.ngecol_'.$x . ', ' . $tableSelector . '>tbody>tr.ngerow_' . $y . '>td.ngecol_'.$x .'{';
                            $part->style[] = 'text-align: ' . $dataCell->align . ';';
                            $part->style[] = 'padding-left: ' . $dataCell->hpadding . 'px;';
                            $part->style[] = 'padding-right: ' . $dataCell->hpadding . 'px;';
                            $part->style[] = '}';
                        }
                        
                        if ($dataCell->font->style != 'default'){
                            $dataCellFont = $dataCell->font;
                            $dataCellFont->selector = $tableSelector . '>thead>tr.ngerow_' . $y . '>th.ngecol_'.$x . ', ' . $tableSelector . '>tbody>tr.ngerow_' . $y . '>td.ngecol_'.$x;
                            $part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataCellFont);
                        }
                        if ($dataCell->border->style != 'default'){
                            $dataCellBorder = $dataCell->border;
                            $dataCellBorder->selector = $tableSelector . '>thead>tr.ngerow_' . $y . '>th.ngecol_'.$x . ', ' . $tableSelector . '>tbody>tr.ngerow_' . $y . '>td.ngecol_'.$x;
                            $part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataCellBorder);
                        }
                        if ($dataCell->background->style != 'default'){
                            $dataCellBackground = $dataCell->background;
                            $dataCellBackground->selector = $tableSelector . '>thead>tr.ngerow_' . $y . '>th.ngecol_'.$x . ', ' . $tableSelector . '>tbody>tr.ngerow_' . $y . '>td.ngecol_'.$x;
                            $part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataCellBackground);
                        }
                    }
                }
	    }
	}
    }
}//End css cache

//Cells Background CSS
/*if ($data->table->cells->background->style != "default" && $data->table->cells->background->style != "none") {
	$dataCellsBackground = $data->table->cells->background;
	$dataCellsBackground->selector = '#part-' . $data->id . ' tbody td';
	$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataCellsBackground);
}*/

//Writing cache    
if (($data->cache->css == '' && count($part->style) >0) || ($data->cache->js == '' && count($part->script) >0)){
    require_once NGEPATH_HELPERS . '/data/nge/partdriver.php';
    NgeNgePartDriver::storeCache($data->id, implode($part->style), implode($part->script));    		
}

/***** HTML *****/
//Inlineediting
if(isset($data->rendering->mode) && $data->rendering->mode == 'edit'){
    $headerEditableClass = ' class="ngeinlineeditable"';
    $headerEditableAttributes = ' data-nge = \'{"title": "Row", "type": "table.header", "source":"params:table.header", "name":"XXXX"}\' ';

    $rowEditableClass = ' ngeinlineeditable';
    $rowEditableAttributes = ' data-nge = \'{"title": "Row", "type": "table.row", "source":"params:table.rowxxx", "name":"XXXX"}\' ';
}else {
    $rowEditableClass = '';
    $rowEditableAttributes = '';
    $headerEditableClass = '';
    $headerEditableAttributes = '';
}

$part->content .= '<table id="part-'.$data->id.'-table" ' . implode($attributesTable) . '>';
$rowno = 0;

//***************** TABLE HEADER *************************************
$headerRowNumber = min($data->table->header->length, count($dataContent));
if ($data->table->header->display == "1") {
    $part->content .= '<thead' . $headerEditableClass . $headerEditableAttributes . '>';
    
    
    /*
    for ($i=0;$i<$headerRowNumber;$i++) {
	$part->content .= '<tr>';.nge-workshop-preview
	foreach ($dataContent[$i] as $value) {
		$part->content .= '<td>' . $value . '</td>';		
	}
	$part->content .= '</tr>';
	$rowno++;
    }
    */    

    //fake row to keep all widths. Used to be sure all widths are kept, even if many cells are merged
$colno=0;
$part->content .= '<tr class="fake">';
if (isset($dataContent[0]))
    while ($colno < count($dataContent[0])) {
	    $part->content .= '<th class="ngecol_' . $colno . '">&nbsp;</th>';
	    $colno++;
    }
$part->content .= '</tr>';
    if($headerRowNumber > 1){
        $hasMoreThanOneRowInHeader = true;
    }

    while ($rowno < $headerRowNumber) {
        //Warning responsible datatable when multi row doesn't works. So only show the first row.
        if(!$usingDatatables || ($usingDatatables && (!$hasMoreThanOneRowInHeader || ($hasMoreThanOneRowInHeader && $rowno === ($headerRowNumber - 1))))){
            $part->content .= '<tr class="ngerow_' . $rowno . $rowEditableClass  .'" '  . $rowEditableAttributes . '>';

            $colno = 0;
            while ($colno < count($dataContent[$rowno])) {
                //if previous row is mergedremoved in the same columns, bypass this cell
                if (!isset($data->content->input->options->headers->cells[$rowno][$colno]->isMergedRemoved)){
                    //Cell merged ?
                    $rowSpan = 0;
                    $colSpan = 0;
                    $mergeAttributes = '';
                    if (isset($data->content->input->options->headers->cells[$rowno][$colno]->mergeCell)){
                        if (isset($data->content->input->options->headers->cells[$rowno][$colno]->mergeCell->rowspan))
                            $rowSpan = $data->content->input->options->headers->cells[$rowno][$colno]->mergeCell->rowspan;
                        if (isset($data->content->input->options->headers->cells[$rowno][$colno]->mergeCell->colspan))
                            $colSpan = $data->content->input->options->headers->cells[$rowno][$colno]->mergeCell->colspan;

                        if(!$usingDatatables || ($rowno + $rowSpan !== $headerRowNumber) || $colSpan <= 1){
                            if ((($rowSpan != '') && ($rowSpan != 0)) && ($colSpan > 0)){
                                $mergeAttributes .= ' rowspan="' . $rowSpan . '"';
                                $mergeAttributes .= ' colspan="' . $colSpan . '"';

                                //Cells in next rows will be merged.
                                for ($i=1;$i<$rowSpan;$i++){
                                    for ($j=0;$j<$colSpan;$j++){
                                        if (isset($data->content->input->options->headers->cells[$rowno+$i][$colno+$j])){
                                            $data->content->input->options->headers->cells[$rowno+$i][$colno+$j]->isMergedRemoved = true;
                                        }else if (!isset($data->content->input->options->headers->cells[$rowno+$i][$colno+$j]) 
                                                && is_null($data->content->input->options->headers->cells[$rowno+$i][$colno+$j])){
                                            $data->content->input->options->headers->cells[$rowno+$i][$colno+$j] = new stdClass();
                                            $data->content->input->options->headers->cells[$rowno+$i][$colno+$j]->isMergedRemoved = true;
                                        }
                                    }
                                }

                                /*For warning message in preview mode and ff multi column merged with last row*/
                                if(($rowno + $rowSpan === $headerRowNumber) && ($colSpan > 1)){
                                    $hasLastHeaderMergedCells = true;
                                }
                            }else if(($rowSpan != '') && ($rowSpan != 0)){
                                $mergeAttributes .= ' rowspan="' . $rowSpan . '"';
                                //Cells in next rows will be merged.
                                for ($i=0;$i<$rowSpan;$i++){
                                    if ($data->content->input->options->headers->cells[$rowno+$i][$colno] == null){
                                        $data->content->input->options->headers->cells[$rowno+$i][$colno] = new stdClass();
                                    }
                                    $data->content->input->options->headers->cells[$rowno+$i][$colno]->isMergedRemoved = true;
                                }

                                /*For warning message in preview mode and ff multi column merged with last row*/
                                if(($rowno + $rowSpan === $headerRowNumber) && ($colSpan > 1)){
                                    $hasLastHeaderMergedCells = true;
                                }
                            }
                            //Colspan : enabled in flat tables (without Datatables), and in Datatables header rows, except the last row.
                            //Datatables cannot merge cells in the last row : reserved to sorting, and problems in scrolling to calculate the colums width (same width in body than in head)
                            else{ /*(($colSpan > 0) && (($usingDatatables == false) || ($rowno != $headerRowNumber-1)))*/
                                $mergeAttributes .= ' colspan="' . $colSpan . '"';
                            }
                        }
                    }

                    //Rendering cell                
                    if ($data->rendering->mode == 'edit' && $data->content->source == 'input'){
                        $cellEditableAttributes = ' data-nge = \'{"title": "cell", "type": "figaro.table.header.cell", "source":"content:content.input.headers.' . $rowno . '.' . $colno . '", "index":"' . $rowno . '.' . $colno . '", "options":{"preload":false}}\' ';
                        $part->content .= '<th id="#part-' . $data->id . '-c_'.$rowno.'_'.$colno . '" class = "ngecol_' . $colno . '"' . $mergeAttributes . '><div class="ngeelement ngeinlineeditor" ' . $cellEditableAttributes . '>' . $dataContent[$rowno][$colno] . '</div></th>';
                    }else{
                        $part->content .= '<th id="#part-' . $data->id . '-c_'.$rowno.'_'.$colno . '" class = "ngecol_' . $colno . '"' . $mergeAttributes . '>' . $dataContent[$rowno][$colno] . '</th>';
                    }

                    //For warning message in preview mode
                    if (($rowno == $headerRowNumber-1) && $colSpan > 1){		
                        $hasLastHeaderMergedCells = true;
                    }
                }

                if ($colSpan > 0){ //Next cell will be not rendered 
                    $colno = $colno + $colSpan;
                }else{
                    $colno++;
                }
            }

            $part->content .= '</tr>';
        }
	$rowno++;
}
    
    $part->content .= '</thead>';
    
}

//***************** TABLE BODY *************************************
$part->content .= '<tbody>';
$alternate = '';
$alternateClass = '';
$odd = true;

while ($rowno < count($dataContent)) {
	$alternateClass = $odd? ' odd' :  ' even';
	$part->content .= '<tr class="ngerow_' . $rowno . $alternateClass . $rowEditableClass  .'" '  . $rowEditableAttributes . '>';
	$odd = !$odd;
	$colno = 0;
	while ($colno < count($dataContent[$rowno])) {

	    //In flat rendering (no datatable) if previous row is mergedremoved in the same columns, bypass this cell
	    if (!isset($data->content->input->options->cells[$rowno][$colno]->isMergedRemoved)){
	    
		//Cell merged ? Only if not using Datatables. Datatables implementations does'nt support cell merges, and it is not logical
		//Problems in sorting, in result searching and in pagination
		//If we are using Datatables, we do not merge cells, even if it has been setted in the input screen
		$rowSpan = 0;
		$colSpan = 0;
		$mergeAttributes = '';
		if (isset($data->content->input->options->cells[$rowno][$colno]->mergeCell)){

		    //For warning message in preview mode
		    $hasBodyMergedCells = true;		
		    //If flat mode (no datatables, we can render merged cells. When using Datatables, we can not.
		    if (!$usingDatatables){
			if (isset($data->content->input->options->cells[$rowno][$colno]->mergeCell->rowspan))
			    $rowSpan = $data->content->input->options->cells[$rowno][$colno]->mergeCell->rowspan;
			if (isset($data->content->input->options->cells[$rowno][$colno]->mergeCell->colspan))
			    $colSpan = $data->content->input->options->cells[$rowno][$colno]->mergeCell->colspan;

                        if (($rowSpan != '') && ($rowSpan != 0) && ($colSpan != '') && ($colSpan != 0)){
                            $mergeAttributes .= ' rowspan="' . $rowSpan . '"';
                            $mergeAttributes .= ' colspan="' . $colSpan . '"';
                            
                            for ($i=1;$i<$rowSpan;$i++){
                                for ($j=0;$j<$colSpan;$j++){
                                    if (isset($data->content->input->options->cells[$rowno+$i][$colno+$j])){
                                        $data->content->input->options->cells[$rowno+$i][$colno+$j]->isMergedRemoved = true;
                                    }else if (!isset($data->content->input->options->cells[$rowno+$i][$colno+$j]) 
                                            && is_null($data->content->input->options->cells[$rowno+$i][$colno+$j])){
                                        $data->content->input->options->cells[$rowno+$i][$colno+$j] = new stdClass();
                                        $data->content->input->options->cells[$rowno+$i][$colno+$j]->isMergedRemoved = true;
                                    }
                                }
                            }
                        }else if(($rowSpan != '') && ($rowSpan != 0)){
                            $mergeAttributes .= ' rowspan="' . $rowSpan . '"';
                            //Cells in next rows will not be rendered
                            for ($i=1;$i<$rowSpan;$i++){
                                if (isset($data->content->input->options->cells[$rowno+$i][$colno])){
                                    $data->content->input->options->cells[$rowno+$i][$colno]->isMergedRemoved = true;
                                }else if (!isset($data->content->input->options->cells[$rowno+$i][$colno]) 
                                        && is_null($data->content->input->options->cells[$rowno+$i][$colno])){
                                    $data->content->input->options->cells[$rowno+$i][$colno] = new stdClass();
                                    $data->content->input->options->cells[$rowno+$i][$colno]->isMergedRemoved = true;
                                }
                            }
                        }else{/*($colSpan != '') && ($colSpan != 0)*/
                            $mergeAttributes .= ' colspan="' . $colSpan . '"';
                        }
		    }
		}
		
		//Rendering cell
		if ($data->rendering->mode == 'edit' && $data->content->source == 'input'){
			$cellEditableAttributes = ' data-nge = \'{"title": "cell", "type": "figaro.table.cell", "source":"content:content.input.values.' . intval($rowno-$data->table->header->length) . '.' . $colno . '", "index":"' . intval($rowno-$data->table->header->length) . '.' . $colno . '", "options":{"preload":false}}\' ';
			//$part->content .= '<td class="content ngecontenteditable" style="text-align:' . $align . '" data-property="content_input_values.' . $rowno . '.' . $key . '" data-pk="' . $data->id . '-content_input_values-' . $rowno . '-' . $key . '">' . $value . '</td>';
			//$part->content .= '<td class="ngecol_' . $colno . ' ngeinlineeditor" ' . $cellEditableAttributes . '>' . $value . '</td>';
			$part->content .= '<td class = "ngecol_' . $colno . '"' . $mergeAttributes . '><div class="ngeelement ngeinlineeditor" ' . $cellEditableAttributes . '>' . $dataContent[$rowno][$colno] . '</div></td>';
		}
		else
			$part->content .= '<td class = "ngecol_' . $colno . '"' . $mergeAttributes . '>' . $dataContent[$rowno][$colno] . '</td>';		
		
		//Merged cells?
		if ($colSpan > 0){ //Next cell will be not rendered 
		    $colno = $colno + $colSpan;
		}
		else{
		    $colno++;
                    
                }
	    } //row merged
	    else
		$colno++;
	}

	$part->content .= '</tr>';
	$rowno++;
}

$part->content .= '</tbody>';
$part->content .= '</table>';

//Warnings in preview mode
//if(!isset($data->noWarnings) || (isset($data->noWarnings) && !$data->noWarnings)){
//    if ($usingDatatables && $hasBodyMergedCells){
//	$part->warnings[] = NGE::translate('COM_NGE_WARNING_TABLE_MERGE_BODY');
//    }
//    if ($usingDatatables && $hasLastHeaderMergedCells){
//	$part->warnings[] = NGE::translate('COM_NGE_WARNING_TABLE_MERGE_HEAD');
//    }        
//    if ($usingDatatables && $hasMoreThanOneRowInHeader){
//	$part->warnings[] = NGE::translate('COM_NGE_WARNING_TABLE_MULTIROW_HEADER');
//    }        
//}      

echo $part->render();
