<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

class LayoutPart{
	
	public $data;
	public $html; //Rendered html
	public $style; //all rendered css. Maybe in cache
	public $script; //all rendered js. Maybe in cache	
	public $warnings; //In preview mode (config screen) Warning messages
	public $informations; // In preview mode (config screen) Information messages
	
	function __construct($data){
		$this->data =			$data;
		$this->html = 			array();
		$this->style = 			array();
		$this->script = 			array();
		$this->warnings = 			array();
		$this->informations = 		array();
	}
	
	public function renderScripts(){
		$scripts = array();
		if (count($this->style) != 0){
		    //Part usage is unique or multiple (in data reports) If multiple, style are unique outside of the part
		    if (isset($this->data->rendering->multiple) && ($this->data->rendering->multiple == true))
			NgeContenthelper::addStyle('#part-'.$this->data->id, implode($this->style));
		    else //unique rendering, inside the part (it can be edited and replaced)
			$scripts[] = '<style>' . implode($this->style) . '</style>';
		}
		if (count($this->script) != 0)
			$scripts[] = '<script>jQuery(document).ready(function (){' . implode($this->script) . '});</script>';
		return implode($scripts);
	    
	}
	
	public function renderMessages(){
	    
	    $messages = array();
	    //When in preview mode, rendering warning messages before the main content (parent::render)
	    if (($this->data->rendering->mode =="preview") || ($this->data->rendering->mode =="edit")){
		foreach ($this->warnings as $warning){
		    $messages[] = '<div class="ngePreviewWarning ngenosave">
		    <button type="button" class="close" data-dismiss="alert">&times;</button>
		    <h4><span class="icomoon icomoon-warning"></span>&nbsp;' . NGE::translate('COM_NGE_WARNING').'</h4>'.
		    NGE::translate($warning). '</div>';
		}
		foreach ($this->informations as $information){
		    $messages[] = '<div class="ngePreviewInformation ngenosave">
		    <button type="button" class="close" data-dismiss="alert">&times;</button>
		    <h4><span class="icomoon icomoon-info"></span>&nbsp;' . NGE::translate('COM_NGE_INFORMATION') . '</h4>'.
		    NGE::translate($information). '</div>';
		}
		
	    }	    
	    return implode($messages);
	}
		
}
