<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

require_once(NGEPATH_LAYOUTS . '/parts/parts/html/part.php');

class LayoutPanel extends LayoutPart {

	public $content;
	public $class;
	
	function __construct($data) {
		parent::__construct($data);
		$this->content = '';
		$this->class= array();
	}

	public function render() {

	    //Removing effects if in fastview mode
	    if ($this->data->rendering->mode == "fastview"){
		$this->data->header->effects = array();
		$this->data->legend->effects = array();
	    }
	    
	    //Warning messages if preview mode
	    $html[] = parent::renderMessages();
	    
		if ($this->data->badge->label != ''){

		    if ($this->data->rendering->mode == 'edit') {
			    $content_badge = '<span class="ngeinlineeditable ngeinlinetext" data-type="text" data-nge = \'{"title": "Label", "type": "text", "source":"content:badge.label"}\'>' . $this->data->badge->label . '</span>';
		    } else {
			    $content_badge = '<span>' . $this->data->badge->label . '</span>';
		    }
		    //$theme_badge = (isset($this->data->badge->display) && (isset($this->data->badge->theme)) && ($this->data->badge->display == "0")) ? "none" : $this->data->badge->theme;
		    $theme_badge = '';


	    //Badge
		    //$this->class = array();
		    if ($theme_badge == "none") {
			    $this->class[] = '';
		    } else if ($theme_badge == "rectangle") {
			    $this->class[] = 'badger-' . $this->data->badge->align;
			    $this->class[] = ' ' . $this->data->badge->color;
		    } else if ($theme_badge == "button") {
			    $this->class[] = '';
		    } else if ($theme_badge == "triangular") {
			    $this->class[] = '';
		    }
		}    
		    
		    
		$this->class[] = "part";
		$this->class[] = $this->data->shadow->display != 'none' ? $this->data->shadow->style : '';

//Part display options
		$this->data->selector = '#part-' . $this->data->id ;		
		$this->style[] = NGE::layout('nge.parts.parts.display_style', $this->data);
		$this->class[] = NGE::layout('nge.parts.parts.display_class', $this->data);
		$this->script[] = NGE::layout('nge.parts.parts.display_script', $this->data);
		
		//If part usage is multiple (in data reports), using class instead of unique selector as main selector to apply styles and scripts
		if (isset($this->data->rendering->multiple) && ($this->data->rendering->multiple == true))
		    $class[] = 'part-'.$this->data->id;	
		
//Attribute
		$attributes = array();
		$attributes[] = ' id="part-' . $this->data->id . '"';
		$attributes[] = ' data-part="' . $this->data->name . '"';
		$attributes[] = ' data-part-label="' . NGE::translate($this->data->title) . '"';
		
		//$attributes[] = ' data-aos="slide-right" data-aos-once="true"';
		//$attributes[] = ' data-aos="fade-right"';
		
		
		
		$attributes[] = NGE::layout('nge.parts.parts.display_attribute', $this->data);
		$attributes[] = (implode($this->class) != "") ? ' class="' . implode(' ', $this->class) . '"' : "";
		//Adding optionnal attributes coming from api 
		foreach ($this->data->attributes as $key=>$value){
		    $attributes[] = ' '. $key . '="' . $value . '"';
		}
		

		// bootstrap redefined span size and margin
		//By Bertrand
		//JMB comment 23/01/16
//$this->style[] = NGE::layout('nge.parts.panels.css.bootstrap_redefined_css', $this->dataGeneral);
		//$this->style[] = NGE::layout('nge.parts.panels.css.ngespan_css', $this->data);
		NgeContenthelper::addStyleSheet(NGEURL_ASSETS . 'css/ngespan.css');		
		
		//If part has fixed size and overflow content is custom scrollbar, call niceScroll library
		if (($this->data->size->height->mode == 'custom') && ($this->data->size->height->overflow == 'scrollbar') && ($this->data->scrollbar->style != 'default'))
		    NgeContenthelper::addScript(NGEURL_MEDIA . 'nicescroll/jquery.nicescroll.min.js');
		else
		if (($this->data->size->height->mode == 'custom') && ($this->data->size->height->overflow == 'parallax'))
		    NgeContenthelper::addScript(NGEURL_MEDIA . 'parallax/parallax.min.js');
		
		
		/*** CSS ********************************************************/
		//Cache
		if ($this->data->cache->css != ''){
		    $this->style[] = $this->data->cache->css;
		}
		else {
		
//$attributes[] =  $this->data->size->type == 'css' ? ' style="width:'.$this->data->size->css.';"' : '';
//General CSS		
		$this->dataGeneral = $this->data;
		$this->dataGeneral->selector = '#part-' . $this->data->id;
		$this->style[] = NGE::layout('nge.parts.panels.css.panel_css', $this->dataGeneral);
		
		//Header CSS
		if ($this->data->header->label != '' || $this->data->header->glyph->name != '') {
    
			$this->dataHeader = $this->data->header;
			//$this->dataHeader->selector = '#part-' . $this->data->id . ' .part_header';
			$this->dataHeader->selector = '#part-' . $this->data->id . '-header';
			$this->dataHeader->selector_hover = '#part-' . $this->data->id . ':hover #part-' . $this->data->id . '-header'; //For effects
			$this->style[] = NGE::layout('nge.parts.panels.css.header_css', $this->dataHeader);

			//Header Font CSS
			if ($this->data->header->font->style == 'custom') {
				$this->dataHeaderFont = $this->data->header->font;
				$this->dataHeaderFont->selector = '#part-' . $this->data->id . ' .header_title';
				$this->dataHeaderFont->selector_hover = '#part-' . $this->data->id . ':hover .header_title';
				$this->style[] = NGE::layout('nge.parts.text.css.font_css', $this->dataHeaderFont);
			}

			//Header Border
			if ($this->data->header->border->style != "none") {
				$this->dataHeaderBorder = $this->data->header->border;
				//$this->dataHeaderBorder->selector = '#part-' . $this->data->id . ' .part_header';
				$this->dataHeaderBorder->selector = '#part-' . $this->data->id . '-header';
				$this->dataHeaderBorder->selector_hover = '#part-' . $this->data->id . ':hover .part_header';
				$this->style[] = NGE::layout('nge.parts.panels.css.border_css', $this->dataHeaderBorder);
			}

			//Header Background CSS
			if ($this->data->header->background->style != "none") {			    
				$this->dataHeaderBackground = $this->data->header->background;
				//$this->dataHeaderBackground->selector = '#part-' . $this->data->id . ' .part_header';
				$this->dataHeaderBackground->selector = '#part-' . $this->data->id . '-header';
				$this->dataHeaderBackground->selector_hover = '#part-' . $this->data->id . ':hover .part_header';
				$this->style[] = NGE::layout('nge.parts.panels.css.background_css', $this->dataHeaderBackground);
			}
			//Header Glyph CSS
			if ($this->data->header->glyph->name != "") {
				NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'icomoon/icomoon-nge.css');
				$this->dataHeaderIcomoon = $this->data->header->glyph;
				//$this->dataHeaderIcomoon->selector = '#part-' . $this->data->id . ' .part_header .icomoon';
				$this->dataHeaderIcomoon->selector = '#part-' . $this->data->id . '-header-glyph';
				$this->dataHeaderIcomoon->selector_hover = '#part-' . $this->data->id . ':hover .part_header .icomoon';
				$this->style[] = NGE::layout('nge.parts.panels.css.icomoon_css', $this->dataHeaderIcomoon);
			}
			//Header Strikeout CSS
			if ($this->data->header->strikeout->style != "none") {
				$this->dataHeader = $this->data->header;
				$this->dataHeader->selector = '#part-' . $this->data->id . '-header-content h1';
				$this->style[] = NGE::layout('nge.parts.panels.css.strikeout_css', $this->dataHeader);
			}
		}

		/* Badge CSS */
		if ($this->data->badge->label != '') {
			//Badge CSS
			$this->dataBadge = $this->data->badge;
			$this->dataBadge->selector = '#part-' . $this->data->id . ' .part_badge';
			$this->style[] = NGE::layout('nge.parts.panels.css.badge_css', $this->dataBadge);

			//Badge Font CSS
			if ($this->data->badge->font->style == 'custom') {
				$this->dataBadgeFont = $this->data->badge->font;
				$this->dataBadgeFont->selector = '#part-' . $this->data->id . ' .part_badge span';
				$this->style[] = NGE::layout('nge.parts.text.css.font_css', $this->dataBadgeFont);
			}

			//Badge Border
			if ($this->data->badge->border->style != "none") {
				$this->dataBadgeBorder = $this->data->badge->border;
				$this->dataBadgeBorder->selector = '#part-' . $this->data->id . ' .part_badge';
				$this->style[] = NGE::layout('nge.parts.panels.css.border_css', $this->dataBadgeBorder);
			}

			//Badge Background CSS
			if ($this->data->badge->background->style != "none") {
				$this->dataBadgeBackground = $this->data->badge->background;
				$this->dataBadgeBackground->selector = '#part-' . $this->data->id . ' .part_badge';
				$this->style[] = NGE::layout('nge.parts.panels.css.background_css', $this->dataBadgeBackground);
			}
			//Badge Icomoon CSS
			if ($this->data->badge->glyph->name != ''){
				NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'icomoon/icomoon-nge.css');
				$this->dataBadgeIcomoon = $this->data->badge->glyph;
				$this->dataBadgeIcomoon->selector = '#part-' . $this->data->id . ' .part_badge .icomoon';
				$this->style[] = NGE::layout('nge.parts.panels.css.icomoon_css', $this->dataBadgeIcomoon);
			}
						
			//Badge effects
			if (isset($this->data->badge->effects) && count($this->data->badge->effects) > 0){
			    foreach ($this->data->badge->effects as $effect){
				if ($effect->type == 'display'){
				    $dataEffect = $effect;
				    $dataEffect->selector = '#part-' . $this->data->id . ' .part_badge';
				    if (isset($data->selector_hover))
					$dataEffect->selector_hover = '#part-' . $this->data->id . ':hover .part_badge';
				    switch ($effect->action){
					case 'show' :
					    $this->style[] = NGE::layout('nge.parts.parts.effects.css.effects_display_show_css', $dataEffect);
					    break;
					case 'animate' :
					    $this->style[] = NGE::layout('nge.parts.parts.effects.css.effects_display_animate_css', $dataEffect);
					    break;
					case 'hide' :
					    $this->style[] = NGE::layout('nge.parts.parts.effects.css.effects_display_hide_css', $dataEffect);
					    break;
				    }
				}
			    }
			}
			
			$this->style[] = '#part-' . $this->data->id . ' {position:relative; }';
		}

		//Legend
		if ($this->data->legend->html != '') {

			//Legend CSS
			$dataLegend = $this->data->legend;
			$dataLegend->selector = '#part-' . $this->data->id . '-legend';
			$dataLegend->selector_hover = '#part-' . $this->data->id . ':hover .part_legend';
			$dataLegend->parentselector = '#part-' . $this->data->id;
			$this->style[] = NGE::layout('nge.parts.panels.css.legend_css', $dataLegend);

			//Legend Font CSS
			if ($this->data->legend->font->style == 'custom') {
				$dataLegendFont = $this->data->legend->font;
				$dataLegendFont->selector = '#part-' . $this->data->id . '-legend';
				$dataLegendFont->selector_hover = '#part-' . $this->data->id . ':hover .part_legend';
				$this->style[] = NGE::layout('nge.parts.text.css.font_css', $dataLegendFont);
			}

			//Legend Border
			if ($this->data->legend->border->style != "none") {
				$dataLegendBorder = $this->data->legend->border;
				$dataLegendBorder->selector = '#part-' . $this->data->id . '-legend';
				$dataLegendBorder->selector_hover = '#part-' . $this->data->id . ':hover .part_legend';
				$this->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataLegendBorder);
			}

			//Legend Background CSS
			if ($this->data->legend->background->style != "none") {
				$dataLegendBackground = $this->data->legend->background;
				$dataLegendBackground->selector = '#part-' . $this->data->id . '-legend';
				$dataLegendBackground->selector_hover = '#part-' . $this->data->id . ':hover .part_legend';
				$this->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataLegendBackground);
			}
			
			// Legend show hover 
		}

		//Body Padding
		$dataPadding = $this->data->body->padding;
		$dataPadding->selector = '#part-' . $this->data->id . '-body';
		$this->style[] = NGE::layout('nge.parts.panels.css.padding_css', $dataPadding);

		//Body Font
		if (isset($this->data->body->font) && ($this->data->body->font->style == 'custom')) {
			$dataFont = $this->data->body->font;
			$dataFont->selector = '#part-'.$this->data->id.'-body';
			$this->style[] = NGE::layout('nge.parts.text.css.font_css', $dataFont);
		} 

		//Body effects, used for example for images
		if (isset($this->data->body->effects) && count($this->data->body->effects) > 0){
		    foreach ($this->data->body->effects as $effect){
			if ($effect->type == 'display'){
			    $dataEffect = $effect;
			    $dataEffect->selector = '#part-' . $this->data->id . '-body';
			    $dataEffect->selector_hover = '#part-' . $this->data->id . '-body:hover';

			    switch ($effect->action){
				case 'show' :
				    $this->style[] = NGE::layout('nge.parts.parts.effects.css.effects_display_show_css', $dataEffect);
				    break;
				case 'animate' :
				    $this->style[] = NGE::layout('nge.parts.parts.effects.css.effects_display_animate_css', $dataEffect);
				    break;
				case 'colors' :
				    $this->style[] = NGE::layout('nge.parts.parts.effects.css.effects_display_colors_css', $dataEffect);
				    break;				
				case 'hide' :
				    $this->style[] = NGE::layout('nge.parts.parts.effects.css.effects_display_hide_css', $dataEffect);
				    break;
			    }
			}
		    }
		}
				
		//Main panel border
		if ($this->data->border->style != "none") {
			$this->dataGeneralBorder = $this->data->border;
			$this->dataGeneralBorder->selector = '#part-' . $this->data->id;
			$this->style[] = NGE::layout('nge.parts.panels.css.border_css', $this->dataGeneralBorder);
		}
		//Background
		if ($this->data->background->style != "none") {
			$this->dataPanelBackground = $this->data->background;
			$this->dataPanelBackground->selector = '#part-' . $this->data->id;
			$this->style[] = NGE::layout('nge.parts.panels.css.background_css', $this->dataPanelBackground);
		}
		
		//Shadow
		if ($this->data->shadow->style != 'none') {
			$this->dataShadow = $this->data->shadow;
			$this->dataShadow->selector = '#part-' . $this->data->id;
			$this->dataShadow->background = $this->data->background;
			$this->style[] = NGE::layout('nge.parts.panels.css.shadow_css', $this->dataShadow);
		}
		

		}	//if cache		

		/*** JS *********************************************************/
		//Cache
		if ($this->data->cache->js != ''){
		    $this->script[] = $this->data->cache->js;
		}
		else {		
			if ($this->data->badge->label != '') {
				//Badge CSS
				/*$this->dataBadge = $this->data->badge;
				$this->dataBadge->selector = '#part-' . $this->data->id . ' .part_badge';
				$this->script[] = NGE::layout('nge.parts.panels.js.badge_js', $this->dataBadge);*/
			}	
		}//if cache
		
		
		
		$html[] = '<div ' . implode($attributes) . '>';

		
		//If stored content of the widget is in 1.x version. It not will be editable, Message to ask edit with config
		if (($this->data->rendering->mode == 'edit') && isset($this->data->content->version) && ($this->data->content->version == '1')){
		    $lang = JFactory::getLanguage();	
		    // loading main language file 
		    $app = JFactory::getApplication();		
		    $lang->load('com_nge', JPATH_SITE);
		    //Display in information panel
		    $html[] = NGE::layout('nge.parts.nge.information', 'upgradeforediting');    
		}
		
		
		//Header		
		if (($this->data->header->label != '' || $this->data->header->glyph->name != '')) {
			$this->dataHeader = $this->data;
			$this->dataHeader->selector = '#part-' . $this->data->id . ' .part_header';
			$headerContent = NGE::layout('nge.parts.panels.html.header_html', $this->dataHeader);
		}
		else
			$headerContent= '';

		//Badge
		if ($this->data->badge->label != '')
			$headerContent .= '<div class="part_badge">' . $content_badge . '</div>';
		//Body
		$bodyContent = $this->content;
		$bodyContent = '<div id="part-'.$this->data->id.'-panel" class="part_panel">'. $this->content .'</div>';
		
		//Legend
		if(isset($this->data->legend->html) && ($this->data->legend->html != "")){
                    $legendContent = NGE::layout('nge.parts.panels.html.legend_html', $this->data);
		}else{
                    $legendContent = '';
                }
		

		//Main rendering		
		
		//Top
		if (($headerContent !='') && ($this->data->header->position == 'top')){
		    $html[] .= $headerContent;
		}
		//Legend in top position, except if header is on sides
		if (($legendContent !='') && ($this->data->legend->position == 'top')
		&& !(($headerContent !='') && (in_array($this->data->header->position, array('left', 'right'))))){
		    $html[] .= $legendContent;
		}
		
		//Left or right sides
		if (($headerContent !='') && (in_array($this->data->header->position, array('left', 'right'))) 
		|| ($legendContent !='') && (in_array($this->data->legend->position, array('left', 'right'))) ){
		    $html[] = '<div id = "part-' . $this->data->id . '-outerpaneltable">';
		    
		    //Left		
		    if (($headerContent !='') && ($this->data->header->position == 'left')){
			$html[] .= $headerContent;
		    }
		    if (($legendContent !='') && ($this->data->legend->position == 'left')){
			$html[] .= $legendContent;
		    }
		    
		    //Body
		    //Header outside
		    if (($headerContent !='') && (in_array($this->data->header->position, array('left', 'right')))){
			if (($legendContent !='') && ($this->data->legend->position == 'top')){
			    $html[] = '<div id = "part-' . $this->data->id . '-innerpaneltable">';
			    $html[] .= $legendContent;
			    $html[] .= $bodyContent;
			    $html[] = '</div>';
			}
			else
			if (($legendContent !='') && ($this->data->legend->position == 'bottom')){
			    $html[] = '<div id = "part-' . $this->data->id . '-innerpaneltable">';
			    $html[] .= $bodyContent;
			    $html[] .= $legendContent;			    
			    //
			    $html[] = '</div>';
			}
			else
			    $html[] .= $bodyContent;
		    }
		    else
			$html[] .= $bodyContent;
		    
		    //Right
		    if (($legendContent !='') && ($this->data->legend->position == 'right')){
			$html[] .= $legendContent;
		    }
		    if (($headerContent !='') && ($this->data->header->position == 'right')){
			$html[] .= $headerContent;
		    }
		    
		    $html[] = '</div>';
		}    
		else
		    $html[] .= $bodyContent;
		
		//Bottom
		//Legend in bottom position, except if bottom is on sides
		if (($legendContent !='') && ($this->data->legend->position == 'bottom')
		&& !(($headerContent !='') && (in_array($this->data->header->position, array('left', 'right'))))){
		    $html[] .= $legendContent;
		}
		if (($headerContent !='') && ($this->data->header->position == 'bottom')){
		    $html[] .= $headerContent;
		}
		
		//Writing cache
		/*
		if (($this->data->cache->css == '' && count($this->style) >0) || ($this->data->cache->js == '' && count($this->script) >0)){		
			require_once NGEPATH_HELPERS . '/data/nge/partdriver.php';
			NgeNgePartDriver::storeCache($this->data->id, implode($this->style), implode($this->script));    
		}
	*/
		//Import style CSS & script JS
		/*if (count($this->style) != 0)
			$html[] = '<style>' . implode($this->style) . '</style>';
		if (count($this->script) != 0)
			$html[] = '<script>jQuery(document).ready(function (){' . implode($this->script) . '});</script>';*/
			//$html[] = '<script>' . implode($this->script) . '</script>';
		$html[] = parent::renderScripts();	

		$html[] = '</div>';
//Generate HTML
		return implode($html);
	}

}

