<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

/* This package uses elements direction
/*!
 * Hover.css (http://ianlunn.github.io/Hover/)
 * Version: 2.1.0
 * Author: Ian Lunn @IanLunn
 * Author URL: http://ianlunn.co.uk/
 * Github: https://github.com/IanLunn/Hover

 * Made available under a MIT License:
 * http://www.opensource.org/licenses/mit-license.php

 * Hover.css Copyright Ian Lunn 2014. Generated with Sass.
 */


// No direct access
defined('_JEXEC') or die;

//NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'animate/css/animate.min.css');

$data = $displayData;

if(isset($data->selector_hover) && $data->selector_hover!='')
    $selector_hover = $data->selector_hover;
else 
    $selector_hover = str_replace(',', ':hover,', $data->selector).':hover'; 



if ($data->event == "hover")
    $selector = $selector_hover;
else{
    $selector = $data->selector;
    if ($data->trigger == "viewport")
	$selector .= '.ngeviewport';
}


$selectorDefault = $data->selector;

$keyframeSuffix = str_replace(array('#', '-', ':', ' ', '.'), '', $data->selector);

 switch ($data->name){
     
     case 'move' :
	 echo $selector_hover . ' {    
	  border-color: ' . $data->color . ';
	}';
	 
	echo $data->selector . '{
	  -webkit-transform: perspective(1px) translateZ(0);
	  transform: perspective(1px) translateZ(0);
	  box-shadow: 0 0 1px transparent;
	  -webkit-transition-duration: 0.3s;
	  transition-duration: 0.3s;
	  -webkit-transition-property: transform;
	  transition-property: transform;
	}';
	//echo $data->selector . ':hover, ' . $data->selector . ':focus, ' . $data->selector . ':active {
	echo $selector_hover . ' {';
	switch ($data->direction){
	     case 'left' :
		 echo '    -webkit-transform: translateX(-8px);
			transform: translateX(-8px);';
		 break;
	     case 'right' :
		 echo '    -webkit-transform: translateX(8px);
			transform: translateX(8px);';
		 break;
	     case 'up' :
		echo ' -webkit-transform: translateY(-8px);
			transform: translateY(-8px);';
		 break;
	     case 'down' :
		echo ' -webkit-transform: translateY(8px);
			transform: translateY(8px);';
		 break;	     
	 }
	echo '}';
	 break;
     case 'fade' :
	 $opacity = strval(1 - $data->strength/10);
	echo '@-webkit-keyframes fade' . $keyframeSuffix . ' {0% {opacity: ' . $opacity . ';} to {opacity: 1;}}';
	echo '@keyframes fade' . $keyframeSuffix . ' {0% {opacity: ' . $opacity . ';} to {opacity: 1;}}';		
	echo $selector . '{';
	echo 'opacity : ' . $opacity . ';';
	echo 'animation: fade' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 forwards;';
	echo '-webkit-animation: fade' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 forwards;';
	echo '}';
	break;
     case 'zoom' :
	 $scale = strval(1 - $data->strength*0.07);
	 $translate = strval($data->strength*10);
	 switch ($data->origin){
	    case 'up' : 
		 echo '@-webkit-keyframes fade' . $keyframeSuffix . ' {0% {opacity: 0;-webkit-transform: translate3d(0, -' . $translate . '%, 0) scale3d(' . $scale . ', ' . $scale . ', ' . $scale . ');} to {opacity: 1;-webkit-transform: none;}}';
		echo '@keyframes fade' . $keyframeSuffix . ' {0% {opacity: 0;transform: translate3d(0, -' . $translate . '%, 0) scale3d(' . $scale . ', ' . $scale . ', ' . $scale . ');} to {opacity: 1;transform: none;}}';
		break;
	     case 'down' : 
		 echo '@-webkit-keyframes fade' . $keyframeSuffix . ' {0% {opacity: 0;-webkit-transform: translate3d(0, ' . $translate . '%, 0) scale3d(' . $scale . ', ' . $scale . ', ' . $scale . ');} to {opacity: 1;-webkit-transform: none;}}';
		echo '@keyframes fade' . $keyframeSuffix . ' {0% {opacity: 0;transform: translate3d(0, ' . $translate . '%, 0) scale3d(' . $scale . ', ' . $scale . ', ' . $scale . ');} to {opacity: 1;transform: none;}}';
		break;
	     case 'left' : 
		 echo '@-webkit-keyframes fade' . $keyframeSuffix . ' {0% {opacity: 0;-webkit-transform: translate3d(-' . $translate . '%, 0, 0) scale3d(' . $scale . ', ' . $scale . ', ' . $scale . ');} to {opacity: 1;-webkit-transform: none;}}';
		echo '@keyframes fade' . $keyframeSuffix . ' {0% {opacity: 0;transform: translate3d(-' . $translate . '%, 0, 0) scale3d(' . $scale . ', ' . $scale . ', ' . $scale . ');} to {opacity: 1;transform: none;}}';
		break;
	     case 'right' : 
		 echo '@-webkit-keyframes fade' . $keyframeSuffix . ' {0% {opacity: 0;-webkit-transform: translate3d(' . $translate . '%, 0, 0) scale3d(' . $scale . ', ' . $scale . ', ' . $scale . ');} to {opacity: 1;-webkit-transform: none;}}';
		echo '@keyframes fade' . $keyframeSuffix . ' {0% {opacity: 0;transform: translate3d(' . $translate . '%, 0, 0) scale3d(' . $scale . ', ' . $scale . ', ' . $scale . ');} to {opacity: 1;transform: none;}}';
		break;
	    default :
		echo '@-webkit-keyframes fade' . $keyframeSuffix . ' {0% {opacity: 0;-webkit-transform: scale3d(' . $scale . ', ' . $scale . ', ' . $scale . ');} to {opacity: 1}}';
		echo '@keyframes fade' . $keyframeSuffix . ' {0% {opacity: 0;transform: scale3d(' . $scale . ', ' . $scale . ', ' . $scale . ');} to {opacity: 1}}';
	 }
	echo $selector . '{';
	echo 'opacity : 0;';	
	echo 'animation: fade' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 forwards;';
	echo '-webkit-animation: fade' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 forwards;';
	echo '}';
	break;
    case 'slidexx' :
	 $translate = strval($data->strength*10);
	echo $selector . '{';
	 switch ($data->direction){
	     case 'up' : 
		echo '-webkit-transform:translate(0, ' . $translate . '%);';
		echo 'transform: translate(0, ' . $translate . '%);';		
		break;
	    case 'down' : 
		echo '-webkit-transform:translate(0, -' . $translate . '%);';
		echo 'transform: translate(0, -' . $translate . '%);';				
		break;
	     case 'left' : 
		echo '-webkit-transform:translate(' . $translate . '%, 0);';
		echo 'transform: translate(' . $translate . '%, 0);';				 
		break;
	     default : 
		echo '-webkit-transform:translate(-' . $translate . '%, 0);';
		echo 'transform: translate(-' . $translate . '%, 0);';				 
		break;
	 }
	echo '}';
	 if ($data->delay !=0)
	    echo ' -webkit-animation-delay: ' . $data->delay .'s;
	    animation-delay: ' . $data->delay .'s;';
	 echo '-webkit-transition: all ' . $data->duration .'s;
	  transition: all ' . $data->duration .'s;
	}';
	/*echo $selector . '{';
	echo '-webkit-transform: none;';
	echo 'transform: none;';
	echo '}';*/
	break;
case 'slideXX' :
	 $translate = strval($data->strength*10);
	echo $selectorDefault . '{';
	echo 'transform: translate(0, 0);';
	echo 'transform: translate(0, 0);';
	 /*if ($data->delay !=0)
	    echo ' -webkit-animation-delay: ' . $data->delay .'s;
	    animation-delay: ' . $data->delay .'s;';*/
	 echo '-webkit-transition: all ' . $data->duration .'s ease-in-out;
	  transition: all ' . $data->duration .'s ease-in-out;
	}';
	echo $selectorEffect . '{';
	 switch ($data->direction){
	     case 'up' : 
		echo '-webkit-transform:translate(0, ' . $translate . '%);';
		echo 'transform: translate(0, ' . $translate . '%);';		
		break;
	    case 'down' : 
		echo '-webkit-transform:translate(0, -' . $translate . '%);';
		echo 'transform: translate(0, -' . $translate . '%);';				
		break;
	     case 'left' : 
		echo '-webkit-transform:translate(' . $translate . '%, 0);';
		echo 'transform: translate(' . $translate . '%, 0);';				 
		break;
	     default : 
		echo '-webkit-transform:translate(-' . $translate . '%, 0);';
		echo 'transform: translate(-' . $translate . '%, 0);';				 
		break;
	 }
	echo '}';
	break;    
     case 'slide' :
	 $scale = strval(1 - $data->strength*0.07);
	 $translate = strval($data->strength*10);
	 switch ($data->origin){
	    case 'up' : 
		 echo '@-webkit-keyframes slide' . $keyframeSuffix . ' {0% {opacity: 0;-webkit-transform: translate3d(0, -' . $translate . '%, 0)} to {opacity: 1;-webkit-transform: none;}}';
		echo '@keyframes slide' . $keyframeSuffix . ' {0% {opacity: 0;transform: translate3d(0, -' . $translate . '%, 0)} to {opacity: 1;transform: none;}}';
		break;
	     case 'down' : 
		 echo '@-webkit-keyframes slide' . $keyframeSuffix . ' {0% {opacity: 0;-webkit-transform: translate3d(0, ' . $translate . '%, 0)} to {opacity: 1;-webkit-transform: none;}}';
		echo '@keyframes slide' . $keyframeSuffix . ' {0% {opacity: 0;transform: translate3d(0, ' . $translate . '%, 0)} to {opacity: 1;transform: none;}}';
		break;
	     case 'right' : 
		 echo '@-webkit-keyframes slide' . $keyframeSuffix . ' {0% {opacity: 0;-webkit-transform: translate3d(' . $translate . '%, 0, 0)} to {opacity: 1;-webkit-transform: none;}}';
		echo '@keyframes slide' . $keyframeSuffix . ' {0% {opacity: 0;transform: translate3d(' . $translate . '%, 0, 0)} to {opacity: 1;transform: none;}}';
		break;
	     default : 
		 echo '@-webkit-keyframes slide' . $keyframeSuffix . ' {0% {opacity: 0;-webkit-transform: translate3d(-' . $translate . '%, 0, 0)} to {opacity: 1;-webkit-transform: none;}}';
		echo '@keyframes slide' . $keyframeSuffix . ' {0% {opacity: 0;transform: translate3d(-' . $translate . '%, 0, 0)} to {opacity: 1;transform: none;}}';
		break;
	 }
	echo $selector . '{';
	echo 'opacity: 0;';
	echo 'transform: translate3d(-' . $translate . '%, 0, 0);';
	echo '}';
	echo $selector . '{';
	echo 'animation: slide' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 forwards;';
	echo '-webkit-animation: slide' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 forwards;';
	echo '}';
	break;    
     case 'bounce' :
	$translate1 = strval($data->strength * 10);
	$translate2 = strval($data->strength * 2.5);
	$translate3 = $data->strength;
	$translate4 = strval($data->strength * 0.5);
	 switch ($data->origin){
	    case 'up' : 
		 echo '@-webkit-keyframes bounce' . $keyframeSuffix . ' {0%, 60%, 75%, 90%, to {-webkit-animation-timing-function: cubic-bezier(.215, .61, .355, 1);}
		    0% {opacity: 0;-webkit-transform: translate3d(0, -' . $translate1 . '%, 0);}
		    60% {opacity: 1;-webkit-transform: translate3d(0, ' . $translate2 . 'px, 0);}
		    75% {-webkit-transform: translate3d(0, -' . $translate3 . 'px, 0);}
		    90% {-webkit-transform: translate3d(0, ' . $translate3 . 'px, 0);}
		    to {-webkit-transform: none;}}';
		echo '@keyframes bounce' . $keyframeSuffix . ' {0%, 60%, 75%, 90%, to {animation-timing-function: cubic-bezier(.215, .61, .355, 1);}
		    0% {opacity: 0;transform: translate3d(0, -' . $translate1 . '%, 0);}
		    60% {opacity: 1;transform: translate3d(0, ' . $translate2 . 'px, 0);}
		    75% {transform: translate3d(0, -' . $translate3 . 'px, 0);}
		    90% {transform: translate3d(0, ' . $translate3 . 'px, 0);}
		    to {transform: none;}}';
		break;
	     case 'down' : 
		 echo '@-webkit-keyframes bounce' . $keyframeSuffix . ' {0%, 60%, 75%, 90%, to {-webkit-animation-timing-function: cubic-bezier(.215, .61, .355, 1);}
		    0% {opacity: 0;-webkit-transform: translate3d(0, ' . $translate1 . '%, 0);}
		    60% {opacity: 1;-webkit-transform: translate3d(0, -' . $translate2 . 'px, 0);}
		    75% {-webkit-transform: translate3d(0, ' . $translate3 . 'px, 0);}
		    90% {-webkit-transform: translate3d(0, -' . $translate4 . 'px, 0);}
		    to {-webkit-transform: translateZ(0);}}';
		echo '@keyframes bounce' . $keyframeSuffix . ' {0%, 60%, 75%, 90%, to {animation-timing-function: cubic-bezier(.215, .61, .355, 1);}
		    0% {opacity: 0;transform: translate3d(0, ' . $translate1 . '%, 0);}
		    60% {opacity: 1;transform: translate3d(0, -' . $translate2 . 'px, 0);}
		    75% {transform: translate3d(0, ' . $translate3 . 'px, 0);}
		    90% {transform: translate3d(0, -' . $translate4 . 'px, 0);}
		    to {transform: translateZ(0);}}';
		break;
	     case 'left' : 
		 echo '@-webkit-keyframes bounce' . $keyframeSuffix . ' {0%, 60%, 75%, 90%, to {-webkit-animation-timing-function: cubic-bezier(.215, .61, .355, 1);}
		    0% {opacity: 0;-webkit-transform: translate3d(-' . $translate1 . '%, 0, 0);}
		    60% {opacity: 1;-webkit-transform: translate3d(' . $translate2 . 'px, 0, 0);}
		    75% {-webkit-transform: translate3d(-' . $translate3 . 'px, 0, 0);}
		    90% {-webkit-transform: translate3d(' . $translate4 . 'px, 0, 0);}
		    to {-webkit-transform: none;}}';
		echo '@keyframes bounce' . $keyframeSuffix . ' {0%, 60%, 75%, 90%, to {animation-timing-function: cubic-bezier(.215, .61, .355, 1);}
		    0% {opacity: 0;transform: translate3d(-' . $translate1 . '%, 0, 0);}
		    60% {opacity: 1;transform: translate3d(' . $translate2 . 'px, 0, 0);}
		    75% {transform: translate3d(-' . $translate3 . 'px, 0, 0);}
		    90% {transform: translate3d(' . $translate4 . 'px, 0, 0);}
		    to {transform: none;}}';
		break;
	     case 'right' : 
		 echo '@-webkit-keyframes bounce' . $keyframeSuffix . ' {0%, 60%, 75%, 90%, to {-webkit-animation-timing-function: cubic-bezier(.215, .61, .355, 1);}
		    0% {opacity: 0;-webkit-transform: translate3d(' . $translate1 . '%, 0, 0);}
		    60% {opacity: 1;-webkit-transform: translate3d(-' . $translate2 . 'px, 0, 0);}
		    75% {-webkit-transform: translate3d(' . $translate3 . 'px, 0, 0);}
		    90% {-webkit-transform: translate3d(-' . $translate4 . 'px, 0, 0);}
		    to {-webkit-transform: none;}}';
		echo '@keyframes bounce' . $keyframeSuffix . ' {0%, 60%, 75%, 90%, to {animation-timing-function: cubic-bezier(.215, .61, .355, 1);}
		    0% {opacity: 0;transform: translate3d(' . $translate1 . '%, 0, 0);}
		    60% {opacity: 1;transform: translate3d(-' . $translate2 . 'px, 0, 0);}
		    75% {transform: translate3d(' . $translate3 . 'px, 0, 0);}
		    90% {transform: translate3d(-' . $translate4 . 'px, 0, 0);}
		    to {transform: none;}}';
		break;
	     default : 
		$scale1 = strval(1 - $data->strength * 0.06);
		$scale2 = strval(1 + $data->strength * 0.02);
		$scale3 = strval(1 - $data->strength * 0.02);
		$scale4 = strval(1 + $data->strength * 0.006);
		$scale5 = strval(1 - $data->strength * 0.006);
		 echo '@-webkit-keyframes bounce' . $keyframeSuffix . ' {0%, 20%, 40%, 60%, 80%, to {-webkit-animation-timing-function: cubic-bezier(.215, .61, .355, 1);animation-timing-function: cubic-bezier(.215, .61, .355, 1)}
		    0% {opacity: 0;-webkit-transform: scale3d(' . $scale1 . ', ' . $scale1 . ', ' . $scale1 . ');}
		    20% {-webkit-transform: scale3d(' . $scale2 . ', ' . $scale2 . ', ' . $scale2 . ');}
		    40% {-webkit-transform: scale3d(' . $scale1 . ', ' . $scale3 . ', ' . $scale3 . ');}
		    60% {opacity: 1;-webkit-transform: scale3d(' . $scale4 . ', ' . $scale4 . ', ' . $scale4 . ');}
		    80% {-webkit-transform: scale3d(' . $scale5 . ', ' . $scale5 . ', ' . $scale5 . ');}
		    to {opacity: 1;-webkit-transform: scaleX(1);}}';
		echo '@keyframes bounce' . $keyframeSuffix . ' {0%, 20%, 40%, 60%, 80%, to {animation-timing-function: cubic-bezier(.215, .61, .355, 1);animation-timing-function: cubic-bezier(.215, .61, .355, 1)}
		    0% {opacity: 0;transform: scale3d(' . $scale1 . ', ' . $scale1 . ', ' . $scale1 . ');}
		    20% {transform: scale3d(' . $scale2 . ', ' . $scale2 . ', ' . $scale2 . ');}
		    40% {transform: scale3d(' . $scale3 . ', ' . $scale3 . ', ' . $scale3 . ');}
		    60% {opacity: 1;transform: scale3d(' . $scale4 . ', ' . $scale4 . ', ' . $scale4 . ');}
		    80% {transform: scale3d(' . $scale5 . ', ' . $scale5 . ', ' . $scale5 . ');}
		    to {opacity: 1;transform: scaleX(1);}}';
		break;
	 }
	echo $selector . '{';
	echo 'animation: bounce' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 ;';
	echo '-webkit-animation: bounce' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s;';
	echo '}';
	break;    
     case 'flip' :
	$perspective = strval($data->strength * 10);	
	$deg1 = strval($data->strength * 10);
	$deg2 = strval($data->strength * 10);
	$translate = strval($data->strength * 10);
	$scale = strval($data->strength * 10);
	$rotate1 = strval($data->strength * 10);
	$rotate2 = strval($data->strength * 10);
	$rotate3 = strval($data->strength * 10);
	$rotate4 = strval($data->strength * 10);
	switch ($data->direction){
	     case 'horizontal' : 
		$rotate1 = strval($data->strength * 45);
		$rotate2 = strval($data->strength * 10);
		$rotate3 = strval($data->strength * 5);
		$rotate4 = strval($data->strength * 2.5);
		 echo '@-webkit-keyframes flip' . $keyframeSuffix . ' {0% {-webkit-transform: perspective(400px) rotateY('. $rotate1 . 'deg);opacity: 0}
		    0%,40% {-webkit-animation-timing-function: ease-in}
		    40% {-webkit-transform: perspective(400px) rotateY(-'. $rotate2 . 'deg)}
		    60% {-webkit-transform: perspective(400px) rotateY('. $rotate3 . 'deg);opacity: 1}
		    80% {-webkit-transform: perspective(400px) rotateY(-'. $rotate4 . 'deg)}
		    to {-webkit-transform: perspective(400px)}}';
		echo '@keyframes flip' . $keyframeSuffix . ' {0% {transform: perspective(400px) rotateY('. $rotate1 . 'deg);opacity: 0}
		    0%,40% {animation-timing-function: ease-in}
		    40% {transform: perspective(400px) rotateY(-'. $rotate2 . 'deg)}
		    60% {transform: perspective(400px) rotateY('. $rotate3 . 'deg);opacity: 1}
		    80% {transform: perspective(400px) rotateY(-'. $rotate4 . 'deg)}
		    to {transform: perspective(400px)}}';
		break;
	    case 'vertical' : 
		$rotate1 = strval($data->strength * 45);
		$rotate2 = strval($data->strength * 10);
		$rotate3 = strval($data->strength * 5);
		$rotate4 = strval($data->strength * 2.5);
		 echo '@-webkit-keyframes flip' . $keyframeSuffix . ' {0% {-webkit-transform: perspective(400px) rotateX('. $rotate1 . 'deg);opacity: 0}
		    0%,40% {-webkit-animation-timing-function: ease-in}
		    40% {-webkit-transform: perspective(400px) rotateX(-'. $rotate2 . 'deg)}
		    60% {-webkit-transform: perspective(400px) rotateX('. $rotate3 . 'deg);opacity: 1}
		    80% {-webkit-transform: perspective(400px) rotateX(-'. $rotate4 . 'deg)}
		    to {-webkit-transform: perspective(400px)}}';
		echo '@keyframes flip' . $keyframeSuffix . ' {0% {transform: perspective(400px) rotateX('. $rotate1 . 'deg);opacity: 0}
		    0%,40% {animation-timing-function: ease-in}
		    40% {transform: perspective(400px) rotateX(-'. $rotate2 . 'deg)}
		    60% {transform: perspective(400px) rotateX('. $rotate3 . 'deg);opacity: 1}
		    80% {transform: perspective(400px) rotateX(-'. $rotate4 . 'deg)}
		    to {transform: perspective(400px)}}';
		break;
	 }
	 echo $selector . '{';
	echo 'animation: flip' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 ;';
	echo '-webkit-animation: flip' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s;';
	echo '}';
	break;    
     case 'rotate' :
	 switch ($data->pivot){
	    case 'left' : 
		$translate = $data->strength*10;
		$rotate = $data->strength*24;
		 echo '@-webkit-keyframes rotate' . $keyframeSuffix . ' {0% {opacity: 0;-webkit-transform: translate3d(-' . $translate . '%, 0, 0) rotate(-' . $rotate . 'deg);} to {opacity: 1;-webkit-transform: none;}}';
		echo '@keyframes rotate' . $keyframeSuffix . ' {0% {opacity: 0;transform: translate3d(-' . $translate . '%, 0, 0) rotate(-' . $rotate . 'deg);} to {opacity: 1;transform: none;}}';
		break;	    	 
	     case 'leftdown' : 
		 $rotate = $data->strength*9;
		 /*echo '@-webkit-keyframes rotate' . $keyframeSuffix . ' {0% {transform-origin: left bottom;-webkit-transform: rotate(-' . $rotate . 'deg);opacity: 0}
			0%, to {-webkit-transform-origin: left bottom} to {transform-origin: left bottom;-webkit-transform: none;opacity: 1}}';
		echo '@keyframes rotate' . $keyframeSuffix . ' {0% {transform-origin: left bottom;-transform: rotate(-' . $rotate . 'deg);opacity: 0}
			0%, to {transform-origin: left bottom} to {transform-origin: left bottom;transform: none;opacity: 1}}';*/
		echo '@-webkit-keyframes rotate' . $keyframeSuffix . ' {0% {transform-origin: left bottom;-webkit-transform: rotate(-' . $rotate . 'deg);opacity: 0}
			0%, to {-webkit-transform-origin: left bottom} to {transform-origin: left bottom;-webkit-transform: none;opacity: 1}}';
		echo '@keyframes rotate' . $keyframeSuffix . ' {0% {transform-origin: left bottom;transform: rotate(-' . $rotate . 'deg);opacity: 0}
			0%, to {transform-origin: left bottom} to {transform-origin: left bottom;transform: none;opacity: 1}}';
		break;
	    case 'rightdown' : 
		$rotate = $data->strength*9;
		 echo '@-webkit-keyframes rotate' . $keyframeSuffix . ' {0% {transform-origin: right bottom;-webkit-transform: rotate(' . $rotate . 'deg);opacity: 0}
			0%, to {-webkit-transform-origin: right bottom} to {transform-origin: right bottom;-webkit-transform: none;opacity: 1}}';
		echo '@keyframes rotate' . $keyframeSuffix . ' {0% {transform-origin: right bottom;transform: rotate(' . $rotate . 'deg);opacity: 0}
			0%, to {transform-origin: right bottom} to {transform-origin: right bottom;transform: none;opacity: 1}}';
		break;
	     case 'leftup' : 
		 $rotate = $data->strength*9;
		 echo '@-webkit-keyframes rotate' . $keyframeSuffix . ' {0% {transform-origin: left bottom;-webkit-transform: rotate(' . $rotate . 'deg);opacity: 0}
			0%, to {-webkit-transform-origin: left bottom} to {transform-origin: left bottom;-webkit-transform: none;opacity: 1}}';
		echo '@keyframes rotate' . $keyframeSuffix . ' {0% {transform-origin: left bottom;transform: rotate(' . $rotate . 'deg);opacity: 0}
			0%, to {transform-origin: left bottom} to {transform-origin: left bottom;transform: none;opacity: 1}}';
		break;
	     case 'rightup' :
		 $rotate = $data->strength*18;
		 echo '@-webkit-keyframes rotate' . $keyframeSuffix . ' {0% {transform-origin: right bottom;-webkit-transform: rotate(-' . $rotate . 'deg);opacity: 0}
			0%,to {-webkit-transform-origin: right bottom} to {transform-origin: right bottom;-webkit-transform: none;opacity: 1}}';
		echo '@keyframes rotate' . $keyframeSuffix . ' {0% {transform-origin: right bottom;transform: rotate(-' . $rotate . 'deg);opacity: 0}
			0%,to {transform-origin: right bottom} to {transform-origin: right bottom;transform: none;opacity: 1}}';
		break;
	    default : //revolve 
		$rotate = $data->strength*40;
		echo '@-webkit-keyframes rotate' . $keyframeSuffix . ' {0% {transform-origin: center;-webkit-transform: rotate(-' . $rotate . 'deg);opacity: 0}
			0%, to {-webkit-transform-origin: center} to {transform-origin: center;-webkit-transform: none;opacity: 1}}';
		echo '@keyframes rotate' . $keyframeSuffix . ' {0% {transform-origin: center;transform: rotate(-' . $rotate . 'deg);opacity: 0}
			0%, to {transform-origin: center} to {transform-origin: center;transform: none;opacity: 1}}';
	 }
	echo $selector . '{';
	echo 'opacity: 0;';
	echo 'animation: rotate' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 forwards;';
	echo '-webkit-animation: rotate' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 forwards;';
	echo '}';
    
    case 'fill' :
    case 'bounce' :	
	 break;
 }