<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

/* This package uses elements direction
/*!
 * Hover.css (http://ianlunn.github.io/Hover/)
 * Version: 2.1.0
 * Author: Ian Lunn @IanLunn
 * Author URL: http://ianlunn.co.uk/
 * Github: https://github.com/IanLunn/Hover

 * Made available under a MIT License:
 * http://www.opensource.org/licenses/mit-license.php

 * Hover.css Copyright Ian Lunn 2014. Generated with Sass.
 */


// No direct access
defined('_JEXEC') or die;

//NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'animate/css/animate.min.css');

$data = $displayData;

if(isset($data->selector_hover) && $data->selector_hover!='')
    $selector_hover = $data->selector_hover;
else 
    $selector_hover = str_replace(',', ':hover,', $data->selector).':hover'; 


if ($data->event == "hover")
    $selector = $selector_hover;
else
    $selector = $data->selector;

 switch ($data->name){
     
     case 'move' :
	 echo $selector_hover . ' {    
	  border-color: ' . $data->color . ';
	}';
	 
	echo $data->selector . '{
	  -webkit-transform: perspective(1px) translateZ(0);
	  transform: perspective(1px) translateZ(0);
	  box-shadow: 0 0 1px transparent;
	  -webkit-transition-duration: 0.3s;
	  transition-duration: 0.3s;
	  -webkit-transition-property: transform;
	  transition-property: transform;
	}';
	//echo $data->selector . ':hover, ' . $data->selector . ':focus, ' . $data->selector . ':active {
	echo $selector_hover . ' {';
	switch ($data->direction){
	     case 'left' :
		 echo '    -webkit-transform: translateX(-8px);
			transform: translateX(-8px);';
		 break;
	     case 'right' :
		 echo '    -webkit-transform: translateX(8px);
			transform: translateX(8px);';
		 break;
	     case 'up' :
		echo ' -webkit-transform: translateY(-8px);
			transform: translateY(-8px);';
		 break;
	     case 'down' :
		echo ' -webkit-transform: translateY(8px);
			transform: translateY(8px);';
		 break;	     
	 }
	echo '}';
	 break;
     case 'fade' :
	 $animation = 'fadeOut';
	 switch ($data->direction){
	    case 'left':	$animation .= 'Left';		break;
	    case 'right':	$animation .= 'Right';		break;
	    case 'up':	$animation .= 'Up';		break;
	    case 'down':	$animation .= 'Down';		break;
	 }
	 if (($data->direction != 'none') && ($data->strength == 'large'))
	     $animation .= 'Big';	 
	echo $selector . '{';
	if ($data->delay !=0)
	    echo ' -webkit-animation-delay: ' . $data->delay .'s;
	    animation-delay: ' . $data->delay .'s;';
	echo ' -webkit-animation-duration: ' . $data->duration .'s;
	    animation-duration: ' . $data->duration .'s;
	    -webkit-animation-fill-mode: both;
	    animation-fill-mode: both;
	    -webkit-animation-name: ' . $animation . ';
	    animation-name: ' . $animation . ';';
	echo '}';
	break;    
     case 'zoom' :
	 $animation = 'zoomOut';
	 switch ($data->direction){
	    case 'left':	$animation .= 'Left';		break;
	    case 'right':	$animation .= 'Right';		break;
	    case 'up':	$animation .= 'Up';		break;
	    case 'down':	$animation .= 'Down';		break;
	 }
	echo $selector . '{';
	if ($data->delay !=0)
	    echo ' -webkit-animation-delay: ' . $data->delay .'s;
	    animation-delay: ' . $data->delay .'s;';
	echo ' -webkit-animation-duration: ' . $data->duration .'s;
	    animation-duration: ' . $data->duration .'s;
	    -webkit-animation-fill-mode: both;
	    animation-fill-mode: both;
	    -webkit-animation-name: ' . $animation . ';
	    animation-name: ' . $animation . ';';
	echo '}';
	break;    
     case 'slide' :
	 $animation = 'slideOut';
	 switch ($data->direction){
	    case 'left':	$animation .= 'Left';		break;
	    case 'right':	$animation .= 'Right';		break;
	    case 'up':	$animation .= 'Up';		break;
	    case 'down':	$animation .= 'Down';		break;
	 }
	echo $selector . '{';
	if ($data->delay !=0)
	    echo ' -webkit-animation-delay: ' . $data->delay .'s;
	    animation-delay: ' . $data->delay .'s;';	
	echo ' -webkit-animation-duration: ' . $data->duration .'s;
	    animation-duration: ' . $data->duration .'s;
	    -webkit-animation-fill-mode: both;
	    animation-fill-mode: both;
	    -webkit-animation-name: ' . $animation . ';
	    animation-name: ' . $animation . ';';
	echo '}';
	break;    
     case 'bounce' :
	 $animation = 'bounceOut';
	 switch ($data->direction){
	    case 'left':	$animation .= 'Left';		break;
	    case 'right':	$animation .= 'Right';		break;
	    case 'up':	$animation .= 'Up';		break;
	    case 'down':	$animation .= 'Down';		break;
	 }
	echo $selector . '{';
	if ($data->delay !=0)
	    echo ' -webkit-animation-delay: ' . $data->delay .'s;
	    animation-delay: ' . $data->delay .'s;';
	echo ' -webkit-animation-duration: ' . $data->duration .'s;
	    animation-duration: ' . $data->duration .'s;
	    -webkit-animation-fill-mode: both;
	    animation-fill-mode: both;
	    -webkit-animation-name: ' . $animation . ';
	    animation-name: ' . $animation . ';';
	echo '}';
	break;    
      case 'flip' :
	 $animation = 'flip';
	 switch ($data->direction){
	    case 'horizontal':	$animation .= 'OutY';		break;
	    case 'vertical':	$animation .= 'OutX';		break;
	 }
	echo $selector . '{';
	if ($data->delay !=0)
	    echo ' -webkit-animation-delay: ' . $data->delay .'s;
	    animation-delay: ' . $data->delay .'s;';	
	echo ' -webkit-animation-duration: ' . $data->duration .'s;
	    animation-duration: ' . $data->duration .'s;
	    -webkit-animation-fill-mode: forwards;
	    animation-fill-mode: forwards;
	    -webkit-animation-name: ' . $animation . ';
	    animation-name: ' . $animation . ';';
	echo '}';
	break;    
     case 'rotate' :
	 $animation = 'rotateOut';
	 switch ($data->direction){
	     case 'roll':	$animation = 'RollOut';			break;
	    case 'downleft':	$animation .= 'DownLeft';		break;
	    case 'downright':	$animation .= 'DownRight';		break;
	    case 'upleft':	$animation .= 'UpLeft';		break;
	    case 'upright':	$animation .= 'UpRight';		break;
	 }
	echo $selector . '{';
	if ($data->delay !=0)
	    echo ' -webkit-animation-delay: ' . $data->delay .'s;
	    animation-delay: ' . $data->delay .'s;';	
	echo ' -webkit-animation-duration: ' . $data->duration .'s;
	    animation-duration: ' . $data->duration .'s;
	    -webkit-animation-fill-mode: forwards;
	    animation-fill-mode: forwards;
	    -webkit-animation-name: ' . $animation . ';
	    animation-name: ' . $animation . ';';
	echo '}';
	break;    

    case 'fill' :
    case 'bounce' :	
	 break;
 }
