<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */


// No direct access
defined('_JEXEC') or die;

$data = $displayData;

if(isset($data->selector_hover) && $data->selector_hover!='')
    $selector_hover = $data->selector_hover;
else 
    $selector_hover = str_replace(',', ':hover,', $data->selector).':hover'; 

if ($data->event == "hover")
    $selector = $selector_hover;
else
    $selector = $data->selector;

 switch ($data->name){
     
    case 'zoomin' :
	    echo $data->selector . '{-webkit-transition: 0.4s all ease-int;
	    -o-transition: 0.4s all ease-in;
	    -moz-transition: 0.4s all ease-in;
	    transition: 0.4s all ease-in;}';
	    echo $selector . '{transform: scale(1.25);'
			    . ' }';
	    break;
    case 'grayscale' :
	    if ($data->direction == 'towards'){
		echo $data->selector . ' {filter: grayscale(0%); -webkit-filter: grayscale(0%);}';
		echo $selector . '{filter: gray; filter: grayscale(' . $data->strength*10 . '%);
		-webkit-filter: grayscale(' . $data->strength*10 . '%);
		-webkit-transition: ' . $data->duration .'s all;
		transition: ' . $data->duration .'s all;}';
	    }
	    else {
		echo $data->selector . ' {filter: gray; filter: grayscale(' . $data->strength*10 . '%); -webkit-filter: grayscale(' . $data->strength*10 . '%);}';
		echo $selector . '{filter: grayscale(0%); -webkit-filter: grayscale(0%);
		-webkit-transition: ' . $data->duration .'s all;
		transition: ' . $data->duration .'s all;}';
	    }
	    break;
    case 'sepia' :
	    if ($data->direction == 'towards'){
		echo $data->selector . ' {filter: sepia(0%);-webkitfilter: sepia(0%);}';
		echo $selector . '{filter: sepia(' . $data->strength*10 . '%);
		-webkit-filter: sepia(' . $data->strength*10 . '%);
		-webkit-transition: ' . $data->duration .'s all;
		transition: ' . $data->duration .'s all;}';
	    }
	    else {
		echo $data->selector . ' {filter: sepia(' . $data->strength*10 . '%); -webkit-filter: sepia(' . $data->strength*10 . '%);}';
		echo $selector . '{filter: sepia(0%); -webkit-filter: sepia(0%);
		-webkit-transition: ' . $data->duration .'s all;
		transition: ' . $data->duration .'s all;}';
	    }
	    break;
    case 'darken' :
	    $brightness = strval(100 - $data->strength*10);
	    if ($data->direction == 'towards'){
		echo $data->selector . ' {filter: brightness(100%);}';
		echo $selector . '{filter: brightness(' . $brightness . '%);
		-webkit-filter: brightness(' . $brightness . '%);
		-webkit-transition: ' . $data->duration .'s all;
		transition: ' . $data->duration .'s all;}';
	    }
	    else {
		echo $data->selector . ' {filter: brightness(' . $brightness . '%); -webkit-filter: brightness(' . $brightness . '%);}';
		echo $selector . '{filter: brightness(100%); -webkit-filter: brightness(100%);
		-webkit-transition: ' . $data->duration .'s all;
		transition: ' . $data->duration .'s all;}';
	    }
	    break;
    case 'transparency' :
	    $opacity = strval(1 - $data->strength/10);
	    if ($data->direction == 'towards'){
		echo $data->selector . ' { opacity: 1;}';
		echo $selector . '{opacity:' . $opacity . ';
		-webkit-transition: ' . $data->duration .'s all;
		transition: ' . $data->duration .'s all;}';
	    }
	    else {
		echo $data->selector . ' {opacity : ' . $opacity . ';}';
		echo $selector . '{opacity : 1;
		-webkit-transition: ' . $data->duration .'s all;
		transition: ' . $data->duration .'s all;}';
	    }
	    break;
    case 'blur' :
	    $blur = strval($data->strength*2);
	    if ($data->direction == 'towards'){
		echo $data->selector . ' {filter: blur(0);-webkitfilter: blur(0);}';
		echo $selector . '{filter: blur(' . $blur . 'px);
		-webkit-filter: blur(' . $blur . 'px);
		-webkit-transition: ' . $data->duration .'s all;
		transition: ' . $data->duration .'s all;}';
	    }
	    else {
		echo $data->selector . ' {filter: blur(' . $blur . 'px); -webkit-filter: blur(' . $blur . 'px);}';
		echo $selector . '{filter: blur(0); -webkit-filter: blur(0);
		-webkit-transition: ' . $data->duration .'s all;
		transition: ' . $data->duration .'s all;}';
	    }
	    break;
	
	    echo $data->selector . ' {filter: blur(0); -webkit-filter: blur(0);}';
	    echo $selector . '{filter: blur(5px); -webkit-filter: blur(5px);'
			    . ' -webkit-transition: 0.8s all ease-in;
	    -o-transition: 0.8s all ease-in;
	    -moz-transition: 0.8s all ease-in;
	    transition: 0.8s all ease-in;}';
	    break;
    case 'sharpen' :
	    echo $data->selector . ' {filter: blur(5px); filter: blur(5px); -webkit-filter: blur(5px);}';
	    echo $selector . '{filter: blur(0); -webkit-filter: blur(0);'
			    . ' -webkit-transition: 0.8s all ease-in;
	    -o-transition: 0.8s all ease-in;
	    -moz-transition: 0.8s all ease-in;
	    transition: 0.8s all ease-in;}';
	    break;
    case 'lighten' :
	    echo $data->selector . ' {filter: brightness(30%); -webkit-filter: brightness(30%);}';
	    echo $selector . '{filter: brightness(100%); -webkit-filter:brightness(100%);'
			    . ' -webkit-transition: 0.8s all ease-in;
-o-transition: 0.8s all ease-in;
-moz-transition: 0.8s all ease-in;
transition: 0.8s all ease-in;}';
	    break;
    case 'darkzoom' :
	    echo $data->selector . '{filter: brightness(100%); -webkit-filter: brightness(100%); -webkit-transition: 0.5s all ease-int;
	    -o-transition: 0.5s all ease-in;
	    -moz-transition: 0.5s all ease-in;
	    transition: 0.5s all ease-in;}';
	    echo $selector . '{transform: scale(1.15); filter: brightness(30%); -webkit-filter:brightness(30%)'
			    . ' }';
	    break;
 }

 