<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

/* This package uses elements from

 * Hover.css (http://ianlunn.github.io/Hover/)
 * Author: Ian Lunn @IanLunn
 * Author URL: http://ianlunn.co.uk/
 * Github: https://github.com/IanLunn/Hover
 * Made available under a MIT License:
 * http://www.opensource.org/licenses/mit-license.php
 * Hover.css Copyright Ian Lunn 2014. Generated with Sass.

 * animate.css -http://daneden.me/animate
 * Licensed under the MIT license - http://opensource.org/licenses/MIT
 * Copyright (c) 2016 Daniel Eden
 */

// No direct access
defined('_JEXEC') or die;

$data = $displayData;

if(isset($data->selector_hover) && $data->selector_hover!='')
    $selector_hover = $data->selector_hover;
else 
    $selector_hover = str_replace(',', ':hover,', $data->selector).':hover'; 
 $selector = $data->selector;
if ($data->event == "hover")
    $selector = $selector_hover;
else
    $selector = $data->selector;

$keyframeSuffix = str_replace(array('#', '-', ':', ' ', '.'), '', $data->selector);

 switch ($data->name){
     case 'move' :
	 $translate = strval($data->strength*10);
	 switch ($data->origin){
	    case 'up' : 
		 echo '@-webkit-keyframes slide' . $keyframeSuffix . ' {0% {-webkit-transform: translate(0, -' . $translate . '%)} to {-webkit-transform: none;}}';
		echo '@keyframes slide' . $keyframeSuffix . ' {0% {transform: translate(0, -' . $translate . '%)} to {transform: none;}}';
		break;
	     case 'down' : 
		 echo '@-webkit-keyframes slide' . $keyframeSuffix . ' {0% {-webkit-transform: translate(0, ' . $translate . '%)} to {-webkit-transform: none;}}';
		echo '@keyframes slide' . $keyframeSuffix . ' {0% {transform: translate(0, ' . $translate . '%)} to {transform: none;}}';
		break;
	     case 'right' : 
		 echo '@-webkit-keyframes slide' . $keyframeSuffix . ' {0% {-webkit-transform: translate(' . $translate . '%, 0)} to {-webkit-transform: none;}}';
		echo '@keyframes slide' . $keyframeSuffix . ' {0% {transform: translate(' . $translate . '%, 0)} to {transform: none;}}';
		break;
	     default : 
		 echo '@-webkit-keyframes slide' . $keyframeSuffix . ' {0% {-webkit-transform: translate(-' . $translate . '%, 0)} to {-webkit-transform: none;}}';
		echo '@keyframes slide' . $keyframeSuffix . ' {0% {transform: translate(-' . $translate . '%, 0)} to {transform: none;}}';
		break;
	 }
	echo $selector . '{';
	echo 'transform: translate(-' . $translate . '%, 0);';
	echo 'animation: slide' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 forwards;';
	echo '-webkit-animation: slide' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 forwards;';
	echo '}';
	break;    
     case 'pulse' :
	$scale = strval(1 + $data->strength/20);
	echo '@-webkit-keyframes pulse' . $keyframeSuffix . ' {0% {-webkit-transform: scaleX(1);} 50% {-webkit-transform: scale3d(' . $scale . ', ' . $scale . ', ' . $scale . ');} to {-webkit-transform: scaleX(1);}}';
	echo '@keyframes pulse' . $keyframeSuffix . ' {0% {transform: scaleX(1);} 50% {transform: scale3d(' . $scale . ', ' . $scale . ', ' . $scale . ');} to {transform: scaleX(1);}}';	 	 
	echo $selector . '{';
	echo 'animation: pulse' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 normal both;';
	echo '-webkit-animation: pulse' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 normal both;';
	echo '}';
	break;
     case 'flash' :
	$opacity = strval(1 - $data->strength/10);
	echo '@-webkit-keyframes flash' . $keyframeSuffix . ' {0%, 50%, to {opacity: 1;} 25%, 75% {opacity: ' . $opacity . ';}}';
	echo '@keyframes flash' . $keyframeSuffix . ' {0%, 50%, to {opacity: 1;} 25%, 75% {opacity: ' . $opacity . ';}}';	 
	echo $selector . '{';
	echo 'animation: flash' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 normal both;';
	echo '-webkit-animation: flash' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 normal both;';
	echo '}';
	break;
     case 'shake' :
	$translate = round(5 * $data->strength);
	echo '@-webkit-keyframes shake' . $keyframeSuffix . ' {0%, to {-webkit-transform: translateZ(0);}
	10%,30%,50%,70%,90% {-webkit-transform: translate3d(-' . $translate . 'px, 0, 0);}
	20%,40%,60%,80% {-webkit-transform: translate3d(' . $translate . 'px, 0, 0);}}';
	echo 'keyframes shake' . $keyframeSuffix . ' {0%, to {transform: translateZ(0);}
	10%,30%,50%,70%,90% {transform: translate3d(-' . $translate . 'px, 0, 0);}
	20%,40%,60%,80% {transform: translate3d(' . $translate . 'px, 0, 0);}}';
	echo $selector . '{';
	echo 'animation: shake' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 normal both;';
	echo '-webkit-animation: shake' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 normal both;';
	echo '}';
	break;
     case 'swing' :
	echo '@-webkit-keyframes swing' . $keyframeSuffix . ' {20% {-webkit-transform: rotate(' . round(3 * $data->strength) . 'deg);}
	40% {-webkit-transform: rotate(-' . round(2 * $data->strength) . 'deg);}
	60% {-webkit-transform: rotate(' . round($data->strength) . 'deg);}
	80% {-webkit-transform: rotate(-' . round($data->strength) . 'deg);}
	to {-webkit-transform: rotate(0deg);}}';
	echo 'keyframes swing' . $keyframeSuffix . ' {20% {transform: rotate(' . round(3 * $data->strength) . 'deg);}
	40% {transform: rotate(-' . round(2 * $data->strength) . 'deg);}
	60% {transform: rotate(' . round($data->strength) . 'deg);}
	80% {transform: rotate(-' . round($data->strength) . 'deg);}
	to {transform: rotate(0deg);}}';
	echo $selector . '{';
	echo 'animation: swing' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 normal both;';
	echo '-webkit-animation: swing' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 normal both;';
	echo '}';
	break;
     case 'wobble' :
	$rotate = round(4 * $data->strength);
	echo '@-webkit-keyframes wobble' . $keyframeSuffix . ' {0% {-webkit-transform: none;}
	15% {-webkit-transform: translate3d(-' . round(5 * $data->strength) . '%, 0, 0) rotate(-' . round($data->strength*2) . 'deg);}
	30% {-webkit-transform: translate3d(' . round(4 * $data->strength) . '%, 0, 0) rotate(' . round($data->strength*1.2) . 'deg);}
	45% {-webkit-transform: translate3d(-' . round(3 * $data->strength) . '%, 0, 0) rotate(-' . round($data->strength*1.2) . 'deg);}
	60% {-webkit-transform: translate3d(' . round(2 * $data->strength) . '%, 0, 0) rotate(' . round($data->strength*0.8) . 'deg);}
	75% {-webkit-transform: translate3d(-' . round($data->strength) . '%, 0, 0) rotate(-' . round($data->strength/5) . 'deg);}
	to {-webkit-transform: none;}}';
	echo 'keyframes wobble' . $keyframeSuffix . ' {0% {transform: none;}
	15% {transform: translate3d(-' . round(5 * $data->strength) . '%, 0, 0) rotate(-5deg);}
	30% {transform: translate3d(' . round(4 * $data->strength) . '%, 0, 0) rotate(3deg);}
	45% {transform: translate3d(-' . round(3 * $data->strength) . '%, 0, 0) rotate(-3deg);}
	60% {transform: translate3d(' . round(2 * $data->strength) . '%, 0, 0) rotate(2deg);}
	75% {transform: translate3d(-' . round($data->strength) . '%, 0, 0) rotate(-1deg);}
	to {transform: none;}}';
	echo $selector . '{';
	echo 'animation: wobble' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 normal both;';
	echo '-webkit-animation: wobble' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 normal both;';
	echo '}';
	break;
     case 'grow' :
	 $scale = strval(1 - $data->strength/10);
	//$scale = strval(1 + $data->strength/20);
	echo '@-webkit-keyframes grow' . $keyframeSuffix . ' {0% {-webkit-transform: scale(' . $scale . ');} to {-webkit-transform: scale(1);}}';
	echo '@keyframes grow' . $keyframeSuffix . ' {0% {transform: scale(' . $scale . ');} to {transform: scale(1);}}';
	echo $selector . '{';
	echo 'transform: scale(' . $scale . ');';
	echo 'animation: grow' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 normal forwards;';
	echo '-webkit-animation: grow' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 normal forwards;';
	echo '}';
	break;    
     case 'shrink' :
	 $scale = strval(1 + $data->strength/15);
	//$scale = strval(1 + $data->strength/15);
	echo '@-webkit-keyframes grow' . $keyframeSuffix . ' {0% {-webkit-transform: scale(' . $scale . ');} to {-webkit-transform: scale(1);}}';
	echo '@keyframes grow' . $keyframeSuffix . ' {0% {transform: scale(' . $scale . ');} to {transform: scale(1);}}';
	echo $selector . '{';
	echo 'transform: scale(' . $scale . ');';
	echo 'animation: grow' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 normal forwards;';
	echo '-webkit-animation: grow' . $keyframeSuffix . ' ' . $data->duration .'s ease ' . $data->delay .'s 1 normal forwards;';
	echo '}';
	break;    	
    case 'kenburn' :
	    echo $data->selector . ' {transform: translate(-20px,-20px);}';
	    echo $selector . ':{transform: scale(1.25)  translate(10px,20px);'
			    . ' -webkit-transition: 2.2s all ease-in;
		-o-transition: 0.2s all ease-in;
	    -moz-transition: 0.2s all ease-in;
	    transition: 10.2s all ease-in;}';
	    break;
    case 'kenburnsout' :
	    echo $data->selector . ' {transform: scale(1.25) translate(20px,20px);}';
	    echo $selector . ':{transform: scale(1)  translate(10px,20px);'
			    . ' -webkit-transition: 2.2s all ease-in;
	    -o-transition: 0.2s all ease-in;
	    -moz-transition: 0.2s all ease-in;
	    transition: 10.2s all ease-in;}';
	    break;
    
 }