<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

/* This package uses elements from
/*!
 * Hover.css (http://ianlunn.github.io/Hover/)
 * Version: 2.1.0
 * Author: Ian Lunn @IanLunn
 * Author URL: http://ianlunn.co.uk/
 * Github: https://github.com/IanLunn/Hover

 * Made available under a MIT License:
 * http://www.opensource.org/licenses/mit-license.php

 * Hover.css Copyright Ian Lunn 2014. Generated with Sass.
 */


// No direct access
defined('_JEXEC') or die;

$data = $displayData;
if(isset($data->selector_hover) && $data->selector_hover!='')
    $selector_hover = $data->selector_hover;
else 
    $selector_hover = str_replace(',', ':hover,', $data->selector).':hover'; 

 switch ($data->name){
     
     case 'instant' :
	 //echo $data->selector . ':hover, ' . $data->selector . ':focus, ' . $data->selector . ':active {
	 echo $selector_hover . ' {    
	  border-color: ' . $data->color . ';
	}';
	 break;
     case 'fade' :
	echo $data->selector . '{
	  -webkit-transform: perspective(1px) translateZ(0);
	  transform: perspective(1px) translateZ(0);
	  box-shadow: 0 0 1px transparent;
	  -webkit-transition-duration: 0.3s;
	  transition-duration: 0.3s;
	  -webkit-transition-property: box-shadow;
	  transition-property: box-shadow;
	  box-shadow: inset 0 0 0 4px #e1e1e1, 0 0 1px transparent;
	  /* Hack to improve aliasing on mobile/tablet devices */
	}';
	//echo $data->selector . ':hover, ' . $data->selector . ':focus, ' . $data->selector . ':active {
	    echo $selector_hover . ' {    
	  box-shadow: inset 0 0 0 4px ' . $data->color . ', 0 0 1px transparent;
	  /* Hack to improve aliasing on mobile/tablet devices */
	}';
	    
	 break;    
     case 'fill' :
    case 'bounce' :	
	 echo $data->selector . '{
	  -webkit-transform: perspective(1px) translateZ(0);
	  transform: perspective(1px) translateZ(0);
	  box-shadow: 0 0 1px transparent;
	  position: relative;
	  overflow: hidden;
	}';
	echo $data->selector . ':before{
	  content: "";
	  position: absolute;
	  z-index: -1;
	  background: ' . $data->color . ';
	  height: ' . $data->width . 'px;';

	switch ($data->direction){
	     case 'left' :
		 echo '   left: 100%;
		right: 0;
		bottom: 0;
		-webkit-transition-property: left;
		transition-property: left;';
		 break;
	     case 'right' :
		 echo ' left: 0;
		right: 100%;
		bottom: 0;
		-webkit-transition-property: right;
		transition-property: right;';
		 break;
	     case 'top' :
		echo ' -webkit-transform: scaleY(0);
		transform: scaleY(0);
		-webkit-transform-origin: 50% 100%;
		transform-origin: 50% 100%;';
		 break;
	     case 'bottom' :
		echo ' -webkit-transform: scaleY(0);
		    transform: scaleY(0);
		    -webkit-transform-origin: 50% 0;
		    transform-origin: 50% 0;';
		 break;	     
	 }
		  
	  echo ' -webkit-transition-duration: 0.3s;
	  transition-duration: 0.3s;
	  -webkit-transition-timing-function: ease-out;
	  transition-timing-function: ease-out;
	}';
	//echo $data->selector . ':hover:before, ' . $data->selector . ':focus:before, ' . $data->selector . ':active:before {
	     echo $selector_hover . ':before {';
	  switch ($data->direction){
	     case 'left' :
		 echo 'left: 0;';
		 break;
	     case 'right' :
		 echo 'right: 0;';
		 break;
	     case 'top' :
		echo '';
		 break;
	     case 'bottom' :
		echo '';
		 break;	     
	 }
	  
	echo '}';
	 break;
 }
