<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

/* This package uses elements from
/*!
 * Hover.css (http://ianlunn.github.io/Hover/)
 * Version: 2.1.0
 * Author: Ian Lunn @IanLunn
 * Author URL: http://ianlunn.co.uk/
 * Github: https://github.com/IanLunn/Hover

 * Made available under a MIT License:
 * http://www.opensource.org/licenses/mit-license.php

 * Hover.css Copyright Ian Lunn 2014. Generated with Sass.
 */


// No direct access
defined('_JEXEC') or die;

$data = $displayData;
if(isset($data->selector_hover) && $data->selector_hover!='')
    $selector_hover = $data->selector_hover;
else 
    $selector_hover = str_replace(',', ':hover,', $data->selector).':hover'; 


    require_once(NGEPATH_HELPERS . '/html/css/csshelper.php');
    $opacity = str_replace(',', '.', $data->opacity/100);

if(isset($data->opacity)){
    
	if($data->color2 == '')
	    $data->color2 = $data->color;
	    
	require_once(NGEPATH_HELPERS . '/html/css/csshelper.php');
	$opacity = str_replace(',', '.', $data->opacity/100);
	
	if ($data->color != ''){
	    $colorRGBA = CssHelper::hex2rgb($data->color);
	    if(strpos($data->color,'rgba')===false)
		$data->color = "rgba(".$colorRGBA[0].", ".$colorRGBA[1].", ".$colorRGBA[2].", ".$opacity.")";
	}
	if ($data->color2 != ''){
	    $color2RGBA = CssHelper::hex2rgb($data->color2);	
	    if(strpos($data->color2,'rgba')===false)
		$data->color2 = "rgba(".$color2RGBA[0].", ".$color2RGBA[1].", ".$color2RGBA[2].", ".$opacity.")";
	}
}


//$newProperty = 'background: url("'.NGE::url('root') .$data->image.'");';
//$transitionProperty = 'background';
$newProperty = 'background-color: ' . $data->color . ';';
$transitionProperty = 'background-color';
/*
$newProperty = 'background: -webkit-gradient(
	    linear,
	    right bottom,
	    right top,
	    color-stop(0, '.$data->color2.'),
	    color-stop(1, '.$data->color.')
	    );
	    background: -o-linear-gradient(top, '.$data->color2.' 0%, '.$data->color.' 100%);
	    background: -moz-linear-gradient(top, '.$data->color2.' 0%, '.$data->color.' 100%);
	    background: -webkit-linear-gradient(top, '.$data->color2.' 0%, '.$data->color.' 100%);
	    background: -ms-linear-gradient(top, '.$data->color2.' 0%, '.$data->color.' 100%);
	    background: linear-gradient(to top, '.$data->color2.' 0%, '.$data->color.' 100%);';
*/


 switch ($data->name){
     
     case 'instant' :
	 //echo $data->selector . ':hover, ' . $data->selector . ':focus, ' . $data->selector . ':active {
	 echo $selector_hover . ' {';
	 echo $newProperty;
	echo '}';
	 break;
     case 'fade' :
	echo $data->selector . '{
	  overflow: hidden;
	  -webkit-transition-duration: 0.3s;
	  transition-duration: 0.3s;
	  -webkit-transition-property: ' . $transitionProperty . ';
	  transition-property: ' . $transitionProperty . ';
	}';
	//echo $data->selector . ':hover, ' . $data->selector . ':focus, ' . $data->selector . ':active {
	    echo $selector_hover . ' {';
	    echo $newProperty;
	echo '}';
	 
	 break;    
     case 'fill' :
    case 'bounce' :
	$duration = $data->name == 'bounce' ? '0.5' : '0.3';
	 echo $data->selector . '{
	     position: relative;
	     -webkit-transition-property: color;
	     transition-property: color;
	     -webkit-transition-duration: ' . $duration . 's;
	     transition-duration: ' . $duration . 's;
	   }';
	 echo $data->selector . ':before{
	     content: "";
	     position: absolute;
	     z-index: -1;
	     top: 0;
	     left: 0;
	     right: 0;
	     bottom: 0;';
	 echo $newProperty;
	 switch ($data->direction){
	     case 'left' :
		 echo ' -webkit-transform: scaleX(0);
		    transform: scaleX(0);
		    -webkit-transform-origin: 100% 50%;
		    transform-origin: 100% 50%;';
		 break;
	     case 'right' :
		 echo ' -webkit-transform: scaleX(0);
		    transform: scaleX(0);
		    -webkit-transform-origin: 0 50%;
		    transform-origin: 0 50%;';
		 break;
	     case 'top' :
		echo ' -webkit-transform: scaleY(0);
		transform: scaleY(0);
		-webkit-transform-origin: 50% 100%;
		transform-origin: 50% 100%;';
		 break;
	     case 'bottom' :
		echo ' -webkit-transform: scaleY(0);
		    transform: scaleY(0);
		    -webkit-transform-origin: 50% 0;
		    transform-origin: 50% 0;';
		 break;	     
	 }

	  echo ' -webkit-transition-property: transform;
	     transition-property: transform;
	     -webkit-transition-duration: ' . $duration . 's;
	     transition-duration: ' . $duration . 's;
	     -webkit-transition-timing-function: ease-out;
	     transition-timing-function: ease-out;
	   }';
	 //echo $data->selector . ':hover, ' . $data->selector . ':focus, ' . $data->selector . ':active {
	     echo $selector_hover . ' {    
	     color: white;
	   }';
	 //echo $data->selector . ':hover:before, ' . $data->selector . ':focus:before, ' . $data->selector . ':active:before {
	     echo $selector_hover . ':before {    
	     -webkit-transform: scaleX(1);
	     transform: scaleX(1);';
	 if ($data->name == 'bounce'){
	    echo '-webkit-transition-timing-function: cubic-bezier(0.52, 1.64, 0.37, 0.66);
	    transition-timing-function: cubic-bezier(0.52, 1.64, 0.37, 0.66);';
	 }
	echo '}';

	 break;
 }
