<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

/* This package uses elements from
/*!
 * Hover.css (http://ianlunn.github.io/Hover/)
 * Version: 2.1.0
 * Author: Ian Lunn @IanLunn
 * Author URL: http://ianlunn.co.uk/
 * Github: https://github.com/IanLunn/Hover

 * Made available under a MIT License:
 * http://www.opensource.org/licenses/mit-license.php

 * Hover.css Copyright Ian Lunn 2014. Generated with Sass.
 */


// No direct access
defined('_JEXEC') or die;

$data = $displayData;

 switch ($data->name){
     
     case 'fade' :
	 echo '@keyframes colorIn {
    from { background-color:#fff; }
      to { background-color: ' . $data->color . '; }
}';
	 
	echo $data->selector . '{
	    
	    -webkit-animation: colorIn 3s;
	    animation: colorIn 3s;
	}';
	//echo $data->selector . ':hover, ' . $data->selector . ':focus, ' . $data->selector . ':active {
	 
	 break;    
     case 'fill' :
    case 'bounce' :
	$duration = $data->name == 'bounce' ? '0.5' : '0.3';
	 echo $data->selector . '{
	     -webkit-transform: perspective(1px) translateZ(0);
	     transform: perspective(1px) translateZ(0);
	     box-shadow: 0 0 1px transparent;
	     position: relative;
	     -webkit-transition-property: color;
	     transition-property: color;
	     -webkit-transition-duration: ' . $duration . 's;
	     transition-duration: ' . $duration . 's;
	   }';
	 echo $data->selector . ':before{
	     content: "";
	     position: absolute;
	     z-index: -1;
	     top: 0;
	     left: 0;
	     right: 0;
	     bottom: 0;
	     background: ' . $data->color . ';';

	 switch ($data->direction){
	     case 'left' :
		 echo ' -webkit-transform: scaleX(0);
		    transform: scaleX(0);
		    -webkit-transform-origin: 100% 50%;
		    transform-origin: 100% 50%;';
		 break;
	     case 'right' :
		 echo ' -webkit-transform: scaleX(0);
		    transform: scaleX(0);
		    -webkit-transform-origin: 0 50%;
		    transform-origin: 0 50%;';
		 break;
	     case 'top' :
		echo ' -webkit-transform: scaleY(0);
		transform: scaleY(0);
		-webkit-transform-origin: 50% 100%;
		transform-origin: 50% 100%;';
		 break;
	     case 'bottom' :
		echo ' -webkit-transform: scaleY(0);
		    transform: scaleY(0);
		    -webkit-transform-origin: 50% 0;
		    transform-origin: 50% 0;';
		 break;	     
	 }

	  echo ' -webkit-transition-property: transform;
	     transition-property: transform;
	     -webkit-transition-duration: ' . $duration . 's;
	     transition-duration: ' . $duration . 's;
	     -webkit-transition-timing-function: ease-out;
	     transition-timing-function: ease-out;
	   }';
	 //echo $data->selector . ':hover, ' . $data->selector . ':focus, ' . $data->selector . ':active {
	     echo $data->selector_hover . ' {    
	     color: white;
	   }';
	 //echo $data->selector . ':hover:before, ' . $data->selector . ':focus:before, ' . $data->selector . ':active:before {
	     echo $data->selector_hover . ':before {    
	     -webkit-transform: scaleX(1);
	     transform: scaleX(1);';
	 if ($data->name == 'bounce'){
	    echo '-webkit-transition-timing-function: cubic-bezier(0.52, 1.64, 0.37, 0.66);
	    transition-timing-function: cubic-bezier(0.52, 1.64, 0.37, 0.66);';
	 }
	echo '}';

	 break;
 }
