<?php

/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 * 
 * General styles to be applied to each part
 * 
 */
// no direct access
defined('_JEXEC') or die;

$data = $displayData;

$styles = array();

//Margin
$margin_top = "0";
$margin_right = "0";
$margin_bottom = "0";
$margin_left = "0";

if (isset($data->size->margin->left))
    $margin_left = $data->size->margin->left;
if (isset($data->size->margin->top))
    $margin_top = $data->size->margin->top;
if (isset($data->size->margin->bottom))
    $margin_bottom = $data->size->margin->bottom;
if (isset($data->size->margin->right))
    $margin_right = $data->size->margin->right;

if(isset($data->size->align)){
    switch ($data->size->align) {
        case 'right' :
            if (isset($data->size->display) && ($data->size->display == 'inline')) {
	$styles[] = 'float:right;';
	$styles[] = 'display:inline-block;';		
                if ($margin_left != '0')
                    $styles[] = 'margin-left : ' . $margin_left . ';';
                if ($margin_top != '0')
                    $styles[] = 'margin-top : ' . $margin_top . ';';
                if ($margin_right != '0')
                    $styles[] = 'margin-right : ' . $margin_right . ';';
                if ($margin_bottom != '0')
                    $styles[] = 'margin-bottom : ' . $margin_bottom . ';';
            }else{
                if (isset($data->size->width->mode) && ($data->size->width->mode == 'content')){
                    $styles[] = 'display:table;';
                }else{
                    $styles[] = 'display:block;';
                }
                $styles[] = 'margin:' . $margin_top . ' ' . $margin_right . ' ' . $margin_bottom . ' auto;';
            }
            
            break;
        case 'left' :
            if (isset($data->size->display) && ($data->size->display == 'inline')) {
                //$styles[] = 'float:left;';
	$styles[] = 'display:inline-block;';
                if ($margin_left != '0')
                    $styles[] = 'margin-left : ' . $margin_left . ';';
                if ($margin_top != '0')
                    $styles[] = 'margin-top : ' . $margin_top . ';';
                if ($margin_right != '0')
                    $styles[] = 'margin-right : ' . $margin_right . ';';
                if ($margin_bottom != '0')
                    $styles[] = 'margin-bottom : ' . $margin_bottom . ';';
            }else{
                if (isset($data->size->width->mode) && ($data->size->width->mode == 'content')){
                    $styles[] = 'display:table;';
                }else{
                    $styles[] = 'display:block;';
                }
                $styles[] = 'margin:' . $margin_top . ' auto ' . $margin_bottom . ' ' . $margin_left . ';';
            }
            break;
        case 'center' :
            if (isset($data->size->width->mode) && ($data->size->width->mode == 'content')){
                $styles[] = 'display:table;';
            }else{
                $styles[] = 'display:block;';
            }
            $styles[] = 'margin:' . $margin_top . ' auto ' . $margin_bottom . ' auto;';
            break;
        case 'available' : /* For this to work, we should not specify width */
            $styles[] = 'display:block;';
            $styles[] = 'margin:' . $margin_top . ' ' . $margin_right . ' ' . $margin_bottom . ' ' . $margin_left . ';';
            break;
    }
    
    if($data->size->align !== "available"){
        if (isset($data->size->width->mode) && ($data->size->width->mode == 'content')){
            $styles[] = 'width: auto;';
        }else{ /* Mode fixed or auto */
            $styles[] = 'width: ' . $data->size->width->value . ';';
        }
    }
}

$styles[] = '-webkit-box-sizing: border-box;';
$styles[] = '-moz-box-sizing: border-box;';
$styles[] = 'box-sizing: border-box;';

//Height
if (isset($data->size->height->mode) && ($data->size->height->mode == 'custom')) {
    $styles[] = 'height: ' . $data->size->height->value . ';';
    switch ($data->size->height->overflow){
	case "visible" : 
	    $styles[] = 'overflow : visible;';
	    break;
	case "hidden" : 
	    $styles[] = 'overflow : hidden;';
	    break;
	default : //scrollbar
	    $styles[] = 'overflow : auto;';
    }
}

if (count($styles) > 0) {
    echo '#part-' . $data->id . ' {';
    echo implode($styles);
    echo ' }';
}

//Scrollbar ************************************************************************
if (($data->size->height->overflow == 'scrollbar') && ($data->scrollbar->style != 'default') && ($data->scrollbar->background->style != 'default')){
	//$data->scrollbar->background->selector = $data->selector . ' .nicescroll-rails';
	$data->scrollbar->background->selector = '.nicescroll-rails';
	echo NGE::layout('nge.parts.panels.css.background_css', $data->scrollbar->background);	
}

//Part display effects ****************************************************************
if (isset($data->effects) && count($data->effects) > 0){
    foreach ($data->effects as $effect){
	if ($effect->type == 'display'){
	    $dataEffect = $effect;
	    $dataEffect->selector = $data->selector;
	    switch ($effect->action){
		case 'show' :
		    echo NGE::layout('nge.parts.parts.effects.css.effects_display_show_css', $dataEffect);
		    break;
		case 'animate' :
		    echo NGE::layout('nge.parts.parts.effects.css.effects_display_animate_css', $dataEffect);
		    break;
		case 'hide' :
		    echo NGE::layout('nge.parts.parts.effects.css.effects_display_hide_css', $dataEffect);
		    break;
		}
	}
    }
}
