<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

require_once(NGEPATH_LAYOUTS . '/parts/parts/html/panel.php');
/***** INSTANTIATION VARIABLES *****/
$data = $displayData;

$part = new LayoutPanel($data);


/***** CONTENT *****/
$items = 	array();
$bodyHasHeaderContent = false;
$bodyHasCaptionContent = false;
$bodyHasLegendContent = false;
$hasGlyph = false;

if ($data->content->source == 'joomla.article'){
        
	require_once (NGEPATH_HELPERS . '/data/joomla/articlesdriver.php');
	$params = array();
	$params['category'] =	$data->content->joomla_article->category;
	//$params['author'] =		$data->content->joomla_article->author;
	$params['featured'] =		$data->content->joomla_article->featured;
	$params['tags'] =		$data->content->joomla_article->tags;
	$params['ordering'] =		$data->content->joomla_article->ordering;
	$params['count'] =		$data->content->joomla_article->count;	
	//print_r($params);
	$articlesList = NgeArticlesDriver::load($params);

	for ($i = 0; $i < count($articlesList); $i++) {
		//Add article except if it is already current article (avoid infinite loop)

		$item = new stdClass();
		$item->source = $data->content->source;
		$item->tab = new stdClass();
		$item->tab->label = $articlesList[$i]->title;
		$item->tab->glyph = new stdClass();
		$item->tab->glyph->name = '';
		$item->body = '';
		//$item->legend = '';
		//$item->caption = '';
		$item->editable = false;
		$item->disabled = $articlesList[$i]->active; //If equals current article : not displayed to avoid infinite recursive loop
		$item->active = (($i == 0) && ($item->disabled == false)); //First tab active, except if disabled
		$item->active = (($i == 1) && ($items[0]->disabled == true));//If first tab is current article, active tab will be second tab		
		
		switch($data->content->joomla_article->renderer->style){
			case 'intro' :
				//Header
				//if ($data->content->joomla_article->renderer->intro->header->title->display == 1){
					$item->tab->label = $articlesList[$i]->title;
					$bodyHasHeaderContent = true;
				//}
				//Body
				//if (($data->content->joomla_article->renderer->intro->image->image->display == 1) && (isset($articlesList[$i]->images->image_intro) && ($articlesList[$i]->images->image_intro != ''))){					
				//	if ($data->content->joomla_article->renderer->intro->image->link == 1)
					
						if (isset($articlesList[$i]->images->image_intro) && $articlesList[$i]->images->image_intro != '')
						    $item->body =  '<div><a href="' . $articlesList[$i]->link . '"><img src="' . NGE::url('root') . $articlesList[$i]->images->image_intro . '"/></a></div>';
						else			
						    $item->body = '<a href="' . $articlesList[$i]->link . '">' . strip_tags ($articlesList[$i]->introtext) . '</a>';						    
				//	else
				//		$item->body =  '<div><img src="' . NGE::url('root') . $articlesList[$i]->images->image_intro . '"/></div>';
				//}
				//else
				//	$item->body =  '';
				
				//Caption
				/*if ($data->content->joomla_article->renderer->intro->caption->title->display == 1)
					$item->caption .= $articlesList[$i]->title;
				if ($data->content->joomla_article->renderer->intro->caption->author->display == 1)
					$item->caption .= $articlesList[$i]->author;
				if ($data->content->joomla_article->renderer->intro->caption->date->display == 1)
					$item->caption .= $articlesList[$i]->date;
				if ($data->content->joomla_article->renderer->intro->caption->content->display == 1)
					$item->caption .= $articlesList[$i]->introtext;
				if ($item->caption != '')
					$bodyHasCaptionContent = true;
				*/
				//Legend
				//if ($data->content->joomla_article->renderer->intro->legend->title->display == 1)
		//			$item->legend .= $articlesList[$i]->title;
				/*if ($data->content->joomla_article->renderer->intro->legend->author->display == 1)
					$item->legend .= $articlesList[$i]->author;
				if ($data->content->joomla_article->renderer->intro->legend->date->display == 1)
					$item->legend .= $articlesList[$i]->date;
				if ($data->content->joomla_article->renderer->intro->legend->content->display == 1){
					if ($data->content->joomla_article->renderer->intro->legend->content->size != 0)*/
						//$item->legend .= substr(strip_tags ($articlesList[$i]->introtext), 0, $data->content->joomla_article->renderer->intro->legend->content->size);
						
						
						if (isset($articlesList[$i]->images->image_intro) && $articlesList[$i]->images->image_intro != '')
						    $item->legend .= strip_tags ($articlesList[$i]->introtext);
						
						
					/*else
						$item->legend .= $articlesList[$i]->introtext;
				}*/
				if ($item->legend != '')
					$bodyHasLegendContent = true;
				break;
			case 'full' :
				    $item->header->label = $articlesList[$i]->title;
				    $bodyHasHeaderContent = true;
				    $item->body = $articlesList[$i]->full;			    
				break;
		}
		
		if ($item->disabled != 1){ // Dont display current article (infinite recursive loop)
			//display in thumbnails mode (title, body, legend)
			$dataThumbnail = $data->body	; //General body properties
			$dataThumbnail->renderingMode = $data->rendering->mode;
			$dataThumbnail->content = $item;
			//Detect stored content in 1.x version. It not will be editable
			$dataThumbnail->version = $data->content->version;
			//$dataThumbnail->class =  implode("", $classThumbnail);
			$dataThumbnail->itemCount = $i;
			$dataThumbnail->id = $data->id;
	
			//$dataThumbnail->selector = '#part-' . $data->id . ' .body-header';
			$item->body = NGE::layout('nge.parts.panels.html.thumbnail_html', $dataThumbnail);
		}
		else
			$item->body = '';
		
		$items[] = $item;
		
	}
	
}
else //Custom images
if ($data->content->source == 'images') {
	$class_img = '';	
	for ($i = 0; $i < count($data->content->images->items); $i++) {
		$item = new stdClass();
		
		$item->source = 'image';
		$item->header = new stdClass();
		$item->header->label = '';
		$item->header->glyph = new stdClass();
		$item->header->glyph->name = '';
		$item->legend = '';
		$item->caption = '';
				
		if ($data->content->images->items[$i]->header->label != ''){
			$item->header->label = $data->content->images->items[$i]->header->label;
			$thumbnailsHaveHeaderContent = true;
		}

		if ($data->content->images->items[$i]->header->glyph->name != ''){
			$item->header->glyph = $data->content->images->items[$i]->header->glyph->name; //object
			$thumbnailsHaveHeaderContent = true;
		}
		
		
		if ($data->content->images->items[$i]->legend){
			$item->legend = $data->content->images->items[$i]->legend;
			$thumbnailsHaveLegendContent = true;
		}	

		/*
		//Body panel
		if ($data->content->images->items[$i]->legend != '') {
			$item->body = '<div><img u="image" class="' . $class_img . '" src="' . NGE::url('root') . $data->content->images->items[$i]->image . '" /><div>' . $data->content->images->items[$i]->legend . '</div></div>';
		} else {
			$item->body = '<div><img u="image" class="' . $class_img . '" src="' . NGE::url('root') . $data->content->images->items[$i]->image . '" />'
					. '</div>';
		}
*/


		//Content
		switch ($data->content->images->items[$i]->source){
		case 'video' :
		    $dataVideo = $data->content->images->items[$i]->video;
		    $dataVideo->id = $data->id;
		    $dataVideo->rendering = $data->rendering;
		    $item->body = NGE::layout('nge.parts.media.html.video_html', $dataVideo);
		    break;
		default:
		
		$dataImages = $data->thumbnails->images;
		$class_img = NGE::layout('nge.parts.images.css.image_class', $dataImages);
		
		$imageContent = '	<div class="content_img">';
		$imageContent .= '	      <div>';
		if (isset($data->content->images->items[$i]->caption) && $data->content->images->items[$i]->caption != '') {
			$thumbnailsHaveCaptionContent	= true;
			$item->caption = $data->content->images->items[$i]->caption;
			$imageContent .= ' 	<div class="image_caption">';
			//$imageContent .= ' 		<div class="transparent"></div>';
			if ($data->rendering->mode == 'edit')
				$imageContent .= '			<div id="' . $part->data->id . '-caption" class="caption_value ngecontenteditableinline"  data-type="ngeeditor" data-property="caption.html">' . $data->content->images->items[$i]->caption . '</div>';
			else
				$imageContent .= '			<div class="caption_value" >' . $data->content->images->items[$i]->caption->html . '</div>';
			$imageContent .= ' 	</div>';
		}
		if ($data->rendering->mode == 'edit') {
			$xeditable_class = ' ngecontenteditable';
			$attributes = ' title="Image" data-type="image" data-property="image"';
		} else {
			$xeditable_class = '';
			$attributes = '';
		}
		$attributes .= ' style="width:100%;"'; 

		$imageContent .= '	          <img class="url_image' . $xeditable_class . $class_img . '"' . $attributes . ' src="' . NGE::url('root') . $data->content->images->items[$i]->image . '"/>';
//		if (isset($data->image_hover) && ($data->image_hover != '')) {
//			$imageContent .= '	      <img class="url_image_hover' . $classPopover . '" src="' . NGE::url('root') . $data->image_hover . '"/>';
//		}
		$imageContent .= '	      </div>';
		$imageContent .= '	</div>';

		//Legend
		if (isset($data->content->images->items[$i]->caption) && $data->content->images->items[$i]->caption != '') {
			
		}
		
		//Rendering
		$item->body = $imageContent;

		}
		
		//Hover panel
		$item->caption = '';
		$items[] = $item;
		
	}
	
	//Url link
	for ($i = 0; $i < count($items); $i++) {
		if (isset($data->content->images->items[$i]->link->type)) {
			switch ($data->content->images->items[$i]->link->type) {
				case 'url' :
					$items[$i]->link = $data->content->images->items[$i]->link->url;
					break;
				case 'document' :
					$items[$i]->link = NGE::url('root') .$data->content->images->items[$i]->link->document;
					break;
				case 'image' :
					$items[$i]->link = NGE::url('root') .$data->content->images->items[$i]->link->image;
					break;
				case 'article' :
					$items[$i]->link = NGE::url('root') . 'index.php?option=com_content&view=article&id=' . $data->content->images->items[$i]->link->article;
					break;
				case 'menu' :
					require_once (NGEPATH_HELPERS . '/data/joomla/menudriver.php');
					$menu = NgeJoomlaMenuDriver::loadItem($data->content->images->items[$i]->link->menu);
					if (isset($menu)){
					    $link = $menu->route;
					    $items[$i]->link = NGE::url('root').'index.php/'.$link;        			    
					}
					else{
					    $items[$i]->link = NGE::url('root').'index.php';        
					    NGE::message('Warning : part '.$data->id.' menu item unknown', 'warning');
					}	
					break;
				case 'javascript' :
					$items[$i]->link = $data->content->images->items[$i]->link->javascript;
					break;
				case 'submit' :
					$items[$i]->link = 'jQuery( "form:first" ).submit();'; //TODO pouvoir indiquer un nom de formulaire
					break;
				default :
					$items[$i]->link = "";
			}

			//link on thumbnails if not already in cache
			if ($data->cache->css == '' || $data->cache->js == ''){
				if ($items[$i]->link != "") {
					$dataLink = new stdClass();
					$dataLink->selector = '#part-' . $data->id . ' div.thumbnail-container.thumbnail-container-' . $i;
					$dataLink->url = $items[$i]->link;
					$dataLink->type = $data->content->images->items[$i]->link->type;
					$dataLink->target = $data->content->images->items[$i]->link->target;
					$part->script[] = NGE::layout('nge.parts.panels.js.button_js', $dataLink);
					$part->style[] = '#part-' . $data->id . ' div.thumbnail-container.thumbnail-container-' . $i . '{
						cursor: pointer;
					}';
				}
			}
		}
	}
}
else
if ($data->content->source == 'custom') {	
    //Custom content : input
	for ($i=0;$i<count($data->content->items);$i++){

		$item = new stdClass();
		$item->tab = new stdClass();
		
		//shortcuts for tab content
		//shortcut label content (html)
		if (isset($data->content->items[$i]->label) && $data->content->items[$i]->label != ''){
			$data->content->items[$i]->tab->source = 'html';
			$data->content->items[$i]->tab->html = $data->content->items[$i]->label; 
		}
		//shortcut image content (image)
		if (isset($data->content->items[$i]->image) && $data->content->items[$i]->image != ''){
			$data->content->items[$i]->tab->source = 'image';
			$data->content->items[$i]->tab->image = $data->content->items[$i]->image; 
		}
		//shortcut glyph content
		if (isset($data->content->items[$i]->glyph) && $data->content->items[$i]->glyph != ''){
			$data->content->items[$i]->tab->glyph->name = $data->content->items[$i]->glyph; 
		}
				
		//Tabs
		switch ($data->content->items[$i]->tab->source){
			case 'html' :			    
				$item->tab->label = $data->content->items[$i]->tab->html;
				break;
			case 'image' :
				$item->tab->label = '<img src="'.$data->content->items[$i]->tab->image.'" />';
				break;
			case 'url' :
				require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
				$item->tab->label = UrlDriver::getContents($data->content->items[$i]->tab->url);
				break;
			case 'query' :
				require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
				$items->label = NgeDatabaseDriver::loadSingle($data->content->items[$i]->tab->query);
				break;
			default :
				$item->tab->label = '';
		}		

		//Glyph 
		$item->tab->glyph = $data->content->items[$i]->tab->glyph; //object
		
		//Body panel
		$item->editable = true;
		$item->editableClass = '';
		$item->editableAttributes = '';
		$item->source = $data->content->items[$i]->body->source; //For element inine editing
		
		switch ($data->content->items[$i]->body->source){
			case 'html' :
				$item->body = $data->content->items[$i]->body->html;
				//$item->editableTitle = 'Text';
				$item->editableClass = ' ngeinlineeditable ngeinlineeditor';
				//$item->editableType = 'ngeeditor'; 
				//$item->editableProperty = 'htmls.'.$i;
				//$item->editableAttributes = 'data-nge = \'{"title": "Text", "type": "editor", "source":"content:htmls.'.$i.'"}\'';
				$item->editableAttributes = 'data-nge = \'{"title": "Text", "type": "editor", "source":"content:content.items.'.$i.'.html"}\'';
				break;
			case 'url' :	
				require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
				$item->body = UrlDriver::getContents($data->content->items[$i]->body->url);
				//$item->editableTitle = 'Url';
				$item->editableClass = ' ngeinlineeditable';
				//$item->editableType = 'url'; 
				//$item->editableProperty = 'urls.'.$i;
				$item->editableAttributes = 'data-nge = \'{"title": "Url", "type": "joomla.url", "source":"content:urls.'.$i.'"}\'';
				break;
			case 'query' :
				require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
				$item->body = NgeDatabaseDriver::loadSingle($data->content->items[$i]->body->query);
				//$item->editableTitle = 'Query';
				$item->editableClass = ' ngeinlineeditable';
				//$item->editableType = 'query'; 
				//$item->editableProperty = 'querys.'.$i;
				$item->editableAttributes = 'data-nge = \'{"title": "Query", "type": "joomla.query", "source":"content:querys.'.$i.'"}\'';
				break;
			case 'joomla.article' :
				require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
				$article = NgeJoomlaArticleDriver::load($data->content->items[$i]->body->joomla_article);
				$item->body = $article->introtext;
				//$item->editableTitle = 'Article';
				$item->editableClass = ' ngeelement ngeinlineeditable';
				//$item->editableAttributes = ' data-nge = \'{"title": "Article", "type": "article", "source":"glyph.namexxxxxxxxxx"}\'';
				//$item->editableType = 'article'; 
				//$item->editableProperty = 'articles.'.$i;
				$item->editableAttributes = 'data-nge = \'{"title": "Article", "type": "joomla.article", "source":"content:content.items.'.$i.'.article"}\'';
				break;
			case 'joomla.module' :
				require_once (NGEPATH_HELPERS . '/data/joomla/moduledriver.php');
				$item->body = NgeJoomlaModuleDriver::load($data->content->items[$i]->body->joomla_module);
				//$item->editableTitle = 'Module';
				$item->editableClass = ' ngeelement ngeinlineeditable';
				//$item->editableType = 'module'; 
				//$item->editableProperty = 'modules.'.$i;
				$item->editableAttributes = 'data-nge = \'{"title": "Module", "type": "joomla.module", "source":"content:content.items.'.$i.'.article"}\'';
				break;
			default :
				$item->body = '';	
				//$item->editableTitle = '';
				$item->editableClass = '';
				//$item->editableType = ''; 
				//$item->editableProperty = '';
				$item->editableAttributes = '';
		}
		
		$items[] = $item;
	}
}
else{
    //Loading plugin contents
    $dataSourceFilename = NGEPATH_CONTENTS . '/source/' . str_replace('.', '/', $data->content->source) . '/content.php';
    if (file_exists($dataSourceFilename)){			
	require_once $dataSourceFilename;
	$className = 'Nge' . implode('', array_map('ucfirst', explode('.', $data->content->source))) . 'Content';
	$source = str_replace('.', '/', $data->content->source);
	//WARNING : $data contains properties from the config screen. 
	//All content properties are not known because they can come from external content plugins
	//So we transmit unchanged all these properties as parameter of the loadList method (params)
	$items = $className::getTabsData($data);
	//$items = $className::loadBodyList($data->content->$source);
    }
}

$classPane = array();
$classPane[] = isset($data->body->transition->style) && $data->body->transition->style == 'fadeIn' ? ' fade in' : '';
if (($data->body->height->mode == "maxheight") && ($data->rendering->mode != 'fastview')) {
	NgeContenthelper::addScript(NGEURL_MEDIA . 'jquery-match-height/jquery.matchHeight-min.js');
	$part->script[] = '
		    onChangePartContent'.$data->id.' = function(){
			    jQuery("#part-'.$data->id.' .tab-content").children().matchHeight(false);
		    };
		    onChangePartContent'.$data->id.'();';	
}

// ******** Tabs *************************************
//Tabs CSS

/*
$part->style[] = '#part-'.$data->id.' .nav-tabs>li>a{
	padding : '.$data->tabs->items->padding->default.'px;
	padding-top : '.$data->tabs->items->padding->top.'px;
	padding-right : '.$data->tabs->items->padding->right.'px;
	padding-bottom : '.$data->tabs->items->padding->bottom.'px;
	padding-left : '.$data->tabs->items->padding->left.'px;
}';
*/

//Path libraries css
//NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'animate/css/animate.min.css');

/**** JS ************************************************************************/
if ($data->cache->js == ''){	
	$part->script[] = NGE::layout('nge.parts.panels.js.tabs_js', $data);

}
/**** CSS ***********************************************************************/

//Cache
if ($data->cache->css == ''){

	//General & tabs CSS/JS
	$data->selector = '#part-'.$data->id;
	$part->style[] = NGE::layout('nge.parts.panels.css.tabs_css', $data);

	//tab buttons
	if($data->tabs->items->style == 'custom'){
		//Items display
		$dataItems = $data->tabs->items;
		$dataItems->selector = '#part-'.$data->id.' ul.nav';
		$dataItems->count = count($items);
		$dataItems->orientation =  in_array($data->tabs->position , array('left','right'))? 'vertical' : 'horizontal';;
		$part->style[] = NGE::layout('nge.parts.panels.css.tabitems_css', $dataItems);
		
		// Font CSS
		if (isset($data->tabs->items->font->style) && ($data->tabs->items->font->style == 'custom')){
		    $dataFont = $data->tabs->items->font;
		    $dataFont->selector = '#part-'.$data->id.' .nav-tabs>li >a';;
		    $part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataFont);
		    $dataFont->selector = '#part-'.$data->id;
		    $part->style[] = $dataFont->selector." ul>li.active>a,".$dataFont->selector." .nav-tabs>li.active>a:hover,".$dataFont->selector." .nav-tabs>li.active>a:focus {
		    color: ".$data->tabs->items->font->color_active.";
			    }";
		}
				
		//Border
		if ($data->tabs->items->border->style != "default") {
		    $dataBorder = $data->tabs->items->border;
		    $dataBorder->selector = '#part-'.$data->id.' .nav-tabs>li>a';
		    $part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataBorder);
		}
		
		if ($data->tabs->items->background->style != "default") {
		    $dataBackground = $data->tabs->items->background;
		    $dataBackground->selector = '#part-'.$data->id.' .nav-tabs>li>a';
		    $part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataBackground);
			
		}
		//Shadow
		if($data->tabs->items->shadow->style != 'none'){
		    $dataShadow = $data->tabs->items->shadow;
		    $dataShadow->selector = '#part-'.$data->id.' .nav-tabs>li';;
		    $part->style[] = NGE::layout('nge.parts.panels.css.shadow_css', $dataShadow);
		}
		
	}


	// ******** Body *************************************
	//Body
	    $dataPadding = $data->body->padding;
	    $dataPadding->selector = '#part-'.$data->id.' .tab-pane';
	    $part->style[] = NGE::layout('nge.parts.panels.css.padding_css', $dataPadding);
	
	//Body Font
	if (isset($data->body->font) && ($data->body->font->style == 'custom')) {
		$dataFont = $data->body->font;
		$dataFont->selector = '#part-'.$data->id.' .tab-pane';
		$part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataFont);
	} 

	//Body Border
	if ($data->body->border->style != "none"){
		$dataBorder = $data->body->border;
		$dataBorder->selector = '#part-'.$data->id.' .tab-pane';
		$part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataBorder);
	}

	//Body Background
	if ($data->body->background->style != "none"){
		$dataBackground = $data->body->background;
		$dataBackground->selector = '#part-'.$data->id.' .tab-pane';
		$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataBackground);
	}

	//body Shadow 
	if ($data->body->shadow->style != "none") {
		$dataShadow = $data->body->shadow;
		$dataShadow->selector = '#part-' . $data->id . ' .tab-pane';
		$part->style [] = NGE::layout ( 'nge.parts.panels.css.shadow_css', $dataShadow);
	}

	//Body headers
	if ($bodyHasHeaderContent == true) {
		//Header CSS
		$dataHeader = $data->body->header;
		$dataHeader->selector = '#part-' . $data->id . ' .thumbnail-header';
		$part->style[] = NGE::layout('nge.parts.panels.css.header_css', $dataHeader);

		//Header Font CSS
		$dataHeaderFont = $data->body->header->font;
		$dataHeaderFont->selector = '#part-' . $data->id . ' .thumbnail-header';
		$part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataHeaderFont);
		
		//Header Icomoon CSS
		$dataHeaderIcomoon = $data->body->header->glyph;
		$dataHeaderIcomoon->selector = '#part-' . $data->id . ' .thumbnail-header .icomoon';
		$dataHeaderIcomoon->selector_hover = '#part-' . $data->id;
		$part->style[] = NGE::layout('nge.parts.panels.css.icomoon_css', $dataHeaderIcomoon);

		//Header Border
		if ($data->body->header->border->style != "none") {
			$dataHeaderBorder = $data->body->header->border;
			$dataHeaderBorder->selector = '#part-' . $data->id . ' .thumbnail-header';
			$part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataHeaderBorder);
		}

		//Header Background CSS
		$dataHeaderBackground = $data->body->header->background;
		$dataHeaderBackground->selector = '#part-' . $data->id . ' .thumbnail-header';
		$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataHeaderBackground);

	}

	//Body legends
	//Legend CSS
	if ($bodyHasLegendContent == true){

		$dataLegend = $data->body->legend;
		$dataLegend->selector = '#part-'.$data->id.' .thumbnail-legend';
		$part->style[] = NGE::layout('nge.parts.panels.css.legend_css', $dataLegend);
		//Font
		if ($data->body->legend->font->style == 'custom') {
			$dataLegendFont = $data->body->legend->font;
			$dataLegendFont->selector = '#part-' . $data->id . ' .thumbnail-legend';
			$part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataLegendFont);
		}
		//Border
		if ($data->body->legend->border->style != "none") {
			$dataLegendBorder = $data->body->legend->border;
			$dataLegendBorder->selector = '#part-' . $data->id . ' .thumbnail-legend';
			$part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataLegendBorder);
		}

		//background
		if ($data->body->legend->background->style != "none") {
			$dataLegendBackground = $data->body->legend->background;
			$dataLegendBackground->selector = '#part-' . $data->id . ' .thumbnail-legend';
			$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataLegendBackground);
		}	

	}

	//body captions
	//CAPTION Css
 	if($bodyHasCaptionContent == true){
	 	/*Caption options and display*/
	 	$dataCaption = $data->body->caption;
	 	$dataCaption->selector = '#part-'.$data->id.' .thumbnail-body-caption';
		$dataCaption->selector_hover = '#part-'.$data->id.':hover .nge-slider-captions';

		$part->style[] = NGE::layout('nge.parts.images.css.caption_css', $dataCaption);
		
		//Font
		if ($data->body->caption->font->style == 'custom') {
			$this->dataCaptionFont = $data->body->caption->font;
			$this->dataCaptionFont->selector = '#part-' . $data->id . ' .thumbnail-body-caption div';
			$part->style[] = NGE::layout('nge.parts.text.css.font_css', $this->dataCaptionFont);
		}
		
		//Caption Border
		if ($data->body->caption->border->style != "none") {
			$dataCaptionBorder = $data->body->caption->border;
			$dataCaptionBorder->selector = '#part-' . $data->id .  ' .thumbnail-body-caption div';
			$part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataCaptionBorder);
		}
		
		//Caption background
		if ($data->body->caption->background->style != "none") {
			$dataCaptionBackground = $data->body->caption->background;
			$dataCaptionBackground->selector = '#part-' . $data->id . ' .thumbnail-body-caption div';
			$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataCaptionBackground);
		}
 	}
}//if cache

$tabsOutput = array();
$tabsTheme = (($data->tabs->items->style == 'pills') || ($data->tabs->items->style == 'flat')) ? 'nav-tabs nav-pills' : 'nav-tabs';
//Sortable if custom content and edit mode
if ($data->rendering->mode == 'edit'){
    if (isset($data->content->source) && ($data->content->source == 'custom' || $data->content->source == 'joomla.articles')){
	$dataNge = 'data-nge=\'{"itemsmode": "content_' . str_replace('.', '_', $data->content->source) . '", "itemstype": "tabs"}\'';
    }
    else $dataNge = ''; //TODO images?
    $tabsOutput[] = '<ul id="part-' . $data->id . '-tabs" class="nav ngeaddableitems ngeitemsortable ngeitemsremovable ' . $tabsTheme.'" data-toggle="tab-hover" ' . $dataNge . '>';
}
else
    $tabsOutput[] = '<ul id="part-' . $data->id . '-tabs" class="nav ' . $tabsTheme . '" data-toggle="tab-hover">';
    
$font_css = isset($data->font->style) && $data->font->style == 'class' ? $data->font->class : '';

if ($data->start->mode == 'random')
    $randomMax = rand(0, count($items)-1);

for ($i=0;$i<count($items); $i++){
		/*
	if (isset($items[$i]->glyph)) {		
		if ($data->tabs->items->glyph->position == 'right')
			$contentTab = $items[$i]->label . ' '.$items[$i]->glyph;
		else
			$contentTab = $items[$i]->glyph .' '. $items[$i]->label;
	}
	else
		$contentTab = $items[$i]->label;
*/
	//$attributesLabel = (isset($data->content->source) && $data->content->source == 'custom') && ($data->rendering->mode == 'edit') ? ' title="Tab" class="ngeinlineeditable ngeinlinetext" data-nge = \'{"title": "Text", "type": "text", "source":"content:labels.'.$i.'"}\' ' : '';
	$attributesLabel = (isset($data->content->source) && $data->content->source == 'custom') && $data->rendering->mode == 'edit' ? ' title="Tab" class="ngeinlineeditable ngeinlinetext" data-nge = \'{"title": "Text", "type": "text", "source":"content:content.items.'.$i.'.label"}\' ' : '';

	if(isset($items[$i]->tab->glyph->name) && $items[$i]->tab->glyph->name != '') {

	    if($data->rendering->mode == 'edit'){
		    $glyphEditableClass = ' ngeinlineeditable ngeinlineglyph';
		    $glyph_name = (isset($items[$i]->tab->glyph->name) && $items[$i]->tab->glyph->name != '') ? $items[$i]->tab->glyph->name : '';
		    $glyphEditableAttributes = ' data-nge = \'{"title": "Glyph", "type": "glyph", "source":"content:glyph_names.'.$i.'", "name":"'.$glyph_name.'"}\' ';
	    }else{
		    $glyphEditableClass = '';
		    $glyphEditableAttributes = '';
	    }

	    $hasGlyph = true;

	    if ($data->tabs->items->style == 'custom'){
		switch ($data->tabs->items->glyph->position){
			case 'top':
				//$glyphBackgroundSize = $data->tabs->items->glyph->size + 20;
				$label = '<span '.$attributesLabel.'>'.$items[$i]->tab->label .'</span>';
				$glyphtop =  '<span class="icomoon '.$items[$i]->tab->glyph->name.$glyphEditableClass.'"'.$glyphEditableAttributes.'></span>';			
				//$glyphtop =  '<span style="border:transparent;line-height: 0px;padding-top: 0px;padding-bottom: 0px;background-color:#ffffff;display:inline-block;border-radius:50%;width:'.$glyphBackgroundSize.'px;min-height:'.$glyphBackgroundSize.'px">'.$glyphtop.'</span>';			
				$contentTab = $glyphtop . '<br/>' . $label;
				break;
			case 'bottom':
				$label = '<span '.$attributesLabel.'>'.$items[$i]->tab->label .'</span>';
				$glyphbottom =  '<span class="icomoon '.$items[$i]->tab->glyph->name.$glyphEditableClass.'"'.$glyphEditableAttributes.'></span><br/>';			
				$contentTab = $label . '<br/>' . $glyphbottom;
				break;
			case 'right':
				$label = '<span style="display:table-cell"><span '.$attributesLabel.'>'.$items[$i]->tab->label .'</span></span>';
				$glyphright = '<span class="icomoon '.$items[$i]->tab->glyph->name.$glyphEditableClass.'"'.$glyphEditableAttributes.' style="display:table-cell; vertical-align:middle; padding-left:8px"></span>';
				$contentTab = $label . $glyphright;
				break;
			default :
				$label = '<span style="display:table-cell"><span '.$attributesLabel.'>'.$items[$i]->tab->label .'</span></span>';
				$glyphleft = '<span class="icomoon '.$items[$i]->tab->glyph->name.$glyphEditableClass.'"'.$glyphEditableAttributes.' style="display:table-cell; vertical-align:middle; padding-right:8px"></span>';			
				$contentTab = $glyphleft . $label;
		}	
	    }
	    else {
		$label = '<span style="display:table-cell"><span '.$attributesLabel.'>'.$items[$i]->tab->label .'</span></span>';
		$glyphleft = '<span class="icomoon '.$items[$i]->tab->glyph->name . $glyphEditableClass.'"'.$glyphEditableAttributes.' style="display:table-cell; vertical-align:middle; padding-right:8px"></span>';
		$contentTab = $glyphleft . $label;		
	    }
	}
	else
		$contentTab = '<span '.$attributesLabel.'>'.$items[$i]->tab->label  .'</span>';	
	
	//Active tab
	switch ($data->start->mode){
	    case 'random' :
		$max = rand(0, count($items)-1);
		$items[$i]->active = (isset($items[$i]->active) && ($items[$i]->active == true)) ? $items[$i]->active : $i==$randomMax;
		break;
	    case 'none' :
		$items[$i]->active = false; 
		break;
	    case 'custom' :
		$items[$i]->active = (isset($items[$i]->active) && ($items[$i]->active == true)) ? $items[$i]->active : $i==($data->start->index-1); //active if already defined, if not : first tab
		break;
	    default : //first
		$items[$i]->active = (isset($items[$i]->active) && ($items[$i]->active == true)) ? $items[$i]->active : $i==0; //active if already defined, if not : first tab
	}
	$items[$i]->disabled = isset($items[$i]->disabled) ? $items[$i]->disabled : false; //diabled if content is current article, if not never disable

	$state = $items[$i]->active ? ' active' : '';
	$state .= $items[$i]->disabled ? ' disabled' : ''; 
	$toggle = $items[$i]->disabled ? '' : ' data-toggle="tab"';
		
    $attributesTabEditable = (isset($data->content->items[$i]->tab->source) && $data->content->items[$i]->tab->source == 'html') && $data->rendering->mode == 'edit' ? ' title="Tab" class="ngecontenteditableinline" data-type="inline" data-property="labels.'.$i.'"' : '';

	$tabsOutput[] = '<li class="ngelayout-part-content'.$state.'">
                        <a href="#tab-'.$data->id.'-'.$i.'" class="'.$font_css.'"'.$toggle.'>
                            <span'.$attributesTabEditable.' >'.$contentTab.'
                            </span>
                        </a>
                    </li>';
}

//Live editing

//$tabsOutput[] = '<li class="tabadd contentaddable" style="cursor:pointer;"><span id="part-'.$data->id.'-add" title="Add tab">+</span></li>';
if ($data->rendering->mode == 'edit')
    $tabsOutput[] = '<li class="ngeaddableitem" style="display:none;"><a><span class="ngeinlineaddable ngeaddablecustomcontent" title="Add a new tab">+</span></a><li>';
/*
$part->script[]="
 jQuery('#part-".$data->id."-add').click(function(){ 

                this.popover({
                html:true,
                title:this.html(),
                content:'Loading'
            }).popover('show');   
            jQuery.ajax({
                url: 'http://localhost/ngeNB/index.php?option=com_nge&view=config&caller=layout&mode=create&tmpl=component&template=system&plname=panels.tabs&layout=addcontent',
                cache: false,
                success: function(data) {
                     var popover = this.data('popover');
                     popover.options.content = data;    
                     this.popover('show');
                }
            });

        });	
";	
*/	

    if ($hasGlyph == true)
	NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'icomoon/icomoon-nge.css');

    if($data->tabs->items->style == 'custom'){
	//Icomoon CSS
	if (($hasGlyph == true) && (isset($data->tabs->items->glyph))){

		$dataTabsGlyph = $data->tabs->items->glyph;
		$dataTabsGlyph->id = $data->id;
		//$dataHeaderIcomoon->position = "unknown";
		//$dataHeaderIcomoon->color_hover = null; //Because is already define above
		$dataTabsGlyph->selector = '#part-'.$data->id.' span.icomoon';
		$dataTabsGlyph->selector_hover = '#part-'.$data->id.' li:hover .icomoon';
		$dataTabsGlyph->selector_active = '#part-'.$data->id.' .nav-tabs>li.active .icomoon';		
		$part->style[] = NGE::layout('nge.parts.panels.css.icomoon_css', $dataTabsGlyph);
	}		
    }

//$html[] = '<a id="newtab" href="#" class="btn" data-toggle="popover" data-position="bottom" data-content="Vivamus sagittis lacus vel augue laoreet rutrum faucibus." title="" data-original-title="Popover on bottom">Popover on bottom</a>';
//$part->script[] = "jQuery('#newtab').popover('show');";

$popover_content = array();
/*$popover_content[] = '<ul class="thumbnails ngetabthumbnails">';
$popover_content[] = '<li class="thumb"><a href="javascript:alert(\'oo\');">Html</a></li>';
$popover_content[] = '<li>Image</li>';
$popover_content[] = '<li>Article</li>';
$popover_content[] = '<li>Part</li>';
$popover_content[] = '<li>Module</li>';
$popover_content[] = '</ul>';
*/
$popover_content[] = '<iframe id="tabadd_iframe" frameborder="0" scrolling="yes" height="220" width="800"';
//$popover_content[] = 'src="index.php?option=com_nge&view=config&caller=layout&mode=create&tmpl=component&template=system&plname=panels.panel&layout=wizard&form=addcontent&pk='.$data->id.'">';
$popover_content[] = 'src="index.php?option=com_nge&view=config&caller=front&mode=edit&layout=addcontent&form=addcontent&tmpl=component&template=system&pk='.$data->id.'">';
$popover_content[] = '</iframe>';


/*
$popover_content = implode($popover_content);
	$dataPopover = new stdClass();
	$dataPopover->id = 'ididi';
	$dataPopover->position = 'bottom';
	$dataPopover->width_mode = 'custom';
	$dataPopover->width = '800';
	$dataPopover->selector =  'part-'.$data->id.'-add';
	$part-style[] = NGE::layout('nge.parts.text.css.popover_css', $dataPopover);
	$part->script[] = NGE::layout('nge.parts.text.js.popover_js', $dataPopover);
	//$html[] = '<span id="part-'.$data->id.'-add"> <span class="trigger">Add</span>';
	$html[] = '<div id="part-'.$data->id.'-add-popover-title" style="display:none;visibility:hidden"><div>Add tab</div></div>';
	$html[] = '<div id="part-'.$data->id.'-add-popover-content" style="display:none;visibility:hidden">'.$popover_content.'</div>';
	$html[] = '</span>';
$part-style[] = '.ngetabthumbnails >li{
     border: 1px solid #ddd;
     padding-top:35px;
	-webkit-border-radius: 4px;
	-moz-border-radius: 4px;
	border-radius: 4px;
	-webkit-box-shadow: 0 1px 3px rgba(0,0,0,0.055);
	-moz-box-shadow: 0 1px 3px rgba(0,0,0,0.055);
	box-shadow: 0 1px 3px rgba(0,0,0,0.055);
	-webkit-transition: all .2s ease-in-out;
	-moz-transition: all .2s ease-in-out;
	-o-transition: all .2s ease-in-out;
	transition: all .2s ease-in-out;
	width:120px;
	height:85px;
	text-align: center;
	position:relative;
}

.ngetabthumbnails >li:hover{
	background-color: #EEE;
	cursor:pointer;
               border: 1px solid #71889D;
}

.ngetabthumbnails >li >a{
    margin-top:35px;
}
';
*/

/**** JS *************************************************************************/

//Cache
if ($data->cache->css == ''){

	$part->script[] = "jQuery('#tabadd_iframe').on('load', function () {
	     /*       $('#loader1').hide();*/
		});";


	$part->script[] ="jQuery('.ngetabthumbnails >li >a').click(function(e) {
	 /*   jQuery('#part-".$data->id."-add').popover('hide'); */
	});";
}

/*
$part->script[]="
    jQuery(function() {
            jQuery.ajax({
                url: 'index.php?option=com_nge&view=config&caller=layout&mode=create&tmpl=component&template=system&plname=panels.panel&layout=wizard&format=raw',                
                success: function(htmlresult) {
                     jQuery('#part-".$data->id."-add-popover-content').html(htmlresult);
                }
            });
    });
        
";	
*/	



$tabsOutput[] = '</ul>';

$contentOutput = array();
$contentOutput[] = '<div class="tab-content">';

if ($data->rendering->mode != 'fastview')
    $nbItems = count($items);
else
    $nbItems = 1; //In fastview, rendering only first tab
for ($i=0;$i <$nbItems; $i++){
	$items[$i]->active = isset($items[$i]->active) ? $items[$i]->active : $i==0; //active if already defined, if not : first tab
	$items[$i]->disabled = isset($items[$i]->disabled) ? $items[$i]->disabled : false; //diabled if content is current article, if not never disable
	$active = $items[$i]->active ? ' active' : '';
	
	//if(isset($data->rendering->mode) && ($data->rendering->mode == 'edit') &&  (isset($data->content->source) && $data->content->source == 'custom')){
	if($data->rendering->mode == 'edit' && (isset($items[$i]->editable)) && ($items[$i]->editable == true)){
	    $contentOutput[] = '<div class="tab-pane '.$items[$i]->editableClass.' '.implode(' ',$classPane).$active.'" id="tab-'.$data->id.'-'.$i.'" ' . $items[$i]->editableAttributes . ' >';
	}else{
		$contentOutput[] = '<div class="tab-pane '.implode(' ',$classPane).$active.'" id="tab-'.$data->id.'-'.$i.'">';
	}
	
 //	$contentOutput[] = $items[$i]->editableAttributes ;
 	$contentOutput[] = $items[$i]->body;
 	$contentOutput[] = '</div>';
 }	
$contentOutput[] = '</div>';

//Attributes
$classTabs = array();
$classTabs[] = 'tabbable ngelayout-multiple ';
$classTabs[] = isset($data->tabs->position) && $data->tabs->position == 'left' ? 		'tabs-left' : '';
$classTabs[] = isset($data->tabs->position) && $data->tabs->position == 'right' ? 		'tabs-right' : '';
$classTabs[] = isset($data->tabs->position) && $data->tabs->position == 'below' ? 		'tabs-below' : '';

if (isset($data->tabs->position) && $data->tabs->position == 'below') {
	$part->content = '<div id="part-' . $data->id . '-body" class="'.implode($classTabs).'">';
	$part->content .= implode($contentOutput);	
	$part->content .= implode($tabsOutput);	
	$part->content .= '</div>';	
}
else {
	$part->content = '<div class="'.implode($classTabs).'">';
	$part->content .= implode($tabsOutput);
	$part->content .= implode($contentOutput);
	$part->content .= '</div>';	
}

echo $part->render();

if ($data->rendering->mode == 'preview'){
	$class= array();
	//$class[] = NgeBootstrapTag::_( 'hidden-xs' ) : '';
	$class= NgeBootstrapTag::_( 'hidden-sm' );
	$class .= ' '.NgeBootstrapTag::_( 'hidden-md' );
	$class .= ' '.NgeBootstrapTag::_( 'hidden-lg' );
	echo '<div class="'.$class.'"><i>Warning : due to the small screen width, current preview is adjusted to smartphone device display. To see rendering on others devices, enlarge preview panel, or choose a device above.</i></div>';
}

//NGE::loadHelpersScript('editor/layout/part/editor.part_sortable.js');