<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

require_once(NGEPATH_LAYOUTS . '/parts/parts/html/panel.php');
/***** INSTANTIATION VARIABLES *****/
$data = 			$displayData;

$part = new LayoutPanel($data);

//CONTENTS
$items = array();
$slidesCaption = array();

$thumbnailsHaveHeaderContent = false;
$thumbnailsHaveHoverContent = false;
$thumbnailsHaveCaptionContent = false;
$thumbnailsHaveLegendContent = false;

$i=0;

/* * *** CONTENT **** */
if ($data->content->source == 'joomla.article'){
        
	require_once (NGEPATH_HELPERS . '/data/joomla/articlesdriver.php');
	$params = array();
	$params['category'] =	$data->content->joomla_article->category;
	//$params['author'] =		$data->content->joomla_article->author;
	$params['featured'] =		$data->content->joomla_article->featured;
	$params['tags'] =		$data->content->joomla_article->tags;
	$params['ordering'] =		$data->content->joomla_article->ordering;
	$params['count'] =		$data->content->joomla_article->count;	
	//print_r($params);
	$articlesList = NgeArticlesDriver::load($params);
	
	for ($i = 0; $i < count($articlesList); $i++) {
		//Add article except if it is already current article (avoid infinite loop)

		$item = new stdClass();
		$item->title = $articlesList[$i]->title;
		$item->header = new stdClass();
		$item->header->label = '';
		$item->header->glyph = new stdClass();
		$item->header->glyph->name = '';
		$item->body = '';
		$item->legend = '';
		$item->caption = '';
		$item->editable = false;
		$item->disabled = $articlesList[$i]->active; //If equals current article : not displayed to avoid infinite recursive loop
		$item->active = (($i == 0) && ($item->disabled == false)); //First tab active, except if disabled
		$item->active = (($i == 1) && ($items[0]->disabled == true));//If first tab is current article, active tab will be second tab		

		switch($data->content->joomla_article->renderer->style){
			case 'intro' :
				//Header
				//if ($data->content->joomla_article->renderer->intro->header->title->display == 1){
					$item->header->label = $articlesList[$i]->title;
					$bodyHasHeaderContent = true;
				//}
				//Body
				//if (($data->content->joomla_article->renderer->intro->image->image->display == 1) && (isset($articlesList[$i]->images->image_intro) && ($articlesList[$i]->images->image_intro != ''))){					
				//	if ($data->content->joomla_article->renderer->intro->image->link == 1)
					
						if (isset($articlesList[$i]->images->image_intro) && $articlesList[$i]->images->image_intro != '')
						    $item->body =  '<div class="ngearticle"><a href="' . $articlesList[$i]->link . '"><img src="' . NGE::url('root') . $articlesList[$i]->images->image_intro . '"/></a></div>';
						else {
						    //Find any image, keep first one
						    $img = '';
						    $posImg = strpos($articlesList[$i]->introtext, '<img');
						    if ($posImg !== false) {
							$posEndImg = strpos(substr($articlesList[$i]->introtext, $posImg), '>');
							$img = substr($articlesList[$i]->introtext, $posImg, $posEndImg+1);
						    }
						    $text = substr(strip_tags ($articlesList[$i]->introtext), 0, 200);
						    $item->body = '<a class="ngearticle" href="' . $articlesList[$i]->link . '">' . $img . $text . '</a>';						    
						}

				//	else
				//		$item->body =  '<div><img src="' . NGE::url('root') . $articlesList[$i]->images->image_intro . '"/></div>';
				//}
				//else
				//	$item->body =  '';
				
				//Caption
				/*if ($data->content->joomla_article->renderer->intro->caption->title->display == 1)
					$item->caption .= $articlesList[$i]->title;
				if ($data->content->joomla_article->renderer->intro->caption->author->display == 1)
					$item->caption .= $articlesList[$i]->author;
				if ($data->content->joomla_article->renderer->intro->caption->date->display == 1)
					$item->caption .= $articlesList[$i]->date;
				if ($data->content->joomla_article->renderer->intro->caption->content->display == 1)
					$item->caption .= $articlesList[$i]->introtext;
				if ($item->caption != '')
					$bodyHasCaptionContent = true;
				*/
				//Legend
				//if ($data->content->joomla_article->renderer->intro->legend->title->display == 1)
		//			$item->legend .= $articlesList[$i]->title;
				/*if ($data->content->joomla_article->renderer->intro->legend->author->display == 1)
					$item->legend .= $articlesList[$i]->author;
				if ($data->content->joomla_article->renderer->intro->legend->date->display == 1)
					$item->legend .= $articlesList[$i]->date;
				if ($data->content->joomla_article->renderer->intro->legend->content->display == 1){
					if ($data->content->joomla_article->renderer->intro->legend->content->size != 0)*/
						//$item->legend .= substr(strip_tags ($articlesList[$i]->introtext), 0, $data->content->joomla_article->renderer->intro->legend->content->size);
						
						if (isset($articlesList[$i]->images->image_intro) && $articlesList[$i]->images->image_intro != '')
						    $item->legend = substr(strip_tags ($articlesList[$i]->introtext), 0, 200);						
						
						
					/*else
						$item->legend .= $articlesList[$i]->introtext;
				}*/
				if ($item->legend != '')
					$bodyHasLegendContent = true;
				break;
			case 'full' :
				break;
		}
				
		if ($item->disabled != 1){ // Dont display current article (infinite recursive loop)
			//display in thumbnails mode (title, body, legend)
			$dataThumbnail = $data->slides;
			$dataThumbnail->renderingMode = $data->rendering->mode;
			$dataThumbnail->content = $item;
			//Detect stored content in 1.x version. It not will be editable
			$dataThumbnail->version = $data->content->version;
			//$dataThumbnail->class =  implode("", $classThumbnail);
			$dataThumbnail->itemCount = $i;
			$dataThumbnail->id = $data->id;
	
			//$dataThumbnail->selector = '#part-' . $data->id . ' .body-header';
			$item->body = NGE::layout('nge.parts.panels.html.thumbnail_html', $dataThumbnail);
		}
		else
			$item->body = '';
		
		$items[] = $item;
		
	}
}
else
if ($data->content->source == 'custom') {		
	$countItems = count($data->content->items);
	for ($i = 0; $i <$countItems; $i++) {
		$item = new stdClass(); //item content for each thumbnail
		
		//Header
		$item->header = new stdClass();
		$item->header->label = '';
		$item->header->glyph = new stdClass();
		$item->header->glyph->name = '';

		if (($data->content->items[$i]->header->label != '') || ($data->content->items[$i]->header->glyph->name != '')){
			$item->header->label = $data->content->items[$i]->header->label;
			$item->header->glyph->name = $data->content->items[$i]->header->glyph->name;
			$thumbnailsHaveHeaderContent = true;
		}	
		
		//Legend
		if ($data->content->items[$i]->legend != ''){		
		    $item->legend = $data->content->items[$i]->legend;		
		    $thumbnailsHaveLegendContent = true;
		}    
		else
		    $item->legend = '';		    
		
		//Source
		$item->source = $data->content->items[$i]->body->source;

		//Body panel
		switch ($data->content->items[$i]->body->source) {
			case 'url' :
				require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
				$item->body = UrlDriver::getContents($data->content->items[$i]->body->url);
				break;
			case 'query' :
				require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
				$item->body = NgeDatabaseDriver::loadSingle($data->content->items[$i]->body->query);
				break;
			case 'article' :
				require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
				$article = NgeJoomlaArticleDriver::load($data->content->items[$i]->body->joomla_article);
				$item->body = $article->introtext;
				break;
			case 'module' :
				require_once (NGEPATH_HELPERS . '/data/joomla/moduledriver.php');
				$item->body = NgeJoomlaModuleDriver::load($data->content->items[$i]->body->joomla_module);
				break;
/*			case 'image' : 
				$dataImages = $data->slides->images;
				$class_img = NGE::layout('nge.parts.images.css.image_class', $dataImages);
				$dataImages->selector = '#part-'.$data->id . ' img';
				$part->style[] = NGE::layout('nge.parts.images.css.image_css', $dataImages);
				$imageSrc = $data->content->items[$i]->body->image != "" ? $data->content->items[$i]->body->image : "components/com_nge/assets/images/default_bigthumb_purple.png";
				$item->body = '<img class="' . $class_img . '" src="' . NGEURL_ROOT . $imageSrc . '" />';
			    break;
			case 'video' : 
				    $dataVideo = new stdClass();				    
				    $dataVideo->content = $data->content->items[$i]->body->video;
				    $dataVideo->rendering = $data->rendering;
				    $item->body = NGE::layout('nge.parts.media.html.video_html', $dataVideo);
		
			//Caption
			if (isset($data->content->items[$i]->caption) && $data->content->items[$i]->caption != '') {
				$thumbnailsHaveCaptionContent = true;
				$item->caption = $data->content->items[$i]->caption;
			}else{
				$item->caption = '';
			}*/
			case 'image' : 
				//$item = $data->content->items[$i];
			    	$dataImages = $data->slides->images;
				$class_img = NGE::layout('nge.parts.images.css.image_class', $dataImages);

				$imageContent = '	<div class="content_img">';
				if (isset($data->content->items[$i]->caption) && $data->content->items[$i]->caption->html != '') {
					$thumbnailsHaveCaptionContent	= true;
					$item->caption = $data->content->items[$i]->caption->html;
					$imageContent .= ' 	<div class="image_caption">';
					//$imageContent .= ' 		<div class="transparent"></div>';
					if ($data->rendering->mode == 'edit')
						$imageContent .= '<div id="' . $part->data->id . '-caption" class="caption_value ngecontenteditableinline"  data-type="ngeeditor" data-property="caption.html">' . $data->content->items[$i]->caption->html . '</div>';
					else
						$imageContent .= '<div class="caption_value" >' . $data->content->items[$i]->caption->html . '</div>';
					$imageContent .= ' 	</div>';
				}
				if ($data->rendering->mode == 'edit') {
					$xeditable_class = ' ngecontenteditable';
					$attributes = ' title="Image" data-type="image" data-property="image"';
				} else {
					$xeditable_class = '';
					$attributes = '';
				}
				$attributes .= ' style="width:100%;"'; 
				if ($data->content->items[$i]->body->image != '')
				    $imageUrl = NGEURL_ROOT . $data->content->items[$i]->body->image;
				else
				    $imageUrl = NGEURL_ROOT . "components/com_nge/assets/images/default_bigthumb_purple.png";
				
				$imageContent .= '	          <img class="url_image' . $xeditable_class . $class_img . '"' . $attributes . ' src="' . $imageUrl . '"/>';
		//		if (isset($data->image_hover) && ($data->image_hover != '')) {
		//			$imageContent .= '	      <img class="url_image_hover' . $classPopover . '" src="' . NGE::url('root') . $data->image_hover . '"/>';
		//		}
				$imageContent .= '	</div>';
				$item->body = $imageContent;
				//$item->caption = $data->content->items[$i]->caption->html;
				$item->legend = $data->content->items[$i]->legend;
				break;				
			case 'video' : 
				$dataVideo = new stdClass();
				$dataVideo->id = $data->id;
				$dataVideo->content = $data->content->items[$i]->body->video;
				$dataVideo->rendering = $data->rendering;
				$item->body = NGE::layout('nge.parts.media.html.video_html', $dataVideo);
				$item->legend = $data->content->items[$i]->legend;
				$thumbnailsHaveVideoContent = true;
				break;
			default : //html
				$item->body = $data->content->items[$i]->body->html;
				break;			    
		}
					
		//Hover panel
		switch ($data->content->items[$i]->hover->source) {
			case 'html' :
				$item->hover = $data->content->items[$i]->hover->html;
				break;
			case 'url' :
				require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
				$item->hover = UrlDriver::getContents($data->content->items[$i]->hover->url);
				break;
			case 'query' :
				require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
				$item->hover = NgeDatabaseDriver::loadSingle($data->content->items[$i]->hover->query);
				break;
			case 'joomla.article' :
				require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
				$article = NgeJoomlaArticleDriver::load($data->content->items[$i]->hover->joomla_article);
				$item->hover = $article->introtext;
				break;
			case 'joomla.module' :
				require_once (NGEPATH_HELPERS . '/data/joomla/moduledriver.php');
				$item->hover = NgeJoomlaModuleDriver::load($data->content->items[$i]->hover->joomla_module);
				break;
			case 'image' : 
				//$item = $data->content->items[$i];
			    	$dataImages = $data->thumbnails->images;
				$class_img = NGE::layout('nge.parts.images.css.image_class', $dataImages);

				$imageContent = '	<div class="content_img">';
				$imageContent .= '	      <div>';

				if (isset($data->content->items[$i]->caption) && $data->content->items[$i]->caption != '') {
					$thumbnailsHaveCaptionContent	= true;
					$item->caption = $data->content->items[$i]->caption;
					$imageContent .= ' 	<div class="image_caption">';
					//$imageContent .= ' 		<div class="transparent"></div>';
					if ($data->rendering->mode == 'edit')
						$imageContent .= '			<div id="' . $part->data->id . '-caption" class="caption_value ngecontenteditableinline"  data-type="ngeeditor" data-property="caption.html">' . $data->content->items[$i]->caption->html . '</div>';
					else
						$imageContent .= '			<div class="caption_value" >' . $data->content->items[$i]->caption->html . '</div>';
					$imageContent .= ' 	</div>';
				}
				if ($data->rendering->mode == 'edit') {
					$xeditable_class = ' ngecontenteditable';
					$attributes = ' title="Image" data-type="image" data-property="image"';
				} else {
					$xeditable_class = '';
					$attributes = '';
				}
				$attributes .= ' style="width:100%;"'; 

				$imageContent .= '	          <img class="url_image' . $xeditable_class . $class_img . '"' . $attributes . ' src="' . NGE::url('root') . $data->content->items[$i]->hover->image . '"/>';
		//		if (isset($data->image_hover) && ($data->image_hover != '')) {
		//			$imageContent .= '	      <img class="url_image_hover' . $classPopover . '" src="' . NGE::url('root') . $data->image_hover . '"/>';
		//		}
				$imageContent .= '	      </div>';
				$imageContent .= '	</div>';
				$item->hover = $imageContent;
				break;				
			case 'video' : 
				$dataVideo = new stdClass();
				$dataVideo->id = $data->id;
				$dataVideo->content = $data->content->items[$i]->hover->video;
				$dataVideo->rendering = $data->rendering;
				$item->hover = NGE::layout('nge.parts.media.html.video_html', $dataVideo);
				$thumbnailsHaveVideoContent = true;
				break;
			default :
				$item->hover = '';
		}
		if ($item->hover != '')
			$thumbnailsHaveHoverContent = true;

		    /*Link*/
		    if (isset($data->content->items[$i]->link->type)) {
			    switch ($data->content->items[$i]->link->type) {
				    case 'url' :
					    $item->link = $data->content->items[$i]->link->url;
					    break;
				    case 'document' :
					    $item->link = $data->content->items[$i]->link->document;
					    break;
				    case 'article' :
					    $item->link = NGE::url('root') . 'index.php?option=com_content&view=article&id=' . $data->content->items[$i]->link->article;
					    break;
				    case 'image' :
					    $item->link = NGE::url('root') .$data->content->items[$i]->link->image;
					    break;
				    case 'file' :
					    $item->link = NGE::url('root') .$data->content->items[$i]->link->file;
					    break;					
				    case 'menu' :
					    require_once (NGEPATH_HELPERS . '/data/joomla/menudriver.php');
					    $menu = NgeJoomlaMenuDriver::loadItem($data->content->items[$i]->link->menu);
					    if (isset($menu)){
						$link = $menu->route;
						$item->link = NGE::url('root').'index.php/'.$link;        			    
					    }
					    else{
						$item->link = NGE::url('root').'index.php';        
						NGE::message('Warning : part '.$data->id.' menu item unknown', 'warning');
					    }	
					    break;
				    case 'javascript' :
					    $item->link = $data->content->items[$i]->link->javascript;
					    break;
				    case 'submit' :
					    $item->link = 'jQuery( "form:first" ).submit();'; //TODO pouvoir indiquer un nom de formulaire
					    break;
				    default :
					    $item->link = "";
			    }

			    //link on thumbnails if not already in cache
			if ($data->cache->css == '' || $data->cache->js == ''){
				if ($item->link != "") {
					$dataLink = new stdClass();
					$dataLink->selector = '#part-' . $data->id . ' div.thumbnail-container.thumbnail-container-' . $i;
					$dataLink->url = $item->link;
					$dataLink->type = $data->content->items[$i]->link->type;
					$dataLink->target = $data->content->items[$i]->link->target;
					$part->script[] = NGE::layout('nge.parts.panels.js.button_js', $dataLink);
					$part->style[] = '#part-' . $data->id . ' div.thumbnail-container.thumbnail-container-' . $i . '{
						cursor: pointer;
					}';
				}
				//Display absolute arrows
				if($data->navigator->arrows->display != 'never')
				    $part->style[] = '#part-' . $data->id . '-panel{
					position: relative;
				    }';
			}
		    }

		//display in thumbnails mode (title, body, legend	
		$dataThumbnail = $data->slides	; //General properties
		$dataThumbnail->renderingMode = $data->rendering->mode;
		$dataThumbnail->content = $item;
		//Detect stored content in 1.x version. It not will be editable
		$dataThumbnail->version = $data->content->version;		
		//$dataThumbnail->class =  implode("", $classThumbnail);
		$dataThumbnail->itemCount = $i;
		$dataThumbnail->id = $data->id;
	
		$dataThumbnail->selector = '#part-' . $data->id . ' .body-header';
		$item->body = NGE::layout('nge.parts.panels.html.thumbnail_html', $dataThumbnail);
		
		$items[] = $item;
	}			
}
 else{
    //Loading plugin contents
    $dataSourceFilename = NGEPATH_CONTENTS . '/source/' . str_replace('.', '/', $data->content->source) . '/content.php';
    if (file_exists($dataSourceFilename)){			
	require_once $dataSourceFilename;
	$className = 'Nge' . implode('', array_map('ucfirst', explode('.', $data->content->source))) . 'Content';
	$source = str_replace('.', '/', $data->content->source);
	//WARNING : $data contains properties from the config screen. 
	//All content properties are not known because they can come from external content plugins
	//So we transmit unchanged all these properties as parameter of the loadList method (params)
	$dataItems = $className::getThumbnailsData($data);
	//$items = $className::loadBodyList($data->content->$source);
	
	$i = 0;
	foreach ($dataItems as $dataItem){
	    //display in thumbnails mode (title, body, legend	
	    $dataThumbnail = $data->slides; //General properties
	    $dataThumbnail->renderingMode = $data->rendering->mode;
	    $dataThumbnail->content = $dataItem;
	    //Detect stored content in 1.x version. It not will be editable
	    $dataThumbnail->version = $data->content->version;		
	    //$dataThumbnail->class =  implode("", $classThumbnail);
	    $dataThumbnail->itemCount = $i;
	    $dataThumbnail->id = $data->id;

	    $dataThumbnail->selector = '#part-' . $data->id . ' .body-header';
	    $item = new StdClass();
	    $item->body = NGE::layout('nge.parts.panels.html.thumbnail_html', $dataThumbnail);

	    $items[] = $item;	    
	    $i++;
	}
	
    }
    
        
}

	//Preset styles?
	if ($data->navigator->arrows->style != 'custom'){
	    if ($data->content->mode == 'images'){
		    $data->navigator->arrows->positions->horizontal->position = 'inside';
		}
		else { //Text
		    $data->navigator->arrows->positions->horizontal->position = 'outside';
		}	
	    
	    $data->navigator->arrows->positions->vertical->position = 'middle';
	    $data->navigator->arrows->positions->horizontal->margin = '10';
	    $data->navigator->arrows->steps = '1';
	}
	if ($data->navigator->bullets->style != 'custom'){
	    $data->navigator->bullets->orientation = 'horizontal';
	    $data->navigator->bullets->position = 'outsidebottom';
	    $data->navigator->bullets->align = 'center';
	    $data->navigator->bullets->steps = '1';
	}


/**** CSS ***********************************************************************/

//Cache
if ($data->cache->css == ''){

    	//Part display options
	$dataThumbnail = $data->slides;
	$dataThumbnail->selector = '#part-' . $data->id;
	$part->style[] = NGE::layout('nge.parts.panels.css.thumbnails_css', $dataThumbnail);
    

	// ******** Slides CSS *************************************
//Header CSS
		$dataSlider = $data->slider;
		$dataSlider->selector = '#part-' . $data->id . '-slider';
		$part->style[] = NGE::layout('nge.parts.panels.css.slider_slides_css', $dataSlider);
    
	// ******** Tumbnail CSS *************************************
	if ($thumbnailsHaveHeaderContent == true) {
		//Header CSS
		$dataHeader = $data->slides->header;
		$dataHeader->selector = '#part-' . $data->id . ' .thumbnail-header';
		$part->style[] = NGE::layout('nge.parts.panels.css.header_css', $dataHeader);

		//Header Font CSS
		$dataHeaderFont = $data->slides->header->font;
		//Links same color. Il will be possible in the future to add input fields for link colors
		$dataHeaderFont->color_link = $dataHeaderFont->color;
		$dataHeaderFont->color_link_hover = $dataHeaderFont->color_hover;
		$dataHeaderFont->selector = '#part-' . $data->id . ' .thumbnail-header';
		$part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataHeaderFont);

		//Header Border
		if ($data->slides->header->border->style != "none") {
			$dataHeaderBorder = $data->slides->header->border;
			$dataHeaderBorder->selector = '#part-' . $data->id . ' .thumbnail-header';
			$part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataHeaderBorder);
		}

		//Header Background CSS
		$dataHeaderBackground = $data->slides->header->background;
		$dataHeaderBackground->selector = '#part-' . $data->id . ' .thumbnail-header';
		$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataHeaderBackground);

		//Header Icomoon CSS
		$dataHeaderIcomoon = $data->slides->header->glyph;
		$dataHeaderIcomoon->selector = '#part-' . $data->id . ' .thumbnail-header .icomoon';
		$dataHeaderIcomoon->selector_hover = '#part-' . $data->id ;
		$part->style[] = NGE::layout('nge.parts.panels.css.icomoon_css', $dataHeaderIcomoon);

	}

	//Thumbnail Font
	if (isset($data->slides->font) && ($data->slides->font->style == 'custom')) {
		$dataFont = $data->slides->font;
		$dataFont->selector = '#part-' . $data->id . ' div.thumbnail-container';
		$part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataFont);
	} 
	
	//Tumbnail Border
	if ($data->slides->border != "none") {
		$dataBorder = $data->slides->border;
		$dataBorder->selector = '#part-' . $data->id . ' div.thumbnail-container';
		$part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataBorder);
	}

	//Tumbnail Background
	if ($data->slides->background != "none") {
		$dataBackground = $data->slides->background;
		$dataBackground->selector = '#part-' . $data->id . ' div.thumbnail-container';
		$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataBackground);
	}

	//Tumbnail Shadow
	if ($data->slides->shadow->style != "none") {
		$dataShadow = $data->slides->shadow;
		$dataShadow->selector = '#part-' . $data->id . ' div.thumbnail-container';
		$part->style[] = NGE::layout('nge.parts.panels.css.shadow_css', $dataShadow);
	}

		//Hover css
	if ($thumbnailsHaveHoverContent == true){
	    	$part->style[] = '#part-' . $data->id . ' div.hasHover .thumbnail-hover{display:none;}';
	    	$part->style[] = '#part-' . $data->id . ' div.hasHover:hover .thumbnail-body{display:none;}';
	    	$part->style[] = '#part-' . $data->id . ' div.hasHover:hover .thumbnail-hover{display:block}';
	}

	
	//Thumbnail legend CSS
	if ($thumbnailsHaveLegendContent == true){

		$dataLegend = $data->slides->legend;
		$dataLegend->selector = '#part-'.$data->id.' .thumbnail-legend';
		$part->style[] = NGE::layout('nge.parts.panels.css.legend_css', $dataLegend);
		//Font
		if ($data->slides->legend->font->style == 'custom') {
			$dataLegendFont = $data->slides->legend->font;
			$dataLegendFont->selector = '#part-' . $data->id . ' .thumbnail-legend';
			$part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataLegendFont);
		}
		//Border
		if ($data->slides->legend->border->style != "none") {
			$dataLegendBorder = $data->slides->legend->border;
			$dataLegendBorder->selector = '#part-' . $data->id . ' .thumbnail-legend';
			$part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataLegendBorder);
		}

		//background
		if ($data->slides->legend->background->style != "none") {
			$dataLegendBackground = $data->slides->legend->background;
			$dataLegendBackground->selector = '#part-' . $data->id . ' .thumbnail-legend';
			$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataLegendBackground);
		}	
	}

	//Caption CSS
	 /*if ($thumbnailsHaveCaptionContent){

 		//Caption options and display
		$dataCaption = $data->slides->caption;
		$dataCaption->selector = '#part-'.$data->id.' .thumbnail-body-caption';
		$dataCaption->selector_hover = '#part-'.$data->id.' .thumbnail-body:hover .thumbnail-body-caption';
		$part->style[] = JLayoutHelper::render('nge.parts.images.css.caption_css', $dataCaption);

		//Font
		if ($data->slides->caption->font->style == 'custom') {
			$this->dataCaptionFont = $data->slides->caption->font;
			$this->dataCaptionFont->selector = '#part-' . $data->id . ' .thumbnail-body-caption';
			$part->style[] = JLayoutHelper::render('nge.parts.text.css.font_css', $this->dataCaptionFont);
		}

		//Caption Border
		if ($data->slides->caption->border->style != "none") {
			$dataCaptionBorder = $data->slides->caption->border;
			$dataCaptionBorder->selector = '#part-' . $data->id . ' .thumbnail-body-caption';
			$part->style[] = JLayoutHelper::render('nge.parts.panels.css.border_css', $dataCaptionBorder);
		}

		//Caption background
		if ($data->slides->caption->background->style != "none") {
			$dataCaptionBackground = $data->slides->caption->background;
			$dataCaptionBackground->selector = '#part-' . $data->id . ' .thumbnail-body-caption';
			$part->style[] = JLayoutHelper::render('nge.parts.panels.css.background_css', $dataCaptionBackground);
		}	
	 }*/
	//Caption CSS
	 if ($thumbnailsHaveCaptionContent == true){
		//Caption options and display
		$dataCaption = $data->slides->caption;
		$dataCaption->selector = '#part-'.$data->id.' .image_caption';
		$dataCaption->selector_hover = '#part-'.$data->id.' .content_img:hover .image_caption';
		$part->style[] = NGE::layout('nge.parts.images.css.caption_css', $dataCaption);

		//Font
		if ($data->slides->caption->font->style == 'custom') {
			$this->dataCaptionFont = $data->slides->caption->font;
			$this->dataCaptionFont->selector = '#part-' . $data->id . ' .caption_value';
			$part->style[] = NGE::layout('nge.parts.text.css.font_css', $this->dataCaptionFont);
		}

		//Caption Border
		if ($data->slides->caption->border->style != "none") {
			$dataCaptionBorder = $data->slides->caption->border;
			$dataCaptionBorder->selector = '#part-' . $data->id . ' .image_caption';
			$part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataCaptionBorder);
		}

		//Caption background
		if ($data->slides->caption->background->style != "none") {

			$dataCaptionBackground = $data->slides->caption->background;
			$dataCaptionBackground->selector = '#part-' . $data->id . ' .content_img .image_caption';
			$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataCaptionBackground);
		}	

		//Effect
		if(isset($data->slides->caption->effect) && ($data->slides->caption->effect->trigger != "none") && ($data->slides->caption->effect->style != "")){
			//NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'animate/css/animate.min.css');
			NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'animate/css/animate_teatis.css');		
			$dataEffect = $data->slides->caption->effect;
			$dataEffect->selector = '#part-'.$data->id .  ' .image_caption';
			$part->style[] = NGE::layout('nge.parts.panels.css.animation_css', $dataEffect);
			$part->script[] = NGE::layout('nge.parts.panels.js.animation_js', $dataEffect);
		}
	 }	 	 
		
	//Arrows	
	if($data->navigator->arrows->display != 'never'){
		$dataArrows = $data->navigator->arrows;
		$dataArrows->content = $data->content;
		//$dataArrows->selector = '#part-' . $data->id . ' .slick-dots';
		$dataArrows->selector = '#part-' . $data->id;
		$dataArrows->selector_hover = '#part-' . $data->id . ':hover .slick-dots';
		$part->style[] = NGE::layout('nge.parts.panels.css.slider_arrows_css', $dataArrows);
	}

	//Bullets	
	if($data->navigator->bullets->display != 'never'){
		$dataBullets = $data->navigator->bullets;
		$dataBullets->selector = '#part-' . $data->id . ' .slick-dots';
		$dataBullets->selector_hover = '#part-' . $data->id . ':hover .slick-dots';
		$part->style[] = NGE::layout('nge.parts.panels.css.slider_bullets_css', $dataBullets);
	}

	//Slick slider
	//To avoid have all slides displayed before initializing, 
	//https://github.com/kenwheeler/slick/issues/158
	if ($data->rendering->mode != "fastview"){
	    $part->style[] = '.slider { visibility: hidden; }.slick-initialized { visibility: visible; }';
	}
	
		 //Blog image cropped	
	$part->style[] = NGE::layout('nge.parts.images.css.imagecrop_css', $data);

	
}//if cache	


//HTML *********************************************************************
	//Navigators
    $navigatorsContent = '';
	//Launched first, to have some widths and heights calculated	
    
    	if($data->navigator->arrows->display != 'never'){
		$dataArrows = $data;
		$dataArrows->selector = '#part-' . $data->id;
    		$navigatorsContent .= NGE::layout ( 'nge.parts.panels.html.sliderarrows_html', $dataArrows);			
	}
/*
    	if($data->navigator->thumbnails->display != 'never'){
		$dataThumbnails = $data->navigator->thumbnails;
		$dataThumbnails->width =  $data->slider->width;
		$dataThumbnails->selector = '#part-' . $data->id;
    		$navigatorsContent .= NGE::layout ( 'nge.parts.panels.html.sliderthumbnails_html', $dataThumbnails);			
	}
*/
if(count($items) == 0){
 	//if  ($data->rendering->mode == 'preview')
	//	NGE::message('<b>Warning</b>, Empty content.', 'warning');
}else{
	//libraries css & js to be added to the common libraries pool    
	if ($data->rendering->mode != "fastview"){
	    NgeContenthelper::addScript($data->libraries['slick.slick.js']);
	    NgeContenthelper::addStyleSheet($data->libraries['slick.slick.css']);
	    NgeContenthelper::addStyleSheet($data->libraries['slick.slick-theme.css']);
	}
	$part->content .= '<section id="part-'.$data->id.'-slider" class="regular slider">';
	if ($data->rendering->mode != 'fastview')
	    $nbItems = count($items);
	else
	    $nbItems = 1; //In fastview, rendering only first tab
	
	for ($i = 0; $i<$nbItems; $i++) {
//		$part->content .= '<div>';
	    $part->content .= '<div>' . $items[$i]->body . '</div>';
	    //$part->content .= $items[$i]->caption;
//	    $part->content .= '</div>';
	}
	$part->content .= '</section>';
	if ($data->grid->display == true){
	    $part->content .= '<section id="part-'.$data->id.'-grid" class="regular slider">';
	    for ($i = 0; $i<count($items); $i++) {
		$part->content .= '<div>';
		$part->content .= $items[$i]->body;
		//$part->content .= $items[$i]->caption;
		$part->content .= '</div>';
	    }
	    $part->content .= '</section>';
	}    
	$part->content .= $navigatorsContent;
	//$dataSlider = $data;
	//$dataSlider->selector = '#part-'.$data->id.'-slider';
	//print_r($data->slider);
	$data->count = count($items);

	
	/**** JS ***********************************************************************/
	//Cache
	if ($data->cache->js == ''){
	    if ($data->rendering->mode != "fastview"){
		if ($data->grid->display == true)
		    $part->script[] = NGE::layout('nge.parts.panels.js.slider_grid_js', $data);
		else
		    $part->script[] = NGE::layout('nge.parts.panels.js.slider_js', $data);
	    }
	//Images crop
	$dataImage = new stdClass();
	$dataImage->selector = '#part-' . $data->id . ' .ngearticle img';
	$part->script[] = NGE::layout('nge.parts.images.js.imagecrop_js', $dataImage);	

	    
	    
/*	    
	    $part->script[] =  "var stHeight = jQuery('.slick-track').height(),
      timeout = false, // holder for timeout id
      delay = 250; // delay after event is complete to run callback

function refreshSlickHeight() {
      jQuery('.slick-slide').css('height', stHeight + 'px' );
}

// window.resize event listener
window.addEventListener('resize', function() {
      // clear the timeout
      clearTimeout(timeout);
      // start timing for event completion
      timeout = setTimeout(refreshSlickHeight, delay);
});";
*/	    
	    /*switch ($data->slides->height->mode) {
		    case 'maxheight' :
			    NgeContenthelper::addScript(NGEURL_MEDIA . 'jquery-match-height/jquery.matchHeight-min.js');
			    $rowHeight = $data->thumbnails->height->mode == "maxrowheight" ? 'true' : 'false';
    //				$part->script[] = 'console.log(jQuery.type(matchHeight));';
			    $part->script[] = '				    
				    onChangePartContent'.$data->id.' = function(){
					    jQuery("#part-' . $data->id . ' div.thumbnail-container").matchHeight(' . $rowHeight . ');	
					    jQuery("#part-' . $data->id . ' div.thumbnail-legend").matchHeight(' . $rowHeight . ');
				    };
				    setTimeout(function () {
					    onChangePartContent'.$data->id.'();					
				    }, 10);';
			    break;
		    case 'square' :
			    $part->script[] = '
			    var selector = jQuery("#part-' . $data->id . ' div.thumbnail-container");
			    var width = selector.outerWidth();
			    var height = selector.outerHeight();
			    var height2 = selector.height();
			    var padding = height - height2;
			    var realHeight = width - padding;

			    selector.height(realHeight);
		    ';
		    break;
	    }*/
	    
	    
	}//if cache

}    
echo $part->render();