<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

require_once NGEPATH_HELPERS . '/ngecontenthelper.php';
 
$data = $displayData;
$i = $data->itemCount;
$html = array();
$divBody = array();
$divHover = array();
	//Editable ?
	// editable for custom content ?
	if (($data->renderingMode == 'edit') && (isset($data->content->source))){	    
		switch ($data->content->source) {
			case 'html' :
				//Detect stored content in 1.x version. It not will be editable
				if (isset($data->version) && ($data->version == '1')){
				    $editable = false;
				    $editableClass = '';
				    $editableAttributes = '';
				}
				else {    
				    $editable = true;
				    $editableClass = ' ngeinlineeditable ngeinlineeditor';
				    $editableAttributes = 'data-nge = \'{"title": "Text", "type": "editor", "source":"content:content.items.'.$i.'.html"}\'';
				}
				break;
			case 'joomla.article' :
				$editable = true;
				$editableClass = ' ngeelement ngeinlineeditable';
				$editableAttributes = 'data-nge = \'{"title": "Article", "type": "joomla.article", "source":"content:content.items.'.$i.'.article"}\'';
				break;
			case 'joomla.module' :
				$editable = true;
				$editableClass = ' ngeinlineeditable';
				$editableAttributes = 'data-nge = \'{"title": "Module", "type": "joomla.module", "source":"content:content.items.'.$i.'.module"}\'';
				break;
			case 'url' :
				$editable = true;
				$editableClass = ' ngeinlineeditable';
				$editableAttributes = 'data-nge = \'{"title": "Url", "type": "joomla.url", "source":"content:content.items.'.$i.'.url"}\'';
				break;
			default :
				$editable = true;
				$editableClass = '';
				$editableAttributes = '';
		}
		//Detect stored content in 1.x version. It not will be editable
		if (isset($data->version) && ($data->version == '1')){
		    $editablePropertyHeader = '';
		    $editableClassHeader = '';
		}
		else {    
		    $editablePropertyHeader = 'data-nge = \'{"title": "Text", "type": "text", "source":"content:content.items.'.$i.'.header.label"}\'';
		    $editableClassHeader = ' ngeinlineeditable ngeinlinetext';
		}
	} else {
		$editable = false;
		$editableTitle = '';
		$editableClass = '';
		$editableClassHeader = '';
		$editableAttributes = '';
		$editableType = '';
		$editableProperty = '';
		$editablePropertyHeader = '';
	}

	//Hover	
	    if (($data->renderingMode == 'edit') && (isset($data->content->source))){
		switch ($data->content->source) {
			case 'html' :
				//Detect stored content in 1.x version. It not will be editable
				if (isset($data->version) && ($data->version == '1')){
				    $editable = false;
				    $editableClass = '';
				    $editableAttributes = '';
				}
				else {    
				    $editable = true;
				    $editableClass = ' ngeinlineeditable ngeinlineeditor';
				    $editableAttributes = 'data-nge = \'{"title": "Text", "type": "editor", "source":"content:content.items.'.$i.'.html"}\'';
				}
				break;
			case 'joomla.article' :
				$editable = true;
				$editableClass = ' ngeinlineeditable';
				$editableAttributes = 'data-nge = \'{"title": "Article", "type": "joomla.article", "source":"content:content.items.'.$i.'.article"}\'';
				break;
			case 'joomla.module' :
				$editable = true;
				$editableClass = ' ngeinlineeditable';
				$editableAttributes = 'data-nge = \'{"title": "Module", "type": "joomla.module", "source":"content:content.items.'.$i.'.module"}\'';
				break;
			case 'url' :
				$editable = true;
				$editableClass = ' ngeinlineeditable';
				$editableAttributes = 'data-nge = \'{"title": "Url", "type": "joomla.url", "source":"content:content.items.'.$i.'.url"}\'';
				break;
			default :
				$editable = true;
				$editableClass = '';
				$editableAttributes = '';
		}
	    }
	
//Header	
	//Thumbnail header
	//if (isset($data->content->header) && $data->content->header != '') {
	if (($data->content->header->label != '') || ($data->content->header->glyph->name != '')) {
	
        // glyph editble
        if(isset($data->renderingMode) && $data->renderingMode == 'edit'){
        	//$glyphEditableClass = ' ngecontenteditable';
        	//$glyphEditableAttributes = ' title="Glyph" data-type="glyph" data-property="glyph.name"';
	if ($data->version != '1')
	    $glyphEditableClass = ' ngeelement ngeinlineeditable ngeinlineglyph';
	else
	    $glyphEditableClass = '';
        	$glyph_name = (isset($data->content->header->glyph->name) && $data->content->header->glyph->name != '') ? $data->content->header->glyph->name : '';
        	$glyphEditableAttributes = ' data-nge = \'{"title": "Glyph", "type": "glyph", "source":"content:content.items.'.$i.'.header.glyph.name", "value":"'.$glyph_name.'"}\' ';
        }else{
        	$glyphEditableClass = '';
        	$glyphEditableAttributes = '';
        }

	//glyph
	    if ($data->content->header->glyph->name != ''){
		$glyphleft = $data->header->glyph->position == 'left' ? '<span class="icomoon ' . $data->content->header->glyph->name . $glyphEditableClass . '"' . $glyphEditableAttributes.'"></span>' : '';
		$glyphright = $data->header->glyph->position == 'right' ? '<span class="icomoon ' . $data->content->header->glyph->name . $glyphEditableClass . '"' . $glyphEditableAttributes.'"></span>' : '';
	    }
	    else{
		$glyphleft = '';
		$glyphright = '';
	    }

	    //Header
	    $content_header = $data->content->header->label;

	    if (in_array($data->header->tag, array('h1', 'h2', 'h3', 'h4', 'h5', 'h6'))){
		$content_header = $glyphleft.'<'.$data->header->tag.' id="part-' . $data->id . '-header-' . $i . '" class="'.$editableClassHeader.' thumbnail_title" style="display:inline;" '.$editablePropertyHeader.'>'.$content_header.'</'.$data->header->tag.'>'.$glyphright;
	    }else{
		$content_header = $glyphleft.'<span id="part-' . $data->id . '-header-' . $i . '" class="thumbnail_title '.$editableClassHeader.'" '.$editablePropertyHeader.' >'.$content_header.'</span>'.$glyphright;
	    }
	    $span_class = ($data->header->font->style == "class") ? 'class="'.$data->header->font->class.'"' : "";
	    $content_header = '<span '.$span_class.'>'.$content_header.'</span>';

	    $divHeader = '<div class="thumbnail-header">'. $content_header .'</div>';
	}
	else
	    $divHeader = '';
	
	//Body
	$divBody[] = '<div id="part-' . $data->id . '-body-' . $i . '" style="position:relative" class="thumbnail-body ' . $editableClass . '" '.$editableAttributes.' >';

	//Thumbnail legend
	if (isset($data->content->legend) && $data->content->legend != '') {
	
	    $divLegend = '<div class="thumbnail-legend">'. $data->content->legend .'</div>';
	}
	else
	    $divLegend = '';

	//Body caption
	/*
	if (isset($data->content->caption) && ($data->content->caption != '')) {
		$divBody[] = '<div class="thumbnail-body-caption"><div>';
		$divBody[] = $data->content->caption;
		$divBody[] = '</div></div>';
	}*/
	
	$thumbnailClass = '';

	$divBody[] = $data->content->body;
	$divBody[] = '</div>';
	$divBody = implode($divBody);
	
	//Hover content
	if (isset($data->content->hover) && $data->content->hover != ''){
	    $divHover[] = '<div id="part-' . $data->id . '-hover-' . $i . '" class="thumbnail-hover' . $editableClass . '" '.$editableAttributes.'>';
	    $divHover[] = $data->content->hover;
	    $divHover[] = '</div>';
	    $thumbnailClass .= ' hasHover'; //has hover content. Will be displayed in css on hover
	}
	$divHover = implode($divHover);
		
	//HTML	
	//$html[] = '<div class="thumbnail-container thumbnail-container-' . $i . ' ' . $data->class . '">';
	//Is there some class attributes defined?
	$thumbnailClass .= isset($data->class) && $data->class != '' ? ' '.$data->class : '';
	$thumbnailAttributes = isset($data->attributes) && $data->attributes != '' ? ' '.$data->attributes : '';
	$html[] = '<div class="thumbnail-container thumbnail-container-' . $i . $thumbnailClass . '"' . $thumbnailAttributes . '>';	
	
	//Badge
	if (isset($data->content->badge) && $data->content->badge->label != ''){
	    if ($data->renderingMode == 'edit') {		
		$content_badge = '<span class="ngeinlineeditable ngeinlinetext" data-nge = \'{"title": "Text", "type": "text", "source":"content:content.items.'.$i.'.badge.label"}\'>' . $data->content->badge->label . '</span>';
	    } else {
		$content_badge = '<span>' . $data->content->badge->label . '</span>';
	    }
		$html[] = '<div class="part_badge">' . $content_badge . '</div>';
	}

	
		//Main rendering		
		
		//Top
		if (($divHeader !='') && ($data->header->position == 'top')){
		    $html[] .= $divHeader;
		}
		//Legend in top position, except if header is on sides
		if (($divLegend !='') && ($data->legend->position == 'top')
		&& !(($divHeader !='') && (in_array($data->header->position, array('left', 'right'))))){
		    $html[] .= $divLegend;
		}
		
		//Left or right sides
		if (($divHeader !='') && (in_array($data->header->position, array('left', 'right'))) 
		|| ($divLegend !='') && (in_array($data->legend->position, array('left', 'right'))) ){
		    $html[] = '<div style="display:table;height:100%">';
		    
		    //Left		
		    if (($divHeader !='') && ($data->header->position == 'left')){
			$html[] .= $divHeader;
		    }
		    if (($divLegend !='') && ($data->legend->position == 'left')){
			$html[] .= $divLegend;
		    }
		    
		    //Body
		    //Header outside
		    if (($divHeader !='') && (in_array($data->header->position, array('left', 'right')))){
			if (($divLegend !='') && ($data->legend->position == 'top')){
			    $html[] .= $divLegend;
			}
			$html[] .= $divBody . $divHover;
			if (($divLegend !='') && ($data->legend->position == 'bottom')){
			    $html[] .= $divLegend;
			}
		    }
		    else
			$html[] .= $divBody . $divHover;
		    
		    //Right
		    if (($divHeader !='') && ($data->header->position == 'right')){
			$html[] .= $divHeader;
		    }
		    if (($divLegend !='') && ($data->legend->position == 'right')){
			$html[] .= $divLegend;
		    }
		    
		    
		    $html[] = '</div>';
		}    
		else
		    $html[] .= $divBody . $divHover;
		
		//Bottom
		//Legend in bottom position, except if bottom is on sides
		if (($divHeader !='') && ($data->header->position == 'bottom')){
		    $html[] .= $divHeader;
		}
		if (($divLegend !='') && ($data->legend->position == 'bottom')
		&& !(($divHeader !='') && (in_array($data->header->position, array('left', 'right'))))){
		    $html[] .= $divLegend;
		}
		
		

	
	
	/*
	
	//Body and legend
		if (!isset($data->content->legend) || ($data->content->legend == '')){
			$bodyLegendContent = $divBody;
		}
		else {
				switch ($data->legend->position) {
					case 'top' :
						$bodyLegendContent = '<div class="thumbnail-legend">'. $data->content->legend .'</div>' . $divBody;
						break;
					case 'bottom' :
						$bodyLegendContent = $divBody . '<div class="thumbnail-legend">'. $data->content->legend .'</div>';
						break;
					case 'left' :
						$bodyLegendContent = '<div class="row-fluid tile-row" style="margin-top:0px">';
						$bodyLegendContent .= '<div class="nge'.$data->legend->sidewidth->value.' thumbnail-legend legende-left" >' . $data->content->legend . '</div>';
						$bodyLegendContent .= '<div class="thumbnail-body nge'. (string) (12 - (int) $data->legend->sidewidth->value) . ' content-left" >' . $divBody . '</div>';
						$bodyLegendContent .= '</div>';
						break;
					case 'right' :
						$bodyLegendContent = '<div class="row-fluid tile-row" style="margin-top:0px">';
						$bodyLegendContent .= '<div class="thumbnail-body nge'. (string) (12 - (int) $data->legend->sidewidth->value) . ' content-right" >' .$divBody . '</div>';				
						$bodyLegendContent .= '<div class="nge'.$data->legend->sidewidth->value.' thumbnail-legend legende-right" ><div class="thumbnail-legend">'. $data->content->legend .'</div></div>';
						$bodyLegendContent .= '</div>';
						break;		
				}
		}	

		//Main rendering
		switch ($data->header->position) {
			case 'top' :
				$html[] .= $divHeader . $bodyLegendContent;
				break;
			case 'bottom' :
				$html[] .= $bodyLegendContent . $divHeader;				
				break;
			case 'left' :
				if ($data->content->legend == ""){ //No legend
						$html[] .= '<div class="row-fluid tile-row" >';					
						$html[] .= '	<div class="thumbnail-header" >' . $content_header . '</div>';
						$html[] .= '	<div class="thumbnail-body nge'.(string) (12 - (int) $data->header->sidewidth->value).'" >' . $divBody .'</div>';
						$html[] .= '</div>';					
				}
				else
					switch ($data->legend->position) {
						case 'top':
						case 'bottom' :
							$html[] .= '<div class="row-fluid tile-row">';
							$html[] .= '<div class="thumbnail-header">' . $content_header . '</div>';
							$html[] .= '<div class="thumbnail-body nge'. (string)(12 - (int) $data->header->sidewidth->value)  . '" >' . $bodyLegendContent . '</div>';
							$html[] .= '</div>';
							break;
						case 'left' :
							$html[] .= '<div class="row-fluid tile-row" >';					
							$html[] .= '	<div class="thumbnail-header" >' . $content_header . '</div>';
							$html[] .= '	<div class="thumbnail-legend">' . $data->content->legend .'</div>';						
							$html[] .= '	<div class="thumbnail-body nge'.(string) (12 - (int) $data->header->sidewidth->value - (int) $data->legend->sidewidth->value).'" >' . $divBody .'</div>';
							$html[] .= '</div>';
							break;
						case 'right' :
							$html[] .= '<div class="row-fluid tile-row" >';					
							$html[] .= '	<div class="thumbnail-header">' . $content_header . '</div>';
							$html[] .= '	<div class="thumbnail-body nge'.(string) (12 - (int) $data->header->sidewidth->value - (int) $data->legend->sidewidth->value).'" >' . $divBody .'</div>';
							$html[] .= '	<div class="thumbnail-legend" >' . $data->content->legend .'</div>';
							$html[] .= '</div>';
							break;
					}
				break;
			case 'right' :
				if ($data->content->legend == ""){ //No legend
						$html[] .= '<div class="row-fluid tile-row" >';					
						$html[] .= '	<div class="thumbnail-body nge'.(string) (12 - (int) $data->header->sidewidth->value).'" >' . $data->content->body .'</div>';
						$html[] .= '	<div class="thumbnail-header" >' . $content_header . '</div>';						
						$html[] .= '</div>';					
				}
				else
					switch ($data->legend->position) {
						case 'top':
						case 'bottom' :
							$html[] .= '<div class="row-fluid tile-row" >';					
							$html[] .= '<div class="thumbnail-body nge'. (string) (12 - (int) $data->header->sidewidth->value) . '" >' . $bodyLegendContent . '</div>';
							$html[] .= '<div class="nge'.$data->header->sidewidth->value.'" >' . $divHeader . '</div>';
							$html[] .= '</div>';
							break;
						case 'left' :
							$html[] .= '<div class="row-fluid tile-row" >';					
							$html[] .= '	<div class="thumbnail-legend">' . $data->content->legend .'</div>';						
							$html[] .= '	<div class="thumbnail-body nge'.(string) (12 - (int) $data->header->sidewidth->value - (int) $data->legend->sidewidth->value).'" >' . $divBody .'</div>';
							$html[] .= '	<div class="thumbnail-header">' . $content_header . '</div>';						
							$html[] .= '</div>';
							break;
						case 'right' :
							$html[] .= '<div class="row-fluid tile-row">';					
							$html[] .= '	<div class="thumbnail-body nge'.(string) (12 - (int) $data->header->sidewidth->value - (int) $data->legend->sidewidth->value).'" >' . $divBody .'</div>';
							$html[] .= '	<div class="thumbnail-legend" >' . $data->content->legend .'</div>';
							$html[] .= '	<div class="thumbnail-header" >' . $content_header . '</div>';						
							$html[] .= '</div>';
							break;
					}
				break;		
		}
		
		*/
		
	//	if orientation veticae
	//NgeContenthelper::addScript(NGEURL_MEDIA . 'jquery-match-height/jquery.matchHeight-min.js');
					/*$html[] .= '<script>
							setTimeout(function () {
								jQuery("#part-' . $data->id .  ' .tile-row > div").matchHeight(true);	
							}, 10);</script>';*/
		
		
		$html[] = '</div>';
		
		echo implode($html);