<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

$data = $displayData;

//Presets
switch ($data->style){
	case 'circle' :
	case 'class' :
		$data->shape = 'circle';
		$data->size = '8';
		$data->spacing = '15';
		$data->margin = '16';
		$data->background->color = '#666666';
		$data->background->color_hover = '#dddddd';
		$data->background->color_active = '#ffffff';		
		$data->border->width = '1';
		$data->border->color = '#888888';
		$data->border->color_active = '#aaaaaa';
		break;

	case 'square' :
		$data->shape = 'square';
		$data->size = '8';
		$data->spacing = '15';
		$data->margin = '16';
		$data->background->color = '#666666';
		$data->background->color_hover = '#eeeeee';
		$data->background->color_active = '#ffffff';
		$data->border->width = '1';
		$data->border->color = '#999999';
		$data->border->color_active = '#ffffff';
		break;
}

?>

        <style>
            /* jssor slider bullet navigator skin 01 css */
            /*
            .jssorb01 div           (normal)
            .jssorb01 div:hover     (normal mouseover)
            .jssorb01 .av           (active)
            .jssorb01 .av:hover     (active mouseover)
            .jssorb01 .dn           (mousedown)
            */
            <?php echo $data->selector; ?> .jssorb01 {position: absolute;}			   
            <?php echo $data->selector; ?> .slick-dots li button:hover {
				<?php
				if ($data->background->color_hover != '')
					echo 'background-color: '.$data->background->color_hover . ';';
				?>
            }
		<?php echo $data->selector; ?> .slick-dots li.slick-active {
				<?php
				if ($data->background->color_active != '')
					echo 'background-color: '.$data->background->color_active . ';';
				?>

		}
            <?php echo $data->selector; ?> .slick-dots li button { 
		position: absolute;
                overflow: hidden;
                cursor: pointer;
		<?php
			echo 'background-color: '.$data->background->color . ';';
			echo 'filter: alpha(opacity='.$data->background->opacity.');';
			echo 'opacity: '.$data->background->opacity/100 . ';';
			echo 'border: '.$data->border->color.' '.$data->border->width.'px solid;';							
		switch ($data->shape){
			case 'circle' :
				echo 'width: '.$data->size.'px;';
				echo 'height: '.$data->size.'px;';
				echo '-moz-border-radius: ' .  $data->size/2 . 'px;';
				echo '-webkit-border-radius: ' .  $data->size/2 . 'px;';
				echo 'border-radius: ' .  $data->size/2 . 'px;';				
				break;
			case 'square' :
				echo 'width: '.$data->size.'px;';
				echo 'height: '.$data->size.'px;';
				break;
			case 'rectangle' :
				echo 'width: '. (string)$data->size*1.5 . 'px;';
				echo 'height: '.$data->size.'px;';
				break;
			case 'parallelogram' :
				echo 'width: '. (string)$data->size*1.5 . 'px;';
				echo 'height: '.$data->size.'px;';
				echo '-webkit-transform: skew(-20deg);';
				echo '-moz-transform: skew(-20deg);';
				echo '-o-transform: skew(-20deg);';
				break;
		}
?>
			}
            
        </style>
        <!-- bullet navigator container -->
        <div u="navigator" class="jssorb01<?php echo $data->class != '' ? ' '.$data->class : ''; ?>" style="bottom: 16px; right: 10px;">
            <!-- bullet navigator item prototype -->
            <div u="prototype"></div>
        </div>
        <!--#endregion Bullet Navigator Skin End -->