<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

require_once(NGEPATH_LAYOUTS . '/parts/parts/html/panel.php');
/* * *** INSTANTIATION VARIABLES **** */
$data = $displayData;

$part = new LayoutPanel($data);

/* * *** CONTENT **** */
$content = '';

$data->selector = '#part-' . $data->id;
$html = array();

$items = array();

$labels = array();

$urls = array();
$thumbnailsHaveLink = false;
$thumbnailsHaveHeaderContent = false;
$thumbnailsHaveHeaderLink = false;
$thumbnailsHaveHoverContent = false;
$thumbnailsHaveCaptionContent = false;
$thumbnailsHaveLegendContent = false;
$thumbnailsHaveBadgeContent = false;
$thumbnailsHaveImageContent = false;
$thumbnailsHaveVideoContent = false;
$thumbnailsHaveGlyph = false;

/* * *** CONTENT **** */
/*if ($data->content->source == 'joomla.articles') {
	require_once (NGEPATH_HELPERS . '/data/joomla/articlesdriver.php');

	if (isset($data->content->articles->filter->type) && ($data->content->articles->filter->type == 'tags') && isset($data->content->articles->filter->tags) && ($data->content->articles->filter->tags != '')) {
		require_once (NGEPATH_HELPERS . '/data/joomla/tagsdriver.php');

		$params = array();
		$params['tags'] = $data->content->articles->filter->tags;
		//$params['types'] = $data->content->types;
		$params['types'] = '';
		$params['count'] = $data->content->articles->count;
		$articlesList = NgeTagsDriver::load($params);
	} else { //Calling articles driver (Joomla content model)
		require_once (NGEPATH_HELPERS . '/data/joomla/articlesdriver.php');

		$params = array();
		$params['ordering'] = $data->content->articles->ordering;
		$params['count'] = $data->content->articles->count;

		if (isset($data->content->articles->filter->type) && ($data->content->articles->filter->type == 'categories'))
			$params['category'] = $data->content->articles->filter->categories;
		$articlesList = NgeArticlesDriver::load($params);
	}

	for ($i = 0; $i < count($articlesList); $i++) {
		$item = new stdClass();
		$item->header = new stdClass();
		$item->header->label = '';
		$item->header->glyph = new stdClass();
		$item->header->glyph->name = '';
		$item->body = '';
		$item->legend = '';
		$item->caption = '';

		switch($data->content->articles->renderer->style){
			case 'intro' :
				//Header
				if ($data->content->articles->renderer->intro->header->title->display == 1){
					$item->header->label = $articlesList[$i]->title;
					$thumbnailsHaveHeaderContent = true;
				}	
				//Body				
				if (($data->content->articles->renderer->intro->image->image->display == 1) && (isset($articlesList[$i]->images->image_intro))){					
					if ($data->content->articles->renderer->intro->image->link == 1)
						$item->body =  '<div><a href=""><img src="' . NGE::url('root') . $articlesList[$i]->images->image_intro . '"/></a></div>';						
					else
						$item->body =  '<div><img src="' . NGE::url('root') . $articlesList[$i]->images->image_intro . '"/></div>';
					}
				 
				//Caption
				if ($data->content->articles->renderer->intro->caption->title->display == 1)
					$item->caption .= $articlesList[$i]->title;
				if ($data->content->articles->renderer->intro->caption->author->display == 1)
					$item->caption .= $articlesList[$i]->author;
				if ($data->content->articles->renderer->intro->caption->date->display == 1)
					$item->caption .= $articlesList[$i]->date;
				if ($data->content->articles->renderer->intro->caption->content->display == 1)
					$item->caption .= $articlesList[$i]->introtext;
				if ($item->caption != '')
					$thumbnailsHaveCaptionContent = true;
				
				//Legend
				if ($data->content->articles->renderer->intro->legend->title->display == 1)
					$item->legend .= $articlesList[$i]->title;
				if ($data->content->articles->renderer->intro->legend->author->display == 1)
					$item->legend .= $articlesList[$i]->author;
				if ($data->content->articles->renderer->intro->legend->date->display == 1)
					$item->legend .= $articlesList[$i]->created;
				if ($data->content->articles->renderer->intro->legend->content->display == 1){
					if ($data->content->articles->renderer->intro->legend->content->size != 0){
						if (strlen(($articlesList[$i]->introtext)) >$data->content->articles->renderer->intro->legend->content->size)
							$item->legend .= substr(strip_tags ($articlesList[$i]->introtext), 0, $data->content->articles->renderer->intro->legend->content->size).'...';
						else
							$item->legend .= strip_tags ($articlesList[$i]->introtext);
					}	
					else
						$item->legend .= $articlesList[$i]->introtext;
				}
				if ($item->legend != '')
					$thumbnailsHaveLegendContent = true;
				break;
			case 'full' :
				break;
		}
		$items[] = $item;
	}
} else //Custom images*/

if ($data->content->source == 'joomla.article'){
    
    
	require_once (NGEPATH_HELPERS . '/data/joomla/articlesdriver.php');
	$params = array();
	$params['category'] =	$data->content->joomla_article->category;
	//$params['author'] =		$data->content->joomla_article->author;
	$params['featured'] =		$data->content->joomla_article->featured;
	$params['tags'] =		$data->content->joomla_article->tags;
	$params['ordering'] =		$data->content->joomla_article->ordering;
	$params['count'] =		$data->content->joomla_article->count;	
	//print_r($params);
	$articlesList = NgeArticlesDriver::load($params);
	
	//$items = NgeArticlesDriver::loadThumbnailsData($query, $data->content->layout);
	
	for ($i = 0; $i < count($articlesList); $i++) {
		//Add article except if it is already current article (avoid infinite loop)

		$item = new stdClass();
		$item->title = $articlesList[$i]->title;
		$item->header = new stdClass();
		$item->header->label = '';
		$item->header->glyph = new stdClass();
		$item->header->glyph->name = '';
		$item->body = '';
		$item->legend = '';
		$item->link = $articlesList[$i]->link;
		$item->caption = '';
		$item->editable = false;
		$item->disabled = $articlesList[$i]->active; //If equals current article : not displayed to avoid infinite recursive loop
		$item->active = (($i == 0) && ($item->disabled == false)); //First tab active, except if disabled
		$item->active = (($i == 1) && ($items[0]->disabled == true));//If first tab is current article, active tab will be second tab		

		//TODO
		if (!isset($data->content->joomla_article->renderer))
			$data->content->joomla_article->renderer = new stdClass();
		$data->content->joomla_article->renderer->style='intro';
		
		switch($data->content->joomla_article->renderer->style){
			case 'intro' :
			    
				//Header
				//if ($data->content->joomla_article->renderer->intro->header->title->display == 1){
					//if ($data->content->joomla_article->renderer->intro->header->link == 1){
					    $item->header->label = '<a href="' . $articlesList[$i]->link . '">' . $articlesList[$i]->title . '</a>';
					    $thumbnailsHaveHeaderLink = true;
					/*}
					else
					    $item->header->label = $articlesList[$i]->title;*/
					$thumbnailsHaveHeaderContent = true;
				//}
				//Body
				//if (($data->content->joomla_article->renderer->intro->image->image->display == 1) && (isset($articlesList[$i]->images->image_intro) && ($articlesList[$i]->images->image_intro != ''))){					
				//	if ($data->content->joomla_article->renderer->intro->image->link == 1)
					//print_r($articlesList[$i]);
						if (isset($articlesList[$i]->images->image_intro) && $articlesList[$i]->images->image_intro != ''){
						    //$item->body =  '<div class="ngearticle"><img src="' . NGE::url('root') . $articlesList[$i]->images->image_intro . '"/></div>';
						    //if ($data->content->joomla_article->renderer->intro->image->link == 1)
							$item->body =  '<div class="ngearticle"><a href="' . $item->link . '"><img src="' . NGE::url('root') . $articlesList[$i]->images->image_intro . '"/></a></div>';
						    /*else
							$item->body =  '<div class="ngearticle"><img src="' . NGE::url('root') . $articlesList[$i]->images->image_intro . '"/></div>';						    */
						}
						else {
						    //If any existing image in the article, find and keep the first one
						    $img = '';
						    $posImg = strpos($articlesList[$i]->introtext, '<img');
						    if ($posImg !== false) {
							$posEndImg = strpos(substr($articlesList[$i]->introtext, $posImg), '>');
							$img = substr($articlesList[$i]->introtext, $posImg, $posEndImg+1);
						    }
						    $text = substr(strip_tags ($articlesList[$i]->introtext), 0, 200) . '&nbsp;...';
						    $text = substr($text, 0, strrpos($text, ' ')) . '&nbsp;...';
						    
						    //$text = substr($articlesList[$i]->introtext, 0, strrpos(substr($articlesList[$i]->introtext, 0, 200), ' ')) . '&nbsp;...';
						    //$text = substr($articlesList[$i]->introtext, 0, strrpos(substr($articlesList[$i]->introtext, 0, 200), ' ')) . '&nbsp;...';
						    //$item->body = $img . $text;
						    //if ($data->content->joomla_article->renderer->intro->legend->link == 1)
							$item->body = '<a class="ngearticle" href="' . $item->link . '">' . $img . '</a>' . $text;
						    //$item->body = $img . $text;
						}
				//	else
				//		$item->body =  '<div><img src="' . NGE::url('root') . $articlesList[$i]->images->image_intro . '"/></div>';
				//}
				//else
				//	$item->body =  '';
				
				//Caption
				/*if ($data->content->joomla_article->renderer->intro->caption->title->display == 1)
					$item->caption .= $articlesList[$i]->title;
				if ($data->content->joomla_article->renderer->intro->caption->author->display == 1)
					$item->caption .= $articlesList[$i]->author;
				if ($data->content->joomla_article->renderer->intro->caption->date->display == 1)
					$item->caption .= $articlesList[$i]->date;
				if ($data->content->joomla_article->renderer->intro->caption->content->display == 1)
					$item->caption .= $articlesList[$i]->introtext;
				if ($item->caption != '')
					$bodyHasCaptionContent = true;
				*/
				//Legend
				//if ($data->content->joomla_article->renderer->intro->legend->title->display == 1)
		//			$item->legend .= $articlesList[$i]->title;
				/*if ($data->content->joomla_article->renderer->intro->legend->author->display == 1)
					$item->legend .= $articlesList[$i]->author;
				if ($data->content->joomla_article->renderer->intro->legend->date->display == 1)
					$item->legend .= $articlesList[$i]->date;
				if ($data->content->joomla_article->renderer->intro->legend->content->display == 1){
					if ($data->content->joomla_article->renderer->intro->legend->content->size != 0)*/
						//$item->legend .= substr(strip_tags ($articlesList[$i]->introtext), 0, $data->content->joomla_article->renderer->intro->legend->content->size);
						
						if (isset($articlesList[$i]->images->image_intro) && $articlesList[$i]->images->image_intro != '')
						    $item->legend = substr(strip_tags ($articlesList[$i]->introtext), 0, 200) . '&nbsp;...';
						    //$item->legend = substr($articlesList[$i]->introtext, 0, strrpos(substr($articlesList[$i]->introtext, 0, 200), ' ')) . '&nbsp;...';
						
					/*else
						$item->legend .= $articlesList[$i]->introtext;
				}*/
				if ($item->legend != '')
					$thumbnailsHaveLegendContent = true;
				break;
			case 'full' :
				    $item->header->label = $articlesList[$i]->title;
				    $bodyHasHeaderContent = true;
				    $item->body = $articlesList[$i]->full;			    
				break;
		}
		
/*		if ($item->disabled != 1){ // Dont display current article (infinite recursive loop)
			//display in thumbnails mode (title, body, legend)
			$dataThumbnail = $data->body	; //General body properties
			$dataThumbnail->renderingMode = $data->rendering->mode;
			$dataThumbnail->content = $item;
			//$dataThumbnail->class =  implode("", $classThumbnail);
			$dataThumbnail->itemCount = $i;
			$dataThumbnail->id = $data->id;
	
			//$dataThumbnail->selector = '#part-' . $data->id . ' .body-header';
			$item->body = NGE::layout('nge.parts.panels.html.thumbnail_html', $dataThumbnail);
		}
		else
			$item->body = '';
*/		
		$items[] = $item;
		
	}
	
} else   
if ($data->content->source == 'custom') {	    
    //Custom content : input        
	for ($i = 0; $i < count($data->content->items); $i++) {
		$item = new stdClass(); //item content for each thumbnail

		//Header
		$item->header = new stdClass();
		$item->header->label = '';
		$item->header->glyph = new stdClass();
		$item->header->glyph->name = '';
		$item->badge = new stdClass();
		$item->badge->label = '';
		if ($data->content->items[$i]->header->label != ''){
			$item->header->label = $data->content->items[$i]->header->label;
			$thumbnailsHaveHeaderContent = true;
		}
		
		if ($data->content->items[$i]->header->glyph->name != ''){
			$item->header->glyph = $data->content->items[$i]->header->glyph; //Object
			$thumbnailsHaveHeaderContent = true;
			$thumbnailsHaveGlyph = true;
		}
		
		if ($data->content->items[$i]->badge->label != ''){
			$item->badge->label = $data->content->items[$i]->badge->label;
			$thumbnailsHaveBadgeContent = true;
		}
		
		if ($data->content->items[$i]->badge->glyph->name != ''){
			$item->badge->glyph = $data->content->items[$i]->badge->glyph;
			$thumbnailsHaveBadgeContent = true;
			$thumbnailsHaveGlyph = true;
		}
		
		
		//Legend
		$item->legend = '';
		
		//Source
		$item->source = $data->content->items[$i]->body->source;

		//Body panel
		switch ($data->content->items[$i]->body->source) {
			case 'html' :
				$item->body = $data->content->items[$i]->body->html;
				break;
			case 'url' :
				require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
				$item->body = UrlDriver::getContents($data->content->items[$i]->body->url);
				break;
			case 'query' :
				require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
				$item->body = NgeDatabaseDriver::loadSingle($data->content->items[$i]->body->query);
				break;
			case 'joomla.article' :
				require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
				$article = NgeJoomlaArticleDriver::load($data->content->items[$i]->body->joomla_article);
				$item->body = $article->introtext;
				break;
			case 'joomla.module' :
				require_once (NGEPATH_HELPERS . '/data/joomla/moduledriver.php');
				$item->body = NgeJoomlaModuleDriver::load($data->content->items[$i]->body->joomla_module);
				break;
			case 'image' : 
				//$item = $data->content->items[$i];
			    	$dataImages = $data->thumbnails->images;
				$class_img = NGE::layout('nge.parts.images.css.image_class', $dataImages);

				$imageContent = '	<div class="content_img">';
				$imageContent .= '	      <div>';

				if (isset($data->content->items[$i]->caption) && $data->content->items[$i]->caption->html != '') {
					$thumbnailsHaveCaptionContent	= true;
					$item->caption = $data->content->items[$i]->caption->html;
					$imageContent .= ' 	<div class="image_caption">';
					//$imageContent .= ' 		<div class="transparent"></div>';
					if ($data->rendering->mode == 'edit')
						$imageContent .= '			<div id="' . $part->data->id . '-caption" class="caption_value ngecontenteditableinline"  data-type="ngeeditor" data-property="caption.html">' . $data->content->items[$i]->caption->html . '</div>';
					else
						$imageContent .= '			<div class="caption_value" >' . $data->content->items[$i]->caption->html . '</div>';
					$imageContent .= ' 	</div>';
				}
				if ($data->rendering->mode == 'edit') {
					$xeditable_class = ' ngecontenteditable';
					$attributes = ' title="Image" data-type="image" data-property="image"';
				} else {
					$xeditable_class = '';
					$attributes = '';
				}
				$attributes .= ' style="width:100%;"'; 

				$imageContent .= '	          <img class="url_image' . $xeditable_class . $class_img . '"' . $attributes . ' src="' . NGE::url('root') . $data->content->items[$i]->body->image . '"/>';
		//		if (isset($data->image_hover) && ($data->image_hover != '')) {
		//			$imageContent .= '	      <img class="url_image_hover' . $classPopover . '" src="' . NGE::url('root') . $data->image_hover . '"/>';
		//		}
				$imageContent .= '	      </div>';
				$imageContent .= '	</div>';
				$item->body = $imageContent;
				//$item->caption = $data->content->items[$i]->caption->html;
				$item->legend = $data->content->items[$i]->legend;
				$thumbnailsHaveImageContent = true;
				break;				
			case 'video' : 
				$dataVideo = new stdClass();
				$dataVideo->id = $data->id;
				$dataVideo->content = $data->content->items[$i]->body->video;
				$dataVideo->rendering = $data->rendering;
				$item->body = NGE::layout('nge.parts.media.html.video_html', $dataVideo);
				$item->legend = $data->content->items[$i]->legend;
				$thumbnailsHaveVideoContent = true;
				break;
			default :
				$item->body = '';
		}
		
		//Hover panel
		switch ($data->content->items[$i]->hover->source) {
			case 'html' :
				$item->hover = $data->content->items[$i]->hover->html;
				break;
			case 'url' :
				require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
				$item->hover = UrlDriver::getContents($data->content->items[$i]->hover->url);
				break;
			case 'query' :
				require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
				$item->hover = NgeDatabaseDriver::loadSingle($data->content->items[$i]->hover->query);
				break;
			case 'joomla.article' :
				require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
				$article = NgeJoomlaArticleDriver::load($data->content->items[$i]->hover->joomla_article);
				$item->hover = $article->introtext;
				break;
			case 'joomla.module' :
				require_once (NGEPATH_HELPERS . '/data/joomla/moduledriver.php');
				$item->hover = NgeJoomlaModuleDriver::load($data->content->items[$i]->hover->joomla_module);
				break;
			case 'image' : 
				//$item = $data->content->items[$i];
			    	$dataImages = $data->thumbnails->images;
				$class_img = NGE::layout('nge.parts.images.css.image_class', $dataImages);

				$imageContent = '	<div class="content_img">';
				$imageContent .= '	      <div>';

				if (isset($data->content->items[$i]->caption) && $data->content->items[$i]->caption != '') {
					$thumbnailsHaveCaptionContent	= true;
					$item->caption = $data->content->items[$i]->caption;
					$imageContent .= ' 	<div class="image_caption">';
					//$imageContent .= ' 		<div class="transparent"></div>';
					if ($data->rendering->mode == 'edit')
						$imageContent .= '			<div id="' . $part->data->id . '-caption" class="caption_value ngecontenteditableinline"  data-type="ngeeditor" data-property="caption.html">' . $data->content->items[$i]->caption->html . '</div>';
					else
						$imageContent .= '			<div class="caption_value" >' . $data->content->items[$i]->caption->html . '</div>';
					$imageContent .= ' 	</div>';
				}
				if ($data->rendering->mode == 'edit') {
					$xeditable_class = ' ngecontenteditable';
					$attributes = ' title="Image" data-type="image" data-property="image"';
				} else {
					$xeditable_class = '';
					$attributes = '';
				}
				$attributes .= ' style="width:100%;"'; 

				$imageContent .= '	          <img class="url_image' . $xeditable_class . $class_img . '"' . $attributes . ' src="' . NGE::url('root') . $data->content->items[$i]->hover->image . '"/>';
		//		if (isset($data->image_hover) && ($data->image_hover != '')) {
		//			$imageContent .= '	      <img class="url_image_hover' . $classPopover . '" src="' . NGE::url('root') . $data->image_hover . '"/>';
		//		}
				$imageContent .= '	      </div>';
				$imageContent .= '	</div>';
				$item->hover = $imageContent;
				break;				
			case 'video' : 
				$dataVideo = new stdClass();
				$dataVideo->id = $data->id;
				$dataVideo->content = $data->content->items[$i]->hover->video;
				$dataVideo->rendering = $data->rendering;
				$item->hover = NGE::layout('nge.parts.media.html.video_html', $dataVideo);
				$thumbnailsHaveVideoContent = true;
				break;
			default :
				$item->hover = '';
		}
		if ($item->hover != '')
			$thumbnailsHaveHoverContent = true;
		
		
		//Custom width
		if (isset($data->content->items[$i]->width))
		    $item->width = $data->content->items[$i]->width;
		
		//Add item
		$items[] = $item;
		
	}		
			
	//Url link
	for ($i = 0; $i < count($items); $i++) {
		if (isset($data->content->items[$i]->link->type)) {
			switch ($data->content->items[$i]->link->type) {
				case 'url' :
					$items[$i]->link = $data->content->items[$i]->link->url;
					break;
				case 'document' :
					$items[$i]->link = NGE::url('root') .$data->content->items[$i]->link->document;
					break;
				case 'image' :
					$items[$i]->link = NGE::url('root') .$data->content->items[$i]->link->image;
					break;
				case 'file' :
					$items[$i]->link = NGE::url('root') .$data->content->items[$i]->link->file;
					break;
				case 'article' :
					$items[$i]->link = NGE::url('root') . 'index.php?option=com_content&view=article&id=' . $data->content->items[$i]->link->article;
					break;
				case 'menu' :
					require_once (NGEPATH_HELPERS . '/data/joomla/menudriver.php');
					$menu = NgeJoomlaMenuDriver::loadItem($data->content->items[$i]->link->menu);
					if (isset($menu)){
					    $link = $menu->route;
					    $items[$i]->link = NGE::url('root').'index.php/'.$link;        			    
					}
					else{
					    $items[$i]->link = NGE::url('root').'index.php';        
					    NGE::message('Warning : part '.$data->id.' menu item unknown', 'warning');
					}	
					break;
				case 'javascript' :
					$items[$i]->link = $data->content->items[$i]->link->javascript;
					break;
				case 'submit' :
					$items[$i]->link = 'jQuery( "form:first" ).submit();'; //TODO pouvoir indiquer un nom de formulaire
					break;
				default :
					$items[$i]->link = "";
			}

			//link on thumbnails if not already in cache
			if ($data->cache->css == '' || $data->cache->js == ''){
				if ($items[$i]->link != "") {
						$dataLink = new stdClass();
						$dataLink->selector = '#part-' . $data->id . ' div.thumbnail-container.thumbnail-container-' . $i;
						$dataLink->url = $items[$i]->link;
						$dataLink->type = $data->content->items[$i]->link->type;
						$dataLink->target = $data->content->items[$i]->link->target;
						$part->script[] = NGE::layout('nge.parts.panels.js.button_js', $dataLink);
						$part->style[] = '#part-' . $data->id . ' div.thumbnail-container.thumbnail-container-' . $i . '{
							cursor: pointer;
						}';
				}
			}
		}
	}

}
else{
    //print_r($data->content);
    //Loading plugin contents
    $dataSourceFilename = NGEPATH_CONTENTS . '/source/' . str_replace('.', '/', $data->content->source) . '/content.php';
    if (file_exists($dataSourceFilename)){			
	require_once $dataSourceFilename;
	$className = 'Nge' . implode('', array_map('ucfirst', explode('.', $data->content->source))) . 'Content';
	$source = str_replace('.', '/', $data->content->source);
	//WARNING : $data contains properties from the config screen. 
	//All content properties are not known because they can come from external content plugins
	//So we transmit unchanged all these properties as parameter of the loadList method (params)
	//$items = $className::loadThumbnailList($data->content->$source);
	$items = $className::getThumbnailsData($data);
	
	foreach ($items as $item){
	    if ($item->header->label !=''){
		$thumbnailsHaveHeaderContent = true;
		if (substr($item->header->label, 0, 2) == '<a')
		    $thumbnailsHaveHeaderLink = true;
	    }
	    if ($item->header->glyph->name !=''){
		$thumbnailsHaveHeaderContent = true;
		$thumbnailsHaveGlyph = true;
	    }
	    if ($item->caption != '') $thumbnailsHaveCaptionContent	= true;
	    if ($item->badge->label !='')	$thumbnailsHaveBadgeContent = true;
	    if ($item->legend != '')	$thumbnailsHaveLegendContent = true;
	    
	    $thumbnailsHaveLink = true;
	    
	    
	}
    }
}

//Class
$class = array();
$class[] = "part";

//Part display options
$class[] = NGE::layout('nge.parts.parts.display_class', $data);


/**** CSS ***********************************************************************/

//Cache
if ($data->cache->css == ''){
	$dataThumbnail = $data->thumbnails;
	$dataThumbnail->selector = '#part-' . $data->id;
	$part->style[] = NGE::layout('nge.parts.panels.css.thumbnails_css', $dataThumbnail);
    
	if ($data->thumbnails->width->mode == 'auto') {
		$data->thumbnails->width->mode = 'bootstrap';
		switch ($data->thumbnails->width->itemsbyrow) {
			case '1' :
				$data->thumbnails->width->bootstrap = 12;
				break;
			case '2' :
				$data->thumbnails->width->bootstrap = 6;
				break;
			case '3' :
				$data->thumbnails->width->bootstrap = 4;
				break;
			case '4' :
				$data->thumbnails->width->bootstrap = 3;
				break;
			case '6' :
				$data->thumbnails->width->bootstrap = 2;
				break;
			case '12' :
				$data->thumbnails->width->bootstrap = 1;
				break;
		}

		//spacing
		if ($data->thumbnails->spacing->mode != 'auto') {
			$horizontalSpacing = substr($data->thumbnails->spacing->horizontal, -1) == '%' ? substr($data->thumbnails->spacing->horizontal, 0, -1) : $data->thumbnails->spacing->horizontal;
			$totalSpacing = $horizontalSpacing * ((int) $data->thumbnails->width->itemsbyrow - 1);
			$thumbnailWidth = (100 - $totalSpacing) / $data->thumbnails->width->itemsbyrow;
			$part->style[] = '#part-' . $data->id . ' div.thumbnail-container {width:' . $thumbnailWidth . '%;margin-left:' . $horizontalSpacing . '%;}';
			$part->style[] = '#part-' . $data->id . ' div.thumbnail-container:first-child {margin-left:0px;}';

		}
	} else {
		$widthValue = is_numeric($data->thumbnails->width->value) ? $data->thumbnails->width->value . 'px' : $data->thumbnails->width->value;
		$marginWidthValue = is_numeric($data->thumbnails->spacing->horizontal) ? $data->thumbnails->spacing->horizontal . 'px' : $data->thumbnails->spacing->horizontal;
		$part->style[] = '#part-' . $data->id . ' div.thumbnail-container {width:' . $widthValue . '; margin-left : '.$marginWidthValue.';float:left;}';
		$part->style[] = '#part-' . $data->id . ' div.thumbnail-container:first-child {margin-left:0px;}';
	}

		// vertical spacing between thumbnails rows
		$part->style[] = '#part-' . $data->id . ' div.row-fluid {margin-top:' .$data->thumbnails->spacing->vertical. 'px;}';
		$part->style[] = '#part-' . $data->id . ' div.row-fluid:first-child { margin-top:0px}';
		
		
	if ($data->thumbnails->height->mode == 'custom'){
		$heightValue = is_numeric($data->thumbnails->height->value) ? $data->thumbnails->height->value . 'px' : $data->thumbnails->height->value;
		$part->style[] = '#part-' . $data->id . ' div.thumbnail-container {min-height:' . $heightValue . '}';		
	}
		
	if ($thumbnailsHaveHeaderContent == true) {
		//Header CSS    
		$dataHeader = $data->thumbnails->header;
		$dataHeader->selector = '#part-' . $data->id . ' .thumbnail-header';
		$part->style[] = NGE::layout('nge.parts.panels.css.header_css', $dataHeader);

		//Header Font CSS
		$dataHeaderFont = $data->thumbnails->header->font;
		if ($thumbnailsHaveHeaderLink){
		    $dataHeaderFont->selector = '#part-' . $data->id . ' .thumbnail-header .thumbnail_title a';
		    $part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataHeaderFont);
		    $part->style[] = $dataHeaderFont->selector . ', ' . $part->style[] = $dataHeaderFont->selector . ':hover{ text-decoration: none; }';
		}
		else {
		    $dataHeaderFont->selector = '#part-' . $data->id . ' .thumbnail-header .thumbnail_title';		
		    $part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataHeaderFont);		    
		}		

		//Header Border
		if ($data->thumbnails->header->border->style != "none") {
			$dataHeaderBorder = $data->thumbnails->header->border;
			$dataHeaderBorder->selector = '#part-' . $data->id . ' .thumbnail-header';
			$part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataHeaderBorder);
		}

		//Header Background CSS
		$dataHeaderBackground = $data->thumbnails->header->background;
		$dataHeaderBackground->selector = '#part-' . $data->id . ' .thumbnail-header';
		$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataHeaderBackground);

		//Header Icomoon CSS
		$dataHeaderIcomoon = $data->thumbnails->header->glyph;
		$dataHeaderIcomoon->selector = '#part-' . $data->id . ' .thumbnail-header .icomoon';
		$dataHeaderIcomoon->selector_hover = '#part-' . $data->id . ' .thumbnail-header:hover .icomoon';
		$part->style[] = NGE::layout('nge.parts.panels.css.icomoon_css', $dataHeaderIcomoon);


	}

	// ******** Tumbnail body CSS *************************************
	//Tumbnail Font
	if (isset($data->thumbnails->body->font) && ($data->thumbnails->body->font->style == 'custom')) {
		$dataFont = $data->thumbnails->body->font;
		$dataFont->selector = '#part-' . $data->id . ' div.thumbnail-container';
		$part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataFont);
	} 
	 
	//Tumbnail Border
	if ($data->thumbnails->body->border != "none") {
		$dataBorder = $data->thumbnails->body->border;
		$dataBorder->selector = '#part-' . $data->id . ' div.thumbnail-container';
		$part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataBorder);
	}

	//Tumbnail Background
	if ($data->thumbnails->body->background != "none") {
		$dataBackground = $data->thumbnails->body->background;
		$dataBackground->selector = '#part-' . $data->id . ' div.thumbnail-container';
		$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataBackground);
	}

	//Tumbnail Shadow
	if ($data->thumbnails->body->shadow->style != "none") {
		$dataShadow = $data->thumbnails->body->shadow;
		$dataShadow->selector = '#part-' . $data->id . ' div.thumbnail-container';
		$part->style[] = NGE::layout('nge.parts.panels.css.shadow_css', $dataShadow);
	}

	// ******** Hover panel *************************************
	//Hover panel Border
	/*if ($data->thumbnails->body_hover->border != "none") {
		$dataBorder = $data->thumbnails->body_hover->border;
		$dataBorder->selector = '#part-' . $data->id . ' div.thumbnail-container:hover';
		$part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataBorder);
	}

	//Hover panel Background
	if ($data->thumbnails->body_hover->background != "none") {
		$dataBackground = $data->thumbnails->body_hover->background;
		$dataBackground->selector = '#part-' . $data->id . ' div.thumbnail-body-hover';
		$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataBackground);
	}*/

	//Hover css
	if ($thumbnailsHaveHoverContent == true){
	    	$part->style[] = '#part-' . $data->id . ' div.hasHover .thumbnail-hover{display:none;}';
	    	$part->style[] = '#part-' . $data->id . ' div.hasHover:hover .thumbnail-body{display:none;}';
	    	$part->style[] = '#part-' . $data->id . ' div.hasHover:hover .thumbnail-hover{display:block}';
	}
	//Badge CSS
	if ($thumbnailsHaveBadgeContent == true){
	
		    //Badge CSS
		    $this->dataBadge = $data->thumbnails->badge;
		    $this->dataBadge->selector = '#part-' . $data->id . ' .part_badge';
		    $part->style[] = NGE::layout('nge.parts.panels.css.badge_css', $this->dataBadge);

		    //Badge Font CSS
		    if ($data->thumbnails->badge->font->style == 'custom') {
			    $this->dataBadgeFont = $data->thumbnails->badge->font;
			    $this->dataBadgeFont->selector = '#part-' . $data->id . ' .part_badge span';
			    $part->style[] = NGE::layout('nge.parts.text.css.font_css', $this->dataBadgeFont);
		    }

		    //Badge Border
		    if ($data->thumbnails->badge->border->style != "none") {
			    $this->dataBadgeBorder = $data->thumbnails->badge->border;
			    $this->dataBadgeBorder->selector = '#part-' . $data->id . ' .part_badge';
			    $part->style[] = NGE::layout('nge.parts.panels.css.border_css', $this->dataBadgeBorder);
		    }

		    //Badge Background CSS
		    if ($data->thumbnails->badge->background->style != "none") {
			    $this->dataBadgeBackground = $data->thumbnails->badge->background;
			    $this->dataBadgeBackground->selector = '#part-' . $data->id . ' .part_badge';
			    $part->style[] = NGE::layout('nge.parts.panels.css.background_css', $this->dataBadgeBackground);
		    }
		    //Badge Icomoon CSS
		    $this->dataBadgeIcomoon = $data->thumbnails->badge->glyph;
		    $this->dataBadgeIcomoon->selector = '#part-' . $data->id . ' .part_badge .icomoon';
		    $part->style[] = NGE::layout('nge.parts.panels.css.icomoon_css', $this->dataBadgeIcomoon);

		    //Badge display effects
		    if (isset($data->badge->effects) && count($data->badge->effects) > 0){
			foreach ($data->badge->effects as $effect){
			    if ($effect->type == 'display'){
				$dataEffect = $effect;
				$dataEffect->selector = '#part-' . $data->id . ' .part_badge';
				if (isset($data->selector_hover))
				    $dataEffect->selector_hover = '#part-' . $data->id . ':hover .part_badge';
				switch ($effect->action){
				    case 'show' :
					$part->style[] = NGE::layout('nge.parts.parts.effects.css.effects_display_show_css', $dataEffect);
					break;
				    case 'animate' :
					$part->style[] = NGE::layout('nge.parts.parts.effects.css.effects_display_animate_css', $dataEffect);
					break;
				    case 'hide' :
					$part->style[] = NGE::layout('nge.parts.parts.effects.css.effects_display_hide_css', $dataEffect);
					break;
				}
			    }
			}
		    }

		    $part->style[] = '#part-' . $data->id . ' .thumbnail-container {position:relative; }';
	}

	//Legend CSS
	if ($thumbnailsHaveLegendContent == true){

		$dataLegend = $data->thumbnails->legend;
		$dataLegend->selector = '#part-'.$data->id.' .thumbnail-legend';
		$part->style[] = NGE::layout('nge.parts.panels.css.legend_css', $dataLegend);
		//Font
		if ($data->thumbnails->legend->font->style == 'custom') {
			$dataLegendFont = $data->thumbnails->legend->font;
			$dataLegendFont->selector = '#part-' . $data->id . ' .thumbnail-legend';
			$part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataLegendFont);
		}
		//Border
		if ($data->thumbnails->legend->border->style != "none") {
			$dataLegendBorder = $data->thumbnails->legend->border;
			$dataLegendBorder->selector = '#part-' . $data->id . ' .thumbnail-legend';
			$part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataLegendBorder);
		}

		//background
		if ($data->thumbnails->legend->background->style != "none") {
			$dataLegendBackground = $data->thumbnails->legend->background;
			$dataLegendBackground->selector = '#part-' . $data->id . ' .thumbnail-legend';
			$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataLegendBackground);
		}	

	}

	//Caption CSS
	 if ($thumbnailsHaveCaptionContent == true){
		//Caption options and display
		$dataCaption = $data->thumbnails->caption;
		$dataCaption->selector = '#part-'.$data->id.' .image_caption';
		$dataCaption->selector_hover = '#part-'.$data->id.' .content_img:hover .image_caption';
		$part->style[] = NGE::layout('nge.parts.images.css.caption_css', $dataCaption);

		//Font
		if ($data->thumbnails->caption->font->style == 'custom') {
			$this->dataCaptionFont = $data->thumbnails->caption->font;
			$this->dataCaptionFont->selector = '#part-' . $data->id . ' .caption_value';
			$part->style[] = NGE::layout('nge.parts.text.css.font_css', $this->dataCaptionFont);
		}

		//Caption Border
		if ($data->thumbnails->caption->border->style != "none") {
			$dataCaptionBorder = $data->thumbnails->caption->border;
			$dataCaptionBorder->selector = '#part-' . $data->id . ' .image_caption';
			$part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataCaptionBorder);
		}

		//Caption background
		if ($data->thumbnails->caption->background->style != "none") {

			$dataCaptionBackground = $data->thumbnails->caption->background;
			$dataCaptionBackground->selector = '#part-' . $data->id . ' .content_img .image_caption';
			$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataCaptionBackground);
		}	

		//Effect
		if(isset($data->thumbnails->caption->effect) && ($data->thumbnails->caption->effect->trigger != "none") && ($data->thumbnails->caption->effect->style != "")){
			//NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'animate/css/animate.min.css');
			NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'animate/css/animate_teatis.css');		
			$dataEffect = $data->thumbnails->caption->effect;
			$dataEffect->selector = '#part-'.$data->id .  ' .image_caption';
			$part->style[] = NGE::layout('nge.parts.panels.css.animation_css', $dataEffect);
			$part->script[] = NGE::layout('nge.parts.panels.js.animation_js', $dataEffect);
		}

	 }
	 
	 //Blog image cropped
	$part->style[] = NGE::layout('nge.parts.images.css.imagecrop_css', $data);
	
	//Image shape
	if ($thumbnailsHaveImageContent == true){	    	    
	    if (isset($data->thumbnails->images->shape->style) && ($data->thumbnails->images->shape->style != "default")){
		    $dataShape = $data->thumbnails->images->shape;
		    //$dataShape->selector = $data->selector.' .url_image, ' . $data->selector.' .url_image_hover';
		    $dataShape->selector = $data->selector;
		    $part->style[] = JLayoutHelper::render('nge.parts.images.css.shape_css', $dataShape);
		    //todo call once only
		    $part->style[] = JLayoutHelper::render('nge.parts.images.css.imagecrop_css', $dataShape);
	    }
	}

	
		
}//if cache

/**** JS ************************************************************************/

//Cache
if ($data->cache->js == ''){
	$dataThumbnail = $data->thumbnails;
	$dataThumbnail->selector = '#part-' . $data->id;
	if ($data->rendering->mode != 'fastview')
	    $part->script[] = NGE::layout('nge.parts.panels.js.thumbnails_js', $dataThumbnail);
	
	//General display ******************************************************

	switch ($data->thumbnails->height->mode) {
		case 'maxheight' :
		case 'maxrowheight' :
			if ($data->rendering->mode != 'fastview') {
			    NgeContenthelper::addScript(NGEURL_MEDIA . 'jquery-match-height/jquery.matchHeight-min.js');
			    $rowHeight = $data->thumbnails->height->mode == "maxrowheight" ? 'true' : 'false';
//				$part->script[] = 'console.log(jQuery.type(matchHeight));';
			    $part->script[] = '
				onChangePartContent'.$data->id.' = function(){';			    
			    if ( $data->thumbnails->header->position == "top")
				$part->script[] = 'jQuery("#part-' . $data->id . ' .thumbnail-header").matchHeight(' . $rowHeight . ');';
			    $part->script[] = '				    
					jQuery("#part-' . $data->id . ' .thumbnail-image").matchHeight(' . $rowHeight . ');	
					jQuery("#part-' . $data->id . ' .thumbnail-container").matchHeight(' . $rowHeight . ');	
					jQuery("#part-' . $data->id . ' .thumbnail-legend").matchHeight(' . $rowHeight . ');
				};
				setTimeout(function () {
					onChangePartContent'.$data->id.'();					
				}, 10);';
			}
			break;
		case 'square' :
			$part->script[] = '
			var selector = jQuery("#part-' . $data->id . ' div.thumbnail-container");
			var width = selector.outerWidth();
			var height = selector.outerHeight();
			var height2 = selector.height();
			var padding = height - height2;
			var realHeight = width - padding;

			selector.height(realHeight);
		';
		break;
	}
		
	if ($thumbnailsHaveHeaderContent == true) {

		//Headers same height
		if ($data->rendering->mode != 'fastview')
		    NgeContenthelper::addScript(NGEURL_MEDIA . 'jquery-match-height/jquery.matchHeight-min.js');
		//If inserting dynamically in the page without preloaded library, loading the library
		//When dropping the new widget inside an existing page in frontend
		//$part->script[] = 'console.log(jQuery.type(matchHeight));';
	    /*$part->script[] = '	    if (typeof jQuery.matchHeight == "function") {
		    jQuery("head").append(\'<script type="text/javascript" src=""></script>\');
		}';
		//$("head").append('<script type="text/javascript" src="' + script + '"></script>');
		$part->script[] = 'jQuery("#part-' . $data->id . ' .thumbnail-header").matchHeight(true);';*/
	}
	
	if ($thumbnailsHaveVideoContent == true){
	    $part->script[] =  'jQuery(".js-player").click(function(){';
	    $part->script[] =  'var player = plyr.setup(this, {autoplay : true});';
	    $part->script[] =  '});';
	}
	
	if ($thumbnailsHaveGlyph == true){
		//Path libraries css
		NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'icomoon/icomoon-nge.css');	    
	}
	
	//List
	//NgeContenthelper::addScript(NGEURL_MEDIA . 'list/list.min.js');
	/*$html[] = '<input type="text" class="part-' . $data->id . '-search search" placeholder="Search" />';
	$part->script[] =  'patternListjs = new List("part-' . $data->id . '", {
		valueNames: [ "thumbnail_title" ]
	    });';	*/
	
	//Images crop
	$dataImage = new stdClass();
	$dataImage->selector = '#part-' . $data->id . ' .ngearticle img';
	$part->script[] = NGE::layout('nge.parts.images.js.imagecrop_js', $dataImage);	
	
	//Image shape
	if ($thumbnailsHaveImageContent == true){
	    if (isset($data->thumbnails->images->shape->style) && ($data->thumbnails->images->shape->style != "default")){		    		
		    $dataShape = $data->thumbnails->images->shape;
		    //$dataShape->selector = $data->selector.' .url_image, ' . $data->selector.' .url_image_hover';
		    $dataShape->selector = $data->selector;
		    $part->script[] = JLayoutHelper::render('nge.parts.images.js.shape_js', $dataShape);
	    }
	}	
	
}

if ($thumbnailsHaveVideoContent == true){
	    NgeContenthelper::addScript(NGEURL_MEDIA . 'plyr/plyr.js');
	    NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'plyr/plyr.css');
}


$classThumbnail = array();
//$classThumbnail[] = $data->thumbnails->width->mode == 'bootstrap' ? ' ' . NgeBootstrapTag::_('col-md-' . $data->thumbnails->width->bootstrap) : '';
//Detect stored content in 1.x version. It not will be editable
if (($data->rendering->mode == 'edit') && ($data->content->version != '1'))
    $classThumbnail[] = 'ngeelement';

$attributes = array();
//$attributes[] = ' id="part-'.$data->id.'"';
//$attributes[] = ' data-part="'.$data->name.'"';
//$attributes[] = ' data-part-label="'.NGE::translate($data->libraryTitle).'"';
//$attributes[] = ' class="'.implode(' ', $class).'"';
//General CSS *********************************************************************************


//Thumbnails headers CSS *********************************************************************************
$hasHeaderContent = false;
for ($i = 0; $i < count($items); $i++) {
	if (isset($items[$i]->header) && (isset($items[$i]->header->label) && ($items[$i]->header->label != ')') || (isset($items[$i]->header->label->glyph) && $items[$i]->header->glyph->name != ''))){
		$hasHeaderContent = true;
	}	
}

//Thumbnail HTML ********************************************************************
$divThumbnails = array();
$attributesRowDiv = array();
//Sortable if custom content and edit mode
//print_r($data->content->mode);
$thumbsSortable = (isset($data->content->mode) && ($data->content->mode == 'custom' || $data->content->mode == 'images') && $data->rendering->mode == 'edit') ? 'ngeinlinesortable ' : '';
//$thumbsSortable = '';
$thumbsAddable = ' ngeinlinesortable ngeaddableitems';
if (isset($data->content->source) && ($data->content->source == 'custom' || $data->content->source == 'joomla.articles')){
	$dataNge = 'data-nge=\'{"itemsmode": "content_' . str_replace('.', '_', $data->content->source) . '", "itemstype": "grid"}\'';
    }
    else
	$dataNge = '';
$attributesRowDiv[] = 'class="' . $thumbsSortable . $thumbsAddable . ' list row-fluid" ' . $dataNge;

if (is_numeric($data->thumbnails->spacing->vertical))
	$data->thumbnails->spacing->vertical .= 'px';
$itemInRow = 0;

//Kind of content for the multiple items element toolbar
if ($data->content->source == 'custom'){
    $itemsMode = '"itemsmode":"custom", ';
}
else
    $itemsMode = '';

$divThumbnails[] = '<div ' . implode($attributesRowDiv) . '>';
//if ($data->rendering->mode != 'fastview')
    $nbItems = count($items);
//else
  //  $nbItems = 1; //In fastview, rendering only first tab
for ($i = 0; $i <$nbItems; $i++) {

	//Starting new row
	if ($itemInRow == $data->thumbnails->width->itemsbyrow) {
		//In all margin modes, margin needs to be used
		$hspacing = $data->thumbnails->spacing->mode == 'auto' ? '20px' : $data->thumbnails->spacing->vertical;
		$divThumbnails[] = '</div><div ' . implode($attributesRowDiv) . ' style="margin-top:' . $hspacing . '">';
		$itemInRow = 0;
	}

	//$divThumbnails[] = '<a href="'.$dataLink[$i]->url.'"><div class="thumbnail-container thumbnail-container-'.$i.' '.implode("", $classThumbnail).'">';
	//$divThumbnails[] = '<div class="thumbnail-container thumbnail-container-' . $i . ' ' . implode("", $classThumbnail) . '">';
	//
	if (isset($items[$i]->width) && $items[$i]->width->mode == 'custom')
	    $thumbnailWidth = ' ' . NgeBootstrapTag::_('col-md-' . $items[$i]->width->value);
	else
	    $thumbnailWidth = ($data->thumbnails->width->mode == 'bootstrap' && isset($data->thumbnails->width->bootstrap)) ? ' ' . NgeBootstrapTag::_('col-md-' . $data->thumbnails->width->bootstrap) : '';
	
	//Detect stored content in 1.x version. It not will be editable
	if (($data->rendering->mode == 'edit') && ($data->content->version != '1'))
	    $attributesThumbnail = ' data-nge = \'{"title": "Thumbnail", "type": "xxxnge.multiple", ' . $itemsMode . '"source":"content.items.'.$i.'", "value":"'.$i.'"}\'';
	else
	    $attributesThumbnail = '';
		
	$dataThumbnail = $data->thumbnails; //General properties
	$dataThumbnail->renderingMode = $data->rendering->mode;
	//Detect stored content in 1.x version. It not will be editable
	$dataThumbnail->version = $data->content->version;
	$dataThumbnail->content = $items[$i];
	$dataThumbnail->class =  implode(" ", $classThumbnail) . $thumbnailWidth;
	$dataThumbnail->attributes =  $attributesThumbnail;
	$dataThumbnail->itemCount = $i;
	$dataThumbnail->id = $data->id;
	
	//$dataThumbnail->selector = '#part-' . $data->id . ' .body-header';
	$divThumbnails[] = NGE::layout('nge.parts.panels.html.thumbnail_html', $dataThumbnail);
	
	$itemInRow++;
}

$divThumbnails[] = '</div>';

$html[] = '<div id="part-' . $data->id . '-body">'; //first row, no margin-top
//Import style CSS & script JS
//if (count($style) != 0) 
//	$html[] = '<style>'.implode($style).'</style>'; 


$html[] = implode($divThumbnails);
//if (count($script) != 0)
//  $html[] = '<script>jQuery(function () {'.implode($script).'});</script>';
$html[] = '</div>';

//final rendering
//$part->content = 'ooooooooooooooooooo';
$part->content = implode($html);
echo $part->render();
