<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;
$data = $displayData;

function hex2rgb($hex) {
	$hex = str_replace("#", "", $hex);

	if(strlen($hex) == 3) {
		$r = hexdec(substr($hex,0,1).substr($hex,0,1));
		$g = hexdec(substr($hex,1,1).substr($hex,1,1));
		$b = hexdec(substr($hex,2,1).substr($hex,2,1));
	} else {
		$r = hexdec(substr($hex,0,2));
		$g = hexdec(substr($hex,2,2));
		$b = hexdec(substr($hex,4,2));
	}
	$rgb = array($r, $g, $b);
	//return implode(",", $rgb); // returns the rgb values separated by commas
	return $rgb; // returns an array with the rgb values
}

$caption_background_color = hex2rgb($data->backgroundcolor);

echo $data->selector; ?> {
	<?php 		
	switch ($data->verticalposition){
		case 'top' :
			echo 'height:'.round($data->verticalheight - max($data->verticalheight + $data->verticalmargin - 100, 0)).'%;';
			echo 'top:'.$data->verticalmargin.'%;';
			break;
		case 'middle' :
			echo 'height:'.$data->verticalheight.'%;';
			echo 'top:'.round((100-$data->verticalheight)/2).'%;';
			break;
		case 'bottom' :
			echo 'height:'.round($data->verticalheight - max($data->verticalheight + $data->verticalmargin - 100, 0)).'%;';
			echo 'top:'.max(100 - $data->verticalheight - $data->verticalmargin, 0).'%;';
			break;
		case 'full' :
			echo 'height:100%;';
			echo 'top:0;';
			break;
	}
	
	switch ($data->horizontalposition){
		case 'left' :
			echo 'width:'.round($data->horizontalwidth - max($data->horizontalwidth + $data->horizontalmargin - 100, 0)).'%;';
			echo 'left:'.$data->horizontalmargin.'%;';				
			break;
		case 'center' :
			echo 'width:'.$data->horizontalwidth.'%;';
			echo 'left:'.round((100-$data->horizontalwidth)/2).'%;';				
			break;
		case 'right' : 
			echo 'width:'.round($data->horizontalwidth - max($data->horizontalwidth + $data->horizontalmargin - 100, 0)).'%;';
			echo 'left:'.max(100 - $data->horizontalwidth - $data->horizontalmargin, 0).'%;';
			break;
		case 'full' : 
			echo 'width:100%;';
			echo 'left:0;';
			break;
	}
 ?>
	position: absolute;
	<?php echo "background: rgba(".$caption_background_color[0].", ".$caption_background_color[1].", ".$caption_background_color[1].", ".($data->opacity/100).")"; ?>;
}
<?php echo $data->selector; ?> div.bx-caption >span { 
	<?php echo 'color: '.$data->color; ?>;
}
