<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

$data = $displayData;

//Presets
switch ($data->style){
	case 'circle' :
	case 'class' :
		$data->shape = 'circle';
		$data->size = '8';
		$data->spacing = '15';
		$data->margin = '16';
		$data->background->color = '#666666';
		$data->background->color_hover = '#dddddd';
		$data->background->color_active = '#ffffff';		
		$data->border->width = '1';
		$data->border->color = '#888888';
		$data->border->color_active = '#aaaaaa';
		break;

	case 'square' :
		$data->shape = 'square';
		$data->size = '8';
		$data->spacing = '15';
		$data->margin = '16';
		$data->background->color = '#666666';
		$data->background->color_hover = '#eeeeee';
		$data->background->color_active = '#ffffff';
		$data->border->width = '1';
		$data->border->color = '#888888';
		$data->border->color_active = '#aaaaaa';
		break;
}

?>

            <?php echo $data->selector; ?> {position: absolute;
	    <?php
	    
	    //Display
	    if ($data->display == 'hover'){
		//echo 'display:none!important;';
		echo 'opacity : 0;';
		echo '-webkit-transition: opacity 0.25s ease-in-out;';
		echo 'transition: opacity 0.25s ease-in-out;';
	    }
	    
	    //bullets position	
	switch($data->position){
		case "outsidetop" :
			echo 'top : -' . (int) ($data->size + $data->margin) . 'px;';
			break;
		case "top" :
			echo 'top : ' . $data->margin . 'px;';
			break;
		case "middle" :
		    	echo 'top : 50%;';			
			break;
		case "bottom" :
		    	echo 'top : auto;';			
			echo 'bottom : ' . $data->margin . 'px;';
			break;
		case "outsidebottom" :
			break;
	}
	if ($data->orientation != 'vertical')
	switch($data->align){
		case "left" :
			echo 'text-align:left;';
		    	echo 'left : ' . $data->margin . 'px;';
			break;
		case "right" :
			echo 'text-align:right;';
			echo 'right : ' . $data->margin . 'px;';
			break;
		default :
			echo 'width : 100%;';
			break;
	}
	    ?>
	    }
	    
	    <?php
	    if ($data->display == 'hover')
		echo $data->selector_hover . ' { opacity: 1;}';
		//echo $data->selector_hover . ' { display:block!important;}';
	    
	    
	    if ($data->position == 'middle'){	    
		echo $data->selector . ' li {
		    webkit-transform: translate(0, -50%);
		    -ms-transform: translate(0, -50%);
		    transform: translate(0, -50%);
		}';	
	    }
	    
	echo $data->selector; ?> li button:hover{
				<?php
				if ($data->background->color_hover != '')
					echo 'background-color: '.$data->background->color_hover . ';';
				if ($data->border->color_hover != '')
					echo 'border-color: '.$data->border->color_hover . ';';
				?>
            }
		<?php echo $data->selector; ?> li.slick-active button{
				<?php
				if ($data->background->color_active != '')
					echo 'background-color: '.$data->background->color_active . ';';
				if ($data->border->color_active != '')
					echo 'border-color: '.$data->border->color_active . ';';

				?>

		}
		
		<?php 
		echo $data->selector . ' li {
		    width: '.$data->size.'px;
		    height: '.$data->size.'px;';
		
		//Orientation
		if ($data->orientation == 'vertical'){
		    echo 'display: block;';
		    echo 'margin-top : ' .$data->spacing/2 . 'px;';
		    echo 'margin-bottom : ' .$data->spacing/2 . 'px;';
		    
		}
		else {
		    echo 'margin-left : ' .$data->spacing/2 . 'px;';
		    echo 'margin-right : ' .$data->spacing/2 . 'px;';		    
		}
		echo '}';
		?>
		
		<?php echo $data->selector; ?> li button::before { 
		display:none;}
		
            <?php echo $data->selector; ?> li button { 
		position: absolute;
                overflow: hidden;
                cursor: pointer;
		<?php
			echo 'background-color: '.$data->background->color . ';';
			echo 'filter: alpha(opacity='.$data->background->opacity.');';
			echo 'opacity: '.$data->background->opacity/100 . ';';
			echo 'border: '.$data->border->color.' '.$data->border->width.'px solid;';							
		switch ($data->shape){
			case 'circle' :
				echo 'width: '.$data->size.'px;';
				echo 'height: '.$data->size.'px;';
				echo '-moz-border-radius: ' .  $data->size . 'px;';
				echo '-webkit-border-radius: ' .  $data->size . 'px;';
				echo 'border-radius: ' .  $data->size . 'px;';				
				break;
			case 'square' :
				echo 'width: '.$data->size.'px;';
				echo 'height: '.$data->size.'px;';
				break;
			case 'rectangle' :
				echo 'width: '. (string)$data->size*1.5 . 'px;';
				echo 'height: '.$data->size.'px;';
				break;
			case 'parallelogram' :
				echo 'width: '. (string)$data->size*1.5 . 'px;';
				echo 'height: '.$data->size.'px;';
				echo '-webkit-transform: skew(-20deg);';
				echo '-moz-transform: skew(-20deg);';
				echo '-o-transform: skew(-20deg);';
				break;
		}
?>
}