<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

 $data = $displayData;
 
/**
 * @package     NextGenEditor
 * @author       Teatis {www/teatis.com }
 *
 * @copyright   Copyright (C) 2015 Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

 
 /*************************** PRESETS *****************************************/
 
//Presets
switch ($data->style){
	case 'circle' :
	case 'class' :
		$data->arrow->shape = 'chevron';		
		$data->arrow->width = '10';
		$data->arrow->height = '12';
		$data->arrow->thickness = '4';
		$data->background->shape = 'circle';
		$data->background->width = '28';
		$data->background->color = '#333';
		$data->background->color_hover = '';
		$data->background->opacity = 100;
		$data->background->border->width = '2';				
		if ($data->content->mode == 'images'){
		    $data->arrow->color = '#ffffff';
		    $data->background->border->color = '#ffffff';
		    $data->background->border->color_hover = '';
		}
		else { //Text
		    $data->arrow->color = '#666666';
		    $data->background->border->color = '#666666';
		    $data->background->border->color_hover = '';
		}		
		break;
	case 'square' :
		$data->arrow->shape = 'triangle';
		$data->arrow->color = '#ffffff';
		$data->arrow->width = '10';
		$data->arrow->height = '15';
		$data->arrow->thickness = '5';
		$data->background->shape = 'square';
		$data->background->width = '36';
		$data->background->color = '#333';
		$data->background->color_hover = '#000';
		$data->background->opacity = 50;
		$data->background->border->width = 0;
		break;
	case 'square' :
		$data->positions->vertical->position = 'middle';
		$data->positions->margin = '0';
		$data->arrow->shape = 'chevron';
		$data->arrow->color = '#ffffff';
		$data->arrow->width = '15';
		$data->arrow->height = '20';
		$data->arrow->thickness = '6';
		$data->background->shape = 'square';
		$data->background->width = '47';
		$data->background->color = '#e34b24';
		$data->background->color_hover = '#70c4e0';
		$data->background->opacity = 100;
		$data->background->border->width = 0;
		break;
	    
	case 'chevron' :
		$data->arrow->shape = 'chevron';
		$data->arrow->color = '#ffffff';
		$data->arrow->color_hover = '#ffffff';
		$data->arrow->width = '20';
		$data->arrow->height = '50';
		$data->arrow->thickness = '4';
		$data->size = '10';
		$data->border->width = 0;
		$data->background->shape = 'rectangle';
		$data->background->size = '36';
		$data->background->width = '20';
		$data->background->height = '80';
		$data->background->color = '';
		$data->background->opacity = 100;
		$data->background->border->width = 0;
		break;
}
 
/*************************** GENERAL *****************************************/
	    echo $data->selector .'-arrow-prev, ' . $data->selector .'-arrow-next{';
		if ($data->display == 'hover'){
		    echo 'opacity : 0;';
		    echo '-webkit-transition: opacity 0.25s ease-in-out;';
		    echo 'transition: opacity 0.25s ease-in-out;';
		}
		echo 'cursor:pointer;'
		. 'position:absolute;'
		. 'overflow:hidden;';
		echo 'z-index:10;';
	    echo '}';

	    if ($data->display == 'hover'){
		echo $data->selector .'-panel:hover ' . $data->selector .'-arrow-prev, ' .$data->selector .'-panel:hover ' . $data->selector .'-arrow-next{';
		echo 'opacity: '.$data->background->opacity/100 . ';';
	    echo '}';
	    }
	    
	    
	    
 /*************************** POSITION *****************************************/
 	/* Horizontal */	
	    echo $data->selector .'-arrow-prev {';
	    if ($data->positions->horizontal->position == 'inside'){
		echo 'left : ' . $data->positions->horizontal->margin . 'px;';
	    }
	    echo '}';
	    echo $data->selector .'-arrow-next {';
	    if ($data->positions->horizontal->position == 'inside'){
		echo 'right : ' . $data->positions->horizontal->margin . 'px;';
	    }
	    else {
		echo 'right : 0px;';
	    }
	    echo '}';
	    
	    echo $data->selector .'-arrow-prev span, ' . $data->selector .'-arrow-next span{';
		echo 'position:absolute;';
	    echo '}';
	    
	    
	    /* Vertical */
	    echo $data->selector .'-arrow-prev, ' . $data->selector .'-arrow-next {';
	    switch ($data->positions->vertical->position){
		case 'top' : 
		    echo 'top : ' . $data->positions->vertical->margin . 'px;';
		    echo 'bottom : auto;';
		break;
		case 'middle' : 
		    echo 'top : 50%;';
		break;
		case 'bottom' : 
		    echo 'top : auto;';
		    echo 'bottom : ' . $data->positions->vertical->margin . 'px;';
		break;
	    }
	    echo '}';

/***************** ARROW SHAPE ******************************************************/
	    
	    
	//Arrow
		//If circle or square, only width value is used.
		if (in_array($data->background->shape, array('circle', 'square')))
			$data->background->height = 	$data->background->width;
				
		switch ($data->arrow->shape){

			case 'chevron' :
				//Left
				echo $data->selector.'-arrow-prev span{
				height: '.$data->arrow->height.'px;
				width: '.(string)($data->arrow->width) .'px;
				margin-left:'.(string)($data->background->width - $data->arrow->width)/2 .'px;
				margin-top:'.(string)($data->background->height - $data->arrow->height)/2 .'px;
				left:0px;
				}';
				//Width is at least thickness
				$data->arrow->width = max($data->arrow->width, $data->arrow->thickness);
				$skewDegrees = rad2deg(atan(($data->arrow->width-$data->arrow->thickness) *2/ $data->arrow->height));
				
				echo $data->selector.'-arrow-prev span:before{
				content: "";
				position: absolute;
				top: 0;
				left: '.(string)($data->arrow->width - $data->arrow->thickness)/2 .'px;
				height: 50%;
				width: '.(string)$data->arrow->thickness .'px;
				background: '.$data->arrow->color.';
				-webkit-transform: skew(-'.$skewDegrees.'deg, 0deg);
				-moz-transform: skew(-'.$skewDegrees.'deg, 0deg);
				-ms-transform: skew(-'.$skewDegrees.'deg, 0deg);
				-o-transform: skew(-'.$skewDegrees.'deg, 0deg);
				transform: skew(-'.$skewDegrees.'deg, 0deg);
				}';
				echo $data->selector.'-arrow-prev span:after{
  				content: "";
  				position: absolute;
  				top: 50%;
   				left: '.(string)($data->arrow->width - $data->arrow->thickness)/2 .'px;
				right: 0;
  				height: 50%;
  				width: '.(string)$data->arrow->thickness .'px;
  				background: '.$data->arrow->color.';
  				-webkit-transform: skew('.$skewDegrees.'deg, 0deg);
  				-moz-transform: skew('.$skewDegrees.'deg, 0deg);
  				-ms-transform: skew('.$skewDegrees.'deg, 0deg);
  				-o-transform: skew('.$skewDegrees.'deg, 0deg);
  				transform: skew('.$skewDegrees.'deg, 0deg);
				}';
				
				//Right
				echo $data->selector.'-arrow-next span{
				height: '.$data->arrow->height.'px;
  				width: '.(string)($data->arrow->width) .'px;
  				margin-left:'.(string)($data->background->width - $data->arrow->width)/2 .'px;
  				margin-top:'.(string)($data->background->height - $data->arrow->height)/2 .'px;
	  				/*left:0px;*/
				}';
				echo $data->selector.'-arrow-next span:before{
  				content: "";
  				position: absolute;
  				top: 0;
   				/*left: '.(string)($data->arrow->width - $data->arrow->thickness)/2 .'px;
  				right: 0;*/
  				right: '.(string)($data->arrow->width - $data->arrow->thickness)/2 .'px;
  				height: 50%;
  				width: '.(string)$data->arrow->thickness .'px;
  				background: '.$data->arrow->color.';
  				-webkit-transform: skew('.$skewDegrees.'deg, 0deg);
  				-moz-transform: skew('.$skewDegrees.'deg, 0deg);
  				-ms-transform: skew('.$skewDegrees.'deg, 0deg);
  				-o-transform: skew('.$skewDegrees.'deg, 0deg);
  				transform: skew('.$skewDegrees.'deg, 0deg);
				}';
				echo $data->selector.'-arrow-next span:after{
  				content: "";
  				position: absolute;
  				top: 50%;
  				/*left: '.(string)($data->arrow->width - $data->arrow->thickness)/2 .'px;*/
  				right: '.(string)($data->arrow->width - $data->arrow->thickness)/2 .'px;
  				height: 50%;
  				width: '.(string)$data->arrow->thickness .'px;
  				background: '.$data->arrow->color.';
  				-webkit-transform: skew(-'.$skewDegrees.'deg, 0deg);
  				-moz-transform: skew(-'.$skewDegrees.'deg, 0deg);
  				-ms-transform: skew(-'.$skewDegrees.'deg, 0deg);
  				-o-transform: skew(-'.$skewDegrees.'deg, 0deg);
  				transform: skew(-'.$skewDegrees.'deg, 0deg);
				}';

				break;
			case 'arrow' :
				//Left
				echo $data->selector.'-arrow-prev span{
				height: '.$data->arrow->height.'px;
				width: '.(string)($data->arrow->width) .'px;
				margin-left:'.(string)($data->background->width - $data->arrow->width)/2 .'px;
				margin-top:'.(string)($data->background->height - $data->arrow->height)/2 .'px;
				left:0px;
				/*background-color:#00FF00;*/
				}';
				//Width is at least thickness
				$data->arrow->width = max($data->arrow->width, $data->arrow->thickness);
				$skewDegrees = rad2deg(atan(($data->arrow->width-$data->arrow->thickness) *2/ $data->arrow->height));
				
				echo $data->selector.'-arrow-prev span:before{
				content: "";
				position: absolute;
				top: 0;
				left: '.(string)($data->arrow->width - $data->arrow->thickness)/2 .'px;
				height: 50%;
				width: '.(string)$data->arrow->thickness .'px;
				background: '.$data->arrow->color.';
				-webkit-transform: skew(-'.$skewDegrees.'deg, 0deg);
				-moz-transform: skew(-'.$skewDegrees.'deg, 0deg);
				-ms-transform: skew(-'.$skewDegrees.'deg, 0deg);
				-o-transform: skew(-'.$skewDegrees.'deg, 0deg);
				transform: skew(-'.$skewDegrees.'deg, 0deg);
				}';
				echo $data->selector.'-arrow-prev span:after{
  				content: "";
  				position: absolute;
  				top: 50%;
   				left: '.(string)($data->arrow->width - $data->arrow->thickness)/2 .'px;
				right: 0;
  				height: 50%;
  				width: '.(string)$data->arrow->thickness .'px;
  				background: '.$data->arrow->color.';
  				-webkit-transform: skew('.$skewDegrees.'deg, 0deg);
  				-moz-transform: skew('.$skewDegrees.'deg, 0deg);
  				-ms-transform: skew('.$skewDegrees.'deg, 0deg);
  				-o-transform: skew('.$skewDegrees.'deg, 0deg);
  				transform: skew('.$skewDegrees.'deg, 0deg);
				}';
				
				//Right
				echo $data->selector.'-arrow-next span{
				height: '.$data->arrow->height.'px;
  				width: '.(string)($data->arrow->width) .'px;
  				margin-left:'.(string)($data->background->width - $data->arrow->width)/2 .'px;
  				margin-top:'.(string)($data->background->height - $data->arrow->height)/2 .'px;
	  				/*left:0px;*/
				}';
				echo $data->selector.'-arrow-next span:before{
  				content: "";
  				position: absolute;
  				top: 0;
   				left: '.(string)($data->arrow->width - $data->arrow->thickness)/2 .'px;
  				right: 0;
  				height: 50%;
  				width: '.(string)$data->arrow->thickness .'px;
  				background: '.$data->arrow->color.';
  				-webkit-transform: skew('.$skewDegrees.'deg, 0deg);
  				-moz-transform: skew('.$skewDegrees.'deg, 0deg);
  				-ms-transform: skew('.$skewDegrees.'deg, 0deg);
  				-o-transform: skew('.$skewDegrees.'deg, 0deg);
  				transform: skew('.$skewDegrees.'deg, 0deg);
				}';
				echo $data->selector.'-arrow-next span:after{
  				content: "";
  				position: absolute;
  				top: 50%;
  				left: '.(string)($data->arrow->width - $data->arrow->thickness)/2 .'px;
  				height: 50%;
  				width: '.(string)$data->arrow->thickness .'px;
  				background: '.$data->arrow->color.';
  				-webkit-transform: skew(-'.$skewDegrees.'deg, 0deg);
  				-moz-transform: skew(-'.$skewDegrees.'deg, 0deg);
  				-ms-transform: skew(-'.$skewDegrees.'deg, 0deg);
  				-o-transform: skew(-'.$skewDegrees.'deg, 0deg);
  				transform: skew(-'.$skewDegrees.'deg, 0deg);
				}';

				break;
			case 'triangle' :	
				echo $data->selector.'-arrow-prev span{';
				echo 'top: ' . (string) ($data->background->height-$data->arrow->width*1.3)/2 . 'px;';
				echo 'left: ' . (string) ($data->background->width-$data->arrow->width*1.05)/2 . 'px;';
				echo 'width: 0;';
				echo 'height: 0;';
				echo 'border-top: '.(string)$data->arrow->width/1.5 . 'px solid transparent;';
				echo 'border-right: '.$data->arrow->width . 'px solid '.$data->arrow->color.';';
				echo 'border-bottom: '.(string)$data->arrow->width/1.5 . 'px solid transparent;';
				echo '}';
				echo $data->selector.'-arrow-next span{';
				echo 'top: ' . (string) ($data->background->height-$data->arrow->width*1.3)/2 . 'px;';
				echo 'right: ' . (string) ($data->background->width-$data->arrow->width*1.05)/2 . 'px;';
				echo 'width: 0;';
				echo 'height: 0;';
				echo 'border-top: '.(string)$data->arrow->width/1.5 . 'px solid transparent;';
				echo 'border-left: '.$data->arrow->width . 'px solid '.$data->arrow->color.';';
				echo 'border-bottom: '.(string)$data->arrow->width/1.5 . 'px solid transparent;';
				echo '}';
				break;
		}
						    
		
/********************** ARROW BACKGROUND **************************************/
				
		//Background			
		echo $data->selector.'-arrow-prev, '.$data->selector.'-arrow-next{';
			if ($data->background->color != '')
				echo 'background-color: '.$data->background->color . ';';
			if ($data->display == 'always'){ //See on hover with fade effect
			    echo 'filter: alpha(opacity='.$data->background->opacity.');';
			    echo 'opacity: '.$data->background->opacity/100 . ';';			    
			}
			echo 'border: '.$data->background->border->color.' '.$data->background->border->width.'px solid;';

		switch ($data->background->shape){
			case 'circle' :				
				echo 'width: '.$data->background->width.'px;';
				echo 'height: '.$data->background->width.'px;';
				echo '-moz-border-radius: '.$data->background->width . 'px;';
				echo '-webkit-border-radius: '.$data->background->width . 'px;';
				echo 'border-radius: ' . $data->background->width . 'px;';		
				break;
			case 'square' :
				echo 'width: '.$data->background->width.'px;';
				echo 'height: '.$data->background->width.'px;';
				break;
			case 'rectangle' :
				echo 'width: '.$data->background->width.'px;';
				echo 'height: '.$data->background->height.'px;';
				break;
		}
		echo '}';
		
/************************ HOVER ***************************************/
		if ($data->style == 'custom')
				echo $data->selector.'-arrow-prev:hover span:before, ' . $data->selector.'-arrow-prev:hover span:after, ' .
				    $data->selector.'-arrow-next:hover span:before, ' . $data->selector.'-arrow-next:hover span:after{
				    background: '.$data->arrow->color_hover.';
					}';
		
		//Hover
		if ($data->arrow->color_hover != ''){
//			echo $data->selector.'-arrow-prev:hover .jssora01larrow:before .jssora01larrow:after, '.$data->selector.' .jssora01r:hover-arrow-next:before-arrow-next:after, '.$data->selector.' .jssora01ldn:hover, '.$data->selector.' .jssora01rdn:hover{';
			echo $data->selector.'-arrow-prev:hover, '.$data->selector.'-arrow-next:hover{';
			if ($data->arrow->color_hover != '')
				echo 'background-color: '.$data->arrow->color_hover . ';';
			echo '}';
		}

		if (($data->background->color_hover != '') || ($data->background->border->color_hover != '')){
			echo $data->selector.'-arrow-prev:hover, '.$data->selector.'-arrow-next:hover{';
			if ($data->background->color_hover != '')
				echo 'background-color: '.$data->background->color_hover . ';';
			if ($data->background->border->color_hover != '')
				echo 'border: '.$data->background->border->color_hover.' '.$data->background->border->width.'px solid;';
			echo '}';
		}
