<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;
 
/* http://cssdeck.com/labs/different-css3-box-shadows-effects */
/* http://css-tricks.com/examples/CSS3Gradient/ */

$data = $displayData;
echo $data->selector.':before,'.
$data->selector.':after {
	content:"";
	position:absolute;
	z-index:-2;
}';

if (($data->display == 'always') || ($data->display == 'hover')){
	$hover = ($data->display == 'hover') ? ':hover' : '';
    
	switch ($data->style){
		case 'light' :
			echo $data->selector.$hover.'{
			box-shadow: 0px 2px 10px -2px #888888;
			}';
			break;
		case 'blur' :
			echo $data->selector.$hover.'{
			box-shadow: 0px 2px 10px -2px #888888;
			}';
			break;
		case 'bottom' :
			echo $data->selector.$hover.'{	
			-webkit-box-shadow: 0 10px 6px -6px #777;
			-moz-box-shadow: 0 10px 6px -6px #777;
			box-shadow: 0 10px 6px -6px #777;
			}';
			break;
		case 'lifted' :
			echo $data->selector.$hover.'{	
			position: relative;
			}';
			echo $data->selector.$hover.':before, '.$data->selector.$hover.':after{
			z-index: -1;
  			position: absolute;
  			content: "";
  			bottom: 15px;
  			left: 10px;
  			width: 50%;
  			top: 80%;
  			max-width:300px;
  			background: #777;
  			-webkit-box-shadow: 0 15px 10px #777;
  			-moz-box-shadow: 0 15px 10px #777;
  			box-shadow: 0 15px 10px #777;
  			-webkit-transform: rotate(-3deg);
  			-moz-transform: rotate(-3deg);
  			-o-transform: rotate(-3deg);
  			-ms-transform: rotate(-3deg);
  			transform: rotate(-3deg);
			}';
			echo $data->selector.$hover.':after{
  			-webkit-transform: rotate(3deg);
  			-moz-transform: rotate(3deg);
  			-o-transform: rotate(3deg);
  			-ms-transform: rotate(3deg);
  			transform: rotate(3deg);
  			right: 10px;
  			left: auto;
			}';
			break;
		case 'leftcorner' :
			echo $data->selector.$hover.'{	
			position: relative;
			}';
			echo $data->selector.$hover.':before	{
  			z-index: -1;
  			position: absolute;
  			content: "";
  			bottom: 15px;
  			left: 10px;
  			width: 50%;
  			top: 80%;
  			max-width:300px;
  			background: #777;
  			-webkit-box-shadow: 0 15px 10px #777;
  			-moz-box-shadow: 0 15px 10px #777;
  			box-shadow: 0 15px 10px #777;
  			-webkit-transform: rotate(-3deg);
  			-moz-transform: rotate(-3deg);
  			-o-transform: rotate(-3deg);
  			-ms-transform: rotate(-3deg);
  			transform: rotate(-3deg);
			}';
			break;
		case 'rightcorner' :
			echo $data->selector.$hover.'{	
			position: relative;
			}';
			echo $data->selector.$hover.':after{
  			z-index: -1;
  			position: absolute;
  			content: "";
  			bottom: 15px;
  			right: 10px;
  			left: auto;
  			width: 50%;
  			top: 80%;
  			max-width:300px;
  			background: #777;
  			-webkit-box-shadow: 0 15px 10px #777;
  			-moz-box-shadow: 0 15px 10px #777;
  			box-shadow: 0 15px 10px #777;
  			-webkit-transform: rotate(3deg);
  			-moz-transform: rotate(3deg);
  			-o-transform: rotate(3deg);
  			-ms-transform: rotate(3deg);
  			transform: rotate(3deg);
			}';
			break;
		case 'liftedbig' :
			echo $data->selector.$hover.'{	
			position: relative;
			}';
			echo $data->selector.$hover.':before, '.$data->selector.$hover.':after{
  			z-index: -1;
  			position: absolute;
  			content: "";
  			bottom: 25px;
  			left: 10px;
  			width: 50%;
  			top: 80%;
  			max-width:300px;
  			background: #777;
  			-webkit-box-shadow: 0 35px 20px #777;
  			-moz-box-shadow: 0 35px 20px #777;
  			box-shadow: 0 35px 20px #777;
  			-webkit-transform: rotate(-8deg);
  			-moz-transform: rotate(-8deg);
  			-o-transform: rotate(-8deg);
  			-ms-transform: rotate(-8deg);
  			transform: rotate(-8deg);
			}';
			echo $data->selector.$hover.':after			{
  			-webkit-transform: rotate(8deg);
  			-moz-transform: rotate(8deg);
  			-o-transform: rotate(8deg);
  			-ms-transform: rotate(8deg);
  			transform: rotate(8deg);
  			right: 10px;
  			left: auto;
			}';
			break;
		case 'horizontalcurve' :
			echo $data->selector.$hover.'{	
			position:relative;       
    			-webkit-box-shadow:0 1px 4px rgba(0, 0, 0, 0.3), 0 0 40px rgba(0, 0, 0, 0.1) inset;
       			-moz-box-shadow:0 1px 4px rgba(0, 0, 0, 0.3), 0 0 40px rgba(0, 0, 0, 0.1) inset;
            		box-shadow:0 1px 4px rgba(0, 0, 0, 0.3), 0 0 40px rgba(0, 0, 0, 0.1) inset;
			}';
			echo $data->selector.$hover.':before, '.$data->selector.$hover.':after{
			content:"";
    			position:absolute; 
    			z-index:-1;
    			-webkit-box-shadow:0 0 20px rgba(0,0,0,0.8);
    			-moz-box-shadow:0 0 20px rgba(0,0,0,0.8);
    			box-shadow:0 0 20px rgba(0,0,0,0.8);
    			top:50%;
    			bottom:0;
    			left:10px;
    			right:10px;
    			-moz-border-radius:100px / 10px;
    			border-radius:100px / 10px;
			}'; 
			echo $data->selector.$hover.':after{
			right:10px; 
			left:auto;
			-webkit-transform:skew(8deg) rotate(3deg); 
			-moz-transform:skew(8deg) rotate(3deg);     
			-ms-transform:skew(8deg) rotate(3deg);     
			-o-transform:skew(8deg) rotate(3deg); 
			transform:skew(8deg) rotate(3deg);
			}';
			break;
		case 'horizontalcurves' :
			echo $data->selector.$hover.'{	
  			position:relative;       
    			-webkit-box-shadow:0 1px 4px rgba(0, 0, 0, 0.3), 0 0 40px rgba(0, 0, 0, 0.1) inset;
       			-moz-box-shadow:0 1px 4px rgba(0, 0, 0, 0.3), 0 0 40px rgba(0, 0, 0, 0.1) inset;
            		box-shadow:0 1px 4px rgba(0, 0, 0, 0.3), 0 0 40px rgba(0, 0, 0, 0.1) inset;
			}';
			echo $data->selector.$hover.':before, '.$data->selector.$hover.':after{
			content:"";
    			position:absolute; 
    			z-index:-1;
    			-webkit-box-shadow:0 0 20px rgba(0,0,0,0.8);
    			-moz-box-shadow:0 0 20px rgba(0,0,0,0.8);
    			box-shadow:0 0 20px rgba(0,0,0,0.8);
    			top:0;
    			bottom:0;
    			left:10px;
    			right:10px;
    			-moz-border-radius:100px / 10px;
    			border-radius:100px / 10px;
			}'; 
			echo $data->selector.$hover.':after{
			right:10px; 
    			left:auto;
    			-webkit-transform:skew(8deg) rotate(3deg); 
       			-moz-transform:skew(8deg) rotate(3deg);     
        		-ms-transform:skew(8deg) rotate(3deg);     
         		-o-transform:skew(8deg) rotate(3deg); 
            		transform:skew(8deg) rotate(3deg);
			}';
			break;
		case 'verticalcurves' :
			echo $data->selector.$hover.'{	
  			position:relative;       
    			-webkit-box-shadow:0 1px 4px rgba(0, 0, 0, 0.3), 0 0 40px rgba(0, 0, 0, 0.1) inset;
       			-moz-box-shadow:0 1px 4px rgba(0, 0, 0, 0.3), 0 0 40px rgba(0, 0, 0, 0.1) inset;
            			box-shadow:0 1px 4px rgba(0, 0, 0, 0.3), 0 0 40px rgba(0, 0, 0, 0.1) inset;
			}';
			echo $data->selector.$hover.':before, '.$data->selector.$hover.':after{
			content:"";
    			position:absolute; 
    			z-index:-1;
    			-webkit-box-shadow:0 0 20px rgba(0,0,0,0.8);
    			-moz-box-shadow:0 0 20px rgba(0,0,0,0.8);
    			box-shadow:0 0 20px rgba(0,0,0,0.8);
    			top:10px;
    			bottom:10px;
    			left:0;
    			right:0;
    			-moz-border-radius:100px / 10px;
    			border-radius:100px / 10px;
			}'; 
			echo $data->selector.$hover.':after{
			right:10px; 
    			left:auto;
    			-webkit-transform:skew(8deg) rotate(3deg); 
       			-moz-transform:skew(8deg) rotate(3deg);     
        			-ms-transform:skew(8deg) rotate(3deg);     
         			-o-transform:skew(8deg) rotate(3deg); 
            			transform:skew(8deg) rotate(3deg);
			}';  
			break;
		case 'relief' :
			echo $data->selector.$hover.' {
			-webkit-box-shadow:0 1px 4px rgba(0, 0, 0, 0.3), 0 0 40px rgba(0, 0, 0, 0.1) inset;
			-moz-box-shadow:0 1px 4px rgba(0, 0, 0, 0.3), 0 0 40px rgba(0, 0, 0, 0.1) inset;
			box-shadow:0 1px 4px rgba(0, 0, 0, 0.3), 0 0 40px rgba(0, 0, 0, 0.1) inset;
			}';
			break;
		default : //None
			echo $data->selector.' {
			-webkit-box-shadow: none;
			-moz-box-shadow: none;
			box-shadow: none;
			}';
			break;
	}
    	
}	