<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;
$data = $displayData;

echo $data->selector.'{';
	if(isset($data->size)){echo "font-size: ".$data->size."px;";}
	if(isset($data->color) && ($data->color!='')){echo "color: ".$data->color.";";}
	//margin between glyph and side text, except if there is a bacground(divs are added)
	if(isset($data->position) & ($data->background->shape == 'none')){
		if($data->position == "left"){echo "margin-right: 8px;";}
		else if($data->position == "right"){echo "margin-left: 8px;";}
	}
echo "}";

// display or not if trigger=hover
if(isset($data->trigger) && $data->trigger=='hover') {
	echo $data->selector.'{visibility : hidden;}';
	echo "#part-".$data->id.":hover .icomoon {visibility:visible;}";
}

// color hover if isset
if(isset($data->color_active)){
	
	if(isset($data->selector_active) && $data->selector_active != '')
		echo $data->selector_active." {color: ".$data->color_active.";}";
	else 
		echo $data->selector.".active {color: ".$data->color_active.";}";
}

// color hover if isset
if(isset($data->color_hover) && ($data->color_hover !='')){
	
	if(isset($data->selector_hover) && $data->selector_hover!='')
		echo $data->selector_hover." {color: ".$data->color_hover.";}";
	else // for compatibility
		echo "#part-".$data->id.":hover .icomoon {color: ".$data->color_hover.";}";
}

if(isset($data->position)){
	if($data->position == "unknown"){
		echo "#part-".$data->id." .icomoon-left{margin-right: 8px;}";
		echo "#part-".$data->id." .icomoon-right{margin-left: 8px;}";
	}
}

if(isset($data->color)){
	echo "@media print {
		".$data->selector."{
			color: ".$data->color." !important;
		}
	}";
}

//Display effects
if (isset($data->effects) && count($data->effects) > 0){
    foreach ($data->effects as $effect){
	if ($effect->type == 'display'){
	    $dataEffect = $effect;
	    $dataEffect->selector = $data->selector;
	    if (isset($data->selector_hover))
		$dataEffect->selector_hover = $data->selector_hover;
	    switch ($effect->action){
		case 'show' :
		    echo NGE::layout('nge.parts.parts.effects.css.effects_display_show_css', $dataEffect);
		    break;
		case 'animate' :
		    echo NGE::layout('nge.parts.parts.effects.css.effects_display_animate_css', $dataEffect);
		    break;
		case 'hide' :
		    echo NGE::layout('nge.parts.parts.effects.css.effects_display_hide_css', $dataEffect);
		    break;
	    }
	}
    }
}