<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;
 

$data = $displayData;

if ($data->color == '')
	$data->color = 'transparent';

if ($data->style != "default"){
    echo $data->selector . '{';
    if(($data->style != "none") && ($data->style != "")){
		if(isset($data->positions) && $data->positions != ""){
		    if ($data->positions == array("left", "top", "bottom", "right")){
			echo 'border: ' . $data->width . 'px ' . $data->style . ' ' . $data->color . ';';
		    }
		    else {		    		
			if (in_array ( "left", $data->positions ))
				echo 'border-left: ' . $data->width . 'px ' . $data->style . ' ' . $data->color . ';';
			else
				echo 'border-left: none;';
			if (in_array ( "top", $data->positions ))
				echo 'border-top: ' . $data->width . 'px ' . $data->style . ' ' . $data->color . ';';
			else
				echo 'border-top: none;';
			if (in_array ( "right", $data->positions ))
				echo 'border-right: ' . $data->width . 'px ' . $data->style . ' ' . $data->color . ';';
			else
				echo 'border-right: none;';
			if (in_array ( "bottom", $data->positions ))
				echo 'border-bottom: ' . $data->width . 'px ' . $data->style . ' ' . $data->color . ';';
			else
				echo 'border-bottom: none;';
		    }
		}
		
		if(isset($data->radius->positions) && ($data->radius->positions != "") && ($data->radius->width != '0')){
		    if ($data->radius->positions == array("topleft", "topright", "bottomleft", "bottomright")){
			echo '-webkit-border-radius: '.$data->radius->width.'px;';
			echo '-moz-border-radius: '.$data->radius->width.'px;';
			echo 'border-radius: '.$data->radius->width.'px;';
		    }
		    else {
			$radiusTopleft = in_array ("topleft", $data->radius->positions ) ? $data->radius->width.'px' : '0';
			$radiusTopright = in_array ("topright", $data->radius->positions ) ? $data->radius->width.'px' : '0';
			$radiusBottomleft = in_array ("bottomleft", $data->radius->positions ) ? $data->radius->width.'px' : '0';
			$radiusBottomright = in_array ("bottomright", $data->radius->positions ) ? $data->radius->width.'px' : '0';
			echo '-webkit-border-radius: ' . $radiusTopleft . ' ' . $radiusTopright . ' ' . $radiusBottomright . ' ' . $radiusBottomleft . ';';
			echo '-moz-border-radius: ' . $radiusTopleft . ' ' . $radiusTopright . ' ' . $radiusBottomright . ' ' . $radiusBottomleft . ';';
			echo 'border-radius: ' . $radiusTopleft . ' ' . $radiusTopright . ' ' . $radiusBottomright . ' ' . $radiusBottomleft . ';';
		    }
		}
		else{
			echo '-webkit-border-radius: 0;';
			echo '-moz-border-radius: 0;';
			echo 'border-radius: 0;';
		}
		
		
    }
    else if ($data->style == "none"){
	    echo "border: none;";	
    }

    echo '}';
}


if(($data->style != "none") && ($data->style != "") && ($data->style != "default") && ($data->color_hover != '') && ($data->color != $data->color_hover)){
	$selector_hover = '';
	if(isset($data->selector_hover) && $data->selector_hover!='')
		$selector_hover = $data->selector_hover;
	else 
	    $selector_hover = str_replace(',', ':hover,', $data->selector).':hover';

	echo $selector_hover . ' {';
		if(isset($data->positions) && $data->positions != ""){
		    if ($data->positions == array("left", "top", "bottom", "right")){
			echo 'border: ' . $data->width . 'px ' . $data->style . ' ' . $data->color_hover . ';';
		    }
		    else {		    		
			if (in_array ( "left", $data->positions ))
				echo 'border-left: ' . $data->width . 'px ' . $data->style . ' ' . $data->color_hover . ';';
			if (in_array ( "top", $data->positions ))
				echo 'border-top: ' . $data->width . 'px ' . $data->style . ' ' . $data->color_hover . ';';
			if (in_array ( "right", $data->positions ))
				echo 'border-right: ' . $data->width . 'px ' . $data->style . ' ' . $data->color_hover . ';';
			if (in_array ( "bottom", $data->positions ))
				echo 'border-bottom: ' . $data->width . 'px ' . $data->style . ' ' . $data->color_hover . ';';
		    }
		} 
		echo '-moz-transition: all .2s ease-in-out;';
		echo '-o-transition: all .2s ease-in-out;';
		echo '-webkit-transition: all .2s ease-in-out;';
		echo 'transition: all .2s ease-in-out;';
	echo '}';
}

if (isset($data->selector_active) && ($data->color_active != $data->color)){
    echo $data->selector_active.' {';
    echo 'border-color: ' . $data->color_active . ';';
    echo '}';    
}

//Border effects
if (isset($data->effects) && count($data->effects) > 0){
    foreach ($data->effects as $effect){
	if ($effect->type == 'border'){
	    $dataEffect = $effect;
	    $dataEffect->selector = $data->selector;
	    $dataEffect->width = $data->width;
	    if (isset($data->selector_hover))
		$dataEffect->selector_hover = $data->selector_hover;
	    echo NGE::layout('nge.parts.parts.effects.css.effects_border_css', $dataEffect);
	}
    }
}
