<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

$data = $displayData;

if (isset($data->opacity)) {

    if ($data->color2 == '')
	$data->color2 = $data->color;
    if ($data->color_hover2 == '')
	$data->color_hover2 = $data->color_hover;


    require_once(NGEPATH_HELPERS . '/html/css/csshelper.php');
    $opacity = str_replace(',', '.', $data->opacity / 100);

    if ($data->color != '') {
	$colorRGBA = CssHelper::hex2rgb($data->color);
	if (strpos($data->color, 'rgba') === false)
	    $data->color = "rgba(" . $colorRGBA[0] . ", " . $colorRGBA[1] . ", " . $colorRGBA[2] . ", " . $opacity . ")";
    }
    if ($data->color2 != '') {
	$color2RGBA = CssHelper::hex2rgb($data->color2);
	if (strpos($data->color2, 'rgba') === false)
	    $data->color2 = "rgba(" . $color2RGBA[0] . ", " . $color2RGBA[1] . ", " . $color2RGBA[2] . ", " . $opacity . ")";
    }

    //Hover
    if ($data->color_hover != '') {
	$color_hoverRGBA = CssHelper::hex2rgb($data->color_hover);
	if (strpos($data->color_hover, 'rgba') === false)
	    $data->color_hover = "rgba(" . $color_hoverRGBA[0] . ", " . $color_hoverRGBA[1] . ", " . $color_hoverRGBA[2] . ", " . $opacity . ")";

	if ($data->color_hover2 == '')
	    $data->color_hover2 = $data->color2;
    }
    if ($data->color_hover2 != '') {
	$color_hover2RGBA = CssHelper::hex2rgb($data->color_hover2);
	if (strpos($data->color_hover2, 'rgba') === false)
	    $data->color_hover2 = "rgba(" . $color_hover2RGBA[0] . ", " . $color_hover2RGBA[1] . ", " . $color_hover2RGBA[2] . ", " . $opacity . ")";

	if ($data->color_hover == '')
	    $data->color_hover = $data->color;
    }
}

/** Background * */
if ($data->style != 'default'){
    echo $data->selector . ' {';
    switch ($data->style) {
	case 'none' :
	    echo 'background: none;';
	    echo 'background-image: none;';
	    break;
	case 'solid' :
	    if ($data->color != '') {
		echo 'background-color: ' . $data->color . ';
				background-image: none;
				transition: background-color .2s;';
	    }
	    break;
	case 'gradient' :
	    echo 'background: ' . $data->color . ';';
	    switch ($data->direction) :
		case 'horizontal' :
		    echo '			    background: -webkit-gradient(
					    linear,
					    right bottom,
					    left bottom,
					    color-stop(0, ' . $data->color2 . '),
					    color-stop(1, ' . $data->color . ')
					    );
					    background: -o-linear-gradient(left, ' . $data->color2 . ' 0%, ' . $data->color . ' 100%);
					    background: -moz-linear-gradient(left, ' . $data->color2 . ' 0%, ' . $data->color . ' 100%);
					    background: -webkit-linear-gradient(left, ' . $data->color2 . ' 0%, ' . $data->color . ' 100%);
					    background: -ms-linear-gradient(left, ' . $data->color2 . ' 0%, ' . $data->color . ' 100%);
					    background: linear-gradient(to left, ' . $data->color2 . ' 0%, ' . $data->color . ' 100%);';
		    break;
		case 'vertical' :
		    echo '			    background: -webkit-gradient(
					    linear,
					    right bottom,
					    right top,
					    color-stop(0, ' . $data->color2 . '),
					    color-stop(1, ' . $data->color . ')
					    );
					    background: -o-linear-gradient(top, ' . $data->color2 . ' 0%, ' . $data->color . ' 100%);
					    background: -moz-linear-gradient(top, ' . $data->color2 . ' 0%, ' . $data->color . ' 100%);
					    background: -webkit-linear-gradient(top, ' . $data->color2 . ' 0%, ' . $data->color . ' 100%);
					    background: -ms-linear-gradient(top, ' . $data->color2 . ' 0%, ' . $data->color . ' 100%);
					    background: linear-gradient(to top, ' . $data->color2 . ' 0%, ' . $data->color . ' 100%);';
		    break;
		case 'circle' :
		    echo '	    		    background: -webkit-gradient(
					    linear,
					    right bottom,
					    right top,
					    color-stop(0, ' . $data->color2 . '),
					    color-stop(1, ' . $data->color . ')
					    );
					    background: -o-radial-gradient(circle, ' . $data->color2 . ' 0%, ' . $data->color . ' 100%);
					    background: -moz-radial-gradient(circle, ' . $data->color2 . ' 0%, ' . $data->color . ' 100%);
					    background: -webkit-radial-gradient(circle, ' . $data->color2 . ' 0%, ' . $data->color . ' 100%);
					    background: -ms-radial-gradient(circle, ' . $data->color2 . ' 0%, ' . $data->color . ' 100%);
					    background: radial-gradient(circle, ' . $data->color2 . ' 0%, ' . $data->color . ' 100%);';

		    break;
		case 'ellipse' :
		    echo '			    background: -webkit-gradient(
					    linear,
					    right bottom,
					    right top,
					    color-stop(0, ' . $data->color2 . '),
					    color-stop(1, ' . $data->color . ')
					    );
					    background: -o-radial-gradient(ellipse, ' . $data->color2 . ' 0%, ' . $data->color . ' 100%);
					    background: -moz-radial-gradient(ellipse, ' . $data->color2 . ' 0%, ' . $data->color . ' 100%);
					    background: -webkit-radial-gradient(ellipse, ' . $data->color2 . ' 0%, ' . $data->color . ' 100%);
					    background: -ms-radial-gradient(ellipse, ' . $data->color2 . ' 0%, ' . $data->color . ' 100%);
					    background: radial-gradient(ellipse, ' . $data->color2 . ' 0%, ' . $data->color . ' 100%);';
		    break;
	    endswitch;
	    break;
	case 'image' :
	    echo 'background: ';
	    if (($data->image->tint->style == 'solid') && ($data->image->tint->color != '')){
		$colorRGBA = CssHelper::hex2rgb($data->image->tint->color);
		$opacity = str_replace(',', '.', $data->image->tint->opacity / 100);
		echo 'linear-gradient(';
		echo 'rgba(' . $colorRGBA[0] . ', ' . $colorRGBA[1] . ', ' . $colorRGBA[2] . ', ' . $opacity . '),';
		echo 'rgba(' . $colorRGBA[0] . ', ' . $colorRGBA[1] . ', ' . $colorRGBA[2] . ', ' . $opacity . ')),';
	    }
	    echo 'url("' . NGE::url('root') . $data->image->image . '");';
	    if ($data->image->repeat != '1') {
		switch ($data->image->repeat) {
		    case '0' :
			echo 'background-repeat: no-repeat;';
			break;
		    case 'horizontal' :
			echo 'background-repeat: repeat-x;';
			break;
		    case 'vertical' :
			echo 'background-repeat: repeat-y;';
			break;
		    default :
			/* Repeat = repeat default */
			break;
		}
	    }
	    if ($data->image->fit != '1') {
		switch ($data->image->fit) {
		    case 'width' :
			echo 'background-size: 100% auto;';
			break;
		    case 'height' :
			echo 'background-size: auto 100%;';
			break;
		    case 'stretch' :
			echo 'background-size: 100% 100%;';
			break;
		    case 'contain' :
			echo 'background-size: contain;';
			break;
		    case 'cover' :
			echo 'background-size: cover;';
			break;

		    default :
			/* Repeat = repeat default */
			break;
		}
	    }

	    break;
    }
    echo '}';


    /** Background hover * */
    $selector_hover = '';
    if (isset($data->selector_hover) && $data->selector_hover != '')
	$selector_hover = $data->selector_hover;
    else
	$selector_hover = str_replace(',', ':hover,', $data->selector) . ':hover';


    echo $selector_hover . ' {';
    switch ($data->style) {
	case 'none' :
	    echo 'background: none;';
	    echo 'background-image: none;';
	    break;
	case 'solid' :
	    if (($data->color_hover != '') && ($data->color != $data->color_hover)) {
		echo 'background-color: ' . $data->color_hover . ';transition: background-color .2s;';
		echo 'background-image: none;';
	    }
	    break;
	case 'gradient' :
	    if (($data->color_hover != '') && ($data->color_hover2 != '') && (($data->color != $data->color_hover) || ($data->color2 != $data->color_hover2))) {
		echo 'background: ' . $data->color_hover . ';';
		switch ($data->direction) :
		    case 'horizontal' :
			echo 'background: -webkit-gradient(
					    linear,
					    right bottom,
					    left bottom,
					    color-stop(0, ' . $data->color_hover2 . '),
					    color-stop(1, ' . $data->color_hover . ')
					    );
					    background: -o-linear-gradient(left, ' . $data->color_hover2 . ' 0%, ' . $data->color_hover . ' 100%);
					    background: -moz-linear-gradient(left, ' . $data->color_hover2 . ' 0%, ' . $data->color_hover . ' 100%);
					    background: -webkit-linear-gradient(left, ' . $data->color_hover2 . ' 0%, ' . $data->color_hover . ' 100%);
					    background: -ms-linear-gradient(left, ' . $data->color_hover2 . ' 0%, ' . $data->color_hover . ' 100%);
					    background: linear-gradient(to left, ' . $data->color_hover2 . ' 0%, ' . $data->color_hover . ' 100%);';
			break;
		    case 'vertical' :
			echo 'background: -webkit-gradient(
					    linear,
					    right bottom,
					    right top,
					    color-stop(0, ' . $data->color_hover2 . '),
					    color-stop(1, ' . $data->color_hover . ')
					    );
					    background: -o-linear-gradient(top, ' . $data->color_hover2 . ' 0%, ' . $data->color_hover . ' 100%);
					    background: -moz-linear-gradient(top, ' . $data->color_hover2 . ' 0%, ' . $data->color_hover . ' 100%);
					    background: -webkit-linear-gradient(top, ' . $data->color_hover2 . ' 0%, ' . $data->color_hover . ' 100%);
					    background: -ms-linear-gradient(top, ' . $data->color_hover2 . ' 0%, ' . $data->color_hover . ' 100%);
					    background: linear-gradient(to top, ' . $data->color_hover2 . ' 0%, ' . $data->color_hover . ' 100%);';
			break;
		    case 'circle' :
			echo 'background: -webkit-gradient(
					    linear,
					    right bottom,
					    right top,
					    color-stop(0, ' . $data->color_hover2 . '),
					    color-stop(1, ' . $data->color_hover . ')
					    );
					    background: -o-radial-gradient(circle, ' . $data->color_hover2 . ' 0%, ' . $data->color_hover . ' 100%);
					    background: -moz-radial-gradient(circle, ' . $data->color_hover2 . ' 0%, ' . $data->color_hover . ' 100%);
					    background: -webkit-radial-gradient(circle, ' . $data->color_hover2 . ' 0%, ' . $data->color_hover . ' 100%);
					    background: -ms-radial-gradient(circle, ' . $data->color_hover2 . ' 0%, ' . $data->color_hover . ' 100%);
					    background: radial-gradient(circle, ' . $data->color_hover2 . ' 0%, ' . $data->color_hover . ' 100%);';
			break;
		    case 'ellipse' :
			echo 'background: -webkit-gradient(
					    linear,
					    right bottom,
					    right top,
					    color-stop(0, ' . $data->color_hover2 . '),
					    color-stop(1, ' . $data->color_hover . ')
					    );
					    background: -o-radial-gradient(ellipse, ' . $data->color_hover2 . ' 0%, ' . $data->color_hover . ' 100%);
					    background: -moz-radial-gradient(ellipse, ' . $data->color_hover2 . ' 0%, ' . $data->color_hover . ' 100%);
					    background: -webkit-radial-gradient(ellipse, ' . $data->color_hover2 . ' 0%, ' . $data->color_hover . ' 100%);
					    background: -ms-radial-gradient(ellipse, ' . $data->color_hover2 . ' 0%, ' . $data->color_hover . ' 100%);
					    background: radial-gradient(ellipse, ' . $data->color_hover2 . ' 0%, ' . $data->color_hover . ' 100%);';
			break;
		endswitch;
	    }
	    break;
	case 'image' :
	    if (($data->image->image_hover != '') && ($data->image->image != $data->image->image_hover)){
		echo 'background: ';
		if (($data->image->tint->style == 'solid') && ($data->image->tint->color != '')){
		    $colorRGBA = CssHelper::hex2rgb($data->image->tint->color);
		    $opacity = str_replace(',', '.', $data->image->tint->opacity / 100);
		    echo 'linear-gradient(';
		    echo 'rgba(' . $colorRGBA[0] . ', ' . $colorRGBA[1] . ', ' . $colorRGBA[2] . ', ' . $opacity . '),';
		    echo 'rgba(' . $colorRGBA[0] . ', ' . $colorRGBA[1] . ', ' . $colorRGBA[2] . ', ' . $opacity . ')),';
		}	
		echo 'url("' . NGE::url('root') . $data->image->image_hover . '");';
	    }
	    break;
	case 'alternate' :
	    echo 'background-color: ' . $data->color_hover . ';';
	    echo 'transition: background-color .2s;';
	    break;
    }
    echo '}';

    
    
?>    

@media print {
<?php echo $data->selector; ?> {
<?php if ($data->style == 'solid') { ?>
    background: <?php echo $data->color; ?> !important;
<?php } else if ($data->style == 'hgradient') { ?>
    background: -webkit-gradient(
    linear,
    right bottom,
    left bottom,
    color-stop(0, <?php echo $data->color2; ?>),
    color-stop(1, <?php echo $data->color; ?>)
    ) !important;
    background: -o-linear-gradient(left, <?php echo $data->color2; ?> 0%, <?php echo $data->color; ?> 100%) !important;
    background: -moz-linear-gradient(left, <?php echo $data->color2; ?> 0%, <?php echo $data->color; ?> 100%) !important;
    background: -webkit-linear-gradient(left, <?php echo $data->color2; ?> 0%, <?php echo $data->color; ?> 100%) !important;
    background: -ms-linear-gradient(left, <?php echo $data->color2; ?> 0%, <?php echo $data->color; ?> 100%) !important;
    background: linear-gradient(to left, <?php echo $data->color2; ?> 0%, <?php echo $data->color; ?> 100%) !important;	
<?php } else if ($data->style == 'vgradient') { ?>
    background: -webkit-gradient(
    linear,
    right bottom,
    right top,
    color-stop(0, <?php echo $data->color2; ?>),
    color-stop(1, <?php echo $data->color; ?>)
    ) !important;
    background: -o-linear-gradient(top, <?php echo $data->color2; ?> 0%, <?php echo $data->color; ?> 100%) !important;
    background: -moz-linear-gradient(top, <?php echo $data->color2; ?> 0%, <?php echo $data->color; ?> 100%) !important;
    background: -webkit-linear-gradient(top, <?php echo $data->color2; ?> 0%, <?php echo $data->color; ?> 100%) !important;
    background: -ms-linear-gradient(top, <?php echo $data->color2; ?> 0%, <?php echo $data->color; ?> 100%) !important;
    background: linear-gradient(to top, <?php echo $data->color2; ?> 0%, <?php echo $data->color; ?> 100%) !important;
<?php } else if ($data->style == 'image') { ?>
    background: url("<?php echo NGE::url('root') . $data->image->image; ?>") !important;
<?php } else if ($data->style == 'none') { ?>
    background: transparent !important;
<?php } ?>    

}
}
<?php    
    
    
}

//Background effects
if (isset($data->effects) && count($data->effects) > 0) {
    foreach ($data->effects as $effect) {
	if ($effect->type == 'background') {
	    $dataEffect = $effect;
	    $dataEffect->selector = $data->selector;
	    if (isset($data->selector_hover))
		$dataEffect->selector_hover = $data->selector_hover;
	    if ($dataEffect->trigger == 'hover')
		echo NGE::layout('nge.parts.parts.effects.css.effects_background_hover_css', $dataEffect);
	    else
		echo NGE::layout('nge.parts.parts.effects.css.effects_background_display_css', $dataEffect);
	}
    }
}


if ($data->style == 'alternate') {
    if (isset($data->color_odd)) {
	echo str_replace(',', '.odd,', $data->selector) . '.odd{';
	echo 'background: ' . $data->color_odd . ';';
	echo ' }';
    }

    if (isset($data->color_even)) {
	echo str_replace(',', '.even,', $data->selector) . '.even{';
	echo 'background: ' . $data->color_even . ';';
	echo ' }';
    }
}
