<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

 
//http://www.creativejuiz.fr/trytotry/css3-box-shadow-after-before/
// http://cssdeck.com/labs/different-css3-box-shadows-effects

/***** INSTANTIATION VARIABLES *****/
$data = 			$displayData;
$html = 			array();
$style = 			array();
$script = 			array();


// $content_badge = "";
// $theme_badge = "";

// if($data->rendering->mode == 'edit'){
// 	$content_badge = '<span class="xeditable" data-type="text" data-pk="'.$data->id.'-label">'. $data->badge->label .'</span>';
// }else{
// 	$content_badge =  '<span>'.$data->badge->label.'</span>';
// }
// $theme_badge = ($data->badge->display == "0") ? "none" : $data->badge->theme;

/***** CONTENT *****/
$content = '';
if ($data->content->source == 'html') {
	$content = $data->content->html;
}
else if($data->content->source == 'article') {
	require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
	$article = NgeJoomlaArticleDriver::load($data->content->article);
	$content = $article->introtext;
}else if($data->content->source == 'module') {
	require_once (NGEPATH_HELPERS . '/data/joomla/moduledriver.php');
	$content = NgeJoomlaModuleDriver::load($data->content->module);
}else if($data->content->source == 'url'){
	require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
	$content = UrlDriver::getContents($data->content->url);
}else if ($data->content->source == 'query') {
	require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
	$content = NgeDatabaseDriver::loadSingle($data->content->query);
}else if($data->content->source == 'template') {
	require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
	require_once (NGEPATH_HELPERS . '/renderer/smarty/smartyrenderer.php');
	$contentData = NgeDatabaseDriver::loadAssoc($data->content->query);
	
	if ($data->template->source == 'input')
		$content = SmartyRenderer::renderString($contentData, $data->template->input);
	else
	if ($data->template->source == 'file')		
		$content = SmartyRenderer::render($contentData, $data->template->file);
}


$content = '<div class="part">toto</div>';
$content .= '<div class="part">toto</div>';

//Class
$class = array();
// if($theme_badge == "none"){
// 	$class[] = '';
// }else if($theme_badge == "rectangular"){
// 	$class[] = 'badger-'.$data->badge->align;
// 	$class[] = ' '.$data->badge->color;
// }else if($theme_badge == "button"){
// 	$class[] = '';
// }else if($theme_badge == "triangular"){
// 	$class[] = '';
// }
$class[] = "part";
$class[] = $data->shadow->style == 'none' ? '' : $data->shadow->style;
$class[] = NGE::layout('nge.parts.parts.display_class', $data);

//Attribute
$attributes = array();
$attributes[] = ' id="part-'.$data->id.'"';
$attributes[] = (implode($class) != "") ? ' class="'.implode(' ', $class).'"' : "";
$attributes[] =  $data->size->type == 'css' ? ' style="width:'.$data->size->css.';"' : '';

//General CSS
// $dataGeneral = $data;
// $dataGeneral->selector = '#part-'.$data->id;
// $style[] = NGE::layout('nge.parts.panels.css.panel_css', $dataGeneral);

//Container
$dataGeneral = $data;
$dataGeneral->selector = '#part-'.$data->id;
$style[] = NGE::layout('nge.parts.panels.css.container_css', $dataGeneral);
$script[] = NGE::layout('nge.parts.panels.js.container_js', $dataGeneral);

	//Header CSS
	$dataHeader = $data->header;
	$dataHeader->selector = '#part-'.$data->id.' .part_header';
	$style[] = NGE::layout('nge.parts.panels.css.header_css', $dataHeader);

	//Header Font CSS
	if($data->header->font->style == 'custom'){
		$dataHeaderFont = $data->header->font;
		$dataHeaderFont->selector = '#part-'.$data->id.' .header_title';
		$style[] = NGE::layout('nge.parts.text.css.font_css', $dataHeaderFont);
	}
	
	//Header Background CSS
	if ($data->header->background->style != "none") {
		$dataHeaderBackground = $data->header->background;
		$dataHeaderBackground->selector = '#part-'.$data->id.' .part_header';
		$style[] = NGE::layout('nge.parts.panels.css.background_css', $dataHeaderBackground);
	}
	//Header Icomoon CSS
	if ($data->header->glyph->position != "none"){
		NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'icomoon/icomoon-nge.css');
		$dataHeaderIcomoon = $data->header->glyph;
		$dataHeaderIcomoon->selector = '#part-'.$data->id.' .part_header .icomoon';
		$style[] = NGE::layout('nge.parts.panels.css.icomoon_css', $dataHeaderIcomoon);
	}

// //Badge CSS
// $dataBadge = $data->badge;
// $dataBadge->selector = '#part-'.$data->id.' .textarea_badge';
// $style[] = NGE::layout('nge.parts.panels.css.badge_css', $dataBadge);

// //Badge Font CSS
// $dataBadgefont = $data->badge->font;
// $dataBadgefont->selector = '#part-'.$data->id.' .textarea_badge span';
// $style[] = NGE::layout('nge.parts.text.css.font_css', $dataBadgefont);

//Padding
if($data->body->padding != ""){
	$style[] = '#part-'.$data->id . ' .content{';
	$style[] = 	'padding: '.$data->body->padding . 'px;';
	$style[] = '}';
}

//Border
if (($data->border->style != "none") || ($data->border->radius->width != "0")){
	$dataGeneralBorder = $data->border;
	$dataGeneralBorder->selector = '#part-'.$data->id;
	$style[] = NGE::layout('nge.parts.panels.css.border_css', $dataGeneralBorder);
}
//Background
if ($data->background->style != "none") {
	$dataPanelBackground = $data->background;
	$dataPanelBackground->selector = '#part-'.$data->id;
	$style[] = NGE::layout('nge.parts.panels.css.background_css', $dataPanelBackground);
}

//Shadow
if($data->shadow->style != 'none'){
	$dataShadow = $data->shadow;
	$dataShadow->selector = '#part-'.$data->id;
	$dataShadow->background = $data->background;
	$style[] = NGE::layout('nge.parts.panels.css.shadow_css', $dataShadow);
}

$html[] = '<div '.implode($attributes).'>';

//Header
if (($data->header->label != '' || $data->header->glyph->name != '')){
	$dataHeader = $data;
	$dataHeader->selector = '#part-'.$data->id.' .part_header';	
	$html[] = NGE::layout('nge.parts.panels.html.header_html', $dataHeader);
}

//Badge
// if ($data->badge->display == "1") 
// 	$html[] = '<div class="textarea_badge badge">'.$content_badge.'</div>';

if($data->rendering->mode == 'edit'){
	if($data->content->source == 'html'){
		$html[] = '<div class="content xeditable" data-type="xtinymce" data-property="content.text"  data-pk="'.$data->id.'-content-text">'.$content.'</div>';
	}else{
		$html[] = '<div class="content">'.$content.'</div>';
	}
}else{
	$html[] = '<div class="content">'.$content.'</div>';
}
$html[] = '</div>';

//Import style CSS & script JS
if (count($style) != 0) 
	echo '<style>'.implode($style).'</style>'; 
if (count($script) != 0)
	echo '<script>'.implode($script).'</script>';
//Generate HTML
echo implode($html);
