<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// No direct access
defined('_JEXEC') or die;

 
/**
 * @package     NextGenEditor
 * @author       Teatis {www.teatis.com }
 *
 * @copyright   Copyright (C) 2015 Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */


require_once(NGEPATH_LAYOUTS . '/parts/parts/html/panel.php');
/***** INSTANTIATION VARIABLES *****/
$data = 			$displayData;

$part = new LayoutPanel($data);
$items = array();

$contentBodys = 	array();
$tabsNumber = count($data->content->items);
$hasGlyph = false;

if ($data->content->mode == 'joomla.menu'){
	require_once (NGEPATH_HELPERS . '/data/joomla/menudriver.php');
$data->content->showallchildren = 1;
$menu = NgeJoomlaMenuDriver::load($data->content->menu->menutype, (int)$data->content->showallchildren);
	
	$currentLevelIsRoot = true;
	foreach ($menu->items as $i => &$menuitem){
		if ($menuitem->level == '1'){
			$item = new stdClass();
			$item->label = $menuitem->title;
			$item->glyph_name = '';			
			$item->editableClass = '';			
			$item->editableAttributes = '';			
			$item->body = '';			
			$items[] = $item;
		}
	}

	
}
else {//custom

//Target
for ($i=0;$i<$tabsNumber;$i++){
	
		$item = new stdClass();
		$item->glyph_name = '';		
		$item->editableClass = '';
		
		$item->label = $data->content->items[$i]->label;
		if (isset($data->content->items[$i]->glyph->name))
			$item->glyph_name = $data->content->items[$i]->glyph->name != '' ? $data->content->items[$i]->glyph->name : '';
				
		//Body panel
		$item->editable = true;
        $item->editableClass = '';
		$item->editableAttributes = '';
		switch ($data->content->items[$i]->body->source){
			case 'html' :
				$item->body = $data->content->items[$i]->body->html;
				$item->editableClass = ' ngeinlineeditable ngeinlineeditor';
				$item->editableAttributes = 'data-nge = \'{"title": "Text", "type": "editor", "source":"content:content.items.'.$i.'.html"}\'';
				break;
			case 'url' :	
				require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
				$item->body = UrlDriver::getContents($data->content->items[$i]->body->url);
				$item->editableClass = ' ngeinlineeditable';
				$item->editableAttributes = 'data-nge = \'{"title": "Url", "type": "joomla.url", "source":"content:content.items.'.$i.'.url"}\'';
				break;
			case 'article' :
				require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
				$article = NgeJoomlaArticleDriver::load($data->content->items[$i]->body->article);
				$item->body = $article->introtext;
				$item->editableClass = ' ngeinlineeditable';
				$item->editableAttributes = 'data-nge = \'{"title": "Article", "type": "joomla.article", "source":"content:content.items.'.$i.'.article"}\'';
				break;
			case 'module' :
				require_once (NGEPATH_HELPERS . '/data/joomla/moduledriver.php');
				$item->body = NgeJoomlaModuleDriver::load($data->content->items[$i]->body->module);
				$item->editableClass = ' ngeinlineeditable';
				$item->editableAttributes = 'data-nge = \'{"title": "Module", "type": "joomla.module", "source":"content:content.items.'.$i.'.module"}\'';
				break;
			default :
				$item->body = '';	
				$item->editableClass = '';
				$item->editableAttributes = '';
		}
		$items[] = $item;
}
}


//Attributes
$class_a = array();
$class_headings = array();

$class_headings[] = "accordion-header";
$class_headings[] = $data->headings->style != "custom" ? " btn-".$data->headings->style : "";

$class_li = array();
$class_li[] = ($data->headings->style == "bootstrap") ? "btn".NgeBootstrapTag::_("BTN-DEFAULT") : "";
$class_li[] = ($data->headings->style == "bootstrap" && $data->header->theme != "custom") ? "btn btn-".$data->header->theme : "";

$class_a = array();
if (isset($data->headings->font) && ($data->headings->font->style == 'class'))
	$class_a[] = $data->headings->font->class;


/**** CSS ***********************************************************************/

//Cache
if ($data->cache->css == ''){

	if ($data->body->height->mode == "custom"){
		$part->style[] = "#part-".$data->id." .".NgeBootstrapTag::_("PANEL-BODY")."{overflow:auto; height: ".$data->body->height->value."px;}"; 
	}
    
	//Heading CSS & JS
	if (isset($data->headings->style) && $data->headings->style != 'default'){
	    $dataHeading = $data->headings;
	    $dataHeading->selector = '#part-'.$data->id;
	    $part->style[] = NGE::layout('nge.parts.panels.css.accordion-heading_css', $dataHeading);
	}
	
	//If header or body not default, resetting all accordion group border
	if ((isset($data->headings->style) && ($data->headings->style == 'custom' ) && (isset($data->headings->border) && ($data->headings->border->style != 'default'))
		|| (isset($data->body->border) && ($data->body->border->style != 'default'))))
		$part->style[] =  '#part-'.$data->id.' .'.NgeBootstrapTag::_("PANEL-DEFAULT").' {'
				. 'border:none;'
				. '}';
	
	//If header or body not default, resetting all accordion group background
	if ((isset($data->headings->style) && ($data->headings->style == 'custom' ) && (isset($data->headings->background) && ($data->headings->background->style != 'default'))
		|| (isset($data->body->background) && ($data->body->background->style != 'default'))))
		$part->style[] =  '#part-'.$data->id.' .'.NgeBootstrapTag::_("PANEL-DEFAULT").' {'
				. 'background:transparent;'
				. '}';
	
	
	if (isset($data->headings->style) && $data->headings->style == 'custom'){

		/*$part->style[] =  '#part-'.$data->id.' .'.NgeBootstrapTag::_("PANEL-DEFAULT").' {'
				. 'border:none;'
				. '}';
*/
		//Headings Font 
		if (isset($data->headings->font) && ($data->headings->font->style == 'custom')){
			$dataFont = $data->headings->font;
			$dataFont->selector = '#part-'.$data->id.' .accordion-toggle';
			$part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataFont);
		}

		//Header Glyph CSS
		$dataHeaderIcomoon = $data->headings->glyph;
		$dataHeaderIcomoon->selector = '#part-' . $data->id . ' i';
		$dataHeaderIcomoon->selector_hover = '#part-' . $data->id . ' .accordion-heading:hover i';
		$part->style[] = NGE::layout('nge.parts.panels.css.icomoon_css', $dataHeaderIcomoon);

		//Headings Border CSS
		if (isset($data->headings->border)){
			$dataBorder = $data->headings->border;
			$dataBorder->selector = '#part-'.$data->id.' .'.NgeBootstrapTag::_("PANEL-HEADING");
			$part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataBorder);
		}

		//Headings Background CSS
		if (isset($data->headings->background)){
			$dataBackground = $data->headings->background;
			$dataBackground->selector = '#part-'.$data->id.' .'.NgeBootstrapTag::_("PANEL-HEADING");
			$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataBackground);
		}

		//Headings Shadow
		if (isset ( $data->headings->shadow ) && ($data->body->shadow->style != "")) {
			$dataShadow = $data->headings->shadow;
			$dataShadow->selector = '#part-' . $data->id .' .'.NgeBootstrapTag::_("PANEL-HEADING");
			$part->style[] = NGE::layout('nge.parts.panels.css.shadow_css', $dataShadow);
		}
	}

	//Body padding
	    $dataPadding = $data->body->padding;
	    $dataPadding->selector = '#part-'.$data->id.' .'.NgeBootstrapTag::_("PANEL-BODY");
	    $part->style[] = NGE::layout('nge.parts.panels.css.padding_css', $dataPadding);


	//Body Border CSS
	if (isset($data->body->border)){
		$dataBorder = $data->body->border;
		$dataBorder->selector = '#part-'.$data->id.' .'.NgeBootstrapTag::_("PANEL-BODY");
		$part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataBorder);
	}

	//Body Background CSS
	if (isset($data->body->background)){
		$dataBackground = $data->body->background;
		$dataBackground->selector = '#part-'.$data->id.' .'.NgeBootstrapTag::_("PANEL-BODY");
		$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataBackground);
	}

	//Body Shadow
	if (isset ( $data->body->shadow ) && ($data->body->shadow->style != "")) {
		$dataShadow = $data->body->shadow;
		$dataShadow->selector = '#part-' . $data->id .' .'.NgeBootstrapTag::_("PANEL-BODY");
		$part->style[] = NGE::layout('nge.parts.panels.css.shadow_css', $dataShadow);
	}

	//Button Bootstrap style
	if ($data->headings->style == 'bootstrap' && $data->headings->theme == 'custom'){
		//Button CSS
		$dataButtonPadding = $data->headings->padding;
		$dataButtonPadding->selector = '#part-'.$data->id.' .'.NgeBootstrapTag::_("PANEL-HEADING");
		$part->style[] = NGE::layout('nge.parts.panels.css.padding_css', $dataButtonPadding);
	}

    
}

/**** JS ************************************************************************/

//Cache
if ($data->cache->js == ''){
    
	$part->script[] = NGE::layout('nge.parts.panels.js.accordion_js', $data);
        
	if (($data->body->height->mode == "maxheight") && ($data->rendering->mode != 'fastview')){
		NgeContenthelper::addScript(NGEURL_MEDIA . 'jquery-match-height/jquery.matchHeight-min.js');
		$part->script[] =  'jQuery("#part-'.$data->id.' .'.NgeBootstrapTag::_("PANEL-BODY").'").matchHeight(false);';
	}
    
}
	if ($data->rendering->mode != 'fastview')
	    $nbItems = count($items);
	else
	    $nbItems = 1; //In fastview, rendering only first tab

	for ($i=0;$i <$nbItems; $i++){
		$class_c = array();
		$class_c[] = " ".NgeBootstrapTag::_("PANEL-BODY");
		$class_c[] = $data->rendering->mode == 'edit' &&  ($data->content->items[$i]->body->source == 'html') ? " ngecontenteditableinline" : "";

		$attributes_c = array();
		$attributes_c[] = ' id="'.implode($class_c).'"';
		$attributes_c[] = ' class="'.implode($class_c).$items[$i]->editableClass.'"';
		$attributes_c[] =  $items[$i]->editableAttributes ;
		
		if($data->rendering->mode == 'edit'){
			$labelEditableClass = ' ngeinlineeditable ngeinlinetext';
			$labelEditableAttributes = ' data-nge = \'{"title": "Text", "type": "text", "source":"content:labels.'.$i.'"}\' ';
		}else{
		   $labelEditableClass = '';
		   $labelEditableAttributes = '';
		}
        
		$contentLabel = '<span class="'.$labelEditableClass.'" '.$labelEditableAttributes.'>'.$items[$i]->label.'</span>';
        
        
		if($items[$i]->glyph_name != ""){
		    if($data->rendering->mode == 'edit'){
			$glyphEditableClass = ' ngeelement ngeinlineeditable ngeinlineglyph';
			$glyph_name = (isset($data->content->items[$i]->glyph->name) && $data->content->items[$i]->glyph->name != '') ? $data->content->items[$i]->glyph->name : '';
			$glyphEditableAttributes = ' data-nge = \'{"title": "Glyph", "type": "glyph", "source":"content:content.items.'.$i.'.glyph.name", "value":"'.$glyph_name.'"}\' ';
		    }else{
			$glyphEditableClass = '';
			$glyphEditableAttributes = '';
		    }
			$hasGlyph = true;
			if ($data->headings->glyph->position == 'left')
				$contentLabel = '<i class="'.$items[$i]->glyph_name.$glyphEditableClass.'" '.$glyphEditableAttributes.'></i> ' . $contentLabel;
			else
			if ($data->headings->glyph->position == 'right')
				$contentLabel .= ' <i class="'.$items[$i]->glyph_name.$glyphEditableClass.'" '.$glyphEditableAttributes.'></i>';
		}	
		
		$in = $i == 0? ' in': '';
		
		switch (NgeBootstrapTag::getVersion()){
		case '2' : 
			
			$part->content .= '<div class="accordion-group">';
			$part->content .= '<div class="accordion-heading ' . implode(' ', $class_li) . '">';			
			$part->content .= '<span class="accordion-toggle ' . implode(' ', $class_a) . '" data-toggle="collapse"
				data-parent="#part-' . $data->id . '-body" href="#collapse_' . $data->id . '_' . $i . '"> ' . $contentLabel . ' </span>';
			$part->content .= '</div>';
			$part->content .= '<div id="collapse_' . $data->id . '_' . $i . '" class="'.NgeBootstrapTag::_("PANEL-COLLAPSE").' collapse' . $in . '">';
			$part->content .= '<div '  . implode(' ', $attributes_c) . '>' . $items[$i]->body . '</div>';
			$part->content .= '</div>';
			$part->content .= '</div>';
			
			break;	
		case '3' : 
			//TODO
			$part->content .= '<div class="'.NgeBootstrapTag::_("PANEL-DEFAULT").'">';
			$part->content .= '<div class="'.NgeBootstrapTag::_("PANEL-HEADING").' ' . implode(' ', $class_li) . '">';
			$part->content .= '<span class="accordion-toggle ' . implode(' ', $class_a) . '" data-toggle="collapse"
				data-parent="#part-' . $data->id . '" href="#collapse_' . $data->id . '_' . $i . '"> ' . $contentLabel . ' </span>';
			$part->content .= '</div>';
			$part->content .= '<div id="collapse_' . $data->id . '_' . $i . '" class="'.NgeBootstrapTag::_("PANEL-COLLAPSE").' collapse' . $in . '">';
			$part->content .= '<div id="part-' . $data->id . '-collapse-' . $i . '"'  . implode(' ', $attributes_c) . '>' . $items[$i]->body . '</div>';
			$part->content .= '</div>';
			$part->content .= '</div>';
			break;
		}
	}
 
    // accordion contener for bootstrap 2
    if(NgeBootstrapTag::getVersion()==2) {
        $part->content = '<div class="accordion" id="part-' . $data->id . '-body">' . $part->content . '</div>';
    }
	
	if($hasGlyph == true)
	    NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'icomoon/icomoon-nge.css');

echo $part->render();