<?php

/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
// no direct access
defined('_JEXEC') or die;

require_once(NGEPATH_LAYOUTS . '/parts/parts/html/panel.php');
/* * *** INSTANTIATION VARIABLES **** */
$data = $displayData;

$part = new LayoutPanel($data);


// require_once (NGEPATH_HELPERS . '/data/joomla/menudriver.php');
// $menu = NgeJoomlaMenuDriver::load($data->content->menutype, (int)$data->content->showallchildren);

/* * *** CONTENT **** */
$items = array();
$hasItemGlyph = false;
$activeClass = array();

if ($data->content->source == 'database') {
	if ($data->content->source == 'query' && $data->content->query != '') {
		require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');


		$query = $data->content->query;
		if ($data->content->count != '' && $data->content->count != '0')
			$query .= ' LIMIT 0,' . $data->content->count;
		$contentData = NgeDatabaseDriver::loadAssocList($query);

		switch ($data->renderer->mode) {
			case 'default' :
				foreach ($contentData as $contentRow) {
					$htmlRow = '<a href="#">';
					$firstField = true;
					foreach ($contentRow as $key => $value) {
						if ($firstField == true) {
							$htmlRow .= $value;
							$firstField = false;
						}
					}
					$htmlRow .= '</a>';

					$items[] = $htmlRow;
				}
				break;
			case 'php' :
				break;
			case 'template' :
				require_once (NGEPATH_HELPERS . '/renderer/smarty/smartyrenderer.php');
				foreach ($contentData as $contentRow) {

					if ($data->renderer->template->source == 'html')
						$items[] = SmartyRenderer::renderString($contentRow, $data->renderer->template->html->body);
					else
					if ($data->renderer->template->source == 'file')
						$items[] = SmartyRenderer::render($contentRow, $data->renderer->template->file);
				}

				break;
		}
	}
}
else //Articles type content (from category or tag)
if ($data->content->source == 'joomla.menu') {

	require_once (NGEPATH_HELPERS . '/data/joomla/menudriver.php');
	$data->content->showallchildren = 1;
	$menu = NgeJoomlaMenuDriver::load($data->content->menu->menutype, (int) $data->content->showallchildren);
//	print_r($menu->items);
	$items = $menu->items;

	/* 	

	  $part->content .=  '<div class="accordion-group">';
	  $part->content .= '<div class="accordion-heading">';
	  $part->content .= '<a class="accordion-toggle" data-toggle="collapse" href="#part-'.$data->id.'-collapse'.$collapse_id.'">'.$item->label.'</a>';
	  $part->content .= '</div>';
	  // The next item is deeper.
	  if ($item->deeper)
	  {
	  $part->content .= '<div id="part-'.$data->id.'-collapse'.$collapse_id.'" class="accordion-body collapse">';
	  $part->content .= '<div class="accordion-inner">';
	  }
	  elseif ($item->shallower)
	  {
	  // The next item is shallower.
	  $part->content .= str_repeat('</div></div></div></div>', $item->level_diff);
	  }
	  else
	  {
	  $part->content .= '</div>';
	  }
	  $collapse_id++;

	 */


} else 
    if ($data->content->source == 'custom') {	
		
	for ($i = 0; $i < count($data->content->items); $i++) {
		//Label
		$item = new stdClass();
		$item->id = "";
		$item->link = "";
		if ($data->content->items[$i]->glyph->name != ''){ 
			$hasItemGlyph = true;
			if ($data->items->style != 'custom'){
			    $leftGlyphStyle = ' style="display:table-cell; vertical-align:middle; padding-right:8px"';
			    $rightGlyphStyle = ' style="display:table-cell; vertical-align:middle; padding-left:8px"';
			}
			else {
			    $leftGlyphStyle = '';
			    $rightGlyphStyle = '';
			}
			    
			$glyphleft = (isset($data->items->glyph->position) && $data->items->glyph->position == 'left') ? '<span class="icomoon-left icomoon ' . $data->content->items[$i]->glyph->name . '"' . $leftGlyphStyle . '></span>' : '';
			$glyphright = (isset($data->items->glyph->position) && $data->items->glyph->position == 'right') ? '<span class="icomoon-right icomoon ' . $data->content->items[$i]->glyph->name . '"' . $rightGlyphStyle . '></span>' : '';
			$item->label = $glyphleft.$data->content->items[$i]->label.$glyphright;		
		}
		else
			$item->label = $data->content->items[$i]->label;
		
		//Url link
		if (isset($data->content->items[$i]->link->type)) 
			switch ($data->content->items[$i]->link->type) {
				case 'url' :
					if ($data->content->items[$i]->link->url != '')
					    $item->link = $data->content->items[$i]->link->url;
					else
					    $part->warnings[] = NGE::translate('COM_NGE_WARNING_URLLINK_MISSING') . ' (' . (string) ($i+1) . ')';				    
					break;
				case 'article' :
					if($data->content->items[$i]->link->article != ''){
					    $item->link = NGEURL_ROOT . 'index.php?option=com_content&view=article&id='.$data->content->items[$i]->link->article;
					    // Set to active if link is in current page
					    $jinput = JFactory::getApplication()->input;
					    $option = $jinput->get('option','');
					    $view = $jinput->get('view','');
					    $idarticle = $jinput->get('id','');
					    if ($idarticle != ''){
						if($option=='com_content' && $view=='article') {
						    if($data->content->items[$i]->link->article == $idarticle)
							$activeClass[$i]=' active';
						}			
					    }
					}
					else
					    $part->warnings[] = NGE::translate('COM_NGE_WARNING_ARTICLELINK_MISSING') . ' (' . (string) ($i+1) . ')';
					break;
				case 'menu' :
					require_once (NGEPATH_HELPERS . '/data/joomla/menudriver.php');
					$menu = NgeJoomlaMenuDriver::loadItem($data->content->items[$i]->link->menu);
					if (isset($menu)){
					    $link = $menu->route;
					    $item->link = NGE::url('root').'index.php/'.$link;        			    
					}
					else{
					    $part->warnings[] = NGE::translate('COM_NGE_WARNING_MENULINK_MISSING') . ' (' . (string) ($i+1) . ')';
					}				
					// active menu?
					if (NgeJoomlaMenuDriver::isActiveItem($data->content->items[$i]->link->menu))
					    $activeClass[$i]=' active';
					break;
				case 'image' :
					$item->link = NGE::url('root').$data->content->items[$i]->link->image;
					break;
				case 'file' :
					$item->link = NGE::url('root').$data->content->items[$i]->link->file;
					break;
					
				/*case 'javascript' :
					$item->link = $data->content->items[$i]->link->javascript;
					break;
				case 'submit' :
					$item->link = 'jQuery( "form:first" ).submit();'; //TODO pouvoir indiquer un nom de formulaire
					break;*/
			}


			//    $items[] = '<a tabindex="-1" href="'.$url.'">'.$glyphleft.$data->content->items[$i]->label.$glyphright.'</a>';
//		$items[] = '<a tabindex="-1" href="'.$url.'">'.$glyphleft.$data->content->items[$i]->label.$glyphright.'</a>';
		$items[] = $item;	
	}
} else{
    //Loading plugin contents
    $dataSourceFilename = NGEPATH_CONTENTS . '/source/' . str_replace('.', '/', $data->content->source) . '/content.php';
    if (file_exists($dataSourceFilename)){
	require_once $dataSourceFilename;
	$className = 'Nge' . implode('', array_map('ucfirst', explode('.', $data->content->source))) . 'Content';
	$source = str_replace('.', '/', $data->content->source);
	//WARNING : $data contains properties from the config screen. 
	//All content properties are not known because they can come from external content plugins
	//So we transmit unchanged all these properties as parameter of the loadList method (params)
	$items = $className::getListData($data);
    }
}

//In config preview, no link
if (isset($data->rendering->mode) && ($data->rendering->mode == 'preview')){
    for ($i=0;$i<count($items);$i++){
	$items[$i]->link = '#';
    }
}

if ($hasItemGlyph || ($data->header->glyph->name != ''))
    NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'icomoon/icomoon-nge.css');



$class_u = array();
$class_u[] = 'part-' . $data->id . '-list';
//$class_u[] = 'content'; pb padding

if ($data->items->style == 'bootstrap') {
	switch ($data->items->bootstrap->theme) {
		case 'tabs' :
			$class_u[] = 'nav nav-tabs nav-stacked';
			break;
		case 'pills' :
			$class_u[] = 'nav nav-pills nav-stacked';
			break;
		case 'list' :
			$class_u[] = 'nav nav-list nav-stacked';
			break;
	}
} else
	$class_u[] = '';

/**** CSS ***********************************************************************/

//Cache
if ($data->cache->css == ''){

	//List items CSS
	if (isset($data->items) && ($data->items->style == 'custom')) {

		/*
		  $dataList = $data->items;
		  $dataList->selector = '#part-'.$data->id.' ul';
		  $part->style[] = NGE::layout('nge.parts.navigation.css.list_css', $dataList);

		  //List Main CSS (padding)
		  $dataList = $data->items->padding;
		  $dataList->selector = '#part-'.$data->id.' li';
		  $part->style[] = NGE::layout('nge.parts.panels.css.padding_css', $dataList);
		 */
		//Columns
		$part->style[] = '#part-' . $data->id . ' ul { margin:0px;}';

		    //Items (padding, text align, bullets)	
		$dataItems = $data->items;
		$dataItems->selector = '#part-' . $data->id . ' ul';
		$dataItems->orientation = 'vertical';
		$part->style[] = NGE::layout('nge.parts.panels.css.items_css', $dataItems);

		//List Font CSS
		if (isset($data->items->font) && ($data->items->font->style == 'custom')) {
			$dataListFont = $data->items->font;
			$dataListFont->selector = '#part-' . $data->id . ' a, #part-' . $data->id . ' span';
			$dataListFont->selector_hover = '#part-' . $data->id . ' li:hover a, #part-' . $data->id . ' li:hover span';
			$part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataListFont);
		}

		//List Glyphs
		if ($hasItemGlyph == true){
			$dataListGlyph = $data->items->glyph;
			$dataListGlyph->selector = '#part-' . $data->id . ' .icomoon';
			$dataListGlyph->selector_hover = '#part-' . $data->id . ' li:hover .icomoon';
			$dataListGlyph->id = $data->id;
			$part->style[] = NGE::layout('nge.parts.panels.css.icomoon_css', $dataListGlyph);
		}

		//List Border CSS
		$dataListBorder = $data->items->border;
		$dataListBorder->selector = '#part-' . $data->id . ' li';
		$part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataListBorder);

		//List Background CSS
		$dataListBackground = $data->items->background;
		$dataListBackground->selector = '#part-' . $data->id . ' li';
		$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataListBackground);

		//Hover
		$dataListBackground->selector = '#part-' . $data->id . ' li:hover';
		$dataListBackground->color = $data->items->background->color_hover;
		$dataListBackground->color2 = $data->items->background->color_hover2;
		$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataListBackground);

		//Active
		$dataListBackground->selector = '#part-' . $data->id . ' li:active';
		$dataListBackground->color = $data->items->background->color_active;
		$dataListBackground->color2 = $data->items->background->color_active2;
		$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataListBackground);

		//Pager
		$dataList = $data->items;
		$dataList->selector = '#part-' . $data->id . '-pager';
		$part->style[] = NGE::layout('nge.parts.navigation.css.list_css', $dataList);
	}

	//List header CSS
	if (isset($data->headers) && ($data->headers->style == 'custom')) {
		/*
		  $dataList = $data->headers;
		  $dataList->selector = '#part-'.$data->id.'-list';
		  $part->style[] = NGE::layout('nge.parts.navigation.css.list_css', $dataList);
		 */
		//List Main CSS (padding and text align)
		$dataList = $data->headers;
		$dataList->selector = '#part-' . $data->id . ' li.header';
		//$part->style[] = NGE::layout('nge.parts.panels.css.padding_css', $dataList);
		$part->style[] = NGE::layout('nge.parts.panels.css.items_headers_css', $dataList);


		//Items
		if (isset($data->headers->height->mode) && ($data->headers->height->mode == 'custom')) {
			$part->style[] = '#part-' . $data->id . ' li.header{';
			$part->style[] = 'height:' . $data->headers->height->value . 'px;';
			$part->style[] = '}';
		}

		if ($data->headers->spacing != '') {
			$spacing = is_numeric($data->headers->spacing) ? $data->headers->spacing . 'px' : $data->headers->spacing;
			$part->style[] = '#part-' . $data->id . ' li.header{';
			$part->style[] = 'margin-bottom:' . $spacing . ';';
			$part->style[] = '}';
		}

		//List Font CSS
		if (isset($data->headers->font) && ($data->headers->font->style == 'custom')) {
			$dataListFont = $data->headers->font;
			$dataListFont->selector = '#part-' . $data->id . ' li.header a';
			$dataListFont->selector_hover = '#part-' . $data->id . ' li.header:hover a';
			$part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataListFont);
		}

		//List Glyphs
		if (isset($data->headers->glyphs)){
		    $dataListGlyph = $data->headers->glyphs;
		    $dataListGlyph->selector = '#part-' . $data->id . 'li.header';
		    $dataListGlyph->selector_hover = '#part-' . $data->id . 'li.header:hover';
		    $part->style[] = NGE::layout('nge.parts.panels.css.icomoon_css', $dataListGlyph);
		}

		//List Border CSS
		$dataListBorder = $data->headers->border;
		$dataListBorder->selector = '#part-' . $data->id . ' li.header';
		$part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataListBorder);

		//List Background CSS
		$dataListBackground = $data->headers->background;
		$dataListBackground->selector = '#part-' . $data->id . ' li.header';
		$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataListBackground);

		//Hover
		$dataListBackground->selector = '#part-' . $data->id . ' li.header:hover';
		$dataListBackground->color = $data->headers->background->color_hover;
		$dataListBackground->color2 = $data->headers->background->color_hover2;
		$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataListBackground);

		//Active
		$dataListBackground->selector = '#part-' . $data->id . ' li.header:active';
		$dataListBackground->color = $data->headers->background->color_active;
		$dataListBackground->color2 = $data->headers->background->color_active2;
		$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataListBackground);

		//Pager
		$dataList = $data->headers;
		$dataList->selector = '#part-' . $data->id . '-pager';
		$part->style[] = NGE::layout('nge.parts.navigation.css.list_css', $dataList);
	}
}//if cache

/**** JS ************************************************************************/

//Cache
if ($data->cache->js == ''){

	//General display ******************************************************

	//Searching
    /*
	if ($data->navigation->searching->display == 1){
	    
	    NgeContenthelper::addScript(NGEURL_MEDIA . 'list/list.min.js');
	    NgeContenthelper::addScript(NGEURL_MEDIA . 'list/list.pagination.min.js');
	    $part->content .= '<input type="text" class="search part-' . $data->id . '-search" placeholder="Search" />';
	    $part->content .= '<span class="sort" data-sort="part-' . $data->id . '-item-title">Sort by name</span>';
	    $part->script[] =  'var $items = jQuery(".part-'. $data->id . '-list >li");
		    if ($items.length != 0){
			var paginationListBottomOptions = {
			name: "paginationListBottom",
			paginationClass: "paginationListBottom",
			innerWindow: 3,
			left: 2,
			right: 4
			};
			patternListjs = new List("part-' . $data->id . '-panel", {
			valueNames: [ "part-' . $data->id . '-item-title" ],';
			//listClass : "part-' . $data->id . '-list",';
	    if ($data->navigation->paging->display == 1 && $data->navigation->paging->mode=='pager'){
		    $part->script[] =  'page: ' . $data->navigation->paging->pager->length . ',';
		    $part->script[] =  'plugins: [
			ListPagination(paginationListBottomOptions)
			],';
		    $part->script[] =  'paginationClass: "part-' . $data->id . '-pagination"';
	    }
	    //$part->script[] =  'searchClass: "part-' . $data->id . '-search"';
	$part->script[] =  '	    });
		}';	    
	}
     * 
     */
}

//List is editable if custom and edit mode
$dataItemsMode = '';
if ($data->rendering->mode == 'edit'){
    //Removable and sortable items
    if (isset($data->content->source) && (in_array($data->content->source, array('custom', 'joomla.articles', 'joomla.menu')))){
	$class_u[] = 'ngeaddableitems ngeitemsremovable';
	if ($data->content->source == 'custom' || ($data->content->source == 'joomla.articles' && $data->content->articles->ordering == 'ordering') || ($data->content->source == 'joomla.menu'))
	    $class_u[] = 'ngeitemssortable';
	$dataItemsMode = 'data-nge=\'{"itemsmode": "link_' . str_replace('.', '_', $data->content->source) . '", "itemstype": "list"}\'';
    }	
}


if ($data->navigation->paging->display == '1'){
    switch ($data->navigation->paging->mode) {
	case 'scroll' :
		$part->content .= '<div id="part-' . $data->id . '-container" style="overflow-y:scroll; height:200px;">';
		$part->content .= '<ul class="' . implode($class_u, ' ') . '" ' . $dataItemsMode . '>';
		for ($i = 0; $i < count($items); $i++) {
		    $attributesLinkEditable = (isset($data->content->source) && $data->content->source == 'custom') && $data->rendering->mode == 'edit' ? ' class="ngeelement ngeinlineeditable ngeinlinetext" data-nge = \'{"title": "Item", "type": "text", "source":"content:content.items.'.$i.'.label", "value":"'.$i.'"}\'' : '';
		    if (isset($items[$i]->link) && ($items[$i]->link != ''))
			$part->content .= '<li data-item="' . $items[$i]->id . '"><span><a href="'.$items[$i]->link.'">' . $items[$i]->label . '</a></span></li>';
		    else
			$part->content .= '<li data-item="' . $items[$i]->id . '"><span ' . $attributesLinkEditable . '>' . $items[$i]->label . '</span></li>';
		}
		$part->content .= '</ul>';
		$part->content .= '</div>';
		$part->script[] = 'var liHeight = jQuery("#part-' . $data->id . ' ul >li").first().outerHeight();
				jQuery("#part-' . $data->id . '-container").height(liHeight*' . $data->navigation->paging->scrolling->visibleitems . ');';
		break;
	case 'columns' :
		$part->style[] = '#part-' . $data->id . ' .flexcontainer{
			display: flex;
			}';
		$part->style[] = '#part-' . $data->id . ' ul{
			flex: 1;
			}';
		switch ($data->navigation->paging->columns->count) {
			case 'firstlevel' : //each first level item is on top of a new columns
				//Warning : only data from menu at this moment
				$part->content .= '<div class="flexcontainer">';
				for ($i = 0; $i < count($items); $i++) {
					//$part->content .= '<li class="'.implode($class_li, ' ').'">'.$items[$i].'</li>';
					if ($items[$i]->level == 1) {
						if ($i != 0)
							$part->content .= '</ul>';
						$part->content .= '<ul class="' . implode($class_u, ' ') . '">';
						if ($items[$i]->link != '')
						    $part->content .= '<li class="header"><span><a href="'.$items[$i]->link.'">' . $items[$i]->label . '</a></span></li>';
						else
						    $part->content .= '<li class="header"><span>' . $items[$i]->label . '</span></li>';
					}
					else {
						if ($items[$i]->link != '')
						    $part->content .= '<li><span><a href="'.$items[$i]->link.'">' . $items[$i]->label . '</a></span></li>';
						else
						    $part->content .= '<li><span>' . $items[$i]->label . '</span></li>';
					}
				}
				$part->content .= '</ul>';
				$part->content .= '</div>';

				//Columns CSS (rules)
				$dataRenderingColumns = $data->navigation->paging->columns;
				$dataRenderingColumns->selector = '#part-' . $data->id . ' ul';
				$part->style[] = NGE::layout('nge.parts.navigation.css.columns_css', $dataRenderingColumns);

				break;
			case 'auto' : //Columns number is auto : fixed items number by column
			default : //Number of columns is custom				
				if ($data->navigation->paging->columns->count == 'auto')
					$nbCols = ceil(count($items) / $data->navigation->paging->columns->visibleitems);
				else
					$nbCols = $data->navigation->paging->columns->count;

				//List
				$part->content .= '<div id="part-' . $data->id . '-columns">';
				$part->content .= '<ul class="' . implode($class_u, ' ') . '">';

				$columnItemRow = 0;
				for ($i = 0; $i < count($items); $i++) {
					$attributesLinkEditable = (isset($data->content->source) && $data->content->source == 'custom') && $data->rendering->mode == 'edit' ? ' class="ngeelement ngeinlineeditable ngeinlinetext" data-nge = \'{"title": "Item", "type": "text", "source":"content:content.items.'.$i.'.label", "value":"'.$i.'"}\'' : '';
					if (isset($items[$i]->level) && ($items[$i]->level == 1)) {
						$part->content .= '<li class="header"><span><a href="'.$items[$i]->link.'">' . $items[$i]->label . '</a></span></li>';
					} else {
					    if (isset($items[$i]->link) && ($items[$i]->link != ''))
						$part->content .= '<li><span><a href="'.$items[$i]->link.'">' . $items[$i]->label . '</a></span></li>';
					    else
						$part->content .= '<li><span ' . $attributesLinkEditable . '>' . $items[$i]->label . '</span></li>';
					}
				}
				$part->content .= '</ul>';
				$part->content .= '</div>';

				//Columns CSS
				$dataRenderingColumns = $data->navigation->paging->columns;
				$dataRenderingColumns->selector = '#part-' . $data->id . '-columns';
				$dataRenderingColumns->count = $nbCols;
				$part->style[] = NGE::layout('nge.parts.text.css.columns_css', $dataRenderingColumns);
		}
		break;
	case 'expandable' :		
		$part->content .= '<ul class="' . implode($class_u, ' ') . '">';
		for ($i = 0; $i < count($items); $i++) {
			//$part->content .= '<li class="'.implode($class_li, ' ').'">'.$items[$i].'</li>';
			if ((isset($items[$i]->deeper) && ($items[$i]->deeper == 1))){					
				$part->content .= '<li class="header"><span><a href="'.$items[$i]->link.'" class="tree-toggler">' . $items[$i]->label . '</span></a>';
				$part->content .= '<ul class="nav nav-list tree ' . implode($class_u, ' ') . '">';
			}
			else
			if ((isset($items[$i]->shallower) && ($items[$i]->shallower == 1))){					
				if ($items[$i]->link != '')
				    $part->content .= '<li><span><a href="'.$items[$i]->link.'">' . $items[$i]->label . '</a></span></li>';
				else
				    $part->content .= '<li>' . $items[$i]->label . '</li>';
				$part->content .= '</ul></li>';
			}		
			else {
				if ($items[$i]->link != '')
				    $part->content .= '<li><span><a href="'.$items[$i]->link.'">' . $items[$i]->label . '</a></span></li>';
				else
				    $part->content .= '<li><span>' . $items[$i]->label . '</span></li>';
			}	
		}
		$part->content .= '</ul>';
		$part->script[] = NGE::layout('nge.parts.navigation.js.expandable_js', $data);
		break;
	case 'pager' :
		/*if ($data->navigation->searching->display == '1'){ //Dynamic pagination by listjs (due to searching results varying
		    for ($i = 0; $i < count($items); $i++) {
			$attributesLinkEditable = (isset($data->content->source) && $data->content->source == 'custom') && ($data->rendering->mode == 'edit') ? ' class="ngeelement ngeinlineeditable ngeinlinetext" data-nge = \'{"title": "Item", "type": "text", "source":"content:content.items.'.$i.'.label", "value":"'.$i.'"}\'' : '';
			$attributesLinkHeaderEditable = (isset($data->content->source) && $data->content->source == 'custom') && ($data->rendering->mode == 'edit') ? ' class="header ngecontenteditableinline" data-type="inline" data-property="labels.'.$i.'"' : 'class="header"';		    
			//$part->content .= '<li class="'.implode($class_li, ' ').'">'.$items[$i].'</li>';
			$itemTitleSearchClass = ' class="part-' . $data->id . '-item-title"';
			if ((isset($items[$i]->level) && ($items[$i]->level == 1)) || $i == 0) {
				if ($i != 0)
					$part->content .= '</ul>';
				$part->content .= '<ul class="' . implode($class_u, ' ') . ' list" ' . $dataItemsMode . '>';
				if (isset($items[$i]->link) && ($items[$i]->link != ''))
				    $part->content .= '<li class="header" data-item="' . $items[$i]->id . '"><span><a href="'.$items[$i]->link.'" '.$attributesLinkEditable . $itemTitleSearchClass.'>' . $items[$i]->label . '</a></span></li>';
				else
				    $part->content .= '<li  '.$attributesLinkHeaderEditable.' data-item="' . $items[$i]->id . '"><span>' . $items[$i]->label . '</span></li>';
			}
			else {
				if (isset($items[$i]->link) && ($items[$i]->link != ''))
				    $part->content .= '<li data-item="' . $items[$i]->id . '"><a href="'.$items[$i]->link.'" '.$attributesLinkEditable . $itemTitleSearchClass .'>' . $items[$i]->label . '</a></li>';
				else
				    $part->content .= '<li '.$attributesLinkEditable.' data-item="' . $items[$i]->id . '"><span>' . $items[$i]->label . '</span></li>';
			}
		    }
		    $part->content .= '</ul>';
		    $part->content .= '<ul class="part-' . $data->id . '-pagination"></ul>';
		}
		else{ //Static bootstrap pagination*/
		    for ($i = 0; $i < count($items); $i++) {
			    //$part->content .= '<li class="'.implode($class_li, ' ').'">'.$items[$i].'</li>';
			    if ((isset($items[$i]->level) && ($items[$i]->level == 1)) || $i == 0) {
				    if ($i != 0)
					    $part->content .= '</ul>';
				    $part->content .= '<ul class="' . implode($class_u, ' ') . '">';
				    if (isset($items[$i]->link) && ($items[$i]->link != ''))
					$part->content .= '<li class="header"><span><a href="'.$items[$i]->link.'">' . $items[$i]->label . '</a></span></li>';
				    else
					$part->content .= '<li class="header"><span>' . $items[$i]->label . '</span></li>';
			    }
			    else {
				    if (isset($items[$i]->link) && ($items[$i]->link != ''))
					$part->content .= '<li><a href="'.$items[$i]->link.'">' . $items[$i]->label . '</a></li>';
				    else
					$part->content .= '<li>' . $items[$i]->label . '</li>';
			    }
		    }
		    $part->content .= '</ul>';
		    //Pager JS
			    $dataPager = $data->navigation->paging->pager;
			    $dataPager->id = $data->id;
			    $dataPager->selector = '#part-' . $data->id . '-panel >ul';
			    $dataPager->selectorPager = 'part-' . $data->id . '-pager';
			    $part->script[] = NGE::layout('nge.parts.navigation.js.pager_js', $dataPager);

		    //$part->content = '<div '.implode($attributes).'>';
		    //Pager top HTML
		    if (count($items) > $data->navigation->paging->pager->length) {
			    if ($data->navigation->paging->pager->position == 'top')
				    $part->content = NGE::layout('nge.parts.navigation.html.pager_html', $dataPager) . $part->content;
			    else 				
				    $part->content .= NGE::layout('nge.parts.navigation.html.pager_html', $dataPager);
		    }
		/*}*/
		
		break;
	default :		
		for ($i = 0; $i < count($items); $i++) {
			$attributesLinkEditable = (isset($data->content->source) && $data->content->source == 'custom') && $data->rendering->mode == 'edit' ? ' class="ngeelement ngecontenteditableinline" data-nge = \'{"title": "Item", "type": "nge.multiple", "source":"content:content.'.$i.'", "value":"'.$i.'"}\'' : '';
			$attributesLinkHeaderEditable = (isset($data->content->source) && $data->content->source == 'custom') && $data->rendering->mode == 'edit' ? ' class="header ngecontenteditableinline" data-type="inline" data-property="labels.'.$i.'"' : 'class="header"';		    
			//$part->content .= '<li class="'.implode($class_li, ' ').'">'.$items[$i].'</li>';
			$itemTitleSearchClass = ' class="part-' . $data->id . '-item-title"';
			if ((isset($items[$i]->level) && ($items[$i]->level == 1)) || $i == 0) {
				if ($i != 0)
				    $part->content .= '</ul>';
				$part->content .= '<ul class="list ' . implode($class_u, ' ') . '" ' . $dataItemsMode . '>';
				if (isset($items[$i]->link) && ($items[$i]->link != ''))
				    $part->content .= '<li class="header" data-item="' . $items[$i]->id . '"><span><a href="'.$items[$i]->link.'" '.$attributesLinkEditable . $itemTitleSearchClass.'>' . $items[$i]->label . '</a></span></li>';
				else
				    $part->content .= '<li  '.$attributesLinkHeaderEditable.' data-item="' . $items[$i]->id . '"><span>' . $items[$i]->label . '</span></li>';
			}
			else {
				if (isset($items[$i]->link) && ($items[$i]->link != ''))
				    $part->content .= '<li data-item="' . $items[$i]->id . '"><a href="'.$items[$i]->link.'" '.$attributesLinkEditable . $itemTitleSearchClass .'>' . $items[$i]->label . '</a></li>';
				else
				    $part->content .= '<li '.$attributesLinkEditable.' data-item="' . $items[$i]->id . '"><span>' . $items[$i]->label . '</span></li>';
			}
		}
		$part->content .= '</ul>';
		break;
    }
} //$data->navigation->paging->display == '1'
else { //All items
    $part->content .= '<ul>';
    for ($i = 0; $i < count($items); $i++) {
	    $attributesLinkEditable = (isset($data->content->source) && $data->content->source == 'custom') && $data->rendering->mode == 'edit' ? ' class="ngeelement ngeinlineeditable ngeinlinetext" data-nge = \'{"title": "Item", "type": "text", "source":"content:content.items.'.$i.'.label", "value":"'.$i.'"}\'' : '';
	    $attributesLinkHeaderEditable = (isset($data->content->source) && $data->content->source == 'custom') && $data->rendering->mode == 'edit' ? ' class="header ngeinlineeditable ngeinlinetext" data-nge = \'{"title": "Item", "type": "text", "source":"content:content.items.'.$i.'.label", "value":"'.$i.'"}\'' : 'class="header"';		    
	    //$part->content .= '<li class="'.implode($class_li, ' ').'">'.$items[$i].'</li>';
	    $itemTitleSearchClass = ' class="part-' . $data->id . '-item-title"';
	    //if ((isset($items[$i]->level) && ($items[$i]->level == 1)) || $i == 0) {
	    if ((isset($items[$i]->level) && ($items[$i]->level == 1))) {
		    if ($i != 0)
			    $part->content .= '</ul>';
		    $part->content .= '<ul class="list ' . implode($class_u, ' ') . '" ' . $dataItemsMode . '>';
		    if (isset($items[$i]->link) && ($items[$i]->link != ''))
			$part->content .= '<li class="header" data-item="' . $items[$i]->id . '"><span><a href="'.$items[$i]->link.'" '.$attributesLinkEditable . $itemTitleSearchClass.'>' . $items[$i]->label . '</a></span></li>';
		    else
			$part->content .= '<li  '.$attributesLinkHeaderEditable.' data-item="' . $items[$i]->id . '"><span>' . $items[$i]->label . '</span></li>';
	    }
	    else {
		    if (isset($items[$i]->link) && ($items[$i]->link != ''))
			$part->content .= '<li data-item="' . $items[$i]->id . '"><a href="'.$items[$i]->link.'" '.$attributesLinkEditable . $itemTitleSearchClass .'>' . $items[$i]->label . '</a></li>';
		    else
			$part->content .= '<li '.$attributesLinkEditable.' data-item="' . $items[$i]->id . '"><span>' . $items[$i]->label . '</span></li>';
	    }
    }
    $part->content .= '</ul>';
}

echo $part->render();