<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
 
// no direct access
defined('_JEXEC') or die;
	
//Using part class for warning rendering messages
require_once(NGEPATH_LAYOUTS . '/parts/parts/html/part.php');

$data = $displayData;

$html = array();

$part = new LayoutPart($data);

//Part usage is unique or multiple (in data reports)
if (isset($data->rendering->multiple) && ($data->rendering->multiple == true))
    $data->selector = '.part-'.$data->id;
else
    $data->selector = '#part-'.$data->id;


//Label content
if ($data->label->source == 'html') {
	$label = $data->label->html;
}else if($data->label->source == 'url'){
	require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
	$label = UrlDriver::getContents($data->label->url);
}else if($data->label->source == 'query'){
	require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
	$label = NgeDatabaseDriver::loadSingle($data->label->query);
}else if ($data->label->source == 'data') {
	$label = $data->label->data != '' ? '{{item.' . $data->label->data . '}}' : '';
}
else
	$label = $data->label->html;

//Sublabel content
if ($data->sublabel->source == 'html') {
	$sublabel = $data->sublabel->html;
}else if($data->sublabel->source == 'url'){
	require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
	$sublabel = UrlDriver::getContents($data->sublabel->url);
}else if($data->label->sublabel->source == 'query'){
	require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
	$sublabel = NgeDatabaseDriver::loadSingle($data->sublabel->query);
}
 else 
	$sublabel = $data->sublabel->html;

	//Attributes
	$class = array();
	$class[] = "part";
//	$class[] = 'btn btn-default btn-link';
	$class[] = (isset($data->font->style) && $data->font->style == 'class') ? $data->font->class : '';
	
	        //Part display options
            $part->style[] = NGE::layout('nge.parts.parts.display_style', $data);
            $class[] = NGE::layout('nge.parts.parts.display_class', $data);
	    $part->script[] = NGE::layout('nge.parts.parts.display_script', $data);

	//If part usage is multiple (in data reports), using class instead of unique selector
	if (isset($data->rendering->multiple) && ($data->rendering->multiple == true))
	    $class[] = 'part-'.$data->id;	    
	    
	$attributes = array();
	$attributes[] = ' id="part-'.$data->id.'"';
	$attributes[] = ' data-part="'.$data->name.'"';
	$attributes[] = ' data-part-label="'.NGE::translate($data->libraryTitle).'"';
	//$attributes[] = ' type="button"';
	$attributes[] = ' class="'.implode(' ', $class).'"';	
	
	$glyphleft = (isset($data->glyph->position) && $data->glyph->position == 'left') ? '<span class="icomoon '.$data->glyph->name.'"></span>' : '';
	$glyphright = (isset($data->glyph->position) && $data->glyph->position == 'right') ? '<span class="icomoon '.$data->glyph->name.'"></span>' : '';
	
	//Edit mode, xeditable enabled
	if ($data->rendering->mode == 'edit'){
		$attributesLabel = 'class="ngeinlineeditable ngeinlinetext" data-nge = \'{"title": "Link", "type": "text", "source":"label.html"}\'';
	}
	else {
		$attributesLabel = '';
	}
	
	$sublabel = $sublabel != '' ? '<br><span '.$attributesSublabel.'><small>'.$sublabel.'</small></span>' : '';
	$label = $glyphleft.'<span '.$attributesLabel.'>'.$label .'</span>'.$sublabel.$glyphright;
	
	//Url link
	$url = '';
	if (isset($data->link->type)){
	    switch ($data->link->type){
		case 'url' :
		    if ($data->link->url != '')
			$url = $data->link->url;
		    else
			$part->warnings[] = 'COM_NGE_WARNING_URLLINK_MISSING';
		    break;
		case 'article' :
		    if ($data->link->article != '')
			$url = NGEURL_ROOT . 'index.php?option=com_content&view=article&id='.$data->link->article;
		    else
			$part->warnings[] = 'COM_NGE_WARNING_ARTICLELINK_MISSING';
		    break;
		case 'file' : 
		    $url = NGE::url('root').$data->link->file;
		    break;
		case 'menu' :
		    require_once (NGEPATH_HELPERS . '/data/joomla/menudriver.php');
		    $menu = NgeJoomlaMenuDriver::loadItem($data->link->menu);
		    if (isset($menu)){
			$link = $menu->route;
			$url = NGE::url('root').'index.php/'.$link;        			    
		    }
		    else{
			$part->warnings[] = 'COM_NGE_WARNING_MENULINK_MISSING';
		    }	
		    break;
		case 'javascript' :
		    $url = $data->link->javascript;		    
		    break;
		
	    }
	} 
	
	//Url link for MODAL
	if (isset($data->link->target) && $data->link->target == 'modal'){
		if ($data->link->type == 'url'){
			require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
			$modal_content = UrlDriver::getContents($data->content->link_url);
		}else if ($data->link->type == 'menu') {
			require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
			$modal_content = UrlDriver::getContents($url);
		}else if ($data->link->type == 'query') {
			require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
			$modal_content = NgeDatabaseDriver::loadSingle($data->link->query);
		}
		else if ($data->content->link_type == 'article') {
			require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
			$article = NgeJoomlaArticleDriver::load($data->link->article);
			$modal_content = $article->introtext;
		}
	}
	
	//Modal box
	if(isset($modal_content)){
		$config = new stdClass();
		$config->id = 'modal-'.$data->id;
		//$config->title = $part->part;
		$config->header = new stdClass();
		$config->header->display = True;
		$config->header->label = 'Overview';
		$config->header->glyph = new StdClass();
		$config->header->glyph->name = 'icon-book';
		$config->body = $modal_content;
		$config->width="90%";
		$config->confirmbutton = array("show"=>"false");
		$config->cancelbutton = array("label"=>"Close");
		echo NGE::layout('nge.parts.navigation.modal', $config);
	}

//Import CSS & JS
//Font CSS
if(isset($data->label->font->style) && ($data->label->font->style == 'custom')){
	$dataFont = $data->label->font;
	//$dataFont = new stdClass();
	//$dataFont->selector = '#part-'.$data->id.' .button-label';
	$dataFont->selector = $data->selector.' a';
/*	$dataFont->size = $data->label->font->size;
	$dataFont->name = $data->label->font->name;
	$dataFont->italic = $data->label->font->italic;
	$dataFont->weight = $data->label->font->weight;
	$dataFont->letter_spacing = $data->label->font->letter_spacing;*/
	$part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataFont);
	
	$dataFontIcomoon = new stdClass();
	$dataFontIcomoon->selector = $data->selector. '.icomoon';
	$dataFontIcomoon->color = $data->label->font->color;
	$dataFontIcomoon->italic = $data->label->font->italic;
	$dataFontIcomoon->weight = $data->label->font->weight;
	$dataFontIcomoon->color_hover = $data->label->font->color_hover;
	$part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataFontIcomoon);	
}

//Icomoon CSS & Icomoon Font CSS
if(isset($data->glyph->name) && ($data->glyph->name != '')){
	NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'icomoon/icomoon-nge.css');
	$dataGlyph = $data->glyph;
	$dataGlyph->id = $data->id;
	$dataGlyph->selector = $data->selector.' .icomoon';
	$part->style[] = NGE::layout('nge.parts.panels.css.icomoon_css', $dataGlyph);
}

//Button CSS
if (isset($data->link)) {
	$dataLink = $data->link;
	$dataLink->selector = $data->selector;
	$part->style[] = NGE::layout('nge.parts.navigation.css.link_css', $dataLink);
}

//Only if not in preview mode
if (isset($data->rendering->mode) && ($data->rendering->mode != 'preview' )){
	$data->url = $url;
	$data->type = $data->link->type;
	$data->target = $data->link->target;
	$part->script[] = NGE::layout('nge.parts.panels.js.button_js', $data);
}

	//Effect
/*	if(isset($data->effect) && ($data->effect->trigger != "none") && ($data->effect->style != "")){
	    NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'animate/css/animate.min.css');
	    NgeContenthelper::addStyleSheet(NGEURL_MEDIA . 'animate/css/animate_teatis.css');		
	    $dataEffect = $data->effect;
	    $dataEffect->selector = '#part-'.$data->id;
	    $dataEffect->id = $data->id;
	    $part->style[] = NGE::layout('nge.parts.panels.css.animation_css', $dataEffect);
	    $part->script[] = NGE::layout('nge.parts.panels.js.animation_js', $dataEffect);
	}*/

	//Transform
	if (isset($data->transform) && $data->transform->trigger != 'none') {
	    $dataTransform = $data->transform;
	    $dataTransform->selector = $data->selector;
	    $part->style[] = NGE::layout('nge.parts.panels.css.animation_transform_css', $dataTransform);

	}

//Popover
if(isset($data->popover->trigger) && $data->popover->trigger != "none"){
	if ($data->popover->source == 'html')
		$popover_content = $data->popover->html;
	else if ($data->popover->source == 'url'){
		require_once (NGEPATH_HELPERS . '/data/url/urldriver.php');
		$popover_content = UrlDriver::getContents($data->popover->url);
	}
	else if ($data->popover->source == 'query') {
		require_once (NGEPATH_HELPERS . '/data/database/databasedriver.php');
		$popover_content = NgeDatabaseDriver::loadSingle($data->popover->query);
	}
	else if ($data->popover->source == 'article') {
		require_once (NGEPATH_HELPERS . '/data/joomla/articledriver.php');
		$article = NgeJoomlaArticleDriver::load($data->popover->article);
		$popover_content = $article->introtext;
	}
	else
		if ($data->popover->source == 'module') {
			require_once (NGEPATH_HELPERS . '/data/joomla/moduledriver.php');
			$popover_content = NgeJoomlaModuleDriver::load($data->popover->module);
		}
	else
		if($data->popover->source == 'image'){
		if($data->popover->image == ""){
			$data->popover->image = "components/com_nge/assets/images/default_bigthumb.png";
		}
		$popover_content = '<img src="'.NGE::url('root').$data->popover->image.'" />';
	}
}else{
	$popover_content = "";
}

if (isset($popover_content) && $popover_content != "" || $data->popover->caption!=""){
	$dataPopover = $data->popover;
	$dataPopover->selector = $data->selector;
	$dataPopover->id = $data->id;
	$dataPopover->content = $popover_content;
	$dataPopover->rendering_mode = $data->rendering->mode;

	$htmlPopover = NGE::layout('nge.parts.text.html.popover_html', $dataPopover);
	$classPopover = ' trigger';
	$part->style[] = NGE::layout('nge.parts.text.css.popover_css', $dataPopover);
	$part->script[] = NGE::layout('nge.parts.text.js.popover_js', $dataPopover);

	//Popover header
	//Header Font CSS
	if($data->popover->header->font->style == 'custom'){
		$dataHeaderFont = $data->popover->header->font;
		$dataHeaderFont->selector = '#popover-'.$data->id.' .popover > .popover-title';
		$dataHeaderFont->selector_hover = '#popover-'.$data->id.' .popover:hover > .popover-title';
		$part->style[] = NGE::layout('nge.parts.text.css.font_css', $dataHeaderFont);
	}

	//Header Background CSS
	if ($data->popover->header->background->style != "default") {
		$dataHeaderBackground = $data->popover->header->background;
		$dataHeaderBackground->selector = '#popover-'.$data->id.' .popover > .popover-title';
		$dataHeaderBackground->selector_hover = '#popover-'.$data->id.' .popover:hover > .popover-title';
		$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataHeaderBackground);
	}

	//Popover border
	if (($data->popover->border->style != "default") && ($data->popover->border->style != "none")){
		$dataGeneralBorder = $data->popover->border;
		$dataGeneralBorder->selector = '#popover-'.$data->id.' .popover';
		$part->style[] = NGE::layout('nge.parts.panels.css.border_css', $dataGeneralBorder);
	}

	//Popover background
	if ($data->popover->background->style != "default") {
		$dataPanelBackground = $data->popover->background;
		$dataPanelBackground->selector =  '#popover-'.$data->id.' .popover ';
		$dataPanelBackground->selector_hover =  '#popover-'.$data->id.' .popover:hover > .popover-content';
		$part->style[] = NGE::layout('nge.parts.panels.css.background_css', $dataPanelBackground);
	}
}else{
	$htmlPopover = '';
	$classPopover = '';
}

$html[] = '<span '.implode($attributes).'> <span class="'.$classPopover.'"><a href="#">' . $label . '</a></span>';

$html[] = $htmlPopover;
$html[] = $part->renderScripts();
$html[] = '</span>';

echo $part->renderMessages();
echo implode($html);

